<?php
	
	//---------------------------------------------------------------------------------------------------------
	// 06/Abril/2019
	// Versión 1.0 Mostramos un formulario con la dirección de envío seleccionada
	//---------------------------------------------------------------------------------------------------------
	//Vamos a sacar la dirección de envío que es el primer parámetro de la llamada al widget que carga este php
	$cart = CabeceraCesta::getCart();
	$creando = $cart->getCreando();
	$editando = $cart->getEditando();

	if (!$creando){
		$a = $direccion_envio = Theme::getLastParam(1);
	}else{
		$a = $direccion_envio = new Direcciones(array('cliente' => 0));
	}
	//Para poder separar el formulario, vamos a ponerle un ID. Le voy a poner como ID el nombre de la sección en la que estamos:
	$id_formulario = 'cesta_' . preg_replace('/[^A-Za-z0-9\-]/', '', password_hash(time(), PASSWORD_DEFAULT));
	$usuario = Usuario::logueado();
	$direcciones_disponibles = 0;
	if ($usuario != NULL){
		$direcciones_disponibles = count($usuario->direcciones);
	}
	$datos_incompletos = false;
	if ( (trim($a->nombre) == '' ) || (trim($a->direccion) == '' ) ||(trim($a->cod_postal) == '' ) ||(trim($a->localidad) == '' ) ||(trim($a->provincia) == '' ) || (trim($a->telefono) == '' ) ){
			$datos_incompletos = true;
	}
	//Para poder separar el formulario, vamos a ponerle un ID. Le voy a poner como ID el nombre de la sección en la que estamos:
	$id_formulario = 'cesta_' . preg_replace('/[^A-Za-z0-9\-]/', '', password_hash(time(), PASSWORD_DEFAULT));
	//Vamos a tener en cuenta que haya o no que modificar la dirección:
	if ( ($datos_incompletos) || ($editando) || ($creando) ){
/*
?>
<script>
function <?=$nombreFuncionScript;?>(){
	$('.selector_tipo_envio').html('');
	$('fieldset.modificarDireccion').show();
}
</script>
*/

?>

<div class="box">
	<h4 class="page-subheading"><?=traducir('¿Donde lo enviamos?');?></h4>
	<form method="post" class="mod_direccion_envio box" id="<?=$id_formulario;?>">
		<input type="hidden" name="codigo" value="<?=($creando) ? 0 : $cart->codigoDireccion;?>" />
		<div class="formulario_tamano">
			<div class="row">
				<div class="fnombre col-xs-12 col-sm-8">
					<label class="lnombre"> <?=traducir("Nombre");?>*</label>
					<textarea required name="nombre" class="<?=($direccion_envio->nombre != "") ? 'mod_nombre' : '';?> input_formulario form-control" rows="1"><?=$direccion_envio->nombre;?></textarea>
				</div>
				<div class="ftelefono col-xs-12 col-sm-4">
					<label class="lnombre"><?=traducir("Teléfono");?>*</label>
					<input required name="telefono" class="<?=($direccion_envio->telefono == "") ? 'no_relleno' : '';?> mod_telefono input_formulario form-control" type="text" value="<?=$direccion_envio->telefono;?>"/>
				</div>
			</div>
			<div class="row">
				<div class="fdireccion col-xs-12 col-sm-9">
					<label class="lnombre"><?=traducir("Dirección");?>*</label>
					<input required  name="direccion" class="<?=($direccion_envio->direccion == "") ? 'no_relleno' : '';?> mod_direccion input_formulario form-control" type="text" value="<?=$direccion_envio->direccion;?>" />
				</div>
				<div class="fcod_postal col-xs-12 col-sm-3">
					<label class="lnombre"><?=traducir("C.P.");?>*</label>
					<input required  name="cod_postal" class="<?=($direccion_envio->cod_postal == "") ? 'no_relleno' : '';?> mod_cod_postal input_formulario form-control" type="text" value="<?=$direccion_envio->cod_postal;?>"/>
				</div>
			</div>
			<div class="row">
				<div class="flocalidad col-xs-12 col-sm-4">
					<label class="lnombre"><?=traducir("Localidad");?>*</label>
					<input required  name="localidad" class="<?=($direccion_envio->localidad == "") ? 'no_relleno' : '';?> mod_localidad input_formulario form-control" type="text" value="<?=$direccion_envio->localidad;?>"/>
				</div>
				<div class="fprovincia col-xs-12 col-sm-4">
					<label class="lnombre"><?=traducir("Provincia");?>*</label>
					<input required  name="provincia" class="<?=($direccion_envio->provincia == "") ? 'no_relleno' : '';?> mod_provincia input_formulario form-control" type="text" value="<?=$direccion_envio->provincia;?>"/>
				</div>
				<div class="fpais col-xs-12 col-sm-4">
					<label class="lnombre"><?=traducir("Pais");?>*</label>
					<?php
					//Marina (16/Enero/2020) Creo nuevo campo país en el formulario de direcciones
					//Cargamos la lista de paises activos
					$lista_paises_activos = Pais::cargarActivos();
					//contamos cuantos activos hay
					$num_activos = count($lista_paises_activos);
					//inicializo el codigo de pais por defecto a 0 porque es numerico
					$pais_por_defecto = 0;
					//Si estamos editando formulario y tenemos ya un pais almacenado en la direccion del usuario
					if ( $editando && ($direccion_envio->pais != 0) ){
						//guardamos el codigo del pais como pais por defecto 
						$pais_por_defecto = $direccion_envio->pais;
					}else{
						//si no, vamos a guardar por defecto el que tenemos en la clase configuracion
						$pais_por_defecto = Shop::$configuracion->pais;
					}
					//Si hay algun pais activo en la BD creamos nuestro select option con la lista de paises activos
					if( $num_activos > 0){
					?>
						<select name="pais" <?= ($num_activos) == 1 ? 'disabled' : '';?> class="input_formulario form-control">
							<?php
							//si solo hay un pais en la lista deshabilitamos el select
							//vamos a recorrer la lista de paises activos
								foreach ($lista_paises_activos as $clave => $valor) {
									?>
									<option value="<?=$valor->codigo;?>" <?= ($valor->codigo) == $pais_por_defecto ? 'selected' : '';?>>
										<?=$valor->nombre;?>		
									</option>
									<?php
								}
							?>
						</select>
					<?php
					}
					?>
				</div>
			</div>
			<br>
			<div class="modificarDireccion">
			<?php
			//Sólo se muestra este botón si estamos editando o creando y tenemos más direcciones:
			if ( ($editando && (!$datos_incompletos)) || ($creando && ($direcciones_disponibles > 0)) ){
			?>
				<button type="button" class="boton" onclick="
					var data = {'creando' : false};
					WS_data_update(
					'CabeceraCesta',
					'setCreando',
					data,
					'*=\'bloque_direccion_envio\'|*=\'bloque_tipo_envio\'',
					function(objeto){

					}
				);">
					<span><?=traducir('Cancelar');?></span>
				</button>
			<?php
			}
			?>
				<button class="boton" type="submit" >
					<span><?=traducir('Guardar direccion');?></span>
				</button>
			</div>
			<br>
			<script>
				document.querySelector('#<?=$id_formulario;?>').addEventListener('submit', function(event){
					event.preventDefault();
					//Aquí cogemos los datos del formulario y los enviamos con nuestro método
					var data = {
						'codigo' : $(this).find('[name=\'codigo\']').val(),
						'nombre' : $(this).find('[name=\'nombre\']').val(),
						'telefono' : $(this).find('[name=\'telefono\']').val(),
						'direccion' : $(this).find('[name=\'direccion\']').val(),
						'cod_postal' : $(this).find('[name=\'cod_postal\']').val(),
						'localidad' : $(this).find('[name=\'localidad\']').val(),
						'provincia' : $(this).find('[name=\'provincia\']').val(),
						'pais' : $(this).find('[name=\'pais\']').val()
					};
					//console.log(data);
					WS_data_update(
						'CabeceraCesta',
						'setShippingDestination',
						data,
						'*=\'bloque_direccion_envio\'|*=\'bloque_tipo_envio\'|*=\'bloque_total_cesta\'',
						function(objeto){
							
						}
					);
				});
			</script>
		</div>
	</form>
</div>
<?php
	}else{
		Theme::include_file('direccion_envio_selector_direccion.php', $direccion_envio);
	}
?>
	
	