<?php
/*
  Vista de la ultima noticia de wordpress o de las ultimas noticias de wordpress.
  Funciones a disposicion del diseñador/Maquetador/programador
  get_the_category()
  the_category() => Da las categoría o categorías pudiendo pasarle como primero valor el separador entre ellas
  the_title() => nos da el titulo de la noticia
  get_permalink() => nos da el enlace hacia la noticia
  has_post_thumbnail() => nos devuelve si existe una imagen de portada
  the_post_thumbnail() => nos da la imagen destacada tambien llamada de portada del post, pudiendo pasarle como primer valor el tamaño
  small | medium | large y como segundo parametro un array de valores, a destacar de momento la posibilidad de que la imagen tenga una
  clase concreta.
  the_date() => Nos da la fecha del post adminitiendo ("Formato fecha",etiqueta html,cierre etiqueta)
  bloginfo('template_directory') =>informacion del blog, en esta ocasion solo la ruta haciea el template
 */
?>

<?php
$limit = 14;
$resumen = explode(' ', get_the_excerpt(), $limit);
if (count($resumen) >= $limit) {
    array_pop($resumen);
    $resumen = implode(" ", $resumen) . '...';
} else {
    $resumen = implode(" ", $resumen);
}
$resumen = preg_replace('`[[^]]*]`', '', $resumen);
?>


<div class="owl-item" >
    <div class="item sds_blog_post">
        <div class="news_module_image_holder">
            <div class="inline-block_relative">
                <div class="image_holder_wrap">
                    <a href="<?= get_permalink(); ?>">
                        <?php
                        if (has_post_thumbnail()) {
                            the_post_thumbnail(array(284, 210), array('class' => "feat_img_small"));
                        } else {
                            ?>
                            <img src="<?php bloginfo('template_directory'); ?>/images/notimg.png" alt="no imagen" class="feat_img_small"/>                    

                        <?php } ?>
                    </a>
                </div>
                <div class="right_blog_home">
                    <div class="content">
                        <h3 class="sds_post_title">
                            <?= the_title('<a href="' . get_permalink() . '" title="' . traducir('Más información sobre el evento') . '">', '</a>'); ?>
                        </h3>
                        <span class="block_post_date">
                            <i class="icon-calendar">
                            </i>
                            <span class="date_added"><?=  the_date(); ?></span>
                        </span>
                        <p><?= $resumen ?></p>
                        <a href="<?= get_permalink(); ?>" class="r_more"><?= traducir('Leer más'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>