<?php
//---------------------------------------------------------------------------------------------------------
// 10/Octubre/2014
// Versión 1.0 Versión estándar del código html de una mini-ficha de artículo
//---------------------------------------------------------------------------------------------------------
// Versión 1.1 No se va a utilizar "articulo_a_mostrar" en su lugar usaremos una variable local llamada "articulo_a_mostrar"
//---------------------------------------------------------------------------------------------------------
// Versión 1.2 A partir de ahora se cargan los tamaños de las portadas de la tabla "tam_portadas"
// Y la imagen se muestra con "capa_imagen
//---------------------------------------------------------------------------------------------------------
/* Preparacion de los enlaces para las redes sociales de forma que no necesitemos los plugin oficiales */
$url = "https://" . $_SERVER['HTTP_HOST'] . ":" . $_SERVER['SERVER_PORT'] . $_SERVER['REQUEST_URI'];
$url_facebook = "http://facebook.com/sharer.php?u=" . urlencode($url);
$urltwitter = "http://twitter.com/home?status=" . urlencode($url);
$urlgoogle = "https://plus.google.com/share?url=" . urlencode($url);
$urlwasap = "whatsapp://send?text=" . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=Arminet.jpg';
$urlpinterest = 'http://pinterest.com/pin/create/button/?url='. urlencode($url).'&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean='.$articulo_a_mostrar->ean.'&ancho=300&alto=300&calidad=100&fichero_no_foto=rioebro.jpg';
$product = $articulo_a_mostrar;
?>
<div class="<?=Theme::getConfigParam('container_style', 'container');?>">
    <?php
    escupirMiga('prd', true, ">"); //El segundo valor indica que quiero una miga compuesta por el servidor
    ?>
</div>

<div id="columns" class="<?=Theme::getConfigParam('container_style', 'container');?>">
    <div class="row">
        <div class="center_column col-xs-12 col-sm-12 col-md-12 col-lg-9">
            <div class="primary_block row">
                <div class="pb-left-column col-xs-12 col-sm-6 col-md-6">
                    <div id="image-block" class="clearfix">
                        <?php
                        //Debemos de poner el código de cliente de Hedra
                        $opciones = new OpcionesWidget(array("ean" => $product->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/"));
                        new Widget($_WH->GW("multifoto", "mostrarPortadaMultiFotoLupita"), $opciones);
                        ?>	
                    </div>

                    <p class="resetimg clear no-print">

                    </p>
                    <div id="views_block" class="clearfix extraFotos">
                        <div id="thumbs_list">
                            <?php
                            $opciones_extraFoto = new OpcionesWidget(array("ean" => $product->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/"));
                            $opciones_extraFoto->addProperty("tam_portada", "foto_extra");
                            new Widget($_WH->GW("multifoto", "mostrarExtraFotos"), $opciones_extraFoto);
                            ?>
                        </div>
                    </div>
                </div>
                <div class="pb-center-column col-xs-12 col-sm-6 col-md-6">
                    <h1 itemprop="name"><?= $product->nombre; ?></h1>
                    <p id="product_sub"> <?= $product->subtitulo ?> </p>
                    
                    <section id="idTab1" class="page-product-box">
                                <?php
                                if ($product->autor != '') {
                                    ?>
                                    <div class="autor">
                                        <h2><a href="<?= corregir_url(Shop::$configuracion->url . "autor/" . $product->autor); ?>" title="Autor <?= $product->autor ?>"><?= $product->autor ?></a></h2>
                                    </div>
                                    <?php
                                }
                                if ($product->editorial != '') {
                                    ?>
                                    <div class="editorial">
                                        <h2><a href="<?= corregir_url(Shop::$configuracion->url . "editorial/" . $product->editorial); ?>" title="Editorial <?= $product->editorial ?>"><?= $product->editorial ?></a></h2>
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="ean">
                                    <h5><?= traducir('EAN') ?>
                                        <strong><?= $product->ean ?></strong>
                                    </h5>
                                </div>
                                <?php
                                if ($product->ilustrador != '') {
                                    ?>
                                    <div class="ilustrador">
                                        <h5><?= traducir('Ilustrador'); ?>
                                            <strong><?= $product->ilustrador ?></strong> 
                                        </h5>
                                    </div>
                                    <?php
                                }
                                 if ($product->coleccion > 0) {
									?>
									<div class="even">
										<span class="titulo"><?= traducir('Colección'); ?>: </span>
										<span><a href="<?= corregir_url(Shop::$configuracion->url . "coleccion/" . $product->nombreColeccion); ?>" title="<?= $product->nombreColeccion ?>"><?= $product->nombreColeccion ?></a></span>
									</div>
									<?php
								}
								if ($product->numeroColeccion > 0 ){
									?>
									<div class="even">
										<span class="titulo"><?= traducir('Número en la colección'); ?>: </span>
										<span><?= $product->numeroColeccion ?></span>
									</div>
									<?php
								}
                                if ($product->encuadernacion != '') {
                                    ?>
                                    <div class="encuadernacion">
                                        <h5><?= traducir('Encuadernación'); ?>
                                            <strong><?= $product->encuadernacion ?></strong>
                                        </h5>
                                    </div> 
                                    <?php
                                }

                                if ($product->peso > 0) {
                                    ?>
                                    <div class="peso">
                                        <h5><?= traducir('Peso'); ?>
                                            <strong><?= $product->peso ?></strong>
                                        </h5>
                                    </div>
                                    <?php
                                }
                                if ($product->num_paginas > 0) {
                                    ?>
                                    <div class="paginas">
                                        <h5><?= traducir('Páginas'); ?>
                                            <strong><?= $product->num_paginas ?></strong>
                                        </h5>
                                    </div> 
                                    <?php
                                }
                                if ($product->alto > 0 && $product->ancho) {
                                    ?>
                                    <div class="medida">
                                        <h5><?= traducir('Tamaño'); ?>
                                            <strong><?= $product->ancho ?>mm X <?= $product->alto ?>mm</strong>
                                        </h5>
                                    </div> 
                                    <?php
                                }
                                ?>
                    </section>
                    
                    <?php  /*
                    if ($product->stock <= 0) {
                      ?>
                        <p class="bg-danger label">
                            <?= traducir('Producto agotado') ?>
                        </p>

                        <?php
                    } else */
                    if ($product->stock <= 0) {
                        ?>
                        <p class="bg-warning label">
                            <?= traducir('Advertencia: ¡Últimos artículos en inventario!') ?>
                        </p>
                        <?php
                    } else {
                        ?>
                        <p id="availability_statut">
                            <span id="availability_value" class="label label-success"><?= traducir('En stock') ?></span>
                        </p>
                        <?php
                    }
                    ?>
                    <div class="bloque_precio">
                        <div class="pvp">
                            <div id="product_comments_block_extra" class="no-print" >
                                <div class="content_prices clearfix">
                                    <?php
                                    if ($product->pvp_final != $product->pvp) {
                                        ?>
                                        <p id="old_price" class="">
                                            <span id="old_price_display">
                                                <span class="price"><?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                                            </span>
                                        </p>
                                        <p class="our_price_display" >
                                            <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro; </span>
                                        </p>
                                        <?php
                                    } else {
                                        ?>
                                        <p class="our_price_display" >
                                            <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                                        </p>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="comprar">
                            <div class="box-info-product">
                                <div class="box-cart-bottom">
                                    <div>
                                        <?php
                                        //Boton comprar
                                        $conf = new OpcionesWidget(array(
                                            'articulo' => $product,
                                            'fichero_boton' => 'botonComprarAmpliadaRelacionadosAside',
                                            'cantidad_dinamica' => true,
                                            'addBtnCantidad' => true
                                        ));
                                        new Widget($_WH->GW("articulo", "btnComprar"), $conf);
                                        ?>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>						
                            </div>
                        </div>
                    </div>
                    <section class="descripcion_seo">
                        <p>
                            <?php
                                //25-03-2019(Marina) 
                                //compara la descripcion seo con la descripcion completa, si son distintas muestra la seo
                                $descripcion_resumida =$product->descripcion_seo;
                                $masinfo=false;
                                if(strtoupper($product->descripcion_seo) == strtoupper($product->observaciones)){
        							$descripcion_resumida = strip_tags($product->observaciones, '<strong><a>');                                   
        						   $descripcion_resumida=substr($product->observaciones,0,250);
                                    //si la descripcion ya resumida es distinta de la completa le añade puntos suspensivos
                                    if(strnatcasecmp($descripcion_resumida, $product->observaciones)!=0){
                                        $descripcion_resumida.='...';
                                        $masinfo=true;
                                    }
                                }
                            ?>
                            <?= $descripcion_resumida; ?>
                            <?php 
                            if($masinfo){
                                ?>
                                <strong><a id="seguir" href="javascript:$('html,body').animate({scrollTop: $('#ancla').offset().top-100},'slow');">Seguir leyendo</a></strong>
                            <?php
                            }
                            ?>
                        </p>
                    </section>
                    <p class="socialsharing_product list-inline no-print">
                        <a class="solcial" href="<?= $urltwitter ?>" target="_blank">
                            <button data-type="twitter" type="button" class="boton btn-twitter social-sharing">
                                <span class="mdi mdi-twitter"></span> <?=traducir('Tweet');?> 
                            </button> 
                        </a>
                        <a class="solcial" href="<?= $url_facebook ?>" target="_blank">
                            <button data-type="facebook" type="button" class="boton btn-facebook social-sharing"> 
                                <span class="mdi mdi-facebook"></span> <?=traducir('Compartir');?>
                            </button>
                        </a>
                        
                        <a class="solcial" href="<?= $urlpinterest ?>" target="_blank">
                            <button data-type="pinterest" type="button" class="boton btn-pinterest-plus social-sharing"> 
                                <span class="mdi mdi-pinterest"></span> <?=traducir('Pinterest');?>
                            </button>
                        </a>
                        
                        <a class="solcial" href="<?= $urlwasap ?>" target="_blank">
                            <button data-type="whatsapp" type="button" class="boton btn-whatsapp social-sharing"> 
                                <span class="mdi mdi-whatsapp"></span> <?=traducir('Whatsapp');?>
                            </button>
                        </a>
                    </p>
                </div>
            </div>
            <div id="ancla" class="bloque_descripcion">
                <?php
                    if($product->observaciones != ''){
                        ?>
                        <span class="masinfo"><strong><i class="mdi mdi-plus"></i> <?=traducir('info');?></strong></span>
                        <section id="idTab2" class="descripcion">
                            <?= $product->observaciones; ?>
                        </section>
        			 <?php
                    }
                ?>
            </div>
        </div>
        <div class="ficha_aside col-xs-12 col-sm-12 col-md-12 col-lg-3 column">
            <?php
            new Widget($_WH->GW("articulo", "escaparates_articulo"), $articulo_a_mostrar);
            ?>
            
            <?php
            //Cargamos 3 productos relacionados con éste
            $relacionados = $articulo_a_mostrar->productos_relacionados();
            if ($relacionados > 0) {
                ?>
                <div id="productos_relacionados">
                    <h4 class="headRelated"><?= traducir('Productos Relacionados'); ?>:</h4>
                    <?php
                    $widget_relacionados = new Widget($_WH->GW('articulo', 'lista_articulos'), 'ficha_aside', $articulo_a_mostrar->lista_articulos);
                    ?>
                </div>
                <?php
            }
            ?>
        
            <div class="banner_aside">
                <?php
                $ruta_cabecera = Theme::include_file("banner_novedades.php");
                ?>
            </div>
        </div>
    </div>
</div>
<!--Datos para google shoping-->
<span itemprop="name" content="<?= $product->nombre; ?>"></span>
<span itemprop="offerURL" content="<?= $product->url; ?>"></span>
<span itemprop="image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $product->ean; ?>.jpg"></span>
<span itemprop="offerDetails" itemscope itemtype="http://data-vocabulary.org/Offer">
    <span itemprop="identifier" content="isbn:<?= $product->ean; ?>"></span>
    <span class="precio-producto">
        <span itemprop="price" content="<?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?>"></span>
        <span itemprop="currency" content="EUR"></span>
    </span>
    <?php
    if ($product->stock > 0) {
        $disponibilidad = "in_stock";
    } else {
        $disponibilidad = "out_of_stock";
    }
    ?>
    <span itemprop="availability" content="<?= $disponibilidad; ?>"></span>
</span>