<?php
//---------------------------------------------------------------------------------------------------------
// 30/Septiembre/2014
// Versión 1.0 Header natural de la web. La cabecera con todos sus includes y resto de datos
//---------------------------------------------------------------------------------------------------------
// 03/Marzo/2015
// Versión 1.1 Modificamos los datos referentes a la cesta para hacerlas más versátil y más encapsulada
//---------------------------------------------------------------------------------------------------------

//include('comunes/globals.php');

//Vamos a coger la sección actual:
$seccion = Sections::$current_section;

//Si la sección es erronea, vamos a mostrar un 404
if ($seccion == 'error') {
    header('HTTP/1.0 404 Not Found');
}
$idioma = strtolower(Sesion::get('idioma'));
$idioma_local = getLocale();
//Ojo a las locales, por ahora las ponemos en español
setlocale(LC_ALL, $idioma_local);
//Pedro 07/Febrero/2020
//PERO LAS LOCALES NUMÉRICAS VAN EN INGLÉS PARA QUE SEAN 100% COMPATIBLES CON MySql. Esto es porque si no lo hacemos así nos mete los decimales como coma: ','
setlocale(LC_NUMERIC, 'en_US');

//Datos SEO principales. Si no los tenemos, hemos de cogerlos de configuración
$title_web = SEO::getTitle(Shop::$empresa->nombre);
$descripcion_web = SEO::getDescription(Shop::$configuracion->descripcion);
$keywords_web = SEO::getKeywords(Shop::$configuracion->meta);

/*
//Por ahora deshabilitamos la caché
//Vamos a poner una caché de 1 mes:
$seconds_to_cache = 2592000;
$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
header("Expires: $ts");
header("Pragma: cache");
header("Cache-Control: max-age=$seconds_to_cache");
*/
?>
    <head>
        <title><?= strip_tags($title_web); ?></title>
		<meta charset="UTF-8" >
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta http-equiv="Vary" content="Accept-Encoding"/>
        <meta name="language" content="<?= $idioma; ?>"/>
        <meta name="author" content="Arminet"/>
        <meta name="Copyright" content="Copyright ARMINET"/>
        <meta name="revisit-after" content="1 hour"/>
        <meta http-equiv="Cache-Control" content="public"/>
        <!--<meta http-equiv="EXPIRES" content="<?= date(DATE_RSS, time() + 2419200); ?>" />-->
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="description" content="<?=strip_tags(substr($descripcion_web, 0, 160)); ?>" />
        <meta name="keywords" content="<?= substr($keywords_web, 0, 250); ?>" />
        <meta name="title" content="<?=strip_tags($title_web); ?>" />
        <style type="text/css"> 
          <?php include(_WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_ . 'css/cabecera_pie.css')  ?>
      </style>
        <?php
		//Vamos a cargar el loader:
		?>
		<style type="text/css">
			<?php include(_WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_ . 'css/loading.css')  ?> 
		</style>
		<?php
        //Etiquetas que tenemos que añadir
        //Multi-idioma
        //Vamos a cargar todos los idiomas
        $sentencia_sql = "SELECT codigo, locale FROM idioma WHERE disponible = 1 AND UPPER(codigo) != '" . strtoupper($idioma) . "' ";
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                ?>
                <link rel="alternate" href="<?= Shop::$configuracion->url_sin_idioma; ?><?= strtolower($fila['codigo']); ?>/" hreflang="<?= $fila['locale']; ?>">
                <?php
            }
        }

        //RSS:
        //<link rel="alternate" type="application/atom+xml" href="http://php.net/releases/feed.php" title="PHP Release feed">
        //<link rel="alternate" type="application/atom+xml" href="http://php.net/feed.atom" title="PHP: Hypertext Preprocessor">
        //Una URL canónica es la que sirve el contenido real de la página, por si hay contenido duplicado
        //<link rel="canonical" href="http://php.net/manual/es/function.setcookie.php">
        //Consultar aquí: http://blog.solucionesc2.com/como-usar-rel-canonical-c2-seo
        //URL CORTA
        //<link rel="shorturl" href="http://php.net/setcookie">
        //BUSCADOR, especificación
        /* // ==> DESACTIVADO POR AHORA
		$fichero_a_incluir = Theme::findFile('buscador_interno.php');
        //Si tenemos fichero para incluir, lo incluimos, en caso contrario no incluimos nada
        if ($fichero_a_incluir != NULL) {
            ?>
            <link rel="search" type="application/opensearchdescription+xml" href="<?= Shop::$configuracion->url . $fichero_a_incluir; ?>" title="<?= traducir('Buscador de') . ' ' . Shop::$empresa->nombre; ?>">
            <?php
        }*/
        //Consultar aquí: http://www.opensearch.org/Specifications/OpenSearch/1.1
        //Buscador de google
        ?>
        <script type="application/ld+json">
			{
			"@context": "http://schema.org",
			"@type": "WebSite",
			"url": "<?= Shop::$configuracion->url; ?>",
			"potentialAction": {
				"@type": "SearchAction",
				"target": "<?= Shop::$configuracion->url; ?>buscar/{search_term_string}",
				"query-input": "required name=search_term_string"
				}
			}
        </script>
<?php
//INDEXACIÓN DE ESTE CONTENIDO
//<link rel="contents" href="http://php.net/manual/es/index.php">
//<link rel="index" href="http://php.net/manual/es/ref.network.php">
//<link rel="prev" href="http://php.net/manual/es/function.pfsockopen.php">
//<link rel="next" href="http://php.net/manual/es/function.setrawcookie.php">
?>
        <link rel="shortcut icon" href="<?= Shop::$configuracion->url . 'favicon.ico'; ?>">
         <link rel="icon" href="<?= Shop::$configuracion->url; ?>favicon.ico">
    <link rel="apple-touch-icon" sizes="57x57" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-16x16.png">
    <link rel="manifest" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#4666a0">
    <meta name="msapplication-TileImage" content="<?= Shop::$configuracion->url; ?>favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#4666a0">
<?php
        //De nuevo no cargamos esto si estamos en la sección de error
        if ($seccion != 'error') {/*
            ?>

            <?php //Por último añadimos las funciones que "beben" de la configuración ?>
            <script type="text/javascript">
			captchaArray = null;
			document.addEventListener('WSLE', function(event) {
                //Captha site keys
                captchaArray = new captchaElements();
                //Vamos a asignar los valores pendientes en las cookies
			});
			<?php
			if (count($cookies_por_asignar) > 0) {
				foreach ($cookies_por_asignar as $clave => $valor) {
					?>
					<?= $valor; ?>
					<?php
				}
			}
			?>
			});
			<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit&hl=<?= $idioma; ?>" async defer>});
			<?php
			*/
		}
//Ahora vamos a cargar el analytics:
$fichero_a_incluir = Theme::include_file('analytics.php');

//Login de Google si es que lo tenemos:
if (Shop::$configuracion->google_api_id != ''){
	?>
	<meta name="google-signin-client_id" content="<?=Shop::$configuracion->google_api_id;?>">
	<?php
}

//Aquí vamos a cargar los css y js de la cabecera:
Theme::loadMedia(_WS_MEDIA_TYPE_CSS, _WS_MEDIA_POSITION_TOP);
Theme::loadMedia(_WS_MEDIA_TYPE_JS, _WS_MEDIA_POSITION_TOP);

//Tatiana: 19-06-18 => He metido estos metas para que en la ficha del articulo mostramos los metas para que facebook lo indexe bien. 
 if( Sections::getParam('articulo')){
        $articulo_face = Sections::getParam('articulo');
        ?>
        <!-- Datos para Facebook -->
<meta property="og:title" content="<?= $articulo_face->nombre; ?>">
<meta property="og:type" content="article">
<meta property="og:description" content="<?= strip_tags($articulo_face->observaciones); ?>">
<meta property="og:url" content="<?= $articulo_face->url; ?>">
<meta property="og:image" content="https://www.sinlib.es/portadasSinlib/muestraPortada.php?ean=<?= $articulo_face->ean; ?>&cliente=<?=Shop::$configuracion->cliente_arminet;?>&ruta=&ancho=0&alto=395&calidad=70&fichero_no_foto=arminet.jpg">
<meta property="og:site_name" content="<?= Shop::$configuracion->url; ?>">
<?php
    }
?>
    </head>
