function ComponentClass(htmlObject, opciones){
	//Ojo que esta función puede que reciba un objeto "no jquery". en cuyo caso no sigue para delante
	this.error = null;
	//Estas propiedades es necesario inicializarlas
	this.sizeX = "auto";
	this.sizeY = "auto";		
	
	//console.log(htmlObject);
	htmlObject = (typeof(htmlObject) === 'undefined') ? new array() : htmlObject;
	opciones = (typeof(opciones) === 'undefined') ? {} : opciones;
	if ( (htmlObject.length == 0) || (typeof(htmlObject) != 'object')){
		this.error = "Objeto jquery incorrecto";
	}else{
		this.htmlObject = htmlObject;
		this.id = htmlObject.attr("id");
		//Si no hay ID, tampoco permitimos que se cree el objeto
		if ( (this.id == "") || (typeof(this.id) == 'undefined') ){
			//Si no tiene ID, se lo vamos a poner a mano
			var date = new Date();
			var cadenaFecha = date.getHours();
			cadenaFecha = cadenaFecha.toString().concat( date.getMinutes().toString(), date.getSeconds().toString(), date.getMilliseconds().toString() );
			this.htmlObject.attr('id', cadenaFecha);
			//this.error = "Es necesario que el objeto contenga un ID";
			//console.log(htmlObject);
		}
		//Definimos las propiedades de este elemento por defecto
		this.fixedPosition = false;			//Posición fija o relativa(false/true);
		this.inSpeed = 'fast';				//Velocidad de aparición (parámetro jquery)
		this.outSpeed = 'fast';				//Velocidad de desaparición (parámetro jquery
		this.centerH = true;				//El objeto se centra en la pantalla horizontalmente (true/false)
		this.centerV = true;				//El objeto se centra en la pantalla verticalmente (true/false)
		this.sizeX = 'auto';				//Ancho del componente (auto/valor fijo)
		this.sizeY = 'auto';				//Alto del componente (auto/valor fijo)
		this.positionX = 'auto';			//Posición horizontal del componente (auto/valor fijo/parent_{l,t})
		this.positionY = 'auto';			//Posición vertical del componente (auto/valor fijo/parent_{t,b})
		this.pivot = 'lt';					//Pivote del objeto (lt, rt, rb, lb, c);
		this.closeButton = true;			//Indica si hay que añadir o no, un botón de cerrar (true/false)
		this.type = 'modal';				//Tipo de componente (modal/dropDown/dropRight)
		this.transBackground = true;		//Indica si el fondo ha de mostrarse transparente (true/false)
		this.zindex = 50;					//Profundidad del objeto en el eje z
		this.hType = "left";				//Indica si el la posición horizontal se asigna con "left" o con "right"
		this.vType = "top";					//Indica si el la posición horizontal se asigna con "top" o con "bottom"
		this.dropNotClose = false;			//Activando esta opción, los dropRight, left, etc, no se cierran sólos

		//Propiedades que no se deben modificar, se modificarán automáticamente por el objeto
		this.realSizeX = 0;
		this.realSizeY = 0;
		this.realPositionX = 0;
		this.realPositionY = 0;
		this.isShowing = false;	//Cuando es true se está animando 
		//Ahora es el momento de cargar las opciones del array si nos lo hubiesen pasado
		//console.log(opciones, typeof(opciones));
		if (typeof(opciones) == 'object'){
				//Vamos a recorrer las opciones recibidas para asignar sus valores a las opciones de este objeto
				for (var clave in opciones){
						this[clave] = opciones[clave];
						//console.log(clave, opciones[clave]);
				}
		}
		//Vamos a hacer unas correcciones, aquellos elementos que sean "fixedDropLeft, fixedDropRight, etc. se cambian a dropLeft, dropRight, etc activando la opción "dropNotClose"
		if (this.type == "fixedDropRight"){
				this.type = "dropRight";
				this.dropNotClose = true;
		}else if (this.type == "fixedDropLeft"){
				this.type = "dropLeft";
				this.dropNotClose = true;
		}else if (this.type == "fixedDropDown"){
				this.type = "dropDown";
				this.dropNotClose = true;
		}else if (this.type == "fixedDropUp"){
				this.type = "dropUp";
				this.dropNotClose = true;
		}
		//Hay que quitar el visibility hidden y poner un display none
		this.htmlObject.css({
				"display":"none",
				"visibility":""
		});
		//Es posible que haya algún padre con position fixed, si es así tenemos que saberlo:
		//Esto deja de ser así, si un elelemento padre es fixed, no es necesario poner este también fixed
		/*var objAux = this;
		this.htmlObject.parents().each(function(){
				if ($(this).css("position") === "fixed") {
						objAux.fixedPosition = true;
				}
		});*/

		//Le ponemos por el momento la posicion como corresponda
		if (this.fixedPosition){
				this.htmlObject.css("position", "fixed");
		}else{
				this.htmlObject.css("position", "absolute");
		}


		//Si tiene botón de cerrar, es el momento de añadirlo
		if (this.closeButton){
				var equis = $('<div class="btn_cerrar_widget"><a href="javascript:void(0)">X</a></div>');
				var objAux = this;
				equis.on("click", function(){
						objAux.hide();
				});
				this.htmlObject.prepend(equis);
		}
		
	}
}

//Funciónes del componente:
ComponentClass.prototype.resize = function (assignNewSize){
	if (typeof(assignNewSize === 'undefined')){
		assignNewSize = true;
	}
	var ancho = 0;
	var alto = 0;
	var tmpAncho = this.htmlObject.outerWidth();
	var tmpAlto = this.htmlObject.outerHeight();
	//Para esta función necesitamos que los valores de sizeX y sizeY sean alfabéticos.
	this.sizeX = this.sizeX.toString();
	this.sizeY = this.sizeY.toString();
	//Calculamos el ancho
	if (this.sizeX == 'auto'){
		//Quitamos la propiedad css del ancho y vemos cómo queda:
		this.htmlObject.css("width", "");
		ancho = this.htmlObject.outerWidth();
	}else{
		//Si el ancho tiene un %, lo calculamos a partir del body
		if (this.sizeX.indexOf("%") >= 0){
			var tmpAncho = this.sizeX.replace("%", "");
			ancho = ($("body").width() * tmpAncho) / 100;
		}else{
			ancho = this.sizeX;
		}
	}
	//Le reasignamos el ancho que tenía
	this.htmlObject.css({"width":tmpAncho + "px"});

	//Calculamos el alto
	if (this.sizeY == 'auto'){
		//Quitamos la propiedad css del ancho y vemos cómo queda:
		this.htmlObject.css("height", "");
		alto = this.htmlObject.outerHeight();
	}else{
		//Si el ancho tiene un %, lo calculamos a partir del body
		if (this.sizeY.indexOf("%") >= 0){
			var tmpAlto = this.sizeY.replace("%", "");
			alto = ($("body").height() * tmpAlto) / 100;
		}else{
			alto = this.sizeY;
		}
	}
	this.htmlObject.css({"width":tmpAlto + "px"});

	this.realSizeX = ancho;
	this.realSizeY = alto;
	//Redimensionamos el objeto si es necesario
	if (assignNewSize){
		this.htmlObject.css({
			"width":this.realSizeX + "px",
			"height":this.realSizeY + "px"
		});
	}
}

ComponentClass.prototype.calculePosition = function (putAfterCalculate){
	putAfterCalculate = (typeof putAfterCalculate === 'undefined') ? false : putAfterCalculate;
	//Hay que recalcular el tamaño del objeto
	this.resize();
	//El objeto llamado "padre" es el lanzador que siempre está justo después de este
	var posX = 0;
	var posY = 0;
	//Por si el elemento tiene la posición relativa al padre, vamos a coger la posción de dicho elemento
	//var padre = this.htmlObject.next().next();
	var padre = this.htmlObject.siblings(".lanzador_widget");
	//console.log(padre);
	//                           L, R, T, B
	var padreOffset = new Array( 0, 0, 0, 0);
	if (padre.length > 0){
		//Esquina superior izquierda
		var offset = padre.offset();
		//console.log(offset);
		//Vamos a tener en cuanta que haya un elemento con position relativa
		var padreColocado = this.htmlObject
		.parents()
		.filter(function() { 
			return ( ($(this).css('position') == 'relative') || ($(this).css('position') == 'absolute' ) );
		}).first();
		if (padreColocado.length > 0){
			//console.log(padreColocado);
			//Si existe padre colocado, vamo a sacar su posición:
			padreColocadoOffset = padreColocado.offset();
			offset.left -= padreColocadoOffset.left;
			offset.top -= padreColocadoOffset.top;
			//console.log(padreColocadoOffset, padreColocado);
		}
		//console.log(offset);

		padreOffset[0] = offset.left;
		padreOffset[1] = offset.left + padre.outerWidth();
		padreOffset[2] = offset.top;
		padreOffset[3] = offset.top + padre.outerHeight();
		//console.log(padreOffset);
	}
	//console.log(padreOffset);

	//***********
	//Eje X
	//***********
	//Si el elemento no está centrado actuamos de una forma
	if (!this.centerH){
		//Según la el "tipo" de posicion tenemos que hacer una cosa u otra:
		switch (this.positionX){
			case 'auto':
				this.htmlObject.css("left", "");
				var offset = this.htmlObject.offset();
				posX = offset.left;
				if (this.fixedPosition){
					posX -= $(window).scrollLeft();
				}
			break;
			case 'parent_l':
				posX = padreOffset[0];
				if (this.fixedPosition){
					posX -= $(window).scrollLeft();
				}
			break;
			case 'parent_r':
				posX = padreOffset[1];
				if (this.fixedPosition){
					posX -= $(window).scrollLeft();
				}
				//console.log("la posicion " + posX);
			break;
			default:
				//Posición fija
				posX = this.positionX;
		}
		//console.log(posX);
	}else{
		//Hay que centrar el elemento en pantalla
		//Voy a cargar el alto y el ancho sin usar los valores de jquery que no me dan el area visible y que no tenga fixed position
		var ancho = window.innerWidth;
		var scrollLeft = 0;
		var ancho_elemento = this.htmlObject.outerWidth();
		if (!this.fixedPosition){
			scrollLeft = $(window).scrollLeft();
		}
		posX = (ancho / 2) - (ancho_elemento / 2) + scrollLeft;
	}
	//***********
	//Eje Y
	//***********
	//Si el elemento no está centrado actuamos de una forma
	if (!this.centerV){
		//Según la el "tipo" de posicion tenemos que hacer una cosa u otra:
		switch (this.positionY){
			case 'auto':
				this.htmlObject.css("top", "");
				var offset = this.htmlObject.offset();
				posY = offset.top;
				if (this.fixedPosition){
					posY -= $(window).scrollTop();
				}
			break;
			case 'parent_t':
				posY = padreOffset[2];
				if (this.fixedPosition){
					posY -= $(window).scrollTop();
				}
			break;
			case 'parent_b':
				posY = padreOffset[3];
				if (this.fixedPosition){
					posY -= $(window).scrollTop();
				}
			break;
			default:
				//Posición fija
				posY = this.positionY;
		}
	}else{
		//Hay que centrar el elemento en pantalla
		//Voy a cargar el alto y el ancho sin usar los valores de jquery que no me dan el area visible. Sólo lo hago para los que no tengan un "fixed position"
		var alto = window.innerHeight;
		var scrollTop = 0;
		var	alto_elemento = this.htmlObject.outerHeight();
		if (!this.fixedPosition){
			scrollTop = $(window).scrollTop();
		}
		posY = (alto / 2) - (alto_elemento / 2) + scrollTop;
	}
        
	//Los cálculos hechos hasta ahora son para la esquina superior izqueirda. Ahora tenemos que ver el punto de pivote
	switch(this.pivot){
		case 'rt':
			//Derecha arriba
			if (this.hType == "left"){
				posX -= this.htmlObject.outerWidth();
			}
		break;
		case 'lb':
			//Izquierda abajo
			if (this.vType == "top"){
				posY -= this.htmlObject.outerHeight();
			}
		break;
		case 'rb':
			//Derecha abajo
			//Lo subimos y desplazamos a la izquierda
			if (this.hType == "left"){
				//console.log(posX, this.htmlObject.outerWidth());
				posX -= this.htmlObject.outerWidth();
			}
			if (this.vType == "top"){
				posY -= this.htmlObject.outerHeight();
			}
		break;
		case 'c':
			//Centro
			//Hay que subirlo y desplazarlo a la izquierda la mitad de su valor actual y redondeando
			if (this.hType == "left"){
				posX -= Math.round(this.htmlObject.outerWidth() / 2);
			}
			if (this.vType == "top"){
				posY -= Math.round(this.htmlObject.outerHeight() / 2);
			}
		break;
		default:
		break;
	}
	
	this.realPositionX = parseFloat(posX);
	this.realPositionY = parseFloat(posY);
	if (putAfterCalculate){
		this.put();
	}
}

ComponentClass.prototype.put = function(){
	if (this.hType == "right"){
		this.htmlObject.css({"right":this.realPositionX + "px"});
	}else{
		this.htmlObject.css({"left":this.realPositionX + "px"});
	}
	if (this.vType == "bottom"){
		this.htmlObject.css({"bottom":this.realPositionY + "px"});
	}else{
		this.htmlObject.css({"top":this.realPositionY + "px"});
	}
	this.htmlObject.css({
		"z-index":this.zindex
	});
}

ComponentClass.prototype.show = function (){
	//No hacemos nada si el elemento está visible
	if ( (!this.htmlObject.is(":visible")) && (!this.isShowing) ){
		//Según el tipo de elemento, hay que hacer que aparezca de una forma o de otra
		switch (this.type){
			case 'modal':
				//Lo primero es detener cualquier tipo de animación que hubiese sobre este elemento:
				this.htmlObject.stop();
				//Mostramos el elemento sin tener en cuenta su opacidad actual
				var objAux = this;
				var initialWidth = this.htmlObject.outerWidth();
				var initialHeight = this.htmlObject.outerHeight();
				this.htmlObject.show({
					"duration":this.inSpeed, 
					"step":function(now, fx){
						//Vamos a modificar la posición del elemento para que se centre
						if (objAux.hType == "right"){
							var valor = objAux.realPositionX + ( ($(this).outerWidth() - initialWidth) / 2);
							objAux.htmlObject.css({"right" : objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px"});
						}else{
							objAux.htmlObject.css({"left" : objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px"});
						}
						if (objAux.vType == "bottom"){
							objAux.htmlObject.css({"bottom" : objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"});
						}else{
							objAux.htmlObject.css({"top" : objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"});
						}

						/*
						objAux.htmlObject.css({
							hPosition:objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px",
							vPosition:objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"
						});
						*/

					},
					"complete":function(){objAux.isShowing = false;}
				});
				if (this.transBackground){
					componentList.show("fondo_blanco");
				}
			break;

			case 'dropRight':
				var sub_timer = 0;
				var auxObject = this;
				this.htmlObject.animate({width:'toggle'}, {"duration":this.inSpeed, "complete":function(){auxObject.isShowing = false;}});
				//Vamos a conntrolar el mouse out
				if (!this.dropNotClose){
					this.htmlObject.on("mouseleave", function(){
						//Creamos un timer que lo quite
						sub_timer = setTimeout(function() {
							auxObject.hide();
						}, 500);
					});
					//Creamos un evento "mouseenter" para cancelar el timer
					this.htmlObject.on("mouseenter", function(){ clearTimeout(sub_timer);});
				}
			break;

			case 'dropLeft':
				var auxObject = this;
				var initSize = this.htmlObject.outerWidth();
				var auxObject = this;
				//Antes de nada, colocamos el objeto en el lugar que le corresponde, siempre hacia la derecha para que no afecte a la animación
				this.htmlObject.animate({width:'toggle'},{"duration" : this.inSpeed, "step":function(now,fx){
					auxObject.htmlObject.css({"left": auxObject.realPositionX + initSize - fx.now + "px"});
				}, "complete":function(){auxObject.isShowing = false;}});
				//Vamos a conntrolar el mouse out
				var sub_timer = 0;
				if (!this.dropNotClose){
					this.htmlObject.on("mouseleave", function(){
						//Creamos un timer que lo quite
						sub_timer = setTimeout(function() {
							auxObject.hide();
						}, 500);
					});
					//Creamos un evento "mouseenter" para cancelar el timer
					this.htmlObject.on("mouseenter", function(){ clearTimeout(sub_timer);});
				}
			break;

			case 'dropDown':
				var sub_timer = 0;
				var auxObject = this;
				this.htmlObject.animate({height:'toggle'}, {"duration":this.inSpeed, "complete":function(){auxObject.isShowing = false;}});
				//this.htmlObject.slideToggle( this.inSpeed );
				//Vamos a conntrolar el mouse out
				//console.log('dropDown');
				if (!this.dropNotClose){

					this.htmlObject.on("mouseleave", function(){
						//Creamos un timer que lo quite
						sub_timer = setTimeout(function() {
							//$(auxObject).slideToggle();
							auxObject.hide();
						}, 500);
					});
					//Creamos un evento "mouseenter" para cancelar el timer
					this.htmlObject.on("mouseenter", function(){ clearTimeout(sub_timer);});

				}
			break;

			case 'dropUp':
				var auxObject = this;
				var initSize = this.htmlObject.height();
				var sub_timer = 0;
				var auxObject = this;
				//Antes de nada, colocamos el objeto en el lugar que le corresponde, siempre hacia la derecha para que no afecte a la animación
				this.htmlObject.animate({height:'toggle'},{"duration" : this.inSpeed, "step":function(now,fx){
					auxObject.htmlObject.css({"top": auxObject.realPositionY + initSize - fx.now + "px"});
				}, "complete":function(){auxObject.isShowing = false;}});
				//Vamos a conntrolar el mouse out
				if (!this.dropNotClose){

					this.htmlObject.on("mouseleave", function(){
						//Creamos un timer que lo quite
						sub_timer = setTimeout(function() {
							auxObject.hide();
						}, 500);
					});
					//Creamos un evento "mouseenter" para cancelar el timer
					this.htmlObject.on("mouseenter", function(){ clearTimeout(sub_timer);});
				}
			break;
		}
		this.isShowing = true;
	}
}

ComponentClass.prototype.hide = function (){
	//No hacemos nada si el elemento ya es invisible
	if ( (this.htmlObject.is(":visible")) && (!this.isShowing) ){
		//Según el tipo de elemento, hay que hacer que aparezca de una forma o de otra
		switch (this.type){
			case 'modal':
				//Lo primero es detener cualquier tipo de animación que hubiese sobre este elemento:
				this.htmlObject.stop();
				//Mostramos el elemento sin tener en cuenta su opacidad actual
				var objAux = this;
				var initialWidth = this.htmlObject.outerWidth();
				var initialHeight = this.htmlObject.outerHeight();
				this.htmlObject.hide({
					"duration":this.outSpeed, 
					"step":function(now, fx){
						//Vamos a modificar la posición del elemento para que se centre
						if (objAux.hType == "right"){
							objAux.htmlObject.css({"right":objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px"});
						}else{
							objAux.htmlObject.css({"left":objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px"});
						}
						if (objAux.vType == "bottom"){
							objAux.htmlObject.css({"bottom":objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"});
						}else{
							objAux.htmlObject.css({"top":objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"});
						}
						/*
						objAux.htmlObject.css({
							hPosition:objAux.realPositionX + ( (initialWidth - $(this).outerWidth() ) / 2) + "px",
							vPosition:objAux.realPositionY + ( (initialHeight - $(this).outerHeight() ) / 2) + "px"
						});
						*/
					},
					"complete":function(){objAux.isShowing = false;}
				});
				if (this.transBackground){
					componentList.hide("fondo_blanco");
				}
			break;
			case 'dropRight':
				this.htmlObject.off("mouseleave");
				//Quitamos la rutina del mouseenter
				this.htmlObject.off("mouseenter");
				//ocultamos el elemento
				this.htmlObject.animate({width:'toggle'}, this.outSpeed);
			break;
			case 'dropLeft':
				this.htmlObject.off("mouseleave");
				//Quitamos la rutina del mouseenter
				this.htmlObject.off("mouseenter");
				var auxObject = this;
				var initSize = this.htmlObject.outerWidth();
				this.htmlObject.animate({width:'toggle'},{"duration" : this.outSpeed, "step":function(now,fx){
					//Aquí hay que mover el elemento hacia la derecha
					auxObject.htmlObject.css({"left": auxObject.realPositionX + initSize - fx.now + "px"});
				},"complete":function(){auxObject.isShowing = false;}});
			break;
			case 'dropDown':
				this.htmlObject.off("mouseleave");
				//Quitamos la rutina del mouseenter
				this.htmlObject.off("mouseenter");
				//ocultamos el elemento
				this.htmlObject.animate({height:'toggle'}, this.outSpeed);
			break;
			case 'dropUp':
				this.htmlObject.off("mouseleave");
				//Quitamos la rutina del mouseenter
				this.htmlObject.off("mouseenter");
				var auxObject = this;
				var initSize = this.htmlObject.height();
				this.htmlObject.animate({height:'toggle'},{"duration" : this.outSpeed, "step":function(now,fx){
					//Aquí hay que mover el elemento hacia la derecha
					auxObject.htmlObject.css({"top": auxObject.realPositionY + initSize - fx.now + "px"});
				},"complete":function(){auxObject.isShowing = false;}});
			break;
		}
	}
}

//Lista de componentes de la web
function ComponentList(){
	this.components = new Array();
	//Cuando busquemos elementos o recorramos el array, empezamos siempre en el 1. El 0 es el fondo blanco
        
}
ComponentList.prototype.add = function (htmlObject, opciones, posicion){
	//Si posición es true, se coloca el elemento al principio, en cualquier otro caso, se pone al final
	posicion = (typeof posicion === 'undefined') ? false : posicion;
	var auxObject = new ComponentClass(htmlObject, opciones);
	if (auxObject.error == null){
		if (posicion){
			this.components.unshift(auxObject);
		}else{
			this.components.push(auxObject);
		}
	}else{
		console.log(auxObject.error);
	}
	return(this.components.length - 1);
}
ComponentList.prototype.show = function(id){
	var limit = this.components.length;
	var finded = false;
	for (var i = 0; (i < limit) && (!finded); i++){
		if (this.components[i].id == id){
			this.components[i].show();
			finded = true;
		}
	}
}
ComponentList.prototype.hide = function(id){
	var limit = this.components.length;
	var finded = false;
	for (var i = 0; (i < limit) && (!finded); i++){
		if (this.components[i].id == id){
			this.components[i].hide();
			finded = true;
		}
	}
}

ComponentList.prototype.hideAll = function(){
	var limit = this.components.length;
	for (var i = 1; i < limit; i++){
		this.components[i].hide();
	}
	//01/Julio/2016 ==> Si por is no hay nada que ocultar, ocultamos el fondo
	componentList.hide("fondo_blanco");
}

ComponentList.prototype.resize = function(id, assingNewSize){
	//console.log(id);
	var resizeAll = false;
	if (typeof id === 'undefined'){
		resizeAll = true;
	}
	var limit = this.components.length;
	for (var i = 0; i < limit; i++){
		//console.log(this.components[i].id);
		if ( (this.components[i].id == id) || (resizeAll) ){
			this.components[i].resize(assingNewSize);
		}
	}
}
ComponentList.prototype.calculePosition = function(putAfterCalculate, id){
	var limit = this.components.length;
	for (var i = 0; i < limit; i++){
		var modificar = false;
		if (id != null){
			if (this.components[i].id == id){
				modificar = true;
			}
		}else{
			modificar = true;
		}
		if (modificar){
			this.components[i].calculePosition(putAfterCalculate);
		}
	}
}

var componentList = new ComponentList();
/*
//Vamos a añadir un componente blanco ------OBSOLETO
;(function() {
	$(window).on('load', function(){


		var fondo_blanco = $('<div id="fondo_blanco" style="width:100%; height:100%;z-index=100;"></div>');
		fondo_blanco.css({
			"background-color":shopBackgroundColor,
			"opacity" : shopBackgroundOpacity
		});
		$("body").append(fondo_blanco);
		//Metemos el fondo blanco en los componentes
		componentList.add(fondo_blanco, {
			"fixedPosition" : true,
			"inSpeed" : 'fast',
			"outSpeed" : 'fast',
			"centerH" : false,
			"centerV" : false,
			"sizeX" : '100%',
			"sizeY" : '100%',
			"positionX" : '0',
			"positionY" : '0',
			"pivot" : 'lt',
			"closeButton" : false,
			"type" : 'modal',
			"transBackground" : false,
			"zindex" : 100
		}, true);
		//Al fondo blanco hay que asociarle un evento click
		fondo_blanco.on("click", function(){
			componentList.hideAll();
		});
		//Una vez que se ha hecho esto, se calculan las posiciones de todos los componentes y se colocan
		componentList.calculePosition(true);

		$(".webStoreDropRight").on("swipeleft", function(){componentList.hide($(this).attr("id"));});
		$(".webStoreDropLeft").on("swiperight", function(){componentList.hide($(this).attr("id"));});
		$(".webStoreDropDown").on("swipeup", function(){componentList.hide($(this).attr("id"));});
		$(".webStoreDropUp").on("swipedown", function(){componentList.hide($(this).attr("id"));});
		$(window).on( "orientationchange", function( event ) {setTimeout(function(){componentList.calculePosition(true);}, 1000) });
		//Estamos en un ordenador
		$(window).resize(function() { componentList.calculePosition(true); });
	});
}());*/

//Pedro 19/Marzo/2019 ==> Hay que recolocar todos los componentes en su sitio
document.addEventListener('WSLE', function(event) {
	componentList.hideAll();
	componentList.calculePosition(true);
	$(window).resize(function() { componentList.calculePosition(true); });
});