	//---------------------------------------------------------------------------------------------------------
	// 06/Abril/2015
	// Versión 1.0 Script que contiene el comportamiento de los componentes
	//---------------------------------------------------------------------------------------------------------
function CustomAjax(htmlObject, callBack, preAction, xml){
	this.url = "";
	this.objeto = htmlObject;
	this.parametros = [];
	this.strParametros = "";
	this.callBack = (callBack == null) ? function(){} : callBack;
	this.preAction = (preAction == null) ? function(){} : preAction;
	this.xml = (xml == null) ? 0 : xml;
	var tmpObjeto = this;

	this.url = $(htmlObject).prop("action");
	
	$(htmlObject).on("submit", function(event){
		event.preventDefault();
		tmpObjeto.realizar_solicitud();
	});
}

//Funciónes del componente:
CustomAjax.prototype.addParametro = function (clave, valor){
	if ( (typeof clave !== "undefined") && (typeof valor !== "undefined")){
		this.parametros[clave] = valor;
	}
}

CustomAjax.prototype.readData = function (){
	var tmpObjeto = this;
	//Vamos a coger el objeto a cargar TODOS los input, textarea, select
	//Empezamos por los input
	//+-> hidden
	$(this.objeto).find("input[type='hidden']").each(function(){
		//console.log($(this).prop("name"));
		tmpObjeto.addParametro($(this).prop("name"), $(this).val());
	});
	//+-> text
	$(this.objeto).find("input[type='text']").each(function(){
		//console.log($(this).prop("name"));
		tmpObjeto.addParametro($(this).prop("name"), $(this).val());
	});
	//+-> checkbox
	$(this.objeto).find("input[type='checkbox']").each(function(){
		tmpObjeto.addParametro($(this).prop("name"), ($(this).is(":checked")) ? "1" : "0");
	});
	//+-> radiobutton
	$(this.objeto).find("input[type='radiobutton']:checked").each(function(){
		tmpObjeto.addParametro($(this).prop("name"), $(this).val());
	});
	//+-> textarea
	$(this.objeto).find("textarea").each(function(){
		tmpObjeto.addParametro($(this).prop("name"), $(this).val());
	});
	//+-> option
	$(this.objeto).find("#myselect option:selected").each(function(){
		tmpObjeto.addParametro($(this).prop("name"), $(this).text());
	});
}

CustomAjax.prototype.serializeParams = function (){
	for (var key in this.parametros) {
		if (this.parametros.hasOwnProperty(key)){
			this.strParametros += ((this.strParametros != "") ? "&" : "") + key + "=" + this.parametros[key];
		}
	}
}

CustomAjax.prototype.realizar_solicitud = function (xml){
	this.readData();
	//Ejecutamos las pre-acciones
	this.preAction();
	var objetoAjax = this;
	//Si no tenemos parametros, hay que serializarlos:
	if (this.strParametros == ""){
		this.serializeParams();
	}
	//console.log(this.strParametros);
	
	if (typeof XMLHttpRequest === "undefined") {
		XMLHttpRequest = function () {
		try {
			return new ActiveXObject("Msxml2.XMLHTTP.6.0");
		}
		catch (e) {antoarLog("Msxml2.XMLHTTP.6.0 No soportado.\n" + e.message);}
		try {
			return new ActiveXObject("Msxml2.XMLHTTP.3.0");
		}
		catch (e) {antoarLog("Msxml2.XMLHTTP.3.0 No soportado.\n" + e.message);}
		try {
			return new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e) {antoarLog("Microsoft.XMLHTTP No soportado.\n" +  e.message);}
		
		throw new Error("This browser does not support XMLHttpRequest.");
	  };
	}

	var http = new XMLHttpRequest();

	anotarLog("abrimos: " + this.url);
	try {
		//Abrimos la URL
		http.open("POST", this.url, true);
	}catch (e) {antoarLog("Error al abrir la página " + this.url + ".\n" + e.message);}
	try {
		//Modificamos las cabeceras del envío
		http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	}catch (e) {antoarLog("Error al enviar el header.\n" + e.message);}
	//Le asignamos el listener para cuando se realice el enío
	try {
	http.onreadystatechange = function() {
		anotarLog("readyState = " + http.readyState + " status = " + http.status == 200);
		if(http.readyState == 4 && http.status == 200) {
			anotarLog("cadena: " + JSON.stringify(http));
			anotarLog("cadena: " + JSON.stringify(document.cookie));
			var parametro = null;
			if (this.xml){
				parametro = http.responseXML;
			}else{
				parametro = http.responseText;
			}
			objetoAjax.callBack(parametro);
		}
	};
	}catch (e) {antoarLog("Error al obtener el contenido.\n" + e.message);}
		anotarLog("Enviamos los parametros: " + this.strParametros);
	try{
		
		http.send(this.strParametros);
		
	}catch(e){anotarLog("Error al enviar los parametros " + e.message)};
}
