<?php
//---------------------------------------------------------------------------------------------------------
// 27/Noviembre/2015
// Versión 1.0 Fichero para mostrar la descarga del fichero sili de Albaran 
// 30/Noviembre/2015
// Version 1.1 Añadida una linea de identificacion que faltaba
//---------------------------------------------------------------------------------------------------------
if ($numero_fichero != NULL) {
    $albaran = new Albaran($numero_fichero, true, true, true);
    if ($albaran->codigo > 0) {
        header("Content-Type: text/plain");
        header("Content-Disposition: attachment; filename=albaran$numero_fichero.txt");
        /* Registro indentificacion */
        $rI = "I";
        $rI .="01"; //Email de origen
        $rI .="ALBLOG";  //Tipo de fichero
        $rI .="08";  //Version del fichero
        $rI .="000000";   //Nº de transmisión emisor 
        /* Registro de identificación Albaran */
        $rIA = "I";
        $rIA .= str_pad("origen@mail.com", 50, " ", STR_PAD_RIGHT); //Email origen
        $rIA .= str_pad("destino@mail.com", 50, " ", STR_PAD_RIGHT); //Email destino
        $rIA .="ENVIO"; //ENVIO
        $rIA .="08"; //
        $rIA .="        "; //
        /* Registro de Cabecera */
        $rC = "C";     //Tipo de registro
        $rC .= str_pad(Shop::$empresa->nombre_legal, 40, " ", STR_PAD_RIGHT);  // Nomre proveedor
        $rC .= str_pad($albaran->cliente->nombre_legal, 40, " ", STR_PAD_RIGHT); //Nombre Cliente
        $rC .= $albaran->num_doc; //Numero del albaran
        $rC .= date_format($albaran->fecha_date_format, "Ymd"); //Fecha del documento
        $rC .="F"; //tipo de documento
        $rC .= "E"; //tipo de envio
        $rC .= "02"; //Feria del libro
        $rC .= ""; //Importe Gastos /portes
        $rC .= "E"; //moneda
        $rC .= "        "; //Buzon usuario final        
        /* Registro detalle */
        $rD = "";
        foreach ($albaran->lineas_albaran as $key => $objeto) {
            $rD .= "D"; //Tipo de registro
            $rD .= str_pad($objeto->objeto_articulo->isbn, 17, " ", STR_PAD_RIGHT); //ISBN
            $rD .= str_pad($objeto->objeto_articulo->ean, 18, " ", STR_PAD_RIGHT); //EAN
            $rD .= str_pad($objeto->objeto_articulo->referencia, 15, " ", STR_PAD_RIGHT); //Referencia
            $rD .= str_pad($objeto->descripcion, 50, " ", STR_PAD_RIGHT); //Titulo
            $rD .= str_pad($objeto->cantidad, 6, "0", STR_PAD_LEFT); //Cantidad
            $rD .= str_pad(($objeto->precio / 1) * 100, 10, "0", STR_PAD_LEFT); //Precio sin IVA
            $rD .= str_pad($objeto->precio, 10, "0", STR_PAD_LEFT); //Precio con IVA
            $rD . str_pad($objeto->descuento, 6, "0", STR_PAD_LEFT); //Descuento
            $rD .= str_pad($objeto->iva, 5, "0", STR_PAD_LEFT); //Porcentaje IVA
            $rD .= "S"; //Novedad
            $rD .= $objeto->objeto_articulo->tipo_precio; //Tipo de precio
            $rD .=str_pad(" ", 8, "0", STR_PAD_RIGHT); //Fecha tope devolucion
            $rD .= str_pad($albaran->num_doc, 18, "0", STR_PAD_LEFT); //Codigo pedido
            $rD .=str_pad($objeto->objeto_articulo->autor, 150, " ", STR_PAD_RIGHT);
            $rD .=""; //Tipo de precio libre
            $rD.="\r\n";
        }/* Mostramos el contenido */
        echo "$rI\r\n";
        echo "$rIA\r\n";
        echo "$rC\r\n";
        echo $rD;
    } else {
        ?>
        <p class="error_sinli"><?= traducir("No se ha podido cargar el Albaran"); ?></p>
        <?php
    }
}
?>