<?php
/*
*	Este fichero modifica el fichero de secciones para configurar como se mostrarán y qué ficheros incluirán
*	@version 1.0.0
*	@date 2018/03/07
*
*/
//Este fichero no es dinámico. Esto quiere decir que no se recalcularán las secciones en caso de que aquí se meta alguna
//variable del entorno. Sólo se recalcularán las secciones si este ficher cambia físicamente
//Vamos a crearnos unos arrays para guardar lo común:
//$jsComunes = array(	'js/jquery-3.2.1.min.js', 'js/cesta.js', 'js/captcha.js', 'js/components.js', 'js/customAjax.js', 'js/direcciones_envio.js', 
//07/Mayo/2019 ==> Las direcciones de envío se gestionan de otra manera, ya podemos quitarlos del medio
//07/Mayo/2019 ==> El captcha lo vamos a insertar manualmente en la plantilla
$jsComunes = array(	'js/jquery-3.4.1.min.js', 'js/cesta.js', 'js/components.js', 'js/customAjax.js', 
					'js/functionStack.js', 'js/script.js', 'js/selectoresProducto.js', 'js/bootstrap.min.js');
$cssComunes = array('css/bootstrap.min.css', 'css/estilo.css', 'css/widget.css', 'css/animate.css', 'materialdesignicons.min.css');

//El nombre de este array puede ser cualquiera, pero los campos SIEMPRE los mismos
$array_secciones_originales = array(
	array('home', 0, 0, 0, 0),				//Sección de inicio
	array('escaparate', 0, 0, 0, 0),		//Lista de productos escaparate
	array('opcion_generica', 0, 0, 0, 0),	//Opción genérica (menú)
	array('resultado_busqueda', 0, 0, 0, 0),//Resultado de la búsqueda
	array('busqueda_avanzada', 0, 0, 0, 0),	//Página de búsqueda
	array('ficha', 0, 0, 0, 0),				//Ficha del producto
	array('cesta', 0, 0, 0, 0),				//cesta de la compra
	array('finalizar_compra', 0, 1, 0, 0),	//Pantalla de finalización de pedido
	array('registro', 0, 0, 1, 0),			//Registro
	array('confirmacion_registro', 0, 0, 1, 0),//Confirmación de registro
	array('recuperar_pass', 0, 0, 1, 0),	//Recuperar pasword
	array('contacto', 0, 0, 0, 0),			//Contacto
	array('mis_datos', 0, 1, 0, 0),			//Consulta de datos personales
	array('direcciones_envio', 0, 1, 0, 0),	//Direcciones de envío web
	array('favoritos', 0, 1, 0, 0),			//Favoritos
	array('pedidos_pendientes', 0, 1, 0, 0),//consulta de pedidos activos del cliente
	array('historico_pedidos', 0, 1, 0, 0),	//consulta de hco de pedidos del cliente
	array('reservas', 0, 1, 0, 0),			//reservas
	array('albaranes', 0, 1, 0, 0),			//Albaranes
	array('albaran', 0, 1, 0, 0),			//Albaran
	array('facturas', 0, 1, 0, 0),			//==>Muestra las facturas de un cliente con su filtrado y su orden
	array('factura', 0, 1, 0, 0),			//==>Mustra sólo una factura
	array('desconexion', 0, 0, 1, 0),		//Desconexión
	array('error', 1, 0, 0, 0),				//Errores
	array('terminos_y_condiciones', 0, 0, 0, 0),//Textos legales
	array('privacidad', 0, 0, 0, 0),
	array('aviso_legal', 0, 0, 0, 0),
	array('condiciones_venta', 0, 0, 0, 0),
	array('cookies', 0, 0, 0, 0),
	array('politica_email', 0, 0, 0, 0),
	array('colegios', 0, 0, 0, 0),				//Colegios cursos y lotes
	array('cursos', 0, 0, 0, 0),
	array('lote', 0, 0, 0, 0),
	array('venta_lote', 0, 0, 0, 0),
	array('fichero_sinli', 1, 1, 0, 1),				//Para ver los ficheros SINLI
	array('fichero_pdf', 1, 1, 0, 1),				//Para ver los ficheros PDF
	array('fichero_csv', 1, 1, 0, 1),				//Para ver los ficheros CSV
	array('imprimir', 1, 1, 0, 1),					//Impresion
	array('fichero_adjunto', 1, 1, 0, 1),			//Descarga de ficheros adjuntos
	array('depositos', 0, 1, 0, 0),					//Depósitos
	array('catalogos', 0, 1, 0, 0), 				//==>Muestra luna lista de archivos adjuntos para descargar o ver
	array('catalogo', 1, 1, 0, 1),					//Catálogo
	array('resultado_busqueda_lote', 0, 0, 0, 0),	//Buscador secciones
	array('suscripciones', 0, 1, 0, 0),				//Suscripciones de cliente
	array('vendedor', 0, 0, 0, 0),					//Suscripciones vendedores
	array('observaciones_articulo', 1, 0, 0, 0),	//Suscripciones vendedores
	array('mis_descargas', 0, 1, 0, 0),				//Descargas del cliente
	array('login_necesario', 0, 0, 0, 0),			//Sección que aparece cuando el login es necesario
	array('acceso', 0, 0, 0, 0),					//Sección de inicio
	array('conocenos', 0, 0, 0, 0),					//Sección de inicio
	array('condiciones_venta', 0, 0, 0, 0),			//Sección de inicio
	array('resultado_redsys', 1, 0, 0, 1),			//Resultado de la pasarela de redsis
	array('resultado_paypal', 1, 0, 0, 1),			//Resultado de la pasarela de redsis
	array('resultado_ceca', 1, 0, 0, 1),			//Resultado de la pasarela de ceca
	array('blog', 0, 0, 0, 0),		
	array('pago_seguro', 0, 0, 0, 0),
	array('gastos_envio', 0, 0, 0, 0),
	array('noticias', 0, 0, 0, 0),			
	
);
$array_secciones = array();
foreach($array_secciones_originales as $clave => $valor){
	$array_secciones[$valor[0]] = array(
		'completa' => $valor[1],		//=> Carga parcial o completa (0,1);
		'publica' => $valor[2],			//privada/publica => 0 = publica. 1 = privada
		'solo_publica' => $valor[3],	// solo_publica => 0 = publica y privada. 1 = Sólo pública
		'absoluta' => $valor[4],		// Absoluta => 0 = normal. 1 = sin header ni ficheros de ningún tipo
		'jsCabecera' => array(),
		'jsPie' => array_merge($jsComunes, array('js/' . $valor[0] . '.js')),
		'cssCabecera' => array(),
		'cssPie' => array_merge($cssComunes, array('css/' . $valor[0] . '.css', 'css/loadingFadeOut.css')), //Lo juntamos con el css de la sección y con el de fadeOut de la capa de loading
		'header' => 'header.php', 		//se incluirá entre el html y el body
		'footer' => 'footer.php', 		//se incluirá entre el /body y el /html
		'plantilla' => 'plantilla.php', //es la plantilla de la web para las secciones que no son completas
	);
	//Originalmente el js para el registro con Google sólo iba en el registro, pero como tiene la función de login y la de registro, hay que incluirlo en login in registro:
	if ( ($valor[0] == 'registro') || ($valor[0] == 'acceso') || ($valor[0] == 'cesta') ){
		$array_secciones[$valor[0]]['jsPie'] = array_merge($array_secciones[$valor[0]]['jsPie'],  array('js/googleRegister.js', 'js/facebookRegister.js'));
		//var_dump($array_secciones[$valor[0]]);
	}

	//Marina(11/Diciembre/2019) añadimos una condición para que el rango de precio del filtrado se cargue solamente en escaparates y resultado de búsqueda
	// if ( ($valor[0] == 'escaparate') || ($valor[0] == 'resultado_busqueda') ){
	// 	$array_secciones[$valor[0]]['jsPie'] = array_merge($array_secciones[$valor[0]]['jsPie'],  array('js/bootstrap-slider.js'));
	// 	$array_secciones[$valor[0]]['cssPie'] = array_merge($array_secciones[$valor[0]]['cssPie'],  array('css/bootstrap-slider.css'));
	// }
	
}
//Si estamos en el registro, entonces vamos a añadir el js de googleRegister:
//var_dump($array_secciones);
//$array_secciones['registro']['jsPie'] = array_merge($array_secciones['registro']['jsPie'],  array('js/googleRegister.js'));

$section_list->sections = $array_secciones;
?>