<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Filtrado de clientes -->
<!-- ============================================================== -->
<?php  
  $parametrosPlantilla = Theme::getLastParamList();
  $camposTabla = Theme::getLastParam('camposTabla');
  $filasTabla = Theme::getLastParam('filasTabla');
  $seccion = Theme::getLastParam('seccion');
?>


<!-- ============================================================== -->
<!-- FILTRADO DE CLIENTES -->
<!-- ============================================================== -->

<div class="card m-b-0 border-top">
  <div class="card-header" id="headingTwo">
    <h5 class="mb-0">
      <a class="collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        <i class="m-r-5 fa mdi mdi-filter" aria-hidden="true"></i>
          <span><?=traducir('Filtrado');?></span>
      </a>
    </h5>
  </div>
  <?php
    //filtrar por: nombre, codigo, codigo_sinlib, email, cod_postal, provincia:desplegable, origen(facebook, google :con check)
    //Vamos a crear las variables para cada campo del formulario
    $ordenActual = Getter::get('ord', '');
    $elementosXPagina = Getter::get('exp', 10);

    $codigo = Getter::get('codigo', '');
    $codigo_sinlib = Getter::get('codigo_sinlib', '');
    $nombre = Getter::get('nombre', '');
    $email = Getter::get('email', '');
    $google = Getter::get('google', '');
    $facebook = Getter::get('facebook', '');
    $web = Getter::get('web', '');
    $provincia = Getter::get('provincia', '');
    $cod_postal = Getter::get('cod_postal', '');

    $where = array();
    $reemplazo = array('\'', '"', '%');
    //Section::setParam($paramName, $value);

    if($google != '' || $facebook != '' || $web != ''){
      $subArray = array();

      if($web != ''){
        $subArray[] = array(
          'google_user' => 0,
          'fbId' => ''
        ); 
      }

      if($google != ''){
        $subArray['google_user'] = array( 'campo' => 'google_user', 'operador' => 'OR', 'valor' => 1);
      }

      if($facebook != ''){
        $subArray['fbId'] = array('condicion' => '!=', 'campo' => 'fbId', 'operador' => 'OR', 'valor' => '');
      }

      //$subArray['web'] = 1;


      $where[] = $subArray;
    }


    if ($codigo != ''){
      $where['codigo'] = $codigo;
    }
    if ($codigo_sinlib != ''){
      $where['codigo_sinlib'] = $codigo_sinlib;
    }
    if ($nombre != ''){
      $nombre_filtro = str_replace($reemplazo, '', $nombre);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'nombre_legal', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      $where['nombre_legal'] = $subArray;
    }

    if ($email != ''){
      $where['email'] = array('condicion' => 'LIKE', 'campo' => 'email',  'valor' => '%' . $email . '%');
    }

    if ($provincia != ''){
      $where['provincia'] = array('condicion' => 'LIKE', 'campo' => 'provincia',  'valor' => '%' . $provincia . '%');
    }

    if ($cod_postal != ''){
      $where['cod_postal'] = array('condicion' => 'LIKE', 'campo' => 'cod_postal', 'valor' => $cod_postal . '%');
    }

    Sections::setParam('filtro', $where);
  ?>
  <div id="collapseTwo" class="collapse <?=(count($where) > 0) ? 'show' : '';?>" aria-labelledby="headingTwo" data-parent="#accordionExample">
    <div class="card-body">
      <div class="row">
      <!-- FORMULARIO DE FILTRADO DE USUARIOS-->
        <form class="form-horizontal col-12" method="POST" action="<?=Shop::$configuracion->url . $seccion;?>">
            <div class="card-body">
              <h4 class="card-title"><?=traducir('Filtrar lista');?></h4>
              <input type="hidden" name="ord"  value="<?=$ordenActual;?>">
              <input type="hidden" name="exp"  value="<?=$elementosXPagina?>">

              <div class="row">
                <div class="col-12 row">
                  <div class="form-group col-lg-2">
                    <label for="fcod" class="col-md-12 font-bold"><?=traducir('Código');?></label>
                    <input type="text" name="codigo"  value="<?=$codigo;?>" class="form-control" id="fcod" placeholder="Código">
                  </div>
                  <div class="form-group col-lg-2">
                    <label for="fcodsl" class="col-md-12 font-bold"><?=traducir('Código alt.');?></label>
                    <input type="text" name="codigo_sinlib"  value="<?=$codigo_sinlib;?>"  class="form-control" id="fcodsl" placeholder="Código alt.">
                  </div>
                  <div class="form-group col-lg-4">
                    <label for="fname" class="col-md-12 font-bold"><?=traducir('Nombre');?></label>
                    <input type="text" name="nombre"  value="<?=$nombre;?>" class="form-control" id="fname" placeholder="Nombre">
                  </div>
                  <div class="form-group col-lg-4">
                    <label for="femail" class="col-md-12 font-bold"><?=traducir('Email');?></label>
                    <input type="text" name="email"  value="<?=$email;?>" class="form-control" id="femail" placeholder="Email">
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="form-group col-lg-6">
                  <label class="col-md-12 font-bold"><?=traducir('Origen');?></label>
                  <div class="col-md-12 row">
                    <div class="custom-control custom-checkbox col-4">
                        <input type="checkbox" name="google"  <?=$google != '' ? 'checked="checked"' : '';?> class="custom-control-input" id="customControlAutosizing1">
                        <label class="custom-control-label" for="customControlAutosizing1"><i class="mdi mdi-google"></i> <?=traducir('Google');?></label>
                    </div>
                    <div class="custom-control custom-checkbox col-4">
                        <input type="checkbox" name="facebook" <?=$facebook != '' ? 'checked="checked"' : '';?> class="custom-control-input" id="customControlAutosizing2">
                        <label class="custom-control-label" for="customControlAutosizing2"><i class="mdi mdi-facebook"></i> <?=traducir('Facebook');?></label>
                    </div>
                    <div class="custom-control custom-checkbox col-4">
                        <input type="checkbox" name="web"   <?=$web != '' ? 'checked="checked"' : '';?> class="custom-control-input" id="customControlAutosizing3">
                        <label class="custom-control-label" for="customControlAutosizing3"><i class="mdi mdi-earth"></i> <?=traducir('Web');?></label>
                    </div>
                  </div>
                </div>

                <div class="form-group col-lg-6 row">
                  <div class="form-group col-9">
                    <label for="fprov" class="col-md-12 font-bold"><?=traducir('Provincia');?></label>
                     <input type="text" name="provincia"  value="<?=$provincia;?>" class="form-control" id="fprov" placeholder="Provincia">
                      <?php
                      //TODO
                      //Convertir el input provincia en un select en el futuro
                        // <select name="provincia" class="select2 form-control custom-select">
                        // <option value="" >Select</option>
                        // $provincias = array();
                        // for($i = 0; $i <= count($provincias); $i++){
                        // <option value='$provincias[$i]';
                        // $provincias[$i]
                        //  </option> 
                        // }
                        //</select>
                      ?>                   
                  </div>
                  <div class="form-group col-3">
                    <label for="fpostal" class="col-md-12 font-bold"><?=traducir('Código Postal');?></label>
                    <input type="text" name="cod_postal" value="<?=$cod_postal;?>" class="form-control" id="fpostal" placeholder="Código postal">
                  </div>
                </div>
              </div>
            </div>
            <div class="border-top">
                <div class="card-body">
                  <?php
                    if (count($where) > 0){
                      //componemos la lista de parámetros a utilizar
                      $parametrosFinales = ($ordenActual != '') ? 'ord=' . $ordenActual : '';
                      //Elementos X Pagina
                      $parametrosFinales .= ( ($parametrosFinales != '' && $elementosXPagina != '') ? '&' : '') .  (($elementosXPagina != '') ? 'exp=' . $elementosXPagina : '');
                     
                      //Componemos en enlace "base sobre el que añadir la página a la que navegar"
                      $enlace = Shop::$configuracion->url . Sections::$current_section . ( ($parametrosFinales != '') ? '?' : '') . $parametrosFinales;
                    ?>

                      <a href="<?=$enlace;?>"><button type="button" class="btn btn-danger"><?=traducir('Borrar filtro');?></button></a>
                    <?php
                    }
                  ?> 

                    <button type="submit" class="btn btn-primary"><?=traducir('Filtrar');?></button>
                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>


