<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">
                        <div class="form-group row">
                            <label for="importe_minimo" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Importe mínimo');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="importe_minimo" value="<?=intval(Shop::$configuracion->importe_minimo);?>" class="form-control" id="importe_minimo" placeholder="Importe mínimo">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_por_pagina" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos por página');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_por_pagina" value="<?=Shop::$configuracion->elementos_por_pagina;?>" class="form-control" id="elementos_por_pagina" placeholder="Elementos por página">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="decimales" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Decimales');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="decimales" value="<?=intval(Shop::$configuracion->decimales);?>" class="form-control" id="decimales" placeholder="Decimales">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="num_novedades" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Novedades en página');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="num_novedades" value="<?=Shop::$configuracion->num_novedades;?>" class="form-control" id="num_novedades" placeholder="Novedades en página">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="paginas_a_mostrar" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Páginas a mostrar');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="paginas_a_mostrar" value="<?=Shop::$configuracion->paginas_a_mostrar;?>" class="form-control" id="paginas_a_mostrar" placeholder="Páginas a mostrar">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="descripcion" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Descripción');?></label>
                            <div class="col-sm-4">
                                <textarea name="descripcion" class="form-control" id="descripcion" placeholder="Descripción"><?=Shop::$configuracion->descripcion;?></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="meta" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Meta');?></label>
                            <div class="col-sm-4">
                                <textarea name="meta"  class="form-control" id="meta" placeholder="Meta"><?=Shop::$configuracion->meta;?></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="busquedas_papeleria" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Búsquedas Papelería');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="busquedas_papeleria" value="<?=Shop::$configuracion->busquedas_papeleria;?>" class="form-control" id="busquedas_papeleria" placeholder="Búsquedas Papelería">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="url_sin_idioma" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Url sin idioma');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="url_sin_idioma" value="<?=Shop::$configuracion->url;?>" class="form-control" id="url_sin_idioma" placeholder="Url sin idioma">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="password_encriptado" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Password encriptado');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="password_encriptado" value="<?=Shop::$configuracion->password_encriptado;?>" class="form-control" id="password_encriptado" placeholder="Password encriptado">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="datos_obligatorios" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Datos obligatorios');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="datos_obligatorios" value="<?=Shop::$configuracion->datos_obligatorios;?>" class="form-control" id="datos_obligatorios" placeholder="Datos obligatorios">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_relacionados" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos relacionados');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_relacionados" value="<?=Shop::$configuracion->elementos_relacionados;?>" class="form-control" id="elementos_relacionados" placeholder="Elementos relacionados">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="pedidos_sin_login" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Pedidos sin login');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="pedidos_sin_login" value="<?=Shop::$configuracion->pedidos_sin_login;?>" class="form-control" id="pedidos_sin_login" placeholder="Pedidos sin login">
                            </div>
                        </div>               
                        <div class="form-group row">
                            <label for="tipo_envio" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Tipo de envío');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="tipo_envio" value="<?=Shop::$configuracion->tipo_envio;?>" class="form-control" id="tipo_envio" placeholder="Tipo de envío">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="dto_dia_libro" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Descuento día del libro');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="dto_dia_libro" value="<?=Shop::$configuracion->dto_dia_libro;?>" class="form-control" id="dto_dia_libro" placeholder="Descuento día del libro">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="franquicia_feran" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Franquicia Ferán');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="franquicia_feran" value="<?=Shop::$configuracion->franquicia_feran;?>" class="form-control" id="franquicia_feran" placeholder="Franquicia Ferán">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="dto_texto" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Descuento texto');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="dto_texto" value="<?=Shop::$configuracion->dto_texto;?>" class="form-control" id="dto_texto" placeholder="Descuento texto">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="dto_texto_libre" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Descuento texto libre');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="dto_texto_libre" value="<?=Shop::$configuracion->dto_texto_libre;?>" class="form-control" id="meta" placeholder="Descuento texto libre">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="mes_inicio_texto" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Mes inicio texto');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="mes_inicio_texto" value="<?=Shop::$configuracion->mes_inicio_texto;?>" class="form-control" id="mes_inicio_texto" placeholder="Mes inicio texto">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="mes_fin_texto" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Mes fin texto');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="mes_fin_texto" value="<?=Shop::$configuracion->mes_fin_texto;?>" class="form-control" id="mes_fin_texto" placeholder="Mes fin texto">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="captchaSiteKey" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Captcha Site Key');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="captchaSiteKey" value="<?=Shop::$configuracion->captchaSiteKey;?>" class="form-control" id="captchaSiteKey" placeholder="Captcha Site Key">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="captchaClaveSecreta" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Captcha clave secreta');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="captchaClaveSecreta" value="<?=Shop::$configuracion->captchaClaveSecreta;?>" class="form-control" id="captchaClaveSecreta" placeholder="Captcha clave secreta">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="cesta_login_inicio" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Cesta login inicio');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="cesta_login_inicio" value="<?=Shop::$configuracion->cesta_login_inicio;?>" class="form-control" id="cesta_login_inicio" placeholder="Cesta login inicio">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="dias_borrado_pedidos_libros" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Días borrado
                             pedidos libros');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="dias_borrado_pedidos_libros" value="<?=Shop::$configuracion->dias_borrado_pedidos_libros;?>" class="form-control" id="dias_borrado_pedidos_libros" placeholder="Días borrado pedidos libros">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="dias_borrado_pedidos_papeleria" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Días borrado pedidos papelería');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="dias_borrado_pedidos_papeleria" value="<?=Shop::$configuracion->dias_borrado_pedidos_papeleria;?>" class="form-control" id="dias_borrado_pedidos_papeleria" placeholder="Días borrado pedidos papelería">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="permitir_anular_pedidos_pendientes" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Permitir anular pedidos pendientes');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="permitir_anular_pedidos_pendientes" value="<?=Shop::$configuracion->permitir_anular_pedidos_pendientes;?>" class="form-control" id="permitir_anular_pedidos_pendientes" placeholder="Permitir anular pedidos pendientes">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_hco_pedidos" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos histórico de pedidos');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_hco_pedidos" value="<?=Shop::$configuracion->elementos_hco_pedidos;?>" class="form-control" id="elementos_hco_pedidos" placeholder="Elementos histórico de pedidos">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_reservas" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos reservas');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_reservas" value="<?=Shop::$configuracion->elementos_reservas;?>" class="form-control" id="elementos_reservas" placeholder="Elementos reservas">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_pedidos_pendientes" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos pedidos pendientes');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_pedidos_pendientes" value="<?=Shop::$configuracion->elementos_pedidos_pendientes;?>" class="form-control" id="elementos_pedidos_pendientes" placeholder="Elementos pedidos pendientes">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_facturas" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos facturas');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_facturas" value="<?=Shop::$configuracion->elementos_facturas;?>" class="form-control" id="elementos_facturas" placeholder="Elementos facturas">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_albaranes" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos albaranes');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_albaranes" value="<?=Shop::$configuracion->elementos_albaranes;?>" class="form-control" id="elementos_albaranes" placeholder="Elementos albaranes">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="elementos_depositos" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Elementos depósitos');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="elementos_depositos" value="<?=Shop::$configuracion->elementos_depositos;?>" class="form-control" id="elementos_depositos" placeholder="Elementos depósitos">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="segundos_sesion" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Segundos sesión');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="segundos_sesion" value="<?=Shop::$configuracion->segundos_sesion;?>" class="form-control" id="segundos_sesion" placeholder="Segundos sesión">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="cookies_rules" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Cookies rules');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="cookies_rules" value="<?=Shop::$configuracion->cookies_rules;?>" class="form-control" id="cookies_rules" placeholder="Cookies rules">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="multi_idioma" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Multi idioma');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="multi_idioma" value="<?=Shop::$configuracion->multi_idioma;?>" class="form-control" id="multi_idioma" placeholder="Multi idioma">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="registro_supervisado" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Registro supervisado');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="registro_supervisado" value="<?=Shop::$configuracion->registro_supervisado;?>" class="form-control" id="registro_supervisado" placeholder="Registro supervisado">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="registro_con_confirmacion" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Registro con confirmación');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="registro_con_confirmacion" value="<?=Shop::$configuracion->registro_con_confirmacion;?>" class="form-control" id="registro_con_confirmacion" placeholder="Registro con confirmación">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="campos_busqueda" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Campos búsqueda');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="campos_busqueda" value="<?=Shop::$configuracion->campos_busqueda;?>" class="form-control" id="campos_busqueda" placeholder="Campos búsqueda">
                            </div>
                        </div>
                        <?php
                        //TODO comprobar si el campo controlar stock es number o checkbox
                        ?>
                        <div class="form-group row">
                            <label for="controlar_stock" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Controlar stock');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="controlar_stock" value="<?=Shop::$configuracion->controlar_stock;?>" class="form-control" id="controlar_stock" placeholder="Controlar stock">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="ocultar_stock_0" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Ocultar stock 0');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="ocultar_stock_0" value="<?=Shop::$configuracion->ocultar_stock_0;?>" class="form-control" id="ocultar_stock_0">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="cliente_contado" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Cliente contado');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="cliente_contado" value="<?=Shop::$configuracion->cliente_contado;?>" class="form-control" id="cliente_contado" placeholder="Cliente contado">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="guardar_pedidos_bd" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Guardar pedidos bd');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="guardar_pedidos_bd" value="<?=Shop::$configuracion->guardar_pedidos_bd;?>" class="form-control" id="guardar_pedidos_bd">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="segundaMano" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Segunda mano');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="segundaMano" value="<?=Shop::$configuracion->segundaMano;?>" class="form-control" id="segundaMano">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="filtroGlobal" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Filtro global');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="filtroGlobal" value="<?=Shop::$configuracion->filtroGlobal;?>" class="form-control" id="filtroGlobal" placeholder="Filtro global">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="url_ebooks" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Url de ebooks');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="url_ebooks" value="<?=Shop::$configuracion->url_ebooks;?>" class="form-control" id="url_ebooks" placeholder="Url de ebooks">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="limite_descargas_ebook" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Límite de descargas ebook');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="limite_descargas_ebook" value="<?=Shop::$configuracion->limite_descargas_ebook;?>" class="form-control" id="limite_descargas_ebook" placeholder="Límite de descargas ebook">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="servidor_portadas" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Servidor portadas');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="servidor_portadas" value="<?=Shop::$configuracion->servidor_portadas;?>" class="form-control" id="servidor_portadas" placeholder="Servidor portadas">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="no_foto" class="col-sm-2 text-right control-label col-form-label"><?=traducir('No foto');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="no_foto" value="<?=Shop::$configuracion->no_foto;?>" class="form-control" id="no_foto" placeholder="No foto">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="trabaja_descuentos" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Trabaja descuentos');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="trabaja_descuentos" value="<?=Shop::$configuracion->trabaja_descuentos;?>" class="form-control" id="trabaja_descuentos">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="https_on" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Https ON');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="https_on" value="<?=Shop::$configuracion->https_on;?>" class="form-control" id="https_on" placeholder="Https ON">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="sha1_password" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Password formato Sha1');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="sha1_password" value="<?=Shop::$configuracion->sha1_password;?>" class="form-control" id="sha1_password">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="google_api_id" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Google api ID');?></label>
                            <div class="col-sm-4">
                                <textarea name="google_api_id" class="form-control" id="google_api_id" placeholder="Google api ID"><?=Shop::$configuracion->google_api_id;?></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="guardar_sesion_al_modificar" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Guardar sesión al modificar');?></label>
                            <div class="col-sm-1">
                                <input type="checkbox" name="guardar_sesion_al_modificar" value="<?=Shop::$configuracion->guardar_sesion_al_modificar;?>" class="form-control" id="guardar_sesion_al_modificar" placeholder="Guardar sesión al modificar">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="blowfish" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Blowfish');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="blowfish" value="<?=Shop::$configuracion->blowfish;?>" class="form-control" id="blowfish" placeholder="Blowfish">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="envio_recogida_tienda" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Envío con recogida en tienda');?></label>
                            <div class="col-sm-1">
                                <input type="number" name="envio_recogida_tienda" value="<?=Shop::$configuracion->envio_recogida_tienda;?>" class="form-control" id="envio_recogida_tienda" placeholder="Envío con recogida en tienda">
                            </div>
                        </div>
                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-2 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-4">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="Password requerida para guardar cambios">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary">Guardar</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>