<?php

//---------------------------------------------------------------------------------------------------------
// 27/Enero/2015
// Versión 1.0 Versión unificada del buscador avanzado y del simple
//---------------------------------------------------------------------------------------------------------



function widget_buscador() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'buscador_simple';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function buscador_simple($opciones = NULL) {
    include('comunes/globals.php');
    $filtro_escaparates = false;
    $ocultarCabecera = false;
	$textoInput = $txt_busqueda;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $filtro_escaparates = ($opciones->configuracion->filtro_escaparates != NULL) ? $opciones->configuracion->filtro_escaparates : $filtro_escaparates;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    $idFormularioBusqueda = 'form_buscador_' . incrementa_contador();
    if ($ocultarCabecera) {
        ?>

        <div class="<?= (__FUNCTION__); ?>"><!--Buscador-->
            <?php
        }
        ?>
        <form id="<?= $idFormularioBusqueda; ?>" class="form_buscador" method="post" action="<?= Shop::$configuracion->url; ?>">
            <?php
            //Vamos a tener en cuenta si hay o no texto para insertarlo en el campo buscador.
            $txt_a_mostrar = "";
            $frase_x_defecto = traducir('¿Qué buscas?');
            if ($txt_busqueda == '') {
                //$txt_busqueda = traducir("¿Qué buscas?");
                $clase_input_buscador = 'class="apagado"';
            } else {
                $txt_a_mostrar = $txt_busqueda;
                $clase_input_buscador = 'class="encendido"';
            }
            ?>
            <fieldset class="conjunto_input_buscador">

                <input name="txt_busqueda" type="search" title="<?= traducir('Introduzca aquí el texto a buscar'); ?>" value="<?= $txt_a_mostrar; ?>" placeholder="<?= $frase_x_defecto; ?>" <?= $clase_input_buscador; ?> required /> 
                <?php
                //Si hay filtrado por escaparates hay que crear una select de los escaparates sin padre
                if ($filtro_escaparates) {
                    $filtrado_anterior = Sesion::get("filtrado_actual");
                    $cadenaInicio = '0';
                    if (strpos($filtrado_anterior, 'escaparate') !== false) {
                        $cadenaInicio = 'no';
                    }
                    ?>
                    <select class="selector_filtro_busqueda" name="filtro_escaparate_busqueda_simple">
                        <option value="<?= $cadenaInicio; ?>"><?= traducir("Todo"); ?></option>
                        <?php
                        //Aquí cargamos los escaparates sin padre:
                        $idioma = Sesion::get('idioma');
                        $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
                        $sentencia_sql = "SELECT cescaparate.codigo codigo, traducesca.nombre nombre 
									FROM `cescaparate`, traducesca 
									WHERE cescaparate.codigo = traducesca.escaparate AND idioma = '$idioma' AND escaparate_padre = 0 AND activo = 1";
                        if ($conexionBD) {
                            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                                while ($fila = mysqli_fetch_array($resultado)) {
                                    //echo("El filtrado actual es: $filtrado_actual y en él bsucamos: " . $fila["codigo"] . "<br />\n");
                                    $checked = "";
                                    if (strpos($filtrado_actual, ":" . $fila['codigo']) !== false) {
                                        $checked = ' selected ';
                                    }
                                    ?>
                                    <option value="<?= $fila['codigo']; ?>" <?= $checked; ?>><?= $fila['nombre']; ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
                    </select>
                    <?php
                }
                ?>
                <input type="submit" name="enviar" class="icon_buscar" value="<?= traducir('buscar'); ?>"/>
            </fieldset>
        </form>

        <script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = $("form#<?= $idFormularioBusqueda; ?>");
                if (elementObjetive.length > 0) {
                    elementObjetive.on("submit", function (event) {
                        event.preventDefault();
                        //console.log(frase_x_defecto);
                        var valor_texto = elementObjetive.find("input[name='txt_busqueda']").val();
                        //Componemos la nueva url
                        if (valor_texto != "") {
                            valor_texto = limpiar_texto(valor_texto);
                            var url = '<?= Shop::$configuracion->url; ?>buscar/' + valor_texto;
                            //Hay que tener en cuenta los filtrados de los escaparates
                            url += componer_cad_filtrado_final($("div.filtros div.filtrado"));
                            //Redirigimos a esa página
                            $(location).attr('href', url);
                        }
                    });
                }
            }());
		});
        </script>
        <div class="botones">
            <a href="<?= Shop::$configuracion->url; ?>busqueda_avanzada" class="b_avanzada"><?= traducir('Búsqueda avanzada'); ?></a>
        </div>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>


    <?php
    return(true);
}

function buscador_avanzado($array_campos = array('titulo', 'autor', 'editorial', 'ean')) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if (($array_campos != NULL) && (is_a($array_campos, "OpcionesWidget"))) {
        $opciones = $array_campos;
        $array_campos = array('titulo', 'autor', 'editorial', 'ean');
        if (is_a($opciones, 'OpcionesWidget')) {
            $array_campos = ($opciones->configuracion->array_campos != NULL) ? $opciones->configuracion->array_campos : $array_campos;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $id = incrementa_contador();
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <form id="buscador_avanzado_<?= $id; ?>" class="buscador_avanzado" method="get" action="<?= Shop::$configuracion->url; ?>">
            <fieldset class="campos_busqueda_avanzada">
                <?php
                $placeholder = false;
                if (WEB_MOVIL == 1) {
                    $placeholder = true;
                }
                $num_campos = count($array_campos);
                for ($i = 0; $i < $num_campos; $i++) {
                    $clase_campo = $nombre_campo = $array_campos[$i];

                    if (!$placeholder) {
                        ?>
                        <label class="label_campo_<?= $clase_campo; ?>"><?= traducir(ucfirst(str_replace("_", " ", $nombre_campo))); ?>:</label>
                        <?php
                    }
                    ?>
                    <input type="text" class="input_campo_<?= $clase_campo; ?>" name="<?= $nombre_campo; ?>" <?= ($placeholder) ? 'placeholder="' . traducir(ucfirst($nombre_campo)) . '"' : ""; ?>/>
                    <?php
                }
                ?>
            </fieldset>
            <fieldset class="botones_busqueda_avanzada">
                <input type="submit" name="enviar_busqueda_avanzada" value="<?= traducir("buscar"); ?>" />
            </fieldset>
        </form>
        <script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = getLastHtmlObject();
                elementObjetive.on("submit", function (event) {
                    event.preventDefault();

                    //Primero vamos a ver que campos existen y cuales no
                    var lista_campos = new Array(2);
                    lista_campos[0] = new Array();
                    lista_campos[1] = new Array();
                    elementObjetive.find("input[type='text']").each(function () {
                        lista_campos[0][lista_campos[1].length] = $(this).prop("name");
                        lista_campos[1][lista_campos[1].length] = $(this).prop("value");
                    });
                    //Limpiamos el texto de cada campo
                    var num_campos = lista_campos[0].length;
                    var campos_correctos = false;
                    url = '<?= Shop::$configuracion->url; ?>busqueda_avanzada';
                    for (var i = 0; i < num_campos; i++) {
                        //Comprobamos primero que todos los campos estén rellenos
                        if (lista_campos[1][i] != "") {
                            campos_correctos = true;
                            //Ahora vamos a componer la url a la que hay que enviar
                            url += '/' + lista_campos[0][i] + "_" + limpiar_texto(lista_campos[1][i]);
                        }
                    }
                    //Componemos la nueva url
                    if (campos_correctos != "") {
                        //Redirigimos a esa página
                        $(location).attr('href', url);
                    }

                });
            }());
		});
        </script>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
}

function buscador_simpleV2($opciones = NULL) {
    include('comunes/globals.php');
    $filtro_escaparates = false;
    $fichero_buscador = 'buscadorSimple';
    $idFormularioBusqueda = 'form_buscador_' . incrementa_contador();
    $ocultarCabecera = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $filtro_escaparates = ($opciones->configuracion->filtro_escaparates != NULL) ? $opciones->configuracion->filtro_escaparates : $filtro_escaparates;
        $fichero_buscador = ($opciones->configuracion->fichero_buscador != NULL) ? $opciones->configuracion->fichero_buscador : $fichero_buscador;
        $idFormularioBusqueda = ($opciones->configuracion->idFormularioBusqueda != NULL) ? $opciones->configuracion->idFormularioBusqueda : $idFormularioBusqueda;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    //Vamos a componer las variables disponibles para el usuario
    $contenidoFiltros = '';
	//Vamos a quitar los guiones al recibir algo:
	$textoInput = trim(str_replace('-', ' ', Sections::getParam('txt_busqueda')));
    $accion = Shop::$configuracion->url . 'buscar';
    if ($filtro_escaparates) {
        ob_start();
        ?>
        <select class="selector_filtro_busqueda" name="filtro_escaparate_busqueda_simple">
            <option value="0"><?= traducir("Todo"); ?></option>
            <?php
            //Aquí cargamos los escaparates sin padre:
            $idioma = Sesion::get('idioma');
            $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
            $sentencia_sql = "SELECT cescaparate.codigo codigo, traducesca.nombre nombre 
									FROM `cescaparate`, traducesca 
									WHERE cescaparate.codigo = traducesca.escaparate AND idioma = '$idioma' AND escaparate_padre = 0 AND activo = 1";
            if ($conexionBD) {
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    while ($fila = mysqli_fetch_array($resultado)) {
                        //echo("El filtrado actual es: $filtrado_actual y en él bsucamos: " . $fila["codigo"] . "<br />\n");
                        $checked = "";
                        if (strpos($filtrado_actual, ":" . $fila["codigo"]) !== false) {
                            $checked = ' selected ';
                        }
                        ?>
                        <option value="<?= $fila['codigo']; ?>" <?= $checked; ?>><?= $fila['nombre']; ?></option>
                        <?php
                    }
                }
            }
            ?>
        </select>
        <?php
        $contenidoFiltros = ob_get_clean();
    }
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>"><!--Buscador-->
            <?php
        }
        ?>
        <?php
		Theme::include_file($fichero_buscador . ".php", array('accion' => $accion, 'textoInput' => $textoInput, 'contenidoFiltros' => $contenidoFiltros) );
		//Pedro 29/Mayo/2109 ==> Ya no hay script, se hace el submit y hacemos la recarga desde la sección
		/*
        ?>
        <script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = $("form#<?= $idFormularioBusqueda; ?>");
                if (elementObjetive.length > 0) {
                    elementObjetive.on("submit", function (event) {
                        event.preventDefault();
                        //console.log(frase_x_defecto);
                        var valor_texto = elementObjetive.find("input[name='txt_busqueda']").val();
                        //Componemos la nueva url
                        if (valor_texto != "") {
                            valor_texto = limpiar_texto(valor_texto);
                            var url = '<?= Shop::$configuracion->url; ?>buscar/' + valor_texto;
                            //Hay que tener en cuenta los filtrados de los escaparates
                            url += componer_cad_filtrado_final($("div.filtros div.filtrado"));
                            //Redirigimos a esa página
                            $(location).attr('href', url);
                        }
                    });
                }
            }());
		});
        </script>
        <?php
		*/
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>

    <?php
    return(true);
}

function buscador_avanzadoV2($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    $fichero_buscador = 'buscador_avanzadoV2';

    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_buscador = ($opciones->configuracion->fichero_buscador != NULL) ? $opciones->configuracion->fichero_buscador : $fichero_buscador;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <?php
		$accion = Shop::$configuracion->url . 'busqueda_avanzada';
		Theme::include_file($fichero_buscador . ".php", array('accion' => $accion));

        ?>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		/*
		?>
        <script type="text/javascript"  id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
                elementObjetive.on("submit", function (event) {
                    event.preventDefault();

                    //Primero vamos a ver que campos existen y cuales no
                    var lista_campos = new Array(2);
                    lista_campos[0] = new Array();
                    lista_campos[1] = new Array();
                    elementObjetive.find("input[type='text']").each(function () {
                        lista_campos[0][lista_campos[1].length] = $(this).prop("name");
                        lista_campos[1][lista_campos[1].length] = $(this).prop("value");
                    });
                    //Limpiamos el texto de cada campo
                    var num_campos = lista_campos[0].length;
                    var campos_correctos = false;
                    url = '<?= Shop::$configuracion->url; ?>busqueda_avanzada';
                    for (var i = 0; i < num_campos; i++) {
                        //Comprobamos primero que todos los campos estén rellenos
                        if (lista_campos[1][i] != "") {
                            campos_correctos = true;
                            //Ahora vamos a componer la url a la que hay que enviar
                            url += '/' + lista_campos[0][i] + "_" + limpiar_texto(lista_campos[1][i]);
                        }
                    }
                    //Componemos la nueva url
                    if (campos_correctos != "") {
                        //Redirigimos a esa página
                        $(location).attr('href', url);
                    }

                });
            }());
		});
        </script>
        <?php
		*/
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
}
?>