<?php

//---------------------------------------------------------------------------------------------------------
// 24/Abril/2015
// Versión 1.0 Con este widget gestionamos la información de una factura.
//---------------------------------------------------------------------------------------------------------



function widget_factura() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'resumen_factura';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function facturas_cliente($opciones = NULL) {
    //Muestra todas las facturas de un cliente.
    include('comunes/globals.php');
    //Inicializamos los valores:
    $cargar_cliente_factura = false;
    $cargar_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;
    $ocultarCabecera = false;

    $codigo_sinlib_cliente = $datos_usuario->codigo_sinlib;
    $fichero_factura = 'resumen_factura';
    $filtro_fecha = '';
    $orden = 'fecha/DESC';

    $fecha_inicio = Sesion::get('fecha_inicio_facturas');
    $fecha_fin = Sesion::get('fecha_fin_facturas');
    if (($fecha_inicio !== NULL) && ($fecha_fin !== NULL)) {
        $filtro_fecha = "$fecha_inicio $fecha_fin";
    }

    $orden = Sesion::get('orden_facturas');
    if ($orden == NULL) {
        $orden = 'codigo';
    }
    $tipo_orden = Sesion::get('tipo_orden_facturas');
    if ($tipo_orden == NULL) {
        $tipo_orden = 'DESC';
    }
    if (($tipo_orden !== NULL) && ($orden !== NULL)) {
        $orden = "$orden/$tipo_orden";
    }
    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_sinlib_cliente = ($opciones->configuracion->codigo_sinlib_cliente !== NULL) ? $opciones->configuracion->codigo_sinlib_cliente : $codigo_sinlib_cliente;
        $fichero_factura = ($opciones->configuracion->fichero_factura !== NULL) ? $opciones->configuracion->fichero_factura : $fichero_factura;
        $filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
        $orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;

        $cargar_cliente_factura = ($opciones->configuracion->cargar_cliente_factura !== NULL) ? $opciones->configuracion->cargar_cliente_factura : $cargar_cliente_factura;
        $cargar_albaran = ($opciones->configuracion->cargar_albaran !== NULL) ? $opciones->configuracion->cargar_albaran : $cargar_albaran;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    $filtro_fecha = trim($filtro_fecha);

    $cad_filtro_fechas = '';
    if ($filtro_fecha != '') {
        $array_fechas = explode(' ', $filtro_fecha);
        $cad_filtro_fechas = " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ";
    }

    $sentencia_sql = "SELECT codigo FROM factura WHERE cliente = $codigo_sinlib_cliente $cad_filtro_fechas";
    //Necesitamos saber cuantos elementos hay para poder hacer la paginación
    $total_elementos = mysqli_query($conexionBD, $sentencia_sql);
    $total_elementos = mysqli_num_rows($total_elementos);
    //Tenemos una sentencia sql sin el orden (para que vaya más rápido), con esta select, vamos a ver cuantas facturas hay para añadir la paginación
    $pagina = Sections::getParam('pagina', 0);
    $enlace = Shop::$configuracion->url . 'facturas';

    $orden = trim($orden); //Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
    $array_orden = explode('/', $orden);
    //Añadimos el orden
    $sentencia_sql .= " ORDER BY $array_orden[0] $array_orden[1] ";

    $sentencia_sql .= " LIMIT " . ($pagina * Shop::$configuracion->elementos_facturas) . ", " . Shop::$configuracion->elementos_facturas;

    //echo("$sentencia_sql<br />\n");
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                while ($fila = mysqli_fetch_array($resultado)) {
                    $opciones_factura = new OpcionesWidget(array(
                        'codigo_factura' => $fila['codigo'],
                        'fichero_factura' => $fichero_factura,
                        'cargar_cliente_factura' => $cargar_cliente_factura,
                        'cargar_albaran' => $cargar_albaran,
                        'cargar_lineas_albaran' => $cargar_lineas_albaran,
                        'cargar_articulos_albaran' => $cargar_articulos_albaran
                    ));
                    new Widget($_WH->GW('factura', 'factura_cliente'), $opciones_factura);
                }
                new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_facturas);
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
}

function factura_cliente($opciones = NULL) {
    include('comunes/globals.php');
    //Muestra todos los datos de una factura.
    $codigo_factura = 0;
    $cargar_cliente_factura = false;
    $cargar_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;
    $fichero_factura = 'resumen_factura';
    $ocultarCabecera = false;

    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_factura = ($opciones->configuracion->codigo_factura !== NULL) ? $opciones->configuracion->codigo_factura : $codigo_factura;
        $fichero_factura = ($opciones->configuracion->fichero_factura !== NULL) ? $opciones->configuracion->fichero_factura : $fichero_factura;

        $cargar_cliente_factura = ($opciones->configuracion->cargar_cliente_factura !== NULL) ? $opciones->configuracion->cargar_cliente_factura : $cargar_cliente_factura;
        $cargar_albaran = ($opciones->configuracion->cargar_albaran !== NULL) ? $opciones->configuracion->cargar_albaran : $cargar_albaran;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    if (is_numeric($codigo_factura)) {
        $objeto_factura = new Factura($codigo_factura, $cargar_albaran, $cargar_lineas_albaran, $cargar_articulos_albaran, $cargar_cliente_factura);
    } else {
        $objeto_factura = $codigo_factura;
    }
    if (is_a($objeto_factura, 'Factura')) {
        if ($objeto_factura->codigo > 0) {
            $ruta_fichero = Theme::findFile($fichero_factura . '.php');
            if ($ruta_fichero != NULL) {
                $factura = $objeto_factura;
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                    <div class="<?= (__FUNCTION__); ?>">
                        <?php
                    }
                    ?>
                    <?php
                    include($ruta_fichero);
                    ?>
                    <?php
                    if (!$ocultarCabecera) {
                        ?>
                    </div>
                    <?php
                }
                ?>
                <?php
            }
        }
    }
}

function albaranes_cliente($opciones = NULL) {
    //Muestra todos los albaranes de un cliente.
    include('comunes/globals.php');
    $ocultarCabecera = false;

    //Inicializamos los valores:
    $cargar_cliente_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;

    $codigo_sinlib_cliente = $datos_usuario->codigo_sinlib;
    $fichero_albaran = 'resumen_albaran';
    $filtro_fecha = '';
    $orden = 'fecha/DESC';

    $fecha_inicio = Sesion::get('fecha_inicio_albaranes');
    $fecha_fin = Sesion::get('fecha_fin_albaranes');
    if (($fecha_inicio !== NULL) && ($fecha_fin !== NULL)) {
        $filtro_fecha = "$fecha_inicio $fecha_fin";
    }

    $orden = Sesion::get('orden_albaranes');
    if ($orden == NULL) {
        $orden = 'codigo';
    }
    $tipo_orden = Sesion::get('tipo_orden_albaranes');
    if ($tipo_orden == NULL) {
        $tipo_orden = 'DESC';
    }
    if (($tipo_orden !== NULL) && ($orden !== NULL)) {
        $orden = "$orden/$tipo_orden";
    }
    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_sinlib_cliente = ($opciones->configuracion->codigo_sinlib_cliente !== NULL) ? $opciones->configuracion->codigo_sinlib_cliente : $codigo_sinlib_cliente;
        $fichero_albaran = ($opciones->configuracion->fichero_albaran !== NULL) ? $opciones->configuracion->fichero_albaran : $fichero_albaran;
        $filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
        $orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;

        $cargar_cliente_albaran = ($opciones->configuracion->cargar_cliente_factura !== NULL) ? $opciones->configuracion->cargar_cliente_factura : $cargar_cliente_factura;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    $filtro_fecha = trim($filtro_fecha);

    $cad_filtro_fechas = '';
    if ($filtro_fecha != '') {
        $array_fechas = explode(' ', $filtro_fecha);
        $cad_filtro_fechas = " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ";
    }

    $sentencia_sql = "SELECT codigo FROM cab_albaran WHERE cliente = $codigo_sinlib_cliente $cad_filtro_fechas";
    echo("$sentencia_sql<br />\n");
    //Necesitamos saber cuantos elementos hay para poder hacer la paginación
    $total_elementos = mysqli_query($conexionBD, $sentencia_sql);
    $total_elementos = mysqli_num_rows($total_elementos);
    //Tenemos una sentencia sql sin el orden (para que vaya más rápido), con esta select, vamos a ver cuantas facturas hay para añadir la paginación
    $pagina = Sections::getParam('pagina', 0);
    $enlace = Shop::$configuracion->url . 'albaranes';

    $orden = trim($orden); //Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
    $array_orden = explode('/', $orden);
    //Añadimos el orden
    $sentencia_sql .= " ORDER BY $array_orden[0] $array_orden[1] ";

    $sentencia_sql .= " LIMIT " . ($pagina * Shop::$configuracion->elementos_facturas) . ", " . Shop::$configuracion->elementos_facturas;
    //$sentencia_sql .= " LIMIT " . ($pagina * Shop::$configuracion->elementos_facturas) . ", " . 16;
    //echo("$sentencia_sql<br />\n");

    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                while ($fila = mysqli_fetch_array($resultado)) {
                    $opciones_albaran = new OpcionesWidget(array(
                        'codigo_albaran' => $fila['codigo'],
                        'fichero_albaran' => $fichero_albaran,
                        'cargar_cliente_albaran' => $cargar_cliente_albaran,
                        'cargar_lineas_albaran' => $cargar_lineas_albaran,
                        'cargar_articulos_albaran' => $cargar_articulos_albaran
                    ));
                    new Widget($_WH->GW('factura', 'albaran_cliente'), $opciones_albaran);
                }
                new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_albaranes);
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
}

function albaranes_factura($opciones = NULL) {
    //Muestra todas los albaranes que contengan el codigo de factura indicado.
    include('comunes/globals.php');
    $cargar_cliente_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;
    $ocultarCabecera = false;

    $codigo_factura = 0;
    $fichero_albaranes_factura = 'resumen_albaran';
    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_factura = ($opciones->configuracion->codigo_factura !== NULL) ? $opciones->configuracion->codigo_factura : $codigo_factura;
        $fichero_albaranes_factura = ($opciones->configuracion->fichero_albaranes_factura !== NULL) ? $opciones->configuracion->fichero_albaranes_factura : $fichero_albaranes_factura;

        $cargar_cliente_albaran = ($opciones->configuracion->cargar_cliente_albaran !== NULL) ? $opciones->configuracion->cargar_cliente_albaran : $cargar_cliente_albaran;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    if (is_numeric($codigo_factura)) {
        $objeto_factura = new Factura($codigo_factura);
    } else {
        $objeto_factura = $codigo_factura;
    }
    if (is_a($objeto_factura, 'Factura')) {

        $sentencia_sql = 'SELECT codigo FROM cab_albaran WHERE factura = ' . $objeto_factura->codigo;
        //echo('$sentencia_sql<br />\n');
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                    <div class="<?= (__FUNCTION__); ?>">
                        <?php
                    }
                    ?>
                    <?php
                    while ($fila = mysqli_fetch_array($resultado)) {
                        $opciones_albaran = new OpcionesWidget(array(
                            'codigo_albaran' => $fila['codigo'],
                            'fichero_albaran' => $fichero_albaranes_factura,
                            'cargar_cliente_albaran' => $cargar_cliente_albaran,
                            'cargar_lineas_albaran' => $cargar_lineas_albaran,
                            'cargar_articulos_albaran' => $cargar_articulos_albaran
                        ));
                        new Widget($_WH->GW('factura', 'albaran_cliente'), $opciones_albaran);
                    }
                    ?>
                    <?php
                    if (!$ocultarCabecera) {
                        ?>
                    </div>
                    <?php
                }
                ?>
                <?php
            }
        }
    }
}

function albaran_cliente($opciones = NULL) {
    //Muestra el albarán con todas sus líneas.
    include('comunes/globals.php');
    $cargar_cliente_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;
    $ocultarCabecera = false;
    $codigo_albaran = 0;
    $fichero_albaran = 'resumen_albaran';
    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_albaran = ($opciones->configuracion->codigo_albaran !== NULL) ? $opciones->configuracion->codigo_albaran : $codigo_albaran;
        $fichero_albaran = ($opciones->configuracion->fichero_albaran !== NULL) ? $opciones->configuracion->fichero_albaran : $fichero_albaran;

        $cargar_cliente_albaran = ($opciones->configuracion->cargar_cliente_albaran !== NULL) ? $opciones->configuracion->cargar_cliente_albaran : $cargar_cliente_albaran;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    if (is_numeric($codigo_albaran)) {
        $objeto_albaran = new Albaran($codigo_albaran, $cargar_lineas_albaran, $cargar_articulos_albaran, $cargar_cliente_albaran);
    } else {
        $objeto_albaran = $codigo_albaran;
    }

    if (is_a($objeto_albaran, 'Albaran')) {
        $ruta_fichero = Theme::findFile($fichero_albaran . '.php');
        if ($ruta_fichero != NULL) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                $cab_albaran = $objeto_albaran;
                include($ruta_fichero);
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
}

function lineas_albaran($opciones = NULL) {
    //Esta función muestra las lineas del albaran.
    include('comunes/globals.php');
    $cargar_articulos_albaran = false;
    $ocultarCabecera = false;
    $codigo_albaran = 0;
    $fichero_lineas_albaran = 'detalle_albaran';
    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $codigo_albaran = ($opciones->configuracion->codigo_albaran !== NULL) ? $opciones->configuracion->codigo_albaran : $codigo_albaran;
        $fichero_lineas_albaran = ($opciones->configuracion->fichero_lineas_albaran !== NULL) ? $opciones->configuracion->fichero_lineas_albaran : $fichero_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    if (is_numeric($codigo_albaran)) {
        $objeto_albaran = new Albaran($codigo_albaran, true, $cargar_articulos_albaran, false);
    } else {
        $objeto_albaran = $codigo_albaran;
    }
    if (is_a($objeto_albaran, 'Albaran')) {

        $ruta_fichero = Theme::findFile($fichero_lineas_albaran . '.php');
        if ($ruta_fichero != NULL) {
            $cab_albaran = $objeto_albaran;
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                foreach ($objeto_albaran->lineas_albaran as $clave => $valor) {
                    $linea_albaran = $valor;
                    include($ruta_fichero);
                }
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
}

//cargamos los albaranes de una factura de forma dinámica
function cargar_albaranes_factura($opciones) {
    //Muestra el albarán con todas sus líneas.
    include('comunes/globals.php');
    $consultaJqBoton = '';
    $consultaJqBotonOcultar = '';
    $consultaJqContenedor = '';
    $consultaJqPadre = '';

    $cargar_cliente_albaran = false;
    $cargar_lineas_albaran = false;
    $cargar_articulos_albaran = false;

    $codigo_factura = 0;
    $fichero_albaran = 'resumen_albaran';

    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $consultaJqBoton = ($opciones->configuracion->consultaJqBoton !== NULL) ? $opciones->configuracion->consultaJqBoton : $consultaJqBoton;
        $consultaJqBotonOcultar = ($opciones->configuracion->consultaJqBotonOcultar !== NULL) ? $opciones->configuracion->consultaJqBotonOcultar : $consultaJqBotonOcultar;
        $consultaJqContenedor = ($opciones->configuracion->consultaJqContenedor !== NULL) ? $opciones->configuracion->consultaJqContenedor : $consultaJqContenedor;
        $consultaJqPadre = ($opciones->configuracion->consultaJqPadre !== NULL) ? $opciones->configuracion->consultaJqPadre : $consultaJqPadre;

        $codigo_factura = ($opciones->configuracion->codigo_factura !== NULL) ? $opciones->configuracion->codigo_factura : $codigo_factura;
        $fichero_albaran = ($opciones->configuracion->fichero_albaran !== NULL) ? $opciones->configuracion->fichero_albaran : $fichero_albaran;

        $cargar_cliente_albaran = ($opciones->configuracion->cargar_cliente_albaran !== NULL) ? $opciones->configuracion->cargar_cliente_albaran : $cargar_cliente_albaran;
        $cargar_lineas_albaran = ($opciones->configuracion->cargar_lineas_albaran !== NULL) ? $opciones->configuracion->cargar_lineas_albaran : $cargar_lineas_albaran;
        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
    }
    $cargar_cliente_albaran = ($cargar_cliente_albaran) ? 'true' : 'false';
    $cargar_lineas_albaran = ($cargar_lineas_albaran) ? 'true' : 'false';
    $cargar_articulos_albaran = ($cargar_articulos_albaran) ? 'true' : 'false';

    //Ahora es el momento de insertar el código javascript que hará el trabajo
    if (($consultaJqBoton != '') && ($consultaJqContenedor != '') && ($consultaJqPadre != '')) {
        //Hemos recibido un código para usar jquery y seleccionar el botón al que aplicarle el texto
        if (is_a($codigo_factura, 'Factura')) {
            $codigo_factura = $codigo_factura->codigo;
        }
        $nombre_script = 'script_' . incrementa_contador();
        ?>
        <script type="text/javascript"  id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var ultimoElemento = getLastHtmlObject('<?= $nombre_script; ?>');
                var padre = ultimoElemento.parents('<?= $consultaJqPadre; ?>');
                var btn = padre.find('<?= $consultaJqBoton; ?>');
                var ocultar = padre.find('<?= $consultaJqBotonOcultar; ?>');
                var capaContenedora = padre.find('<?= $consultaJqContenedor; ?>');
                if ((btn.length > 0) && (capaContenedora.length > 0)) {
                    btn.on("click", function () {
                        //Hay que quitar los que estén abiertos
                        $('<?= $consultaJqContenedor; ?>').hide('fast');
                        $('<?= $consultaJqContenedor; ?>').html("");
                        $('<?= $consultaJqBotonOcultar; ?>').hide('fast');
                        $('<?= $consultaJqBoton; ?>').show('fast');
                        var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/get_albaranes_factura.php";
                        var cadena_envio = "hash=<?= genera_cod_seguridad(); ?>&cliente=<?= $datos_usuario->codigo; ?>&codigo_factura=<?= $codigo_factura; ?>&fichero_albaran=<?= $fichero_albaran; ?>";
                        cadena_envio += "&cargar_lineas=<?= $cargar_lineas_albaran; ?>&cargar_articulo=<?= $cargar_articulos_albaran; ?>&cargar_cliente=<?= $cargar_cliente_albaran; ?>";
                        realizar_solicitud(direccion, cadena_envio, function (respuesta) {
                            if (respuesta != "") {
                                capaContenedora.css("display", "none");
                                capaContenedora.html(respuesta);
                                capaContenedora.show('fast');
                                ocultar.show('fast');
                                btn.hide('fast');
                            }
                        });
                    });
                    ocultar.on("click", function () {
                        capaContenedora.hide('fast', function () {
                            capaContenedora.html();
                        });
                        ocultar.hide('fast');
                        btn.show('fast');
                    });
                }
            })();
		});
        </script>
        <?php
    }
}

//cargamos las líneas de albarane de una factura de forma dinámica
function cargar_lineas_albaran($opciones) {
    //Muestra el albarán con todas sus líneas.
    include('comunes/globals.php');
    $consultaJqBoton = '';
    $consultaJqBotonOcultar = '';
    $consultaJqContenedor = '';
    $consultaJqPadre = '';

    $cargar_articulos_albaran = false;

    $codigo_albaran = 0;
    $fichero_linea = 'detalle_albaran';

    if (($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') )) {
        $consultaJqBoton = ($opciones->configuracion->consultaJqBoton !== NULL) ? $opciones->configuracion->consultaJqBoton : $consultaJqBoton;
        $consultaJqBotonOcultar = ($opciones->configuracion->consultaJqBotonOcultar !== NULL) ? $opciones->configuracion->consultaJqBotonOcultar : $consultaJqBotonOcultar;
        $consultaJqContenedor = ($opciones->configuracion->consultaJqContenedor !== NULL) ? $opciones->configuracion->consultaJqContenedor : $consultaJqContenedor;
        $consultaJqPadre = ($opciones->configuracion->consultaJqPadre !== NULL) ? $opciones->configuracion->consultaJqPadre : $consultaJqPadre;

        $codigo_albaran = ($opciones->configuracion->codigo_albaran !== NULL) ? $opciones->configuracion->codigo_albaran : $codigo_albaran;
        $fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;

        $cargar_articulos_albaran = ($opciones->configuracion->cargar_articulos_albaran !== NULL) ? $opciones->configuracion->cargar_articulos_albaran : $cargar_articulos_albaran;
    }
    $cargar_articulos_albaran = ($cargar_articulos_albaran) ? 'true' : 'false';

    //Ahora es el momento de insertar el código javascript que hará el trabajo
    if (($consultaJqBoton != '') && ($consultaJqContenedor != '') && ($consultaJqPadre != '')) {
        //Hemos recibido un código para usar jquery y seleccionar el botón al que aplicarle el texto
        if (is_a($codigo_albaran, 'Albaran')) {
            $codigo_albaran = $codigo_albaran->codigo;
        }
        $nombre_script = 'script_' . incrementa_contador();
        ?>
        <script type="text/javascript"  id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var ultimoElemento = getLastHtmlObject('<?= $nombre_script; ?>');
                //console.log(ultimoElemento);
                ultimoElemento.hide('slow');
                var padre = ultimoElemento.parents('<?= $consultaJqPadre; ?>');
                var btn = padre.find('<?= $consultaJqBoton; ?>');
                var ocultar = padre.find('<?= $consultaJqBotonOcultar; ?>');
                var capaContenedora = padre.find('<?= $consultaJqContenedor; ?>');
                if ((btn.length > 0) && (capaContenedora.length > 0)) {
                    btn.on("click", function () {
                        //Hay que quitar los que estén abiertos
                        $('<?= $consultaJqContenedor; ?>').hide('fast');
                        $('<?= $consultaJqContenedor; ?>').html("");
                        $('<?= $consultaJqBotonOcultar; ?>').hide('fast');
                        $('<?= $consultaJqBoton; ?>').show('fast');
                        var direccion = "<?= Shop::$configuracion->url; ?>comunes/consultas/get_lineas_albaran.php";
                        var cadena_envio = "hash=<?= genera_cod_seguridad(); ?>&cliente=<?= $datos_usuario->codigo; ?>&codigo_albaran=<?= $codigo_albaran; ?>&fichero_linea=<?= $fichero_linea; ?>";
                        cadena_envio += "&cargar_articulo=<?= $cargar_articulos_albaran; ?>";
                        realizar_solicitud(direccion, cadena_envio, function (respuesta) {
                            //console.log(respuesta);
                            if (respuesta != "") {
                                capaContenedora.css("display", "none");
                                capaContenedora.html(respuesta);
                                capaContenedora.show('fast');
                                ocultar.show('fast');
                                btn.hide('fast');
                            }
                        });
                    });
                    ocultar.on("click", function () {
                        capaContenedora.hide('fast', function () {
                            capaContenedora.html();
                        });
                        ocultar.hide('fast');
                        btn.show('fast');
                    });
                }
            })();
		});
        </script>
        <?php
    }
}
?>