<?php
	//---------------------------------------------------------------------------------------------------------
	// 20/Julio/2015
	// Versión 1.0 Extensión del widget de pedidos de clientes
	// 30/Octubre/2015
	// Versión 2.0 => Remodelamos esta extensión por completo
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function resumen_pedido($opciones = NULL){
		include('comunes/globals.php');
		$fichero_resumen = 'resumen_pedido';
		$codigo_pedido = 0;
		if (is_a($opciones, 'OpcionesWidget')){
			$fichero_resumen = ($opciones->configuracion->fichero_resumen !== NULL) ? $opciones->configuracion->fichero_resumen : $fichero_resumen;
			$codigo_pedido = ($opciones->configuracion->codigo_pedido !== NULL) ? $opciones->configuracion->codigo_pedido : $codigo_pedido;
			if (is_numeric($codigo_pedido)){
				//$codigo_pedido = new PedidoCliente($codigo_pedido);
			}
		}
		if (is_a($codigo_pedido, 'PedidoCliente')){
			$ruta_fichero = Theme::findFile($fichero_resumen . '.php');
			if ($ruta_fichero != NULL){
				$mc_pedcli = $codigo_pedido;
				include($ruta_fichero);
			}
		}
		
	}

	function pedidos_pendientes_cliente($opciones = NULL){
		include('comunes/globals.php');
		//Como siempre en V2, procesamos las opciones. Pero en esta función, estas opciones se meterán en el objeto para usarlo después
		$codigo_usuario = 0;
		$fichero_linea = 'linea_pedidos_pendientes';
		$fichero_cabecera = '';
		$fichero_pie = '';
		$ocultar_eliminados = true;
		
		$permitir_anular = Shop::$configuracion->permitir_anular_pedidos_pendientes;
		$pagado = NULL;
		//Vamos a coger el filtro de las fechas
		$filtro_fecha = '';
		$fecha_inicio = Sesion::get('fecha_inicio_pedidos_ptes');
		$fecha_fin = Sesion::get('fecha_fin_pedidos_ptes');
		if ( ($fecha_inicio !== NULL) && ($fecha_fin !== NULL) ){
			$filtro_fecha = "$fecha_inicio $fecha_fin";
		}
		
		$orden = Sesion::get('orden_pedidos_ptes');
		if ($orden == NULL){	$orden = 'fecha';	}
		$tipo_orden = Sesion::get('tipo_orden_pedidos_ptes');
		if ($tipo_orden == NULL){	$tipo_orden = 'DESC';	}

		$cliente = Usuario::logueado();
		if ($cliente !== NULL){
			$codigo_usuario = $cliente->codigo;
		}
		
		$solo_libros_pedidos_ptes = Sesion::get('solo_libros_pedidos_ptes');
		if ($solo_libros_pedidos_ptes == NULL){	$solo_libros_pedidos_ptes = '';	}
		$solo_papeleria_pedidos_ptes = Sesion::get('solo_papeleria_pedidos_ptes');
		if ($solo_papeleria_pedidos_ptes == NULL){	$solo_papeleria_pedidos_ptes = '';	}
		
		if (is_a($opciones, 'OpcionesWidget')){
			$cliente = ($opciones->configuracion->cliente !== NULL) ? $opciones->configuracion->cliente : $cliente;
			if (is_numeric($cliente)){
				$cliente = new usuario($cliente);
			}
			$codigo_usuario = ($opciones->configuracion->codigo_usuario !== NULL) ? $opciones->configuracion->codigo_usuario : $cliente->codigo;
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
			$fichero_cabecera = ($opciones->configuracion->fichero_cabecera !== NULL) ? $opciones->configuracion->fichero_cabecera : $fichero_cabecera;
			$fichero_pie = ($opciones->configuracion->fichero_pie !== NULL) ? $opciones->configuracion->fichero_pie : $fichero_pie;
			$ocultar_eliminados = ($opciones->configuracion->ocultar_eliminados !== NULL) ? $opciones->configuracion->ocultar_eliminados : $ocultar_eliminados;
			
			$filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
			$orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;
			$permitir_anular = ($opciones->configuracion->permitir_anular !== NULL) ? $opciones->configuracion->permitir_anular : $orden;
			$solo_libros_pedidos_ptes = ($opciones->configuracion->solo_libros_pedidos_ptes !== NULL) ? $opciones->configuracion->solo_libros_pedidos_ptes : $solo_libros_pedidos_ptes;
			$solo_papeleria_pedidos_ptes = ($opciones->configuracion->solo_papeleria_pedidos_ptes !== NULL) ? $opciones->configuracion->solo_papeleria_pedidos_ptes : $solo_papeleria_pedidos_ptes;
		}else{
			$opciones = new OpcionesWidget();
		}
		
		//Vamos a hacer ahora la carga
		if ($cliente !== NULL){
			if ($cliente->codigo > 0){
				$codigo_usuario = $cliente->codigo;
				$filtro_fecha = trim($filtro_fecha);
				$orden = trim($orden);//Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
				//Vamos a componer la select:
				$sentencia_sql = "SELECT ml_pedcli.codigo codigo, mc_pedcli 
								FROM mc_pedcli, ml_pedcli, articulo
								WHERE mc_pedcli.cliente = '$codigo_usuario' AND mc_pedcli.codigo = ml_pedcli.mc_pedcli AND (pendiente_sinlib > 0 OR pagado > 0)
								AND (deposito = 0)
								AND (
								CAST(ml_pedcli.cantidad AS SIGNED ) - CAST(ml_pedcli.recibida AS SIGNED ) - CAST(ml_pedcli.retirada AS SIGNED )) > 0 
									AND ml_pedcli.articulo = articulo.codigo ";
				if ($ocultar_eliminados){
					$sentencia_sql .= " AND mc_pedcli.pedido_eliminado = 0 ";
				}
				if ($pagado !== NULL){
					$sentencia_sql .= " AND mc_pedcli.pagado = $pagado ";
				}
				if($filtro_fecha != ""){
					$array_fechas = explode(" ", $filtro_fecha);
					$sentencia_sql .= " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ";
				}
				
				//Los filtros por tipo de artículo, se hacen sólo si son distintos los flags:
				if ($solo_libros_pedidos_ptes != $solo_papeleria_pedidos_ptes){
					if($solo_libros_pedidos_ptes != ""){
						$sentencia_sql .= " AND articulo.tipo = 'L' ";
					}
					
					if($solo_papeleria_pedidos_ptes != ""){
						$sentencia_sql .= " AND articulo.tipo = 'P' ";
					}
				}

				//Necesitamos saber cuantos elementos hay para poder hacer la paginación
				$total_elementos = mysqli_query($conexionBD, $sentencia_sql);
				$total_elementos = mysqli_num_rows($total_elementos);

				//Vamos con el orden. ESTAMOS TENIENDO EN CUENTA QUE SÓLO SE PUEDE ORDENADR POR UN CRITERIO
				//Primero miramos la cabecera:
				$cadena_orden_cabecera = "";
				$cadena_orden_lineas = "";
				$cadena_orden = "";
				if ($fichero_cabecera != ""){
					$cadena_orden_cabecera = " ml_pedcli.mc_pedcli DESC, ml_pedcli.codigo ASC "; //Los pedidos en orden descendente para que los últimos estén los primeros
				}

				if (( $orden != "") && ($tipo_orden != "") ){
					//echo("El orden es: $orden");
					//Tenemos que saber si el orden es en la cabecera o en las líneas
					$cadena_orden = $orden . " " . $tipo_orden . " ";
					if (strpos($orden, 'mc_pedcli.') !== false){
						//Para la cabecera
						$cadena_orden_cabecera = $cadena_orden . ( ($cadena_orden_cabecera != '') ? ', ' : '' ) . $cadena_orden_cabecera;
					}else{
						$cadena_orden_lineas = $cadena_orden;
					}
				}
				$cadena_orden = $cadena_orden_cabecera . ( ($cadena_orden_lineas != '') ? ', ' . $cadena_orden_lineas : '' );
				$cadena_orden = ($cadena_orden != '') ? " ORDER BY $cadena_orden " : $cadena_orden;
				//echo("$sentencia_sql<br />\n");
				//Falta por añadir la paginación
				$pagina = Sections::getParam('pagina', 0);
				$enlace = Shop::$configuracion->url . 'pedidos_pendientes';
				$sentencia_sql .= $cadena_orden . ' LIMIT ' . ($pagina * Shop::$configuracion->elementos_pedidos_pendientes) . ', ' . Shop::$configuracion->elementos_pedidos_pendientes ;
				//echo("$sentencia_sql<br />\n");
				if ($conexionBD){
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
						//Comprobamos si tenemos pedidos
						if(mysqli_num_rows($resultado) === 0){
?>
						<p class="error_no_hay_pedidos"><?=traducir('Aún no ha realizado ningún pedido');?></p>
<?php
						}else{
							$total = 0;
							$mostrar_boton_anular = false;
							$ultimo_pedido = new PedidoCliente(0);
							while ($fila = mysqli_fetch_array($resultado)){
								//Vamos a necesitar un objeto con la linea
								//echo $fila["mc_pedcli"]." ". $fila["codigo"]."<br/>";
								$linea_pedido = new LineaPedidoCliente($fila['mc_pedcli'], $fila['codigo'], true);
								//var_dump($linea_pedido);

								//Si cambiamos de pedido, controlamos que se muestre la cabecera
								if ($ultimo_pedido->codigo != $fila['mc_pedcli']){
									//Si el último pedido es distinto de 0, entonces hay que mostrar el pie:
									if($ultimo_pedido->codigo > 0){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $ultimo_pedido, 'fichero_resumen' => $fichero_pie));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
									//si hay fichero de cabecera, hacemos el include:
									if ($fichero_cabecera != ''){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_cabecera));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
								}
								//Mostramos los pedidos
                                new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $linea_pedido, $fichero_linea);
								$total += $linea_pedido->importe_con_dto_pendiente;
								$ultimo_pedido = $linea_pedido->objeto_pedido;
							}
							//Mostramos el total siempre después de mostrar los pedidos
							if ($fichero_pie != ''){
								$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_pie));
                                new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
							}

							//Paginacion:
                            new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_pedidos_pendientes);
							//Ahora mostramos el botón para solicitar anulación con su script correspondiente
							if ($mostrar_boton_anular){
							}
						}
					}
				}
			}
		}
	}

	
	//------------------------------------------------------------------------------------------------
	//Reservas
	//------------------------------------------------------------------------------------------------
	function reservas_cliente($opciones = NULL){
		include("comunes/globals.php");
		//Como siempre en V2, procesamos las opciones. Pero en esta función, estas opciones se meterán en el objeto para usarlo después
		$codigo_usuario = 0;
		$fichero_linea = 'linea_reserva';
		$fichero_cabecera = '';
		$fichero_pie = '';
		$ocultar_eliminados = true;

		//Vamos a coger el filtro de las fechas
		$filtro_fecha = '';
		$fecha_inicio = Sesion::get('fecha_inicio_reservas');
		$fecha_fin = Sesion::get('fecha_fin_reservas');
		if ( ($fecha_inicio !== NULL) && ($fecha_fin !== NULL) ){
			$filtro_fecha = "$fecha_inicio $fecha_fin";
		}

		$orden = Sesion::get('orden_reservas');
		if ($orden == NULL){ $orden = 'codigo';	}
		$tipo_orden = Sesion::get('tipo_orden_reservas');
		if ($tipo_orden == NULL){	$tipo_orden = 'DESC';	}

		$cliente = Usuario::logueado();
		if ($cliente !== NULL){
			$codigo_usuario = $cliente->codigo;
		}

		$solo_libros_reservas = Sesion::get('solo_libros_pedidos_ptes');
		if ($solo_libros_reservas == NULL){	$solo_libros_reservas = '';	}
		$solo_papeleria_reservas = Sesion::get('solo_papeleria_pedidos_ptes');
		if ($solo_papeleria_reservas == NULL){	$solo_papeleria_reservas = '';	}


		if (is_a($opciones, 'OpcionesWidget')){
			$cliente = ($opciones->configuracion->cliente !== NULL) ? $opciones->configuracion->cliente : $cliente;
			if (is_numeric($cliente)){
				$cliente = new usuario($cliente);
			}
			$codigo_usuario = ($opciones->configuracion->codigo_usuario !== NULL) ? $opciones->configuracion->codigo_usuario : $cliente->codigo;
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero;
			$fichero_cabecera = ($opciones->configuracion->fichero_cabecera !== NULL) ? $opciones->configuracion->fichero_cabecera : $fichero_cabecera;
			$fichero_pie = ($opciones->configuracion->fichero_pie !== NULL) ? $opciones->configuracion->fichero_pie : $fichero_pie;
			$ocultar_eliminados = ($opciones->configuracion->ocultar_eliminados !== NULL) ? $opciones->configuracion->ocultar_eliminados : $ocultar_eliminados;

			$filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
			$orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;
			$solo_libros_reservas = ($opciones->configuracion->solo_libros_reservas !== NULL) ? $opciones->configuracion->solo_libros_reservas : $solo_libros_reservas;
			$solo_papeleria_reservas = ($opciones->configuracion->solo_papeleria_reservas !== NULL) ? $opciones->configuracion->solo_papeleria_reservas : $solo_papeleria_reservas;
		}else{
			$opciones = new OpcionesWidget();
		}

		//Vamos a hacer ahora la carga
		if ($cliente !== NULL){
			if ($cliente->codigo > 0){
				$codigo_usuario = $cliente->codigo;
				$filtro_fecha = trim($filtro_fecha);
				$orden = trim($orden);//Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
				//Vamos a componer la select:
				$sentencia_sql = "SELECT ml_pedcli.codigo codigo, mc_pedcli 
								FROM mc_pedcli, ml_pedcli, articulo
								WHERE mc_pedcli.cliente = '$codigo_usuario' AND mc_pedcli.codigo = ml_pedcli.mc_pedcli
								AND (pendiente_sinlib > 0 OR pagado > 0)
								AND (deposito = 0)
								AND (CAST(ml_pedcli.recibida AS SIGNED ) - CAST(ml_pedcli.retirada AS SIGNED )) > 0  
								AND ml_pedcli.articulo = articulo.codigo ";
				if($filtro_fecha != ""){
					$array_fechas = explode(" ", $filtro_fecha);
					$sentencia_sql .= " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]'";
				}
				
				if ($ocultar_eliminados){
					$sentencia_sql .= ' AND mc_pedcli.pedido_eliminado = 0 ';
				}
				
				if ($solo_libros_reservas != $solo_papeleria_reservas){
					if($solo_libros_reservas != ''){
						$sentencia_sql .= " AND articulo.tipo = 'L' ";
					}
		
					if($solo_papeleria_reservas != ''){
						$sentencia_sql .= " AND articulo.tipo = 'P' ";
					}
				}
				
				//Necesitamos saber cuantos elementos hay para poder hacer la paginación
				//echo("$sentencia_sql<br />\n");
				$total_elementos = 0;
				if ($total_elementos = mysqli_query($conexionBD, $sentencia_sql)){
					$total_elementos = mysqli_num_rows($total_elementos);
				}
				
				$cadena_orden_cabecera = "";
				$cadena_orden_lineas = "";
				$cadena_orden = "";
				if ($fichero_cabecera != ""){
					$cadena_orden_cabecera = 'ml_pedcli.mc_pedcli DESC'; //Los pedidos siempre en orden descendente
				}
				
				if (( $orden != '') && ($tipo_orden != '') ){
					//Tenemos que saber si el orden es en la cabecera o en las líneas
					$cadena_orden = $orden . ' ' . $tipo_orden . ' ';
					if (strpos($orden, 'mc_pedcli.') !== false){
						//Para la cabecera
						$cadena_orden_cabecera = $cadena_orden . ( ($cadena_orden_cabecera != '') ? ', ' : '' ) . $cadena_orden_cabecera;
					}else{
						$cadena_orden_lineas = $cadena_orden;
					}
				}
				
				
				if (( $orden != '') && ($tipo_orden != '') ){
					$cadena_orden .= ( ($cadena_orden != '') ? ' , ' : '' ) . $orden . ' ' . $tipo_orden . ' ';
				}

				$cadena_orden = ($cadena_orden != '') ? " ORDER BY $cadena_orden " : $cadena_orden;

				//Paginación
				$pagina = Sections::getParam('pagina', 0);
				$enlace = Shop::$configuracion->url . 'reservas';
				$sentencia_sql .= $cadena_orden . ' LIMIT ' . ($pagina * Shop::$configuracion->elementos_reservas) . ', ' . Shop::$configuracion->elementos_reservas;

				//echo("$sentencia_sql<br />\n");
				if ($conexionBD){
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
						//Comprobamos si tenemos pedidos
						if(mysqli_num_rows($resultado) === 0){
?>
						<p class="error_no_hay_pedidos"><?=traducir('Aún no ha realizado ningún pedido');?></p>
<?php
						}else{
							$ultimo_pedido = new PedidoCliente(0);
							$total = 0;
							while ($fila = mysqli_fetch_array($resultado)){
								//Vamos a necesitar un objeto con la linea
								$linea_pedido = new LineaPedidoCliente($fila['mc_pedcli'], $fila['codigo'], true);
								if ($ultimo_pedido->codigo != $fila['mc_pedcli']){
									//Si el último pedido es distinto de 0, entonces hay que mostrar el pie:
									if($ultimo_pedido->codigo > 0){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $ultimo_pedido, 'fichero_resumen' => $fichero_pie));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
									//si hay fichero de cabecera, hacemos el include:
									if ($fichero_cabecera != ''){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_cabecera));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
								}
								
								//Mostramos las reservas
                                new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $linea_pedido, $fichero_linea);
								$total += $linea_pedido->importe_con_dto_reservado;
								$ultimo_pedido = $linea_pedido->objeto_pedido;
							}
							//Mostramos el total siempre después de mostrar los pedidos
							if ($fichero_pie != ''){
								$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_pie));
                                new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
							}

							//Paginacion:
                            new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_reservas);
						}
					}
				}
			}
		}
	}
?>