<?php

//---------------------------------------------------------------------------------------------------------
// 25/Noviembre/2015
// Versión 1.0 Cargamos un
//---------------------------------------------------------------------------------------------------------



function widget_selector_idioma($nombre_funcion = 'selector_idioma') {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'selector_idioma';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function selector_idioma($opciones = NULL) {
    //Por el momento aquí no hay opciones ningunas
    include('comunes/globals.php');
    $ocultarCabecera = false;

    $fichero_selector = 'selector_idioma';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
        //Vamos a cargar los idiomas que hay y añadir los elementos
        $sentencia_sql = 'SELECT LOWER(codigo) codigo, LOWER(nombre) nombre, LOWER(iso3) iso3, prefijo FROM idioma WHERE disponible = 1';
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                $opciones->addElement(array('codigo' => $fila['codigo'], 'nombre' => $fila['nombre'], 'iso3' => $fila['iso3'], 'prefijo' => $fila['prefijo']));
            }
        }
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_selector = ($opciones->configuracion->fichero_selector != NULL) ? $opciones->configuracion->fichero_selector : $fichero_selector;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        //Vamos a cargar los idiomas disponibles
        if (count($opciones->elementos) > 0) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                foreach ($opciones->elementos as $clave => $valor) {
                    $codigo_idioma = $valor->codigo;
                    $nombre_idioma = $valor->nombre;
                    $iso3_idioma = $valor->iso3;
                    $prefijo = $valor->prefijo;
                    $url_idioma = Shop::$configuracion->url_sin_idioma . $codigo_idioma . '/' . $parametros_url;
                    $ruta_fichero = Theme::findFile($fichero_selector . '.php');
                    if ($ruta_fichero != NULL) {
                        include($ruta_fichero);
                    }
                }
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }

    return(true);
}

function selector_pais($opciones = NULL) {
    include('comunes/globals.php');
    $value = Shop::$empresa->pais_empresa;
    $opciones->configuracion->name = (isset($opciones->configuracion->name)) ? $opciones->configuracion->name : NULL;
    $opciones->configuracion->value = (isset($opciones->configuracion->value)) ? $opciones->configuracion->value : NULL;
    $name = ($opciones->configuracion->name != NULL) ? $opciones->configuracion->name : 'campo_registro_pais';
    $value = ($opciones->configuracion->value != NULL) ? $opciones->configuracion->value : $value;
    //echo 'El valor es: '.$value;
    $sentencia_sql = 'SELECT * FROM  `pais` ORDER BY  `nombre`';
    $resultado = mysqli_query($conexionBD, $sentencia_sql);
    if (mysqli_num_rows($resultado) > 0) {
        ?>
        <select name = "<?= $name; ?>" class="campo_pais">
            <option value="0"><?= traducir('Seleccione pais'); ?></option>
            <?php
            //echo("$sentencia_sql<br />\n");
            while ($fila = mysqli_fetch_array($resultado)) {
                //Tenemos paises que mostrar
                ?>
                <option value="<?= $fila['codigo'] ?>" <?= ($fila['codigo'] == $value) ? 'selected' : ''; ?>>
                    <?= traducir($fila['nombre']); ?>
                </option>
                <?php
            }
            ?>
        </select>
        <?php
    }
}
?>