<?php
/*
  Clase SuperEbooks
  @version 1.0
 */

class SuperEbook extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();


    public $codigo = 0;
	public $ean = '';
    public $ruta = '';
    public $limiteDescargas = 0;
	public $descargasUsuarioActual = 0;
	public $descargaPermitida = false;
	public $enlaceDescarga = '';
	
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$ean_articulo = isset($argumentos[0]) ? $argumentos[0] : NULl;
		$ruta = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$usuario = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$limitar = isset($argumentos[3]) ? $argumentos[3] : true;
		
		include('comunes/globals.php');
		static::$whereSelect = '' ;
		if ($ean_articulo != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`ean` = "' . $ean_articulo . '" ';
		}
		//No tiene mucho sentido que no nos pasen la ruta si un producto puede tener varias descargas:
		if ($ruta != NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' .  static::getAlias() . '`.`ruta` = "' . $ruta . '" ';
		}
		if ($usuario != NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' .  static::getAlias() . '`.`usuario` = ' . $usuario . ' ';
		}
		if ($limitar != NULL){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    //Constructor y destructor
    function __construct($eanRecibido = NULL, $ruta = NULL) {
        include('comunes/globals.php');
        $this->ean = $eanRecibido;
		$this->ruta = $ruta;
		$filaAdjunto = NULL;
		$opciones = NULL;
		if (is_a($eanRecibido, 'OpcionesWidget')) {
			$opciones = $eanRecibido;
			$this->ean = ($opciones->configuracion->ean != NULL) ? $opciones->configuracion->ean : $ean;
			$this->ruta = ($opciones->configuracion->ruta != NULL) ? $opciones->configuracion->ruta : $ruta;
			$filaAdjunto = ($opciones->configuracion->filaAdjunto != NULL) ? $opciones->configuracion->filaAdjunto : $filaAdjunto;
		}
		//Para comprobar si el usuario actual puede descargar o no, necesitamos el usuario:
		//Ojo, por ahora no se permiten descargas a usuarios que no estén logueados, está pendiente de hacer si es el caso (TODO)
		if (Usuario::logueado()){
			if ($datos_usuario->codigo > 0){
				//Tenemos la posibilidad de que nos hayan mandado la fila de la descarga:
				//var_dump($filaAdjunto);
				if ($filaAdjunto == NULL){
					//Vamos a cargar las descargas que ha hecho el usuario de este fichero:
					$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
									WHERE ' . static::getWhereTabla($this->ean, $this->ruta, $datos_usuario->codigo);
					//echo("$sentencia_sql<br />\n");
					$bd = new BaseDatos();
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}else{
					$fila = $filaAdjunto;
				}
				if ($fila != NULL){
					$this->codigo = $fila[static::getAlias() . '_' . 'ID'];
					$this->ean = $fila[static::getAlias() . '_' . 'ean'];
					$this->ruta = $fila[static::getAlias() . '_' . 'ruta'];
					$this->usuario = $datos_usuario;
					$this->descargasUsuarioActual = $fila[static::getAlias() . '_' . 'descargas'];
					$this->limiteDescargas = Shop::$configuracion->limite_descargas_ebook;

					//Si hay descargas vamos a ver si se pueden descargar o no:
					if ( ($this->descargasUsuarioActual < $this->limiteDescargas) || ($this->limiteDescargas == 0) ){
						$this->descargaPermitida = true;
					}
					//Vamos a generar el enlace de descarga:
					$this->enlaceDescarga = Shop::$configuracion->url . 'descargar-adjunto/' . $this->ruta;
				}
			}
		}
    }

    function __destruct() {
        
    }

	private static function getAdjuntoDir($eanProducto = NULL){
		include('comunes/globals.php');
		$baseDir = getcwd();
		//Vamos a asegurarnos de que sólo hay una barra como separador
		$ultimaLetra = substr(Shop::$configuracion->url_ebooks, -1);
		$relleno = '/';
		if ($ultimaLetra == $relleno){
			$relleno = '';
		}
		$ebookDir = $baseDir . '/' . Shop::$configuracion->url_ebooks . $relleno . $eanProducto;
		if ( ! existe_fichero($ebookDir)){
			$ebookDir = NULL;
		}
		return($ebookDir);
	}
	
	public static function cargarAdjuntos($eanProducto = NULL){
		include('comunes/globals.php');
		$listaEbooks = array();
		if ($eanProducto != NULL){
			if ($ebookDir = self::getAdjuntoDir($eanProducto)){
				//Vamos a leer el contenido del mismo:
				$listaFicheros = scandir($ebookDir);
				foreach($listaFicheros as $clave => $valor){
					if ( ($valor != '.') || ($valor != '..') ){
						$rutaFichero = $ebookDir . '/' . $valor;
						if (!is_dir($rutaFichero)){
							//Para cada elemento dentro de la carpeta que no es un directorio creamos un elemento en el array de ebooks
							array_push($listaEbooks, new Ebook($eanProducto, $valor));
						}
					}
				}
			}
		}
		//Devolvemos el array de ebooks
		return($listaEbooks);
	}

	public static function getProductList($cliente = NULL){
		include('comunes/globals.php');
		$listaProductos = array();
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				//Antes de seguir vamos a cargar todas las descargas disponibles para este cliente:
				$sentencia_sql = 'SELECT DISTINCT `' . static::getAlias() . '`.`ean`' . ', ' . Articulo::getCampos() . '
									FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '`, ' . Articulo::getNombreTabla() . '  
									WHERE ' . static::getWhereTabla(NULL, NULL, $datos_usuario->codigo, false) . '
									AND `' . Articulo::getAlias() . '`.`ean` = `' . static::getAlias() . '`.`ean` 
									' . Articulo::getWhereTabla(NULL, 0, false) . '
									';
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				$bd->setConsultaSQL($sentencia_sql);
				while($fila = $bd->getFila()){
					$opciones = new OpcionesWidget(array('filaArticulo' => $fila));
					array_push($listaProductos, new Articulo($opciones));
				}
			}
		}
		//Devolvemos el array de ebooks
		return($listaProductos);
	}
	
	public static function cargarAdjuntosCliente($cliente = NULL){
		include('comunes/globals.php');
		$listaEbooks = array();
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				//Antes de seguir vamos a cargar todas las descargas disponibles para este cliente:
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
									WHERE ' . static::getWhereTabla(NULL, NULL, $datos_usuario->codigo, false);
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				$bd->setConsultaSQL($sentencia_sql);
				while($fila = $bd->getFila()){
					$opciones = new OpcionesWidget(array('filaAdjunto' => $fila));
					array_push($listaEbooks, new Ebook($opciones));
				}
			}
		}
		//Devolvemos el array de ebooks
		return($listaEbooks);
	}
	
	public static function getRutasAdjuntos($eanProducto){
		include('comunes/globals.php');
		$listaEbooks = array();
		if ($eanProducto != NULL){
			//Vamos a movernos al directorio dónde se guardan los ebooks
			$baseDir = getcwd();
			//Vamos a asegurarnos de que sólo hay una barra como separador
			$ultimaLetra = substr(Shop::$configuracion->url_ebooks, -1);
			$relleno = '/';
			if ($ultimaLetra == $relleno){
				$relleno = '';
			}
			$ebookDir = $baseDir . '/' . Shop::$configuracion->url_ebooks . $relleno . $eanProducto;
			if (existe_fichero($ebookDir)){
				//Vamos a leer el contenido del mismo:
				$listaFicheros = scandir($ebookDir);
				foreach($listaFicheros as $clave => $valor){
					if ( ($valor != '.') || ($valor != '..') ){
						$rutaFichero = $ebookDir . '/' . $valor;
						if (!is_dir($rutaFichero)){
							//Para cada elemento dentro de la carpeta que no es un directorio creamos un elemento en el array de ebooks
							array_push($listaEbooks, $valor);
						}
					}
				}
			}
		}
		//Devolvemos el array de ebooks
		return($listaEbooks);
	}	
	
	public static function descargarAdjunto($ruta){
		include('comunes/globals.php');
		//el cliente tiene q estar logueado:
		$cliente = Usuario::logueado();
		if ( ($cliente != NULL) && ($cliente->codigo > 0) ){
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
							WHERE ' . static::getWhereTabla(NULL, $ruta, $cliente->codigo);
			//echo("$sentencia_sql<br />\n");
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
			$fila = $bd->getFila();
			$adjunto = new Ebook(new OpcionesWidget(array('filaAdjunto' => $fila)));
			if ($adjunto->descargaPermitida){
				//Vamos a mostrar el fichero:
				$ruta = self::getAdjuntoDir($adjunto->ean) . '/' . $adjunto->ruta;
				if (is_file($ruta)) {
					$size = filesize($ruta);
					if (function_exists('mime_content_type')){
						$type = mime_content_type($ruta);
					}else if (function_exists('finfo_file')){
						$info = finfo_open(FILEINFO_MIME);
						$type = finfo_file($info, $ruta);
						finfo_close($info);
					}
					if ($type == ''){
						//$type = "application/force-download";
						$type = "application/octet-stream";
					}
					// Definir headers
					header("Content-Type: $type");
					header("Content-Disposition: attachment; filename=$nombre_fichero");
					header("Content-Transfer-Encoding: binary");
					header("Content-Length: " . $size);
					header('Expires: 0');
					header('Cache-Control: must-revalidate');
					header('Pragma: public');
					header('Content-Description: File Transfer');

					ob_clean();
					flush();
					readfile($ruta);
					//Ahora toca actualizar el número de descargas del fichero:
					$sentencia_sql = 'UPDATE `descargas_ebook` SET descargas = descargas+1 WHERE `ID` = ' . $adjunto->codigo . ';';
					$bd->setConsultaSQL($sentencia_sql);
				}else{
					echo(traducir('El fichero no existe'));
				}
			}else{
				echo(traducir('Descarga no permitida'));
			}
		}
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>