<?php

class SuperLote extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	public $codigo = 0;
	public $nombre = '';
	public $trabaja_cantidades = false;		//Esto es SÓLO para CANTIDADES
	//public $mantener_cantidades = 0;	//Esto es para mantener cantidades y pvp
	public $trabaja_cantidades_pvp = false;
	public $observaciones = '';
	public $total = 0;
	public $cantidad = 0;
	public $codigo_anterior = '';
	public $ano_lote = 0;
	public $precio_lote = 0;
	public $precio_web = 0;
	public $base_precio_web = 0;
	public $sin_envio = false;
	public $visible_web = 0;
	public $lineas_lote = array();
	public $cantidad_fija = 0;
	public $url = '';
	public $colegio = '';
	public $curso = '';

	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$nombre = isset($argumentos[1]) ? $argumentos[1] : '';
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = "' . $id . '" ';
		}
		if (trim($nombre) !== '') {
			static::$whereSelect = ' `' . static::getAlias() . '`.`nombre` LIKE \'%' . $nombre . '%\' ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}


	function __construct($params = 0){
		$codigo_buscar = 0;
		$nombre_buscar = '';
		if (is_numeric($params)){
			$codigo_buscar = $params;
		}else if (is_string($params)){
			$nombre_buscar = $params;
		}
		//Nos aseguramos de que siempre se lee el fichero de OpcionesWidget. Si no nos lo han pasado, lo creamos
		$params = new ObOptions($params);
		$codigo_buscar = $params->getDefaultValue('codigo', $codigo_buscar);
		$nombre_buscar = $params->getDefaultValue('nombre', $nombre_buscar);
		$fila_lote = $params->getDefaultValue('fila_lote', NULL);
		
		$fila = NULL;
		
		if ($fila_lote == NULL){
			if ( ($codigo_buscar > 0) || ($nombre_buscar != '') ){
				//Corregimos el nombre por el que buscamos cambiando guiones por guiones bajos que son comodines
				if ($nombre_buscar != ''){
					$find = array('-');
					$repl = array('_');
					$nombre_buscar = str_replace($find, $repl, $nombre_buscar);
				}
				
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($codigo_buscar, $nombre_buscar);
				//echo($sentencia_sql);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $fila_lote;
		}
		
		//Si tenemos fila aquí la cargamos
		if($fila != null){
			$this->extractData($fila);
		}
	}
	
	private function extractData($fila){
		//Fila es un array asociativo. De él obtenemos los valores a asignar a los campos. OJO, el índice contiene el alias de la tabla. Tenemos una función que nos facilita la tarea de extacción:
		//$this->getProp($fila, 'nombre_original_del_campo');
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->trabaja_cantidades = $this->boolData($this->getProp($fila, 'mantener_cantidades'));
		$this->observaciones = $this->getProp($fila, 'observaciones');
		$this->total = $this->getProp($fila, 'total');
		$this->cantidad = $this->getProp($fila, 'cantidad');
		$this->codigo_anterior = $this->getProp($fila, 'codigo_anterior');
		$this->ano_lote = $this->getProp($fila, 'ano_lote');
		$this->precio_lote = $this->getProp($fila, 'precio_lote');
		$this->precio_web = $this->getProp($fila, 'precio_web');
		$this->sin_envio = $this->boolData($this->getProp($fila, 'sin_envio'));
		$this->visible_web = $this->getProp($fila, 'visible_web');
		$this->trabaja_cantidades_pvp = $this->boolData($this->getProp($fila, 'trabaja_cantidades'));
		//Obtenemos datos extra:
		$arrayNombre = explode('/', $this->nombre);
		if (count($arrayNombre) > 1){
			$this->colegio = $arrayNombre[0];
			$this->curso = $arrayNombre[1];
		}
		$this->url = Shop::$configuracion->url . 'venta_lote/' . corregir_url($this->nombre);
		$this->cargarLineas();
		$this->recalculate();
	}
	
	private function cargarLineas(){
		$sentencia_sql = 'SELECT ' . LineaLote::getCampos() . ' 
			FROM ' . LineaLote::getNombreTabla() . '
			WHERE ' . LineaLote::getWhereTabla($this->codigo, NULL, NULL, false);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			$opciones = array(
				'codigo_lote' => $this->codigo,
				'fila_linea_lote' => NULL,
				'objeto_lote' => $this,
				'trabaja_cantidades_pvp' => $this->trabaja_cantidades_pvp,
				'trabaja_cantidades' => $this->trabaja_cantidades
			);
			while($fila = $bd->getFila()){
				$opciones['fila_linea_lote'] = $fila;
				$objetoLinea =  new LineaLote($opciones);
				$this->lineas_lote[$objetoLinea->codigo] = $objetoLinea;
				//Pedro 22/Julio/2019 ==> Si la línea no es optativa, entonces suma la cantidad:
				if (!$objetoLinea->optativa){
					$this->cantidad_fija += $objetoLinea->cantidad; 
				}
			}
		}
	}
	
	private function recalculate(){
		//Si el lote tiene un precio web, hay que recalcular la base:
		if ($this->precio_web > 0){
			//Guardaremos en un array los importes totales para cada iva, calcularemos el % del total
			$total_base = $total = 0;
			foreach($this->lineas_lote as $clave => $valor){
				$total += $valor->objeto_articulo->pvp;
			}
			//Ahora recorremos el array para asignar el % que le corresponde a cada producto:
			$total_elementos = count($this->lineas_lote);
			$acumulado = $contador = 0;
			foreach($this->lineas_lote as $clave => $valor){
				//Si estamos en el último elemento, el porcentaje es la diferencia entre el total y el acumulado:
				if ($contador == ($total_elementos - 1)){
					$this->lineas_lote[$clave]->precio_web = $this->precio_web - $acumulado;
				}else{
					$this->lineas_lote[$clave]->precio_web = ($valor->objeto_articulo->pvp * $this->precio_web) / $total;
				}
				$this->lineas_lote[$clave]->base_precio_web = $this->lineas_lote[$clave]->precio_web / ( 1 + ( $this->lineas_lote[$clave]->objeto_articulo->iva / 100 ) );
				//Acumulamos para que la última línea sea la diferencia
				$acumulado += $valor->precio_web;
				//Esta variable la vamos a utilizar para tener en cuenta el número de líneas que hay
				$contador++;
			}
			//Ya tenemos el porcentaje de cada artículo, vamos ahora 
			
		}else{
			//Puede que el total de lote sea 0, en ese caso lo recalculamos
			if ($this->total == 0){
				foreach($this->lineas_lote as $clave => $valor){
					$this->total += $valor->objeto_articulo->pvp;
				}
			}
		}
	}
	
	function __destruct(){
		unset($this->codigo);
		unset($this->nombre);
		unset($this->trabaja_cantidades);
		unset($this->observaciones);
		unset($this->total);
		unset($this->cantidad);
		unset($this->codigo_anterior);
		unset($this->ano_lote);
		unset($this->precio_lote);
		unset($this->visible_web);
		unset($this->trabaja_cantidades_pvp);
	}
	
	public static function lote_nombre_colegio($nombre_colegio = ''){
		include('comunes/globals.php');
		$retorno = '';
		if ($nombre_colegio != ''){
			$sentencia_sql = "SELECT SUBSTRING_INDEX( nombre,  '/', 1 ) nombre_lote FROM mc_lotes
							WHERE visible_web =1 AND SUBSTRING_INDEX( nombre,  '/', 1 ) LIKE  '%$nombre_colegio%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila['nombre_lote'];
					}
				}
			}
		}
		return($retorno);	
	}
	
	public static function lote_nombre($nombre = ''){
		include('comunes/globals.php');
		$retorno = '';
		if ($nombre != ''){
			$sentencia_sql = "SELECT nombre FROM mc_lotes
							WHERE visible_web =1 AND nombre LIKE  '%$nombre%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila["nombre"];
					}
				}
			}
		}
		return($retorno);	
	}

	public static function codigo_de_nombre($nombre = ""){
		include('comunes/globals.php');
		$retorno = "";
		if ($nombre != ""){
			$sentencia_sql = "SELECT codigo FROM mc_lotes
							WHERE visible_web =1 AND nombre LIKE  '%$nombre%'
							LIMIT 0 , 1";
			if ($conexionBD){
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
					if ($fila = mysqli_fetch_array($resultado)){
						$retorno = $fila['codigo'];
					}
				}
			}
		}
		return($retorno);	
	}

	public static function borrar_dto_lote($lote = 0){
		include('comunes/globals.php');
		$retorno = false;
		if ($lote > 0){
			//Buscamos el índice del descuento
			$indice_a_borrar = lote::buscar_dto_lote($lote);
			//Si hay índice vamos a borrar
			if ($indice_a_borrar > -1){
				//Cogemos el array de la sesión
				$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
				//Eliminamos el elmento del array
				array_splice($array_descuentos_lotes, indice_a_borrar, 1);
				//Guardamos el array en la sesión
				Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
				$retorno = true;
			}
		}
		return($retorno);
	}

	public static function insertar_dto_lote($lote = 0, $dto = 0, $cod_dto = ''){
		if ($lote != 0){
			//Borramos el descuento que ya tenga el lote
			lote::borrar_dto_lote($lote);
			//Componemos la cadena
			$cad_lote = $lote . '|' . $dto . '|' . $cod_dto . '|';
			$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
			$array_descuentos_lotes[] = $cad_lote;
			Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
		}
	}

	public static function buscar_dto_lote($lote = 0){
		$indice_lote = -1;
		if ($lote > 0){
			$array_descuentos_lotes = Sesion::get('array_descuentos_lotes', array());
			for ($i = 0; ($i < count($array_descuentos_lotes) && ($indice_lote < 0)); $i++){
				$valor_lote = explode('|', $array_descuentos_lotes[$i]);
				if ($valor_lote[0] == $lote){
					$indice_lote = $i;
				}
			}
		}
		return($indice_lote);
	}

	public static function purgar_dto_lotes(){
		//Vamos a coger los códigos de lote que tenemos activos
		$array_lotes_cesta = Sesion::get('array_lotes_cesta');
		//Ahora cogemos los códigos de descuento asociados
		$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
		//Vamos a recorrer los descuentos de los lotes para ir borrando los que no existan en los lotes de la cesta
		foreach($array_descuentos_lotes as $clave => $valor){
			$valor_lote = explode('|', $valor);
			if (!(in_array($valor_lote[0], $array_lotes_cesta))){
				unset($array_descuentos_lotes[$clave]);
			}
		}

		/*
		// Pedro 04/Julio/2019 ==> Esto ya no se usa
		//Ahora toca reordenar el array
		$array_descuentos_lotes = array_values($array_descuentos_lotes);
		//Grabamos el array
		Sesion::set('array_descuentos_lotes', $array_descuentos_lotes);
		*/
	}

	public function findProduct($product){
		$return = NULL;
		//Ojo que el producto puede ser un objeto o un código:
		$codigo_articulo = $product;
		if (is_a($product, 'Articulo')){
			$codigo_articulo = $product->codigo;
		}

		$buscar = true;
		$lista_elementos = array_values($this->lineas_lote);
		for ($i = 0; ( ($i < count($lista_elementos)) && $buscar); $i++){
			$elemento = $lista_elementos[$i];
			if (intval($elemento->articulo) == intval($codigo_articulo)){
				$return = $lista_elementos[$i];
				$buscar = false;
			}
		}
		return($return);
	}
}
?>