<?php
/*
	Clase SuperSections para las secciones de la web
	@version 1.0
*/

class SuperSections{

	protected $lista_completa = array();
	protected $lista_privada = array();
	protected $lista_solo_publica = array();
	protected $lista_absoluta = array();
	//Métodos estáticos que vamos a utilizar para variables globales relacionadas con la sesión
	public static $section_list = NULL;
	public static $current_section = 'error';
	//Aquí definimos los parámetros de la sección actual:
	private static $params = NULL;
	public static $path = array();

	/*public function add($nombre, $completa = 0, $privada = 0, $solo_publica = 0, $absoluta = 0){
		$resultado = true;
		//Da igual que exista o no la opción, siempre se sobre escribirá
		$this->lista_completa[$nombre] = $completa;
		$this->lista_privada[$nombre] = $privada;
		$this->lista_solo_publica[$nombre] = $solo_publica;
		$this->lista_absoluta[$nombre] = $absoluta;
		return($resultado);
	}*/
	
	public function __call($funcion, $nombre){
		$retorno = false;
		//El nombre es un array, sólo necesitamos el primer elemento
		$nombre = $nombre[0];
		//la función necesita el valor 'lista_' delante
		$funcion = 'lista_' . $funcion;
		//Para poder acceder a sus propiedades necesito meterlo en un array PHP, es una forma de parsearla
		$array_lista = $this->$funcion;
		//Ahora trabajamos con el array obtenido y con el nombre para comprobarlo todo 
		if ( (!isset($array_lista[$nombre])) || (!isset($array_lista[$nombre])) ){
			//Si falta algún dato, hay que devolver un valor nulo
			$retorno = NULL;
		}else{
			$retorno = $array_lista[$nombre];
		}
		return($retorno);
	}
	
	public function dame_secciones_privadas(){
		//$secciones_privadas = array();
		$cadena = '';
		foreach($this->lista_privada as $clave => $valor){
			if($valor == 1){
				//$secciones_privadas[$clave] = $valor;
				$cadena .= 'Disallow: /' . $clave . '*\n';
				$cadena .= 'Disallow: /' . strtoupper($clave) . '*\n';
			}
		}
		return($cadena);
	}

	public static function getValueAndPage($string){
		$retorno = array($string, 0);
		//Hemos recibido una cadena de texto, vamos a extraer el valor y la página a la que pertenece:
		$pagina = static::preg_replace_callback_array(
			[
				'#(.+)\-p(\d+)#' => function (&$matches) {
					return($matches[2]);
				}
			],
			$string
		);
		if ($pagina == $string){
			$pagina = 0;
		}
		//Si pagina es un número, recomponemos:
		if (is_numeric($pagina)){
			//Ahora vamos a quitar "-p***" al valor:
			$retorno[0] = str_replace('-p' . $pagina, '', $string);
			$retorno[1] = $pagina;
		}
		return($retorno);		
	}

	public static function extactArrayFilter($list){
		$retorno = array();
		if (count($list) > 0){
			foreach($list as $key => $value){
				//Sólo cogemos el valor si tiene el texto "filtrar":
				if (strpos($value, 'filtrar') !== false) {
					$value = str_replace('filtrar_', '', $value);
					//convertimos el valor en un array:
					$value = explode('=', $value);
					if (count($value) > 1){
						//Lo que vamos a almacenar son arrays de valores:
						if (!isset($retorno[$value[0]])){
							$retorno[$value[0]] = array();
						}
						$retorno[$value[0]][] = $value[1];
					}
				}
			}
		}
		return($retorno);
	}

	public static function extractUrlPart($oldMatches){
		$resto = static::preg_replace_callback_array(
			[
				'#([^/]+)\/(.+)#' => function (&$matches) {
					static::$path[] = $matches[1];
					return($matches[2]);
				},
				'#([^/]+)#' => function (&$matches) {
					static::$path[] = $matches[1];
					return('');
				}
			],
			$oldMatches
		);
		//si hay resto, entonces lo extraemos:
		if ($resto != $oldMatches){
			static::extractUrlPart($resto);
		}
	}

	public static function getAttr($attr = '', $cur_section = ''){
		$retorno = array();
		//Si no nos indican la sección, cogemos la actual
		$cur_section = ($cur_section == '') ? static::$current_section : $cur_section;

		//Si tenemos esa sección, devolvemos el atributo de la misma
		$section_list = static::$section_list;
		if (static::sectionExists($cur_section)){
			$retorno = isset($section_list[$cur_section][$attr]) ? $section_list[$cur_section][$attr] : NULL;
		}
		return($retorno);
	}

	public static function sectionExists($cur_section = ''){
		$retorno = false;
		$cur_section = ($cur_section == '') ? static::$current_section : $cur_section;
		$section_list = static::$section_list;
		if (isset($section_list[$cur_section])){
			$retorno = true;
		}
		return($retorno);
	}

	//Esta función hace un include de un fichero de la sección
	public static function include_file($from_attr){
		$fichero = static::getAttr($from_attr);
		$file = Theme::include_file($fichero);
	}

	//Constructor y destructor
	function __construct() {
	}

	function __destruct() {

	}


	public static function preg_replace_callback_array (array $patterns_and_callbacks, $subject, $limit=-1, &$count=NULL) {
		$count = 0;
		foreach ($patterns_and_callbacks as $pattern => &$callback) {
			/*var_dump($pattern);
			var_dump($callback);
			var_dump($subject);*/
			$subject = preg_replace_callback($pattern, $callback, $subject, $limit, $partial_count);
			//var_dump($subject);

			$count += $partial_count;
		}
		return preg_last_error() == PREG_NO_ERROR ? $subject : NULL;
	}
	
	public static function getParam($paramName, $defaultValue = NULL){
		return( (isset(self::$params->$paramName)) ? self::$params->$paramName : $defaultValue );
	}
	
	public static function setParam($paramName, $value){
		$value = self::$params->$paramName = $value;
	}

	public static function checkParams(){
		self::$params = (self::$params == NULL) ? new BasicObject() : self::$params;
	}
	
	//Álvaro 010219: Creamos nueva función estática, donde metemos el código del antiguo sectionControl.php, pero sin sus define
	public static function sectionControl(){
		/*
		*	Controlamos en qué sección de la web estamos
		*	@version 1.0.0
		*	@date 2018/03/07
		*
		*/
		$section_list = NULL;
		$do_redirect = false;
		$real_url  = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		$url_base = Shop::$configuracion->url;
		//Empezamos con las www:
		if ( (substr_count ($_SERVER['HTTP_HOST'], 'www')) !== (substr_count ($url_base, 'www')) ){
			$do_redirect = true;
			if (strpos ($url_base, 'www') !== false){
				//En este punto quiere decir que el usuario NO está usando las www y en configuración está seteado:
				$real_url  = 'www.' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			}else{
				//El usuario está entrando CON las www y hay que quitarlas:
				$real_url = str_replace($_SERVER['HTTP_HOST'], 'www.', '') . $_SERVER['REQUEST_URI'];
			}
		}
		//Ahora vamos con el https:
		$https_value = (isset($_SERVER['HTTPS'])) ? $_SERVER['HTTPS'] : 'off';	//Es posible que esta variable no esté seteada
		if ( (Shop::$configuracion->https_on) !== ($https_value == 'on') ){
			$do_redirect = true;
		}
		if (Shop::$configuracion->https_on){
			//Venimos sin https y hay que ponerlo:
			$real_url = 'https://' . $real_url;
		}else{
			$real_url = 'http://' . $real_url;
		}
		/*echo("<pre>");
		echo($real_url);
		echo("</pre>");*/
		//Si hay que hacer la redirección la hacemos YA:
		if ($do_redirect){
			header('Location:' . $real_url);
			die();
		}
		//Para ver la sección actual, vamos a quitar a la url actual completa la de configuracion:
		//$seccionActual = str_replace($real_url, $url_base, '');

		//Marca de tiempo del fichero de secciones:
		$sections_time = 0;
		$sections_conf = _WS_THEME_SECTION_DIR_ . 'sections.php';

		if (file_exists($sections_conf)){
			//Vamos a limpiar la caché del fichero
			//clearstatcache (true, $sections_conf); //No vamos a limpiar la caché por ahora por velocidad
			$sections_time = filemtime($sections_conf);
		}

		//Si no tenemos tiempo de modificación no tiene sentido seguir:
		if ($sections_time > 0){
			$section_list = new ConfigFile($sections_time, true, 'sections/');

			$realPath = $section_list->getRealNamePath();
			//Vamos a ver si existe el fichero:
			if (!file_exists($realPath)){
				//Por si no existiese la carpeta, vamos a crearla:
				if (!file_exists(_WS_DYNAMIC_DIR_ . 'sections/')){
					@mkdir(_WS_DYNAMIC_DIR_ . 'sections/');
				}
				//Lo primero es limpiar el directorio:
				FileSystem::cleanDirectory(_WS_DYNAMIC_DIR_ . 'sections/');
				//Ahora vamos a incluir el fichero de configuración:
				$section_list = new ConfigFile($sections_time, false, 'sections/');
				include($sections_conf);
				$section_list->save();
				
			}
			Sections::$section_list = $section_list->sections;
			//Procesamos el htaccess
			if (file_exists(_WS_THEME_SECTION_DIR_ . 'htaccess.php')){
				include(_WS_THEME_SECTION_DIR_ . 'htaccess.php');
			}
			//Vamos a comprobar que la sección esté bien:
			$privada = Sections::getAttr('privada');
			$current_section = Sections::$current_section;
			//Si la sección es privada y el usuario no ha hecho login, hay que obligarlo
			//if ($privada && ($datos_usuario->codigo == 0)){ //$datos_usuario es de globals y es antiguo
				if ($privada && (Usuario::isLogged() !== NULL)){
				//Corregimos la sección
				Sections::$current_section = 'login_necesario';
			}
			//Si la sección es pública solamente y se ha hecho login, devolvemos al home
			$solo_publica = Sections::getAttr('solo_publica');
			//if ( $solo_publica && ($datos_usuario->codigo > 0) ){//$datos_usuario es de globals y es antiguo
				//Ojo sólo tenemos en cuenta que el usuario esté logueado y sea registrado, no valen aquí los usuarios sin registro
				if ( $solo_publica && (Usuario::isLogged()) ){
				//Hay que cambiar la sección
				Sections::$current_section = 'home';
			}
			//Si todo va guay, vamos a ver si hay programación específica para esta sección
			//Lo primero es ver si tenemos una sección definida en el tema:
			if (file_exists(_WS_THEME_SECTION_DIR_ . Sections::$current_section . '.php')){
				include(_WS_THEME_SECTION_DIR_ . Sections::$current_section . '.php');
			}
			
			//Cuando tenga todas las secciones en el tema quitaremos esto que viene ahora:
			//Esto en el futuro se tiene que hacer de otra forma:
			if (file_exists("comunes/procesos_seccion/" . Sections::$current_section . '.php')){
				include("comunes/procesos_seccion/" . Sections::$current_section . '.php');
			}
			
			//Asignamos la sesión
			//echo(Sections::$current_section);
			//Vamos ahora a cargar la hoja de estilos de la plantilla así como sus CSSs
			Theme::createMedia(Sections::getAttr('jsCabecera'), 'jsCabecera.js');
			Theme::createMedia(Sections::getAttr('jsPie'), 'jsPie.js');
			Theme::createMedia(Sections::getAttr('cssCabecera'), 'cssCabecera.css');
			Theme::createMedia(Sections::getAttr('cssPie'), 'cssPie.css');
		}else{
			//Lanzamos la excepción de que no hay secciones configuradas
		}
	}
	
}
