<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración de emails -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Empresa::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$empresa->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }

?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">
                        <h4 class="card-title"><?=traducir('Dirección a mostrar');?></h4>
                        <div class="form-group row">
                            <label for="emailemp" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Email de empresa');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="email_empresa" value="<?=Shop::$empresa->email_empresa;?>" class="form-control" id="emailemp" placeholder="Email de empresa">
                            </div>
                        </div>
                        <h4 class="card-title"><?=traducir('Autenticación SMTP');?></h4>
                        <div class="form-group row">
                            <label for="emailusu" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Email de usuario');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="direccion_email" value="<?=Shop::$empresa->direccion_email;?>" class="form-control" id="emailusu" placeholder="Email de usuario">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="nameusu" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Usuario');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="usuario_email" value="<?=Shop::$empresa->usuario_email;?>" class="form-control" id="nameusu" placeholder="Nombre de usuario">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="psw" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Password');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="password_email" value="<?=Shop::$empresa->password_email;?>" class="form-control" id="psw" placeholder="Password">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="smtp" class="col-sm-2 text-right control-label col-form-label"><?=traducir('SMTP');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="smtp_email" value="<?=Shop::$empresa->smtp_email;?>" class="form-control" id="smtp" placeholder="SMTP">
                            </div>
                        </div>
                        <h4 class="card-title"><?=traducir('Direcciones alternativas');?></h4>
                        <div class="form-group row">
                            <label for="emailpe" class="col-sm-2 text-right control-label col-form-label"><?=traducir('Email para pedidos');?></label>
                            <div class="col-sm-4">
                                <input type="text" name="direccion_email_pedidos" value="<?=Shop::$empresa->direccion_email_pedidos;?>" class="form-control" id="emailpe" placeholder="Email para pedidos">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?=traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>