<!-- ============================================================== -->
<!-- Marina (09/09/2019) Sección dedicada al mantenimiento y limpieza de la web -->
<!-- ============================================================== -->
<?php
    $nombre_seccion = Sections::getParam('section_name', Sections::$current_section);

    $acciones_disponibles = [
        'borrar_cache_completa' => 1,
        'cache_bd' => 2,
        'cache_html' => 3,
        'cache_overrides' => 4,
        'borrar_sesiones' => 5,
        'optimizar_traducciones' =>6,
        'asignar_cod_pedidos' => 7,
        'eliminar_cabeceras' => 8,
        'limpiar_lineas' => 9,
        'limpiar_direcciones' => 10,
        'reindexar_articulos' => 11
    ];
    //TODO crear un switch en el que iremos decidiendo lo que hace cada acción



?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title"><?=traducir('Caché');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['borrar_cache_completa'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar toda la caché"><?=traducir('Borrar toda');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['cache_bd'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de la base de datos"><?=traducir('Solo base de datos');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['cache_html'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de Html"><?=traducir('Solo html');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['cache_overrides'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de overrides"><?=traducir('Solo overrides');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Sesiones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['borrar_sesiones'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar sesiones con más de 7 días"><?=traducir('Borrar sesiones');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Traducciones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['optimizar_traducciones'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar las traducciones vacías"><?=traducir('Optimizar traducciones');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Pedidos');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary"data-name="<?=$acciones_disponibles['asignar_cod_pedidos'];?>"  data-toggle="tooltip" data-placement="top" data-original-title="Asignar códigos programa a pedidos"><?=traducir('Asignar códigos programa a pedidos');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['eliminar_cabeceras'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Eliminar la cabecera de pedidos temporales sin hash"><?=traducir('Eliminar cabeceras hash erróneo');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['limpiar_lineas'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar lineas de pedidos sin cabecera"><?=traducir('Limpiar lineas huérfanas');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Direcciones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['limpiar_direcciones'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar las direcciones vacías"><?=traducir('Limpiar direcciones sin uso');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Artículos');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="submit" class="boton_cambios btn btn-primary" data-name="<?=$acciones_disponibles['reindexar_articulos'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Reconstruir índice de artículos para las búsquedas"><?=traducir('Reindexar artículos');?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    document.addEventListener('WSLE', function(){
        $("button.boton_cambios").on('click', function(){
            $("button.boton_cambios").attr('disabled', 'disabled');
            window.location = "<?=Shop::$configuracion->url . $nombre_seccion;?>?action=" + $(this).data('name');
        });
    });
</script>