<?php
//---------------------------------------------------------------------------------
//	02/Octubre/2018 ==> Este fichero es el encargado de configurar las secciones
//
//
//---------------------------------------------------------------------------------

//Obtenemos la url
$real_url = 'http' . ((Shop::$configuracion->https_on) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$url_base = Shop::$configuracion->url;

$url = str_replace($url_base, '', $real_url);
//Si no tenemos parámetros, creamos unos nuevos
Sections::checkParams();
//Vamos a quitar lo que haya después de la interrogación:
$interrogacion = strpos($url, '?');
if ($interrogacion !== false){
	//Quitamos de la URL la interrogación y lo que hay a la derecha:
	$url = substr($url, 0, $interrogacion);
}

//Antes de seguir vamos a dejar las cosas claras:
$ir_a_login = true;
$usuario = Usuario::logueado();
if ($usuario != NULL){
	if ($usuario->administrador){
		$ir_a_login = false;
	}
}

if (!$ir_a_login){
	if ( ($url == '') || ($url == '/')){
		//Estamos en el home:
		Sections::$current_section = 'home';
	}else{
		//Hay que limpiar la url para quitar la / inicial y final si la tuviese:
		if (substr($url, 0, 1) == '/'){
			$url = substr($url, 1, strlen($url) - 1);
		}
		if (substr($url, -1) == '/'){
			$url = substr($url, 0, strlen($url) - 1);
		}
		
		//Vamos a componer la ruta:
		Sections::extractUrlPart($url);
		//Ahora tengo la ruta a la inversa, la invertimos en un nuevo array para tratarla
		$lista = Sections::$path;
		//Pedro 29/Mayo/2019 ==> OJO, Cuando sólo hay un elemento en la lista, puede que ya tenga paginación. Además inicializamos la sección siempre aquí
		Sections::$current_section = $seccion_actual = $lista[0];
		if (count($lista) == 1){
			$valores = Sections::getValueAndPage($lista[0]);
			Sections::$current_section =  $seccion_actual = $valores[0];
			if (isset($valores[1])){
				Sections::setParam('pagina', $valores[1]);
			}
		}
		$seccion_encontrada = false;
		//Según la lista, vamos a ver qué hacemos:
		switch($seccion_actual){
			case 'recursos':
			case 'imagenes':
				Sections::$current_section = 'imagenes';
				Sections::setParam('section_name', 'Imágenes');
				//var_dump($lista);
			break;
			case 'banners':
				Sections::$current_section = 'banners';
				Sections::setParam('section_name', 'Banners');
			break;
			case 'articulos':
				Sections::$current_section = 'articulos';
				Sections::setParam('section_name', 'Artículos');
			break;
			case 'traduccion':
				Sections::$current_section = 'traduccion';
				Sections::setParam('section_name', 'Traducción');
			break;
			case 'upload':
				Sections::$current_section = 'upload';
				Sections::setParam('section_name', 'Subida de ficheros');
			break;

			case 'configuracion_emails':
				Sections::setParam('section_name', 'Configuración de correo electrónico');
			break;
			case 'configuracion_general':
				Sections::setParam('section_name', 'Configuración general');
			break;
		}
	}
}else{
	//vamos a login
	Sections::$current_section = 'login';
}
/*
if ( ($url == '') || ($url == '/')){
	//Estamos en el home:
	Sections::$current_section = 'home';
}else{
	//Hay que limpiar la url para quitar la / inicial y final si la tuviese:
	if (substr($url, 0, 1) == '/'){
		$url = substr($url, 1, strlen($url) - 1);
	}
	if (substr($url, -1) == '/'){
		$url = substr($url, 0, strlen($url) - 1);
	}
	
	//Vamos a componer la ruta:
	Sections::extractUrlPart($url);
	//Ahora tengo la ruta a la inversa, la invertimos en un nuevo array para tratarla
	$lista = Sections::$path;
	//Ahora tengo en la ruta definido lo que quiero:
	$seccion_actual = $lista[0];
	$seccion_encontrada = false;
	//Según la lista, vamos a ver qué hacemos:
	switch($seccion_actual){
		case 'autor':
		case 'editorial':
		case 'fabricante':
		case 'marca':
			//Todos estos casos es un resultado búsqueda
			Sections::$current_section = 'resultado_busqueda';
			//Vamos a ver si hay pagina:
			$valor = '';
			$pagina = 0;
			//Me aseguro de haber recibido los valores correctos
			if (isset($lista[1])){
				$valores = Sections::getValueAndPage($lista[1]);
				$valor = $valores[0];
				$pagina = $valores[1];
			}
			//Componemos el parámetro que se ha buscado:
			Sections::setParam($seccion_actual, $valor);
			//Sections::$params->$seccion_actual = $valor;
			Sections::setParam('pagina', $pagina);
			//Sections::$params->pagina = $pagina;
			//Ahora es interesante extraer los filtrados:
			Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($lista, 2)));
			//Sections::$params->filtro = Sections::extactArrayFilter(array_slice($lista, 2));
			$seccion_encontrada = true;
		break;
		case 'busqueda_avanzada':
			//Comprobamos si es la sección de búsqueda o si es el resultado
			//Sabemos que si no tiene parámetros es la búsqueda 
			if(isset($lista[1])){
				// Al tener valores es un resultado de la búsqueda avanzada
				//Asignamos la sección
				Sections::$current_section = 'resultado_busqueda';
				//como si tiene valores los asingamos
				$valor = '';
				$pagina = 0;
				$valores = Sections::getValueAndPage($lista[1]);
				Sections::setParam('cadena_busqueda', $valor);
				//Sections::$params->cadena_busqueda = $valor;
				Sections::setParam('pagina', $pagina);
				//Sections::$params->pagina = $pagina;
				//Ojo, a partir de aquí podemos tener filtrados:
				//Ahora es interesante extraer los filtrados:
				Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($lista, 2)));
				//Sections::$params->filtro = Sections::extactArrayFilter(array_slice($lista, 2));
			}else{
				//Asignamos la sección
				Sections::$current_section = 'busqueda_avanzada';
			}
			//Indicamos que se ha encontrado seccion
			$seccion_encontrada = true;
		break;
		case 'buscar':
			//Asignamos la sección
			Sections::$current_section = 'resultado_busqueda';
			$valor = '';
			$pagina = 0;	
			//Me aseguro de haber recibido los valores correctos
			if (isset($lista[1])){
				//Vamos a ver si hay pagina:
				$valores = Sections::getValueAndPage($lista[1]);
				$valor = $valores[0];
				$pagina = $valores[1];
			}
			Sections::setParam('txt_busqueda', $valor);
			//Sections::$params->txt_busqueda = $valor;
			Sections::setParam('pagina', $pagina);
			//Sections::$params->pagina = $pagina;
			//Ahora es interesante extraer los filtrados:
			Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($lista, 2)));
			//Sections::$params->filtro = Sections::extactArrayFilter(array_slice($lista, 2));

			//indicamos que se ha encontrado
			$seccion_encontrada = true;
		break;
		
		case 'registro':
			//Asignamos la sección e indicamos que se ha encontrado
			Sections::$current_section = 'registro';
			//Asignamos los parametros
			Sections::setParam('emailUsuario', Getter::get('emailUsuario', ''));
			$seccion_encontrada = true;
		break;
		
		case 'confirmacion_registro':
			//Asignamos la sección e indicamos que se ha encontrado
			Sections::$current_section = 'confirmacion_registro';
			//Asignamos los parametros
			Sections::setParam('codigo_confirmacion', $lista[1]);
			//Sections::$params->codigo_confirmacion = $lista[1];
			Sections::setParam('codigo_cliente', $lista[2]);
			//Sections::$params->codigo_cliente = $lista[2];
			//indicamos que se ha encontrado
			$seccion_encontrada = true;
		break;
		
		case 'datos_compra':
			//Asignamos la sección
			Sections::$current_section = 'cesta';
			//Asignamos los valores
			Sections::setParam('paso_cesta', 1);
			//Sections::$params->paso_cesta = 1;
			$seccion_encontrada = true;
		break;
		case 'tipo_envio':
			//Asignamos la sección
			Sections::$current_section = 'cesta';
			//Asignamos los valores
			Sections::setParam('paso_cesta', 2);
			//Sections::$params->paso_cesta = 2;
			$seccion_encontrada = true;
		break;
		case 'forma_pago':
			//Asignamos la sección
			Sections::$current_section = 'cesta';
			//Asignamos los valores
			Sections::setParam('paso_cesta', 3);
			//Sections::$params->paso_cesta = 3;
			$seccion_encontrada = true;
		break;
		case 'resumen_compra':
			//Asignamos la sección
			Sections::$current_section = 'cesta';
			//Asignamos los valores
			Sections::setParam('paso_cesta', 4);
			//Sections::$params->paso_cesta = 4;
			$seccion_encontrada = true;
		break;
		case 'finalizar_compra':
			//Asignamos la sección
			Sections::$current_section = 'finalizar_compra';
			//A día de hoy no tenemos código de pedido, la propia sección actualizará el pedido
			$seccion_encontrada = true;
		break;
		
		case 'historico_pedidos':
			//Todos estos casos es un resultado búsqueda
			Sections::$current_section = 'pedidos_pendientes';
			//Vamos a ver si hay pagina:
			$pagina = 0;
			//Me aseguro de haber recibido los valores correctos
			if (isset($lista[1])){
				$pagina = $valores[1];
			}
			Sections::setParam('pagina', $pagina);
			//Sections::$params->pagina = $pagina;
			$seccion_encontrada = true;
		break;
		
		case 'cursos':
			//Asignamos la sección
			Sections::$current_section = 'cursos';
			//Asignamos los valores
			Sections::setParam('colegio', $lista[1]);
			//Sections::$params->colegio = $lista[1];
			$seccion_encontrada = true;
		break;
		case 'lote':
			//Asignamos la sección
			Sections::$current_section = 'lote';
			//Asignamos los valores
			Sections::setParam('nombre_lote', $lista[1]);
			//Sections::$params->nombre_lote = $lista[1];
			$seccion_encontrada = true;
		break;
		case 'venta_lote':
			//Asignamos la sección
			Sections::$current_section = 'venta_lote';
			//Asignamos los valores
			Sections::setParam('nombre_lote', $lista[1]);
			//Sections::$params->nombre_lote = $lista[1];
			$seccion_encontrada = true;
		break;
		case 'busqueda_lote':
			//Asignamos la sección
			Sections::$current_section = 'resultado_busqueda_lote';
			//Asignamos los valores
			Sections::setParam('lote_buscar', $lista[1]);
			//Sections::$params->lote_buscar = $lista[1];
			$seccion_encontrada = true;
		break;
		
		case 'deposito':
			//Asignamos la sección
			Sections::$current_section = 'deposito';
			//Asignamos los valores
			Sections::setParam('codigo_deposito', $lista[1]);
			//Sections::$params->codigo_deposito = $lista[1];
			$seccion_encontrada = true;
		break;
						
		case 'depositos':
			//Todos estos casos es un resultado búsqueda
			Sections::$current_section = 'depositos';
			//Vamos a ver si hay pagina:
			$pagina = 0;
			//Me aseguro de haber recibido los valores correctos
			if (isset($lista[1])){
				$pagina = $valores[1];
			}
			Sections::setParam('pagina', $pagina);
			//Sections::$params->pagina = $pagina;
			$seccion_encontrada = true;
		break;
		
		case 'factura':
			//Asignamos la sección
			Sections::$current_section = 'factura';
			//Asignamos los valores
			Sections::setParam('factura', $lista[1]);
			//Sections::$params->factura = $lista[1];
			$seccion_encontrada = true;
		break;
						
		case 'facturas':
			//Todos estos casos es un resultado búsqueda
			Sections::$current_section = 'facturas';
			//Vamos a ver si hay pagina:
			$pagina = 0;
			//Me aseguro de haber recibido los valores correctos
			if (isset($lista[1])){
				$pagina = $valores[1];
			}
			Sections::setParam('pagina', $pagina);
			//Sections::$params->pagina = $pagina;
			$seccion_encontrada = true;
		break;
		
		case 'descargar-adjunto':
			//Asignamos la sección e indicamos que se ha encontrado
			Sections::$current_section = 'fichero_adjunto';
			Sections::setParam('ruta', $lista[1]);
			//Sections::$params->ruta = $lista[1];
			$seccion_encontrada = true;
		break;
		case 'conocenos':
			//Asignamos la sección
			Sections::$current_section = 'conocenos';
			//Asignamos los valores
			$seccion_encontrada = true;
		break;
	}

	//Si no hemos encontrado la sección vamos a ver qué hacemos 
	if (!$seccion_encontrada){
		//Lo suyo es empeza cargando un escaparate con el último valor de la ruta:
		$infoEscaparate = (isset($lista[0])) ? $lista[0] : '';
		$valores = Sections::getValueAndPage($infoEscaparate);
		$valor = $valores[0];
		$pagina = $valores[1];
		//Ahora es interesante extraer los filtrados TODO:
		$filtro = Sections::extactArrayFilter(array_slice($lista, 1));
		//en valor tengo el nombre del posible escaparate a cargar:
		if (!is_numeric($valor)){
			//Si aquí tuviese un valor no numérico estoy en un producto o escaparate (por ahora)
				//Escaparate, limpiamos el nombre para meter los comodines:
			$nombre_escaparate = strtolower($valor);
			$find = array('-');
			$repl = array('_');
			$nombre_escaparate = str_replace($find, $repl, $nombre_escaparate);
			$opciones = new OpcionesWidget(array(
				'codigo' => $nombre_escaparate,
				'filtrado_actual' => $filtro
			));
			//var_dump($opciones);
			$escaparate = new Escaparate($opciones);
			if ($escaparate->codigo > 0){
				//Hay que cargar los productos del escaparate y crear los objetos "artículo" según esta lista
				$escaparate->carga_articulos($pagina, 0); // ==> Se pone un 0 para que se respete la paginación, si no se pone nada se cargan todos

				//Eureka, estamos en un escaparate
				Sections::$current_section = 'escaparate';
				Sections::setParam('escaparate', $escaparate);
				//Sections::$params->escaparate = $escaparate;
				Sections::setParam('pagina', $pagina);
				//Sections::$params->pagina = $pagina;
				$seccion_encontrada = true;
			}else{
				//Vamos a ver si el último elemento es un EAN
				$ultimoElemento = $lista[count($lista) - 1];
				//Vamos a ver si era un artículo pero cogiéndolo del "último elemento":
				$ean = Sections::preg_replace_callback_array(
				[
					'#(.+)\-p(.+)#' => function (&$matches) {
						return($matches[2]);
					},
				],
				$ultimoElemento
				);
				//Si tenemos un ean, vamos a cargar el producto:
				if ($ean != $ultimoElemento){
					$articulo = new Articulo($ean);
					if ($articulo->codigo > 0){
						//Eureka, estamos en un producto
						Sections::$current_section = 'ficha';
						Sections::setParam('articulo', $articulo);
						//Sections::$params->articulo = $articulo;
						//var_dump($articulo);
						$seccion_encontrada = true;
					}
				}
			}
		}
	}
	//Si llegados a este punto seguimos sin encontrar la sección, vamos a comprobar si estamos en un fichero sin parámetros
	if (!$seccion_encontrada){
		//En caso de que sólo haya un parámetro, estamos en una sección sencilla:
		if (count($lista) == 1){
			$ficheroSeccion = $lista[0];
			//Vamos a comprobar si esa sección está definida:
			if (Sections::sectionExists($lista[0])){
				//Vamos a indicar que es en la que estamos:
				Sections::$current_section = $lista[0];
			}
		}
	}
}
*/

//Vamos a establecer aquí unos parámetros para la web:
//Controlamos que siempre tengamos un orden. Salvo que el usuario haya especificado algo, el orden siempre será por stock DESC: ==> Esto es algo que se hizo para perez fernandez, por defecto lo quitamos
/*$orden = Sesion::get('orderOfProducts');
if ($orden == NULL){
	$orden = ' ORDER BY `' . Articulo::getAlias() . '`.`stock_disponible` DESC, `' . Articulo::getAlias() . '`.`fecha_alta` DESC ';
	Sesion::set('orderOfProducts', $orden);
}*/

//Otra cosa que vamos a hacer es que no exista la capa de "restaurar" de la cesta cuando cambiemos de sección:
Sesion::remove('lastDeleted');