<?php
	//Antes de arrancar el core de webStore vamos a inicializar las variables locales que indicarán qué web vamos a mostrar con este index.
	// Es decir, vamos a tener preparado en el motor de webStore una constante en la que especificar que plantilla cogemos:
	include_once('local.php');	// ==> Lo hacemos con un include para no tener que editar el index en cada cliente (Pedro 07/Febrero/2019)
	
	//Nos aseguramos de que SIEMPRE exista un "core_path"
	if (!defined('_WS_CORE_PATH')){
		define('_WS_CORE_PATH', '');	//Esta variable SÓLO se usa para poder hacer el include de webStore sin tener que tocar el index.php.
										//	Existe otra variable que es "_WS_CORE_DIR_" que contiene la ruta absoluta interna al core de webStore
	}
	
	//Arrancamos el core de webStore
	include(_WS_CORE_PATH . '../core/initWebStore.php');

	error_reporting(E_ALL);	// Esto en el futuro debe desaparecer

	//Vamos a cargar el control de secciones:
	//Álvaro 050219 Tarea 5170: Ahora, en vez de hacer un include de sectioncontrol.php, vamos ahora a llamar a esa funcion estática de sections.php
	//include_once(_WS_CORE_DIR_ . 'sectionControl.php');
	Sections::sectionControl();	//Obsérvese que para que esto tenga sentido se ha cargado el core de webStore, si no, no podríamos hacer referencia a ninguna clase

	//Si la sección es completa la cargamos directamente:
	$completa = Sections::getAttr('completa');
	if ($completa){
		Theme::showContent();
	}else{
		//cargamos el fichero de la sección, según la sección, la plantilla puede ser diferente
		$ficheroPlantilla = Sections::getAttr('plantilla');
		if ( ($ficheroPlantilla != NULL) && ($ficheroPlantilla != '') ){
			Theme::include_file($ficheroPlantilla);
		}
	}
	
	$absoluta = Sections::getAttr('absoluta');
	//Si la sección no es absoluta mostramos lo siguiente:
	//Para asegurarnos de que se guarde en la sesión todo, hacemos un commit
	Sesion::commit();


	//Lo último es desconectarnos de la base de datos
	BaseDatos::closeConexion();

	ob_end_flush();