<?php

//---------------------------------------------------------------------------------------------------------
// 1/Octubre/2014
// Versión 1.0 Aquí se incluirán todos los tipos de menús flotantes de que dispone la web
//---------------------------------------------------------------------------------------------------------
// 16/Octubre/2014
// Versión 2.0 Creamos esta opcion web como widget. Se pasa como parámetro la función a ejecutar (el tipo de objeto que queremos crear)
//---------------------------------------------------------------------------------------------------------



//function widget_lista_escaparates($nombre_funcion = "menu_escaparates", $escaparate_a_seleccionar = 0, $nivel_maximo = 99999, $condicion = NULL, $activo = 1){
function widget_lista_escaparates() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'menu_escaparates';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function menu_escaparates($escaparate_a_seleccionar = 0, $nivel_maximo = 99999, $condicion = NULL, $activo = 1, $limite = NULL, $ficheroListaEscaparate = "cabListaEscaparate", $ficheroLineaEscaparate = "lineaEscaparate") {
    include('comunes/globals.php');
    //Variable utilizada para controlar el rendimiento de esta función
    //Esta variable la declaramos fuera porque debe existir
    $desplegablesJavascript = true;
    //Vamos a transformar esta función en una V2:
    $nivel = 0;
    if (is_a($escaparate_a_seleccionar, 'OpcionesWidget')) {
        $opciones = $escaparate_a_seleccionar;
        $escaparate_a_seleccionar = 0;
        $nivel_maximo = 99999;
        $condicion = NULL;
        $activo = 1;
        $limite = NULL;
        $ficheroListaEscaparate = "cabListaEscaparate";
        $ficheroLineaEscaparate = "lineaEscaparate";
        $nivel = 0;
		$cache = true;

        $nivel_maximo = ($opciones->configuracion->nivel_maximo != NULL) ? $opciones->configuracion->nivel_maximo : $nivel_maximo;
        $condicion = ($opciones->configuracion->condicion != NULL) ? $opciones->configuracion->condicion : $condicion;
        $activo = ($opciones->configuracion->activo != NULL) ? $opciones->configuracion->activo : $activo;
        $limite = ($opciones->configuracion->limite != NULL) ? $opciones->configuracion->limite : $limite;
        $desplegablesJavascript = ($opciones->configuracion->desplegablesJavascript !== NULL) ? $opciones->configuracion->desplegablesJavascript : $desplegablesJavascript;
        $escaparate_a_seleccionar = ($opciones->configuracion->escaparate_a_seleccionar != NULL) ? $opciones->configuracion->escaparate_a_seleccionar : $escaparate_a_seleccionar;
        $ficheroListaEscaparate = ($opciones->configuracion->ficheroListaEscaparate != NULL) ? $opciones->configuracion->ficheroListaEscaparate : $ficheroListaEscaparate;
        $ficheroLineaEscaparate = ($opciones->configuracion->ficheroLineaEscaparate != NULL) ? $opciones->configuracion->ficheroLineaEscaparate : $ficheroLineaEscaparate;
        $nivel = ($opciones->configuracion->nivel != NULL) ? $opciones->configuracion->nivel : $nivel;
		$cache = ($opciones->configuracion->cache !== NULL) ? $opciones->configuracion->cache : $cache;
    }
	$cargadoDesdeCache = false;
	$rutaCache = '';
	if ($cache){
		$rutaCache = $nivel_maximo . $condicion . ($activo?'0':'1') . $limite . $desplegablesJavascript . ((is_a($escaparate_a_seleccionar, 'Escaparate'))?$escaparate_a_seleccionar->rama:'0') . $ficheroListaEscaparate . $ficheroLineaEscaparate . $nivel . ($cache?'0':'1');
		$rutaCache = hash ('sha256', $rutaCache);
		//Vamos a asegurarnos de que exista la carpeta:
		if (!is_dir(_WS_DYNAMIC_DIR_ . 'cache/')){
			mkdir(_WS_DYNAMIC_DIR_ . 'cache/');
		}
		if (!is_dir(_WS_DYNAMIC_DIR_ . 'cache/' . (__FUNCTION__))){
			mkdir(_WS_DYNAMIC_DIR_ . 'cache/' . (__FUNCTION__));
		}
		//Llegados a este punto vamos a intentar ver si hay fichero en la carpeta:
		$rutaCache = _WS_DYNAMIC_DIR_ . 'cache/' . (__FUNCTION__) . '/' . $rutaCache;
		if (file_exists( $rutaCache )){
			$cargadoDesdeCache = (include $rutaCache);
		}
	}
	//Antes de seguir comprobaremos que el escaparate esté cacheado:
	if (!$cargadoDesdeCache ) {
		
		//En este caso continuanos con normalidad
		if (!is_a($escaparate_a_seleccionar, 'Escaparate')) {
			$escaparateActual = new Escaparate($escaparate_a_seleccionar, $nivel_maximo, $condicion, $activo);
		} else {
			$escaparateActual = $escaparate_a_seleccionar;
		}
		//Si después de todo esto tenemos un objeto escaparate, hay que cargar los hijos (si no se han cargado ya):
		if (is_a($escaparateActual, 'Escaparate')) {
			if (!$escaparateActual->hijosCargados){
				//echo '<pre>entra en cargar hijos</pre>';
				$escaparateActual->cargar_hijos();
			}
		}
		if (!$escaparateActual->objeto_vacio) {
			//Vamos a controlar que existan los ficheros:
			$ficheroCabecera = Theme::findFile($ficheroListaEscaparate . ".php");
			$ficheroLinea = Theme::findFile($ficheroLineaEscaparate . ".php");
			if ($ficheroCabecera != NULL && $ficheroLinea != NULL){
				$resultadoCabecera = '';
				//si tiene hijos, hay que ejecutar primero la función recursiva para obtener el resultado:
				if (count($escaparateActual->hijos) > 0){
					$resultado = "";
					/*echo("<pre>");
					foreach($escaparateActual->hijos as $clave => $valor){
						echo("$valor->nombre_natural\n");
					}
					echo("</pre>");*/
					foreach($escaparateActual->hijos as $clave => $valor){
						//Creamos un "opciones widget con las opciones arriba mencionadas:
						$opciones = new OpcionesWidget(array(
							'nivel_maximo' => $nivel_maximo - 1,
							'condicion' => $condicion,
							'activo' => $activo,
							'limite' => $limite,
							'desplegablesJavascript' => $desplegablesJavascript,
							'escaparate_a_seleccionar' => $valor,
							'ficheroListaEscaparate' => $ficheroListaEscaparate,
							'ficheroLineaEscaparate' => $ficheroLineaEscaparate,
							'nivel' => $nivel + 1,
							'cache' => false	//No podemos cargar desde caché en este punto
						));
						//Llamamos a este mismo widget pero capturando la salida:
						ob_start();
						new Widget($_WH->GW('lista_escaparates', 'menu_escaparates'), $opciones);
						$resultado .= ob_get_clean();
					}
					//Ejecutamos la cabecera si la hay:
					ob_start();
					include($ficheroCabecera);
					$resultadoCabecera = ob_get_clean();
					
					//En fichero cabecera tenemos '{líneas}'
					$resultadoCabecera = str_replace('{lineas}', $resultado, $resultadoCabecera);
				}
				ob_start();
				//Por último hacemos el include de la línea:
				include($ficheroLinea);
				$resultadoLinea = ob_get_clean();
				//En fichero cabecera tenemos '{hijos}'
				$resultadoLinea = str_replace('{hijos}', $resultadoCabecera, $resultadoLinea);
				//Mostramos el resultado:
				echo($resultadoLinea);
				//Vamos a guardarlo en caché:
				if ($cache && (!$cargadoDesdeCache)){
					if ($fichero = @fopen($rutaCache, 'w')){
						fwrite($fichero, $resultadoLinea);
						fclose($fichero);
					}
				}
			}
			?>
				   
			<?php
		}
	}
}

function lista_escaparates($lista_escaparates = array()) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    //Transformamos este objeto en un V2, pero sin crear la función V2:
    //Para ello defino las propiedades que van dentro de "opciones_widget"
    $activo = 1;
    if (is_a($lista_escaparates, 'OpcionesWidget')) {
        $opciones = $lista_escaparates;
        $lista_escaparates = array();
        $activo = ($opciones->configuracion->activo != NULL) ? $opciones->configuracion->activo : $activo;
        $lista_escaparates = ($opciones->configuracion->lista_escaparates != NULL) ? $opciones->configuracion->lista_escaparates : $lista_escaparates;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    if (count($lista_escaparates) > 0) {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <ul>
                <?php
                foreach ($lista_escaparates as $clave => $valor) {
                    $mostrar = true;
                    if (($activo != NULL) && ($valor->activo != $activo)) {
                        $mostrar = false;
                    }
                    //Si tenemos en cuenta la condición:
                    if ($mostrar) {
                        $clase_li = $valor->estilo_no_seleccionado;
                        if ($escaparate_actual != NULL) { //Es posible que no esté en ningún escaparate
                            if ($valor->codigo == $escaparate_actual->codigo) {
                                //La clase es la del estilo seleccionado si contiene valor, si no, le ponemos directamente "actual"
                                $clase_li = ($valor->estilo_seleccionado != "") ? $valor->estilo_seleccionado : 'class="actual"';
                            }
                        }
                        ?>
                        <li <?= $clase_li; ?>><a href="<?= $valor->url; ?>" title="<?= $valor->title_seo; ?>"><?= $valor->nombre_seo; ?></a></li>
                        <?php
                    }
                }
                ?>
            </ul>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
}

function boton_suscripcion_escaparate($opciones = null) {
    include('comunes/globals.php');
    if (!is_a($opciones, 'OpcionesWidget')) {
        $opciones = new OpcionesWidget();
    }
    $usuario = ($opciones->configuracion->usuario != NULL) ? $opciones->configuracion->usuario : Usuario::logueado();
    $escaparate = ($opciones->configuracion->escaparate != NULL) ? $opciones->configuracion->escaparate : NULL;
    $fichero_boton = ($opciones->configuracion->fichero_boton != NULL) ? $opciones->configuracion->fichero_boton : 'btnSuscripcion';
    $recursivo = ($opciones->configuracion->recursivo != NULL) ? $opciones->configuracion->recursivo : false;

    //Si no hay escaparate, o no seguimos
    if ($escaparate != NULL && $usuario != NULL) {
        //Si es numérico o es un int, seguimos
        if ((is_int($escaparate) || is_a($escaparate, 'Escaparate')) && (is_int($usuario) || is_a($usuario, 'Usuario'))) {
            //Si el escaparate es un INT, cargamos el mismo:
            if (is_int($escaparate)) {
                $escaparate = new Escaparate($escaparate);
            }
            if (is_int($usuario)) {
                $usuario = new Usuario($usuario);
            }
            //Ahora vamos a mostrar un botón para sucribirse a un escaparate:
            $ruta = Theme::findFile($fichero_boton . '.php');
            if ($ruta != NULL) {
                //Tenemos que ver si el usuario actual está sucrito al escaparate actual:
                $hay_suscripciones = false;
                $sentencia_sql = "SELECT codigo FROM suscrip_esca WHERE cliente = " . $usuario->codigo . " AND cescaparate = " . $escaparate->codigo;
                if ($resultado_suscripcion = mysqli_query($conexionBD, $sentencia_sql)) {
                    if ($fila_suscripcion = mysqli_fetch_array($resultado_suscripcion)) {
                        $hay_suscripciones = ( $fila_suscripcion['codigo'] != "" ) ? true : false;
                    }
                }
                //Por si no se han cargado los hijos del escaparate, los cargamos aquí:
                //$escaparate->cargar_hijos(1, 1); //==> Cargamos los hijos de primer nivel y que estén activos //TODO
                ?>
                <div class="<?= (__FUNCTION__); ?> <?= ($hay_suscripciones ? 'suscrito' : 'no_suscrito'); ?><?= ($recursivo && count($escaparate->hijos) > 0) ? " padre" : ""; ?>">
                    <?php
                    include($ruta);
                    if ($recursivo && count($escaparate->hijos) > 0) {
                        $opciones = new OpcionesWidget(array(
                            'usuario' => $usuario,
                            'lista_escaparates' => $escaparate->hijos,
                            'fichero_boton' => $fichero_boton,
                            'recursivo' => $recursivo
                        ));
                        new Widget($_WH->GW('lista_escaparates', 'suscripciones_lista_escaparates'), $opciones);
                    }
                    ?>
                </div>
                <?php
                $nombre_script = 'script_' . incrementa_contador();
                ?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                        enlace.on("click", function (event) {
                            event.stopPropagation();
                            var escaparate = "<?= $escaparate->codigo; ?>";
                            var usuario = '<?= $usuario->codigo; ?>';
                            //Realizamos la consulta
                            var parametros = "escaparate=" + escaparate + "&usuario=" + usuario + "&hash=<?= genera_cod_seguridad(); ?>";
                            var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/suscribirse_tema.php";
                            var elementoClick = this;
                            //
                            realizar_solicitud(url, parametros, function (respuesta) {
                                respuesta = JSON.parse(respuesta);
                                //console.log(respuesta);
                                //Según el estado recibido, vamos a hacer una cosa u otra
                                if (respuesta.estado == "0") {
                                    $(elementoClick).removeClass("suscrito");
                                    $(elementoClick).addClass("no_suscrito");
                                } else {
                                    $(elementoClick).removeClass("no_suscrito");
                                    $(elementoClick).addClass("suscrito");
                                }

                            });
                        });
                    })();
				});
                </script>
                <?php
            }
            /*
              ?>
              <a href="javascript:void(0);" title="<?=traducir("Suscríbeme");?>"><?=traducir("Suscríbeme");?></a>
              <?php
             */
        }
    }
}

function suscripciones_lista_escaparates($opciones = null) {
    include('comunes/globals.php');
    if (!is_a($opciones, 'OpcionesWidget')) {
        $opciones = new OpcionesWidget();
    }
    $usuario = ($opciones->configuracion->usuario != NULL) ? $opciones->configuracion->usuario : Usuario::logueado();
    $fichero_boton = ($opciones->configuracion->fichero_boton != NULL) ? $opciones->configuracion->fichero_boton : 'listaBtnSucripEsca';
    $lista_escaparates = ($opciones->configuracion->lista_escaparates != NULL) ? $opciones->configuracion->lista_escaparates : NULL;
    $recursivo = ($opciones->configuracion->recursivo != NULL) ? $opciones->configuracion->recursivo : false;

    if ($lista_escaparates != NULL) {
        if (is_array($lista_escaparates)) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
                foreach ($lista_escaparates as $clave => $valor) {
                    $opciones = new OpcionesWidget(array(
                        'usuario' => $usuario,
                        'escaparate' => $valor,
                        'fichero_boton' => $fichero_boton,
                        'recursivo' => $recursivo
                    ));
                    new Widget($_WH->GW('lista_escaparates', 'boton_suscripcion_escaparate'), $opciones);
                }
                ?>
            </div>
            <?php
        }
    }
}

?>