<?php

//---------------------------------------------------------------------------------------------------------
// 12/Enero/2015
// Versión 1.0 Widget que muestra una lista con los menús creados en la web
//---------------------------------------------------------------------------------------------------------



function widget_lista_menus($nombre_funcion = 'lista_menus') {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'lista_menus';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function lista_menus($opciones = NULL, $segundoParametro = NULL, $tercerParametro = '') {
    include('comunes/globals.php');
    //Antes de seguir vamos a ver si hay que utilizar la llamada clásica:
    if (($opciones != NULL) && (!is_a($opciones, "OpcionesWidget"))) {
        
        lista_menus_OLD($posiciones, $segundoParametro, $tercerParametro);
    } else {
        //Aquí creamos el nuevo widget
        $ficheroOpcionMenu = 'opcionMenu';
        $ocultarCabecera = false;
        $extraParams = NULL;
        $separador = '|';
        $posicion = '';
        $visibilidad = NULL;
        if (is_a($opciones, 'OpcionesWidget')) {
            $ficheroOpcionMenu = ($opciones->configuracion->ficheroOpcionMenu != NULL) ? $opciones->configuracion->ficheroOpcionMenu : $ficheroOpcionMenu;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
            $extraParams = ($opciones->configuracion->extraParams != NULL) ? $opciones->configuracion->extraParams : $extraParams;
            $separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
            $posicion = ($opciones->configuracion->posicion != NULL) ? $opciones->configuracion->posicion : $posicion;
            $visibilidad = ($opciones->configuracion->visibilidad != NULL) ? $opciones->configuracion->visibilidad : $visibilidad;
        }
        //Si hay fichero perso, lo usamos:
        $rutaPerso = Theme::findFile($ficheroOpcionMenu . '.php');
        if ($rutaPerso != NULL) {
            //Vamos a cargar el idioma
            $idioma = Sesion::get('idioma');
            $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
            $condicion_posicion = '';
            if (($posicion == 'cabecera') || ($posicion == 'pie') || ($posicion == 'izquierda') || ($posicion == 'derecha')) {
                $condicion_posicion = " AND $posicion = 1 ";
            }
            $cadena_menus = '';
            $condicion_visibilidad = '';
            if ($visibilidad != NULL) {
                $condicion_visibilidad = " AND privada = $condicion_visibilidad ";
            }
            $sentencia_sql = "SELECT menuweb.codigo codigo, parametros, enlace, destino, estilo_seleccionado, estilo_no_seleccionado, ocultar_en_buscadores, nombre
				FROM menuweb, traducmenu
				WHERE oculta = 0 $condicion_posicion $condicion_visibilidad AND menuweb.codigo = traducmenu.menu AND traducmenu.idioma = '$idioma'
				ORDER BY orden ASC";
            //echo($sentencia_sql);
            if (($conexionBD) && ($idioma != NULL)) {
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    $indiceElemento = 0;
                    while ($fila = mysqli_fetch_array($resultado)) {
                        if ($ocultarCabecera ) {
                        ?>
                            <div class="<?= (__FUNCTION__); ?>">
                        <?php
                        }
                        $nombre = $fila['nombre'];
                        //Mostramos la opción de menú
                        //Dedicimos la clase que tendrá la opción
                        $clase_menu = '';
                        if ($fila['codigo'] == $menu_actual) {
                            $clase_menu = $fila['estilo_seleccionado'];
                        } else {
                            $clase_menu = $fila['estilo_no_seleccionado'];
                        }
                        if ($clase_menu == '') {
                            $clase_menu = 'op_menu_' . $fila['codigo'];
                        }
                        //Si la clase no empieza por 'class' entonces se lo ponemos
                        if (substr($clase_menu, 0, 5) != 'class') {
                            $clase_menu = 'class="' . $clase_menu . '"';
                        }
                        //Decidimos cual será el enlace
                        $enlace_menu = '';
                        if ($fila['enlace'] != '') {
                            $enlace_menu = $fila['enlace'];
                        }
                        if ($enlace_menu == '') {
                            //Generamos el enlace desde la opción generica:
                            $enlace_menu = corregir_url(Shop::$configuracion->url . $fila['nombre'] . '/opcion');
                        }
                        //Por último, si la url no empieza por http:// le ponemos la url de la empresa delante
                        if (substr($enlace_menu, 0, 7) != 'http://') {
                            $enlace_menu = Shop::$configuracion->url . $enlace_menu;
                        }
                        //Le añadimos los parámetros
                        if ($fila['parametros'] != '') {
                            $enlace_menu .= '&' . $fila['parametros'];
                        }
                        //Aquí viene la carga de parámetros
                        if ( ($indiceElemento > 0) && ($separador != '')){
                            echo($separador);
                        }
                        include($rutaPerso);
                        $indiceElemento++;
                        if ($ocultarCabecera != '') {
                        ?>
                            </div>
                        <?php
                        }
                    }
                }
                ?>

                </div>
                <?php
            }
            return(true);
        }
    }
}

function lista_menus_OLD($posicion = '', $visibilidad = NULL, $separador = '') {
    include('comunes/globals.php');
//Vamos a cargar el idioma
    $idioma = Sesion::get('idioma');
    $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
    $condicion_posicion = '';
    if (($posicion == 'cabecera') || ($posicion == 'pie') || ($posicion == 'izquierda') || ($posicion == 'derecha')) {
        $condicion_posicion = " AND $posicion = 1 ";
    }
    $cadena_menus = '';
    $condicion_visibilidad = '';
    if ($visibilidad != NULL) {
        $condicion_visibilidad = " AND privada = $condicion_visibilidad ";
    }
    $sentencia_sql = "SELECT menuweb.codigo codigo, parametros, enlace, destino, estilo_seleccionado, estilo_no_seleccionado, ocultar_en_buscadores, nombre
				FROM menuweb, traducmenu
				WHERE oculta = 0 $condicion_posicion $condicion_visibilidad AND menuweb.codigo = traducmenu.menu AND traducmenu.idioma = '$idioma'
				ORDER BY orden ASC";
//echo($sentencia_sql);
    if (($conexionBD) && ($idioma != NULL)) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                //Mostramos la opción de menú
                //Dedicimos la clase que tendrá la opción
                $clase_menu = '';
                if ($fila['codigo'] == $menu_actual) {
                    $clase_menu = $fila['estilo_seleccionado'];
                } else {
                    $clase_menu = $fila['estilo_no_seleccionado'];
                }
                if ($clase_menu == '') {
                    $clase_menu = 'op_menu_' . $fila['codigo'];
                }
                //Si la clase no empieza por 'class' entonces se lo ponemos
                if (substr($clase_menu, 0, 5) != 'class') {
                    $clase_menu = 'class="' . $clase_menu . '"';
                }
                //Decidimos cual será el enlace
                $enlace_menu = '';
                if ($fila['enlace'] != '') {
                    $enlace_menu = $fila['enlace'];
                }
                if ($enlace_menu == '') {
                    //Generamos el enlace desde la opción generica:
                    $enlace_menu = corregir_url(Shop::$configuracion->url . $fila['nombre'] . '/opcion');
                }
                //Por último, si la url no empieza por http:// le ponemos la url de la empresa delante
                if (substr($enlace_menu, 0, 7) != 'http://') {
                    $enlace_menu = Shop::$configuracion->url . $enlace_menu;
                }
                //Le añadimos los parámetros
                if ($fila['parametros'] != '') {
                    $enlace_menu .= '&' . $fila['parametros'];
                }
                $cadena_menus .= (($cadena_menus != '') ? ' ' . $separador . ' ' : '');
                //Ahora que lo tenemos todo, vamos a mostrar el enlace
                if ($fila['ocultar_en_buscadores']) {
                    $cadena_menus .= '<!--googleoff: index-->';
                }
                $cadena_menus .= '<a href="' . $enlace_menu . '" ' . $clase_menu . ' target="' . $fila["destino"] . '">' . $fila["nombre"] . '</a>';
                if ($fila["ocultar_en_buscadores"]) {
                    $cadena_menus .= "<!--googleon: index-->";
                }
            }
        }
    }
    if ($cadena_menus != "") {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?= $cadena_menus; ?>
        </div>
        <?php
    }
    return(true);
}
?>