<?php

//---------------------------------------------------------------------------------------------------------
// 13/Febrero/2015
// Versión 1.0 Con este widget gesionamos la información referente a un pedido ya hecho
//---------------------------------------------------------------------------------------------------------



function widget_pedidos_cliente() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'pedido_completado';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function pedido_completado($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    ?>
    <?php
    if ($ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>

        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    return(true);
}

function lineas_pedido_cliente($objeto_pedido = NULL, $fichero = 'linea_pedido', $tipo_capa_lote = 'div') {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if (($objeto_pedido != NULL) && (is_a($objeto_pedido, "OpcionesWidget"))) {
        $opciones = $objeto_pedido;
        $objeto_pedido = NULL;
        $fichero = 'linea_pedido';
        $tipo_capa_lote = 'div';
        if (is_a($opciones, 'OpcionesWidget')) {
            $objeto_pedido = ($opciones->configuracion->objeto_pedido != NULL) ? $opciones->configuracion->objeto_pedido : $objeto_pedido;
            $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
            $tipo_capa_lote = ($opciones->configuracion->tipo_capa_lote != NULL) ? $opciones->configuracion->tipo_capa_lote : $tipo_capa_lote;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $retorno = 0;
    if (is_a($objeto_pedido, 'PedidoCliente')) {
        $ruta_fichero = Theme::findFile($fichero . '.php');
        if ($ruta_fichero != NULL) {
            ?>
            <?php
            if ($ocultarCabecera) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                /* 				foreach($objeto_pedido->lineas as $clave => $valor){
                  new Widget($_WH->GW("pedidos_cliente", "linea_pedido_cliente"), $valor, $fichero);
                  }
                 */
                //Vamos a obtener primero los elementos sin lote
                foreach (array_filter($objeto_pedido->lineas, 'pedidos_sin_lote') as $clave => $valor) {
                    new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $valor, $fichero);
                }

                //Ahora toca sacar sólo los lotes respetando el oden de entrada
                $ultimo_lote = 0;
                foreach (array_filter($objeto_pedido->lineas, 'pedidos_con_lote') as $clave => $valor) {
                    //antes de mostrar el artículo, vamos a mostrar una línea indicando que es otro lote
                    if ($ultimo_lote != $valor->lote->codigo) {
                        $ultimo_lote = $valor->lote->codigo;
                        genera_cab_lote_pedido($valor->lote, $valor->dto_lote, $tipo_capa_lote);
                    }
                    new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $valor, $fichero);
                }
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
        }
    }
    return($retorno);
}

function linea_pedido_cliente($objeto_linea = NULL, $fichero = 'lineas_pedido') {
    include('comunes/globals.php');
    //Esta función no inserta ninguna capa, es responsabilidad del diseñador incluirla		
    if (is_a($objeto_linea, 'LineaPedidoCliente')) {
        if ($objeto_linea->codigo > 0) {
            $retorno = 0;
            $ruta_fichero = Theme::findFile($fichero . '.php');

            if ($ruta_fichero != NULL) {
                if (is_a($objeto_linea, 'LineaPedidoCliente')) {
                    $ml_pedcli = $objeto_linea;
                    $dato = ($ml_pedcli->codigo_articulo != '') ? $ml_pedcli->codigo_articulo : $ml_pedcli->ean;
                    ?>
                    <div class="linea_pedido<?= ($ml_pedcli->lote->codigo > 0) ? ' linea_cesta_lote' : ''; ?>" data-fichero="<?= $fichero; ?>">
                        <div class="contenedor_pedido_<?= $dato ?>_<?= $ml_pedcli->lote->codigo; ?>">
                            <?php
                            include($ruta_fichero);
                            ?>
                        </div>
                    </div>
                    <?php
                }
            }
        }
    }
}

function finalizar_compra($codigo_pedido_cliente = 0, $fichero_pedido = 'detalle_pedido', $pagado = NULL, $finalizado = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
	$numero_pedido = 0;
    if (($codigo_pedido_cliente != NULL) && (is_a($codigo_pedido_cliente, "OpcionesWidget"))) {
        $opciones = $codigo_pedido_cliente;
        $codigo_pedido_cliente = NULL;
        $fichero_pedido = 'detalle_pedido';
		$numero_pedido = 0;
        if (is_a($opciones, 'OpcionesWidget')) {
            $codigo_pedido_cliente = ($opciones->configuracion->codigo_pedido_cliente != NULL) ? $opciones->configuracion->codigo_pedido_cliente : $codigo_pedido_cliente;
            $fichero_pedido = ($opciones->configuracion->fichero_pedido != NULL) ? $opciones->configuracion->fichero_pedido : $fichero_pedido;
            $pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
			$finalizado = ($opciones->configuracion->finalizado != NULL) ? $opciones->configuracion->finalizado : $finalizado;
			$numero_pedido = ($opciones->configuracion->numero_pedido != NULL) ? $opciones->configuracion->numero_pedido : $numero_pedido;
        }
    }

	if ( ($codigo_pedido_cliente > 0) || ($numero_pedido > 0) ){
		$opciones = new OpcionesWidget(array(
				'codigo_pedido_cliente' => $codigo_pedido_cliente,
				'pagado' => $pagado,
				'con_detalle' => false,
				'finalizado' => $finalizado,
				'numero_pedido' => $numero_pedido
		));
		$mc_pedcli = new PedidoCliente($opciones);
		/*echo("<pre>");
		var_dump($mc_pedcli);
		echo("</pre>");*/
		?>
		<?php
		if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
		<?php
		}

		if ($mc_pedcli->codigo > 0) {

			//$ruta_fichero = "perso/widgets/" . $fichero_pedido . ".php";
			$ruta_fichero = Theme::findFile($fichero_pedido . '.php');
			/* if (!existe_fichero($ruta_fichero)){
			  $ruta_fichero = "base/widgets/" . $fichero_pedido . ".php";
			  }
			 */
			if ($ruta_fichero != NULL) {
				include($ruta_fichero);
			}
		} else {
			?>
			<p class="error_finalizar_pedido"><?= traducir('Ha ocurrido un error al finalizar su pedido. Inténtelo de nuevo y, si el problema persiste, póngase en contacto con nosotros'); ?></p>
			<?php
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
		}
	}
    ?>
    <?php
}

function pedido_cliente($codigo_usuario = 0, $fichero = 'pedidos_cliente', $pagado = 1, $filtro_fecha = '', $orden = 'codigo/DESC') {
    include('comunes/globals.php');
    $filtro_fecha = trim($filtro_fecha);
    $orden = trim($orden); //Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
    $array_orden = explode('/', $orden);

    $ocultarCabecera = false;
    if (($codigo_usuario != NULL) && (is_a($codigo_usuario, "OpcionesWidget"))) {
        $opciones = $codigo_usuario;
        $codigo_usuario = 0;
        $fichero = 'pedidos_cliente';
        $pagado = 1;
        $filtro_fecha = '';
        $orden = 'codigo/DESC';
        if (is_a($opciones, 'OpcionesWidget')) {
            $codigo_usuario = ($opciones->configuracion->codigo_usuario != NULL) ? $opciones->configuracion->codigo_usuario : $codigo_usuario;
            $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
            $pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
            $filtro_fecha = ($opciones->configuracion->filtro_fecha != NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
            $orden = ($opciones->configuracion->orden != NULL) ? $opciones->configuracion->orden : $orden;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }

    if ($filtro_fecha != '') {
        $array_fechas = explode(" ", $filtro_fecha);
        $sentencia_sql = "SELECT codigo FROM mc_pedcli WHERE cliente = '$codigo_usuario' AND pagado = $pagado AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ORDER BY $array_orden[0] $array_orden[1]";
    } else {
        $sentencia_sql = "SELECT codigo FROM mc_pedcli WHERE cliente = '$codigo_usuario' AND pagado = $pagado ORDER BY $array_orden[0] $array_orden[1]";
    }
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            //Comprobamos si tenemos pedidos
            if (mysqli_num_rows($resultado) === 0) {
                ?>
                <p class="error_no_hay_pedidos"><?= traducir('Aún no ha realizado ningún pedido'); ?></p>
                <?php
            } else {
                while ($fila = mysqli_fetch_array($resultado)) {
                    //Mostramos los pedidos
                    $mc_pedcli = new PedidoCliente($fila['codigo'], $pagado);
                    ?>
                    <?php
                    if (!$ocultarCabecera) {
                        ?>
                        <div class="<?= (__FUNCTION__); ?>">
                            <?php
                        }
                        ?>
                        <div class="cabecera_pedido">
                            <div class="numero_pedido_cliente"><?= traducir('Número de pedido:'); ?><span><?= $mc_pedcli->codigo; ?></span></div>
                            <div class="fecha_pedido_cliente"><?= traducir('Fecha de pedido:'); ?><span>
                                    <?php
                                    //Damos formato a la fecha
                                    $date = date_create($mc_pedcli->fecha);
                                    echo date_format($date, 'j/');
                                    echo traducir(date_format($date, 'F'));
                                    echo date_format($date, '/Y');
                                    ?>
                                </span></div>
                            <div class="nombre_envio_pedido_cliente"><?= traducir('Enviar a:'); ?><span><?= $mc_pedcli->nombre_legal; ?></span></div>
                            <?php
                            $widget_datos_envio = new Widget();
                            $widget_datos_envio->cambia_tipo('dropDown');
                            $widget_datos_envio->record();
                            ?>
                            <div class="datos_envio">
                                <span class="datos_envio_direccion">
                                    <span class="dato"><?= traducir('Dirección:'); ?></span>
                                    <span><?= $mc_pedcli->direccion; ?></span>
                                </span>
                                <span class="datos_envio_codigo_postal">
                                    <span class="dato"><?= traducir('Código postal:'); ?></span>
                                    <span><?= $mc_pedcli->cod_postal; ?></span>
                                </span>
                                <span class="datos_envio_localidad">
                                    <span class="dato"><?= traducir('Localidad:'); ?></span>
                                    <span><?= $mc_pedcli->localidad; ?></span>
                                </span>
                                <span class="datos_envio_provincia">
                                    <span class="dato"><?= traducir('Provincia:'); ?></span>
                                    <span><?= $mc_pedcli->provincia; ?></span>
                                </span>
                                <span class="datos_envio_telefono">
                                    <span class="dato"><?= traducir('Teléfono:'); ?></span>
                                    <span><?= $mc_pedcli->telefono; ?></span>
                                </span>
                            </div>
                            <span class="datos_envio_tipo_envio">
                                <span class="dato"><?= traducir('Tipo de envío:'); ?></span>
                                <span><?= $mc_pedcli->tipo_envio->nombre; ?></span>
                            </span>
                            <?php
                            if ($mc_pedcli->forma_pago->nombre != '') {
                                ?>
                                <span class="datos_envio_forma_pago">
                                    <span class="dato"><?= traducir('Forma de pago:'); ?></span>
                                    <span><?= $mc_pedcli->forma_pago->nombre; ?></span>
                                </span>
                                <?php
                            }
                            $widget_datos_envio->record();
                            new Widget(LW_params(), $widget_datos_envio, traducir('Más información'), 'a', 'onclick', 'lanzador_widget');
                            ?>
                            <a href="javascript:void(0);" class="mostrar">Desplegar</a>
                            <script type="text/javascript">
							document.addEventListener('WSLE', function(event) {
                                //Ocultamos las líneas de pedido y mostramos al pulsar el enlace desplegar
                                ;(function () {
                                    var elementObjetive = getLastHtmlObject();
                                    elementObjetive.on("click", function (event) {
                                        var clase = $(this).attr('class');
                                        if (clase == "mostrar") {
                                            $('#contenedor_pedido_<?= $mc_pedcli->codigo; ?>').show('slow');
                                            $(this).attr('class', 'ocultar');
                                            $(this).parent('div').parent('div').attr('class', 'mostrar_pedido_cliente');
                                        } else if (clase == "ocultar") {
                                            $('#contenedor_pedido_<?= $mc_pedcli->codigo; ?>').hide('slow');
                                            $(this).attr('class', 'mostrar');
                                            $(this).parent('div').parent('div').attr('class', 'pedido_cliente');
                                        }
                                    });
                                }());
							});
                            </script>
                        </div>
                        <div class="contenedor_pedido" id="contenedor_pedido_<?= $mc_pedcli->codigo; ?>">
                            <div class="cabecera_lineas_pedido">
                                <div class="cabecera_pedido_campo_nombre"><?= traducir("Artículo"); ?></div>
                                <div class="cabecera_pedido_pvp"><?= traducir("Precio"); ?></div>
                                <div class="cabecera_pedido_cantidad"><?= traducir("Unidades"); ?></div>
                                <div class="cabecera_pedido_importe"><?= traducir("Totales"); ?></div>
                            </div>
                            <?php
                            $ruta_fichero = Theme::findFile($fichero . '.php');
                            if ($ruta_fichero != NULL) {
                                //include($ruta_fichero);
                                new Widget($_WH->GW('pedidos_cliente', 'lineas_pedido_cliente'), $mc_pedcli, $fichero);
                            }
                            ?>
                            <div class="pie_lineas_pedido">
                                <div class="pie_pedido_descuento"><?= traducir('Descuento'); ?> <span class="porcentaje"><span><?= $mc_pedcli->descuento; ?></span> % </span><span class="importe_dto"><?= number_format((number_format($mc_pedcli->total_pvp_con_dto, 2) - $mc_pedcli->importe_total), 2, ',', '.'); ?>&euro;</span></div>
                                <div class="pie_pedido_gastos_envio"><?= traducir('Gastos de envío'); ?><span><?= number_format($mc_pedcli->g_envio, 2, ',', '.'); ?>&euro;</span></div>
                            </div>
                        </div>
                        <div class="pie_pedido">
                            <?php
                            $producto = "";
                            if ($mc_pedcli->cantidad_total == 1) {
                                $producto = traducir('producto');
                            } else {
                                $producto = traducir('productos');
                            }
                            ?>
                            <div class="pie_pedido_total_productos"><?= $mc_pedcli->cantidad_total . ' ' . $producto; ?></span></div>
                            <div class="pie_pedido_total"><?= traducir('Total'); ?><span><?= number_format(($mc_pedcli->importe_total + $mc_pedcli->g_envio), 2, ',', '.'); ?>&euro;</span></div>
                        </div>
                        <?php
                        if (!$ocultarCabecera) {
                            ?>
                        </div>
                        <?php
                    }
                    ?>
                    <?php
                }
            }
        }
    }
}

//---------------------------------------------------------------------------------------------------------
// FUNCIONES V2
//---------------------------------------------------------------------------------------------------------
function pedidos_clienteV2($opciones = NULL) {
    include('comunes/globals.php');
	/*
	//Pedro 21/Febrero/2018 ==> Por ahora nada de esto va a ser necesario:
    //Como siempre en V2, procesamos las opciones
    $codigo_usuario = 0;
    $fichero = 'detalle_hco_pedidos';
    $fichero_linea = 'linea_hco_pedido';

    $pagado = 1;
    //Vamos a coger el filtro de las fechas
    $filtro_fecha = '';
    $fecha_inicio = Sesion::get('fecha_inicio_hco_pedidos');
    $fecha_fin = Sesion::get('fecha_fin_hco_pedidos');
    if (($fecha_inicio !== NULL) && ($fecha_fin !== NULL)) {
        $filtro_fecha = "$fecha_inicio $fecha_fin";
    }

    $orden = Sesion::get('orden_hco_pedidos');
    if ($orden == NULL) {
        $orden = 'codigo';
    }
    $tipo_orden = Sesion::get('tipo_orden_hco_pedidos');
    if ($tipo_orden == NULL) {
        $tipo_orden = 'DESC';
    }

    $cliente = Usuario::logueado();
	*/
	//Cargamos los parámetros de la función
	$codigo_usuario = 0;
    $fichero = 'detalle_hco_pedidos';
    $fichero_linea = 'linea_hco_pedido';
    $pagado = 1;
	$listaPedidos = NULL;
    if (is_a($opciones, 'OpcionesWidget')) {
        $codigo_usuario = ($opciones->configuracion->codigo_usuario != NULL) ? $opciones->configuracion->codigo_usuario : $codigo_usuario;
        $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
        $fichero_linea = ($opciones->configuracion->fichero_linea != NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;

        $pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
        $filtro_fecha = ($opciones->configuracion->filtro_fecha != NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
        $orden = ($opciones->configuracion->orden != NULL) ? $opciones->configuracion->orden : $orden;
        $cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : $cliente;
        if (is_numeric($cliente)) {
            $cliente = new usuario($cliente);
        }
		$listaPedidos = ($opciones->configuracion->listaPedidos != NULL) ? $opciones->configuracion->listaPedidos : $listaPedidos;
    } else {
        $opciones = new OpcionesWidget();
    }
	$elementos_x_pagina = 5;	//En el futuro esto hay que hacerlo por programación
	$pagina = Sections::getParam('pagina', 0);
	$total_elementos = PedidoCliente::getCount(NULL, NULL, true);
	$listaPedidos = ($listaPedidos == NULL) ? PedidoCliente::getPedidosCliente(NULL, NULL, true, NULL, ' LIMIT ' . ($elementos_x_pagina * $pagina) . ', ' . $elementos_x_pagina . ' ') : $listaPedidos;
	//Vamos a mostrarlos:
	if (count($listaPedidos) == 0) {
		?>
		<p class="error_no_hay_pedidos"><?= traducir('Aún no ha realizado ningún pedido'); ?></p>
		<?php
	} else {
		foreach ($listaPedidos as $clave => $valor) {
			//Mostramos los pedidos
			$pedido_cliente = $valor;
			//Vamos a cargar a mano el detalle del pedido:
			//$pedido_cliente->cargarDetalle();
			$opciones->addProperty('pedido_cliente', $pedido_cliente);
			new Widget($_WH->GW('pedidos_cliente', 'pedido_clienteV2'), $opciones);
		}
		//Paginacion:
		//Falta por añadir la paginación
		$enlace = Shop::$configuracion->url . 'historico_pedidos';
		new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, $elementos_x_pagina);
	}
}

function pedido_clienteV2($opciones =NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    //Como siempre en V2, procesamos las opciones
    $fichero = 'detalle_hco_pedidos';
    $fichero_linea = 'linea_hco_pedido';
    $pedido_cliente = NULL;
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
        $fichero_linea = ($opciones->configuracion->fichero_linea != NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
        $pedido_cliente = $opciones->configuracion->pedido_cliente;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        if ($pedido_cliente != NULL) {
            //Si es un objeto pedido_cliente guay, si no miramos si es un número
            if (is_numeric($pedido_cliente)) {
                $pedido_cliente = new PedidoCliente($pedido_cliente);
                $pedido_cliente = ($pedido_cliente->codigo == 0) ? NULL : $pedido_cliente;
            }
        }
    }
    if ($pedido_cliente != NULL) {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <?php
            $fichero = Theme::findFile($fichero . '.php');
            if ($fichero !== NULL) {
                include($fichero);
            }
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
}

function datos_envio_cliente($opciones = NULL) {
    include('comunes/globals.php');

    $ocultarCabecera = false;
    if (is_a($opciones, 'OpcionesWidget')) {
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    //Como siempre en V2, procesamos las opciones
    $pedido_cliente = NULL;
    $fichero_datos = 'datos_envio_cliente';
    //Si no hemos recibido pedido, de aquí no pasamos
    if (is_a($opciones, 'OpcionesWidget')) {
        $pedido_cliente = $opciones->configuracion->pedido_cliente;
        if ($pedido_cliente != NULL) {
            //Si es un objeto pedido_cliente guay, si no miramos si es un número
            if (is_numeric($pedido_cliente)) {
                $pedido_cliente = new PedidoCliente($pedido_cliente);
                $pedido_cliente = ($pedido_cliente->codigo == 0) ? NULL : $pedido_cliente;
            }
        }
        $fichero_datos = ($opciones->configuracion->fichero_datos != NULL) ? $opciones->configuracion->fichero_datos : $fichero_datos;
    }
    //Tenemos todas las opciones procesadas, si hay pedido de cliente, vamos a mostrar el detalle:
    if ($pedido_cliente != NULL) {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <?php
            $fichero_datos = Theme::findFile($fichero_datos . '.php');
            if ($fichero_datos !== NULL) {
                include($fichero_datos);
            }
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
}

function lineas_pedido_clienteV2($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    $fichero_linea = 'linea_hco_pedido';
    $tipo_capa_lote = 'div';
    $pedido_cliente = NULL;

    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_linea = ($opciones->configuracion->fichero_linea != NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
        $pedido_cliente = ($opciones->configuracion->pedido_cliente != NULL) ? $opciones->configuracion->pedido_cliente : $pedido_cliente;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		$fichero_cabecera_lote = ($opciones->configuracion->fichero_cabecera_lote != NULL) ? $opciones->configuracion->fichero_cabecera_lote : 'cab_lote_pedido_linea.php';
		$fichero_pie_lote = ($opciones->configuracion->fichero_pie_lote != NULL) ? $opciones->configuracion->fichero_pie_lote : 'pie_lote_pedido_linea.php';
		$tipo_capa = ($opciones->configuracion->tipo_capa != NULL) ? $opciones->configuracion->tipo_capa : 'div';

        if ($pedido_cliente != NULL) {
            //Si es un objeto pedido_cliente guay, si no miramos si es un número
            if (is_numeric($pedido_cliente)) {
                $pedido_cliente = new PedidoCliente($pedido_cliente);
                $pedido_cliente = ($pedido_cliente->codigo == 0) ? NULL : $pedido_cliente;
            }
        }
    }
    $retorno = 0;
    if (is_a($pedido_cliente, 'PedidoCliente')) {
        $ruta_fichero = Theme::findFile($fichero_linea . '.php');
        if ($ruta_fichero != NULL) {
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
                <<?=$tipo_capa;?> class="<?= (__FUNCTION__); ?>">
                    <?php
                }
                ?>
                <?php
                //Vamos a obtener primero los elementos sin lote
                foreach (array_filter($pedido_cliente->lineas, 'PedidoCliente::sin_lotes') as $clave => $valor) {
                    new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $valor, $fichero_linea);
                }

                //Ahora toca sacar sólo los lotes respetando el oden de entrada
                $ultimo_lote = 0;
				$ultimo_objeto_lote = NULL;
                foreach (array_filter($pedido_cliente->lineas, 'PedidoCliente::con_lotes') as $clave => $valor) {
                    //antes de mostrar el artículo, vamos a mostrar una línea indicando que es otro lote
                    /*if ($ultimo_lote != $valor->lote->codigo) {
                        $ultimo_lote = $valor->lote->codigo;
                        genera_cab_lote_pedido($valor->lote, $valor->dto_lote, $tipo_capa_lote);
                    }
					
					//lo cambio a la forma nueva
					*/
					if ($ultimo_lote != $valor->lote->codigo) {
                        //Si el último lote es > 0, hay que mostrar el pie:
						
						if ($ultimo_lote > 0){
							Theme::include_file($fichero_pie_lote, $ultimo_objeto_lote);
						}
						//Si el lote actual es > 0, mostraoms la cabecera:
						if ($valor->lote->codigo > 0){
							//echo "<br>".$valor->lote->codigo."<br>";
							Theme::include_file($fichero_cabecera_lote, $valor->lote);
						}
                        
						$ultimo_lote = $valor->lote->codigo;
						$ultimo_objeto_lote = $valor->lote;
					}
                    new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $valor, $fichero_linea);
				}
					if ($ultimo_lote > 0){
						Theme::include_file($fichero_pie_lote, $valor->lote);
					}
                
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                </<?=$tipo_capa;?>>
                <?php
            }
            ?>
            <?php
            $nombre_script = 'script_' . incrementa_contador();
            ?>
            <script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
                //Ocultamos las líneas de pedido y mostramos al pulsar el enlace desplegar
                ;(function () {
                    //Tenemos que buscar el "pedidos_clienteV2"
                    var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>').closest(".pedido_clienteV2");
                    if (elementObjetive.length > 0) {
                        //var lineas_pedido = elementObjetive.find('.<?= (__FUNCTION__); ?>');
                        elementObjetive = elementObjetive.find("a.mostrar");
                        if (elementObjetive.length > 0) {
                            elementObjetive.on("click", function (event) {
                                var clase = $(this).attr('class');
                                if (clase == "mostrar") {
                                    $('#contenedor_pedido_<?= $pedido_cliente->codigo; ?>').show('slow');
                                    $(this).attr('class', 'ocultar');
                                } else if (clase == "ocultar") {
                                    $('#contenedor_pedido_<?= $pedido_cliente->codigo; ?>').hide('slow');
                                    $(this).attr('class', 'mostrar');
                                }
                            });
                        }
                    }
                }());
			});
            </script>
            <?php
        }
    }
    return($retorno);
}

//------------------------------------------------------------------------------------------------------------------------------
//Funciones que necesitan los pedidos de cliente
//------------------------------------------------------------------------------------------------------------------------------
/*
function pedidos_sin_lote($valor) {
    if ($valor->lote->codigo == 0) {
        return(true);
    }
}

function pedidos_con_lote($valor) {
    if ($valor->lote->codigo != 0) {
        return(true);
    }
}
*/
function genera_cab_lote_pedido($cod_lote, $dto, $tipo_capa = 'div') {
    include('comunes/globals.php');
    $limpiar_lote_al_finalizar = false;
    if (is_a($cod_lote, 'Lote')) {
        $lote_aux = $cod_lote;
    } else {
        $lote_aux = new Lote($cod_lote);
        $limpiar_lote_al_finalizar = true;
    }
    ?>
    <<?= $tipo_capa; ?> class="lote_cesta cab_lote_cesta_<?= $lote_aux->codigo; ?>">
    <?= traducir('Lote:'); ?><?= $lote_aux->nombre; ?>
    <?php
    if ($dto > 0) {
        ?>
        <span><?= traducir('Descuento del'); ?> <strong><?= number_format($dto, 2); ?></strong><span>%</span></span>
        <?php
    }
    ?>
    </<?= $tipo_capa; ?>>
    <?php
    if ($limpiar_lote_al_finalizar) {
        unset($lote_aux);
    }
}

include_once('pedidos_cliente_extra.php');
?>