<?php
/*
	Clase Idioma
	@version 1.0
*/

//30/Septiembre/2019 ==> Añadimos la carga como objeto de WebStore
class SuperIdioma extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	//campos de la tabla y otros:
	public $codigo = '';
	public $nombre = '';
	public $iso3 = '';
	public $prefijo = 0;
	public $disponible = false;
	public $disponibllocale = '';
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$disponible = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;

		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`codigo` = \'' . $id . '\' ';
		}
		if ($disponible !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`disponible` = 1 ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
	
    function __construct($params){
		//Vamos a decodificar los parámetros:
		//Por defecto nos van a mandar la cadena de texto:
		$frase = '';
		if (is_string($params)){
			$frase = $params;
		}
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaIdioma = $params->getDefaultValue('filaIdioma', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$ID = $params->getDefaultValue('ID', Sesion::get('idioma', Shop::$configuracion->idioma));	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$activo = $params->getDefaultValue('activo', NULL);	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$fila = NULL;

		if ($filaIdioma == NULL){
			if ($ID != '') {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($ID, $activo);
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaIdioma;
		}
		if($fila != null){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->iso3 = $this->getProp($fila, 'iso3');
		$this->prefijo = $this->getProp($fila, 'prefijo');
		$this->disponible = $this->boolData($this->getProp($fila, 'disponible'));
		$this->locale = $this->getProp($fila, 'locale');
	}
	
    function __destruct(){
        
    }
	
	
	//Vamos a coger el idioma actual, La sesión manda, si no está seteada cogemos el de configuración.
		//En caso de estar seteada y ser igual que la de configuración, entonces borramos el idioma de la sesión.
		//Si no hay multi-idioma, no hacemos nada
	public static function getCurrentLanguajeCode(){
		//Cogemos el código de idioma de configuración:
		$idioma = Shop::$configuracion->idioma;
		 //Si tenemos el móculo de "multi-idioma" activo seguimos cargando el de la sesión:
		if (Module::is_active('multi-idioma')){
			$idioma_sesion = Sesion::get('idioma', '');
			if ($idioma_sesion = $idioma){
				//Si el idioma de la sesión es el mismo que el de configuración, vamos a eliminarlo de la sesión para liberar espacio
				Sesion::remove('idioma');
			}
		}
		if ($idioma == ''){
			$idioma = NULL;
		}
		return($idioma);
	}
	public static function getCurrentLanguaje(){
		$idioma = static::getCurrentLanguajeCode();
		if ($idioma != ''){
			$idioma = new Idioma(array('ID' => $idioma, 'activo' => 1));
		}else{
			$idioma = NULL;
		}
		return($idioma);
	}
	
	//Asignamos un nuevo idioma a la web y devolvemos el objeto idioma que esté activo
	public static function setCurrentLanguaje($new_idioma){
		$objetoIdioma = NULL;
		if (Module::is_active('multi-idioma')){
			//Cogemos el código de idioma de configuración:
			$idioma = Shop::$configuracion->idioma;
			if ( ($new_idioma != $idioma) && (Module::is_active('multi-idioma')) ){
				//Si el idioma de configuración es distinto al actual, vamos a asignarlo (si está activo) y si tenemos el módulo de multi-idioma:
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($new_idioma, 1);	//Vamos a ver si el idioma está activo:
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					if ($fila = $bd->getFila()){
						Sesion::set('idioma', $new_idioma);
						$objetoIdioma = new Idioma(array('filaIdioma' => $fila));
					}
				}		
				
			}
		}
		//Sólo devolvemos el objeto idioma si se ha podido cambiar el mismo:
		return($objetoIdioma);
	}
	
	public static function getActiveLanguajes(){
		$avaiables = array();
		$avaiables = static::loadList(array('disponible' => '1', 'limit' => ' '));
		return($avaiables);
	}
}
?>