<?php
/*
  Clase SuperLineaPedidoCliente
 */

class SuperLineaPedidoCliente extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();


    public $mc_pedcli = 0;
    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $articulo = NULL;
    public $codigo_articulo = 0;
    public $ean = '';
    public $cantidad = 0;
    public $recibida = 0;
    public $retirada = 0;
    public $pendiente = 0;
	public $apartada = 0;
    public $pvp = 0;
	public $iva = 0;
    public $descuento = 0;
    public $importe = 0;
    public $importe_pendiente = 0;
    public $importe_reservado = 0;
    public $importe_retirado = 0;
    public $pvp_con_dto = 0;
    public $importe_con_dto = 0;
    public $importe_con_dto_pendiente = 0;
    public $importe_con_dto_reservado = 0;
    public $importe_con_dto_retirado = 0;
	public $base = 0;	//Precio sin iva del pedido con todos los descuentos ya aplicados
    public $cod_lote = 0;
    public $lote = NULL;
    public $dto_lote = 0;
    public $tipo = '';
    public $objeto_pedido = NULL;
    public $pedido_eliminado = 0;


	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' )
				. Articulo::getCampos() . ', ' 
				. BaseDatos::dameCamposAlias('mc_lotes');
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('LineaPedidoCliente', 'articulo', 'Articulo', 'codigo'); //Queremos esta tabla con la de artículo
			$consulta .= Articulo::getNombreTabla(false);								//Cogemos los left join de artículo
			$consulta .= static::getJoin('LineaPedidoCliente', 'lote', 'mc_lotes', 'codigo');
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigoPedido = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$codigoLinea = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		$coma = '';
		if ($codigoPedido !== NULL) {
			static::$whereSelect = ' `' . static::getAlias() . '`.`mc_pedcli` = "' . $codigoPedido . '" ';
			$coma = ' AND  ';
		}
		if ($codigoLinea !== NULL) {
			static::$whereSelect .= $coma . ' `' . static::getAlias() . '`.`codigo` = "' . $codigoLinea . '" ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    function __construct($codigo_pedido_cliente, $codigo_linea = 0, $extraer_datos_cabecera = false, $extraer_datos_articulo = false) {
        //include('comunes/globals.php');
		//Por retro compatibilidad vamos a mantene rla llamada a la función, pero a partir de ahora vamos a intentar llamar a esta función con un objeto_pedidoç
		//de opciones
		$opciones = new OpcionesWidget();
		$objetoPedido = NULL;
		$filaLineaPedido = NULL;
		if ($codigo_pedido_cliente != NULL){
			if (is_a($codigo_pedido_cliente, 'OpcionesWidget')){
				$opciones = $codigo_pedido_cliente;
				$codigo_pedido_cliente = ($opciones->configuracion->codigo_pedido_cliente != NULL) ? $opciones->configuracion->codigo_pedido_cliente : $codigo_pedido_cliente;
				$codigo_linea = ($opciones->configuracion->codigo_linea != NULL) ? $opciones->configuracion->codigo_linea : $codigo_linea;
				$extraer_datos_cabecera = ($opciones->configuracion->extraer_datos_cabecera != NULL) ? $opciones->configuracion->extraer_datos_cabecera : $extraer_datos_cabecera;
				$filaLineaPedido = ($opciones->configuracion->filaLineaPedido != NULL) ? $opciones->configuracion->filaLineaPedido : $filaLineaPedido;
				$objetoPedido = ($opciones->configuracion->objetoPedido != NULL) ? $opciones->configuracion->objetoPedido : $objetoPedido;
			}
		}

		$fila = NULL;
		if ($filaLineaPedido != NULL){
			$fila = $filaLineaPedido;
		}else{
			if (is_a($objetoPedido, 'PedidoCliente')){
				$codigo_pedido_cliente = $objetoPedido->codigo;
			}
			if (intval($codigo_pedido_cliente) > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM ' . static::getNombreTabla() . '
							WHERE ' . static::getWhereTabla($codigo_pedido_cliente, $codigo_linea);

				//echo("$sentencia_sql <br />\n");

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}
		
		if ($fila != NULL) {
			$this->extractData($fila);
		}
	
		//Vamos a ver si nos han pasado un objeto pedido y lo cargamos
		if (is_a($objetoPedido, 'PedidoCliente') ){
			$this->objeto_pedido = $objetoPedido;
		}else if ($extraer_datos_cabecera) {
			$this->objeto_pedido = new PedidoCliente($this->mc_pedcli, NULL, false);
		}
    }

	public function extractData($fila){
		$this->mc_pedcli =  $this->getProp($fila, 'mc_pedcli');
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->codigo_sinlib = $this->getProp($fila, 'codigo_sinlib');
		$this->ean = $this->getProp($fila, 'ean');
		$this->codigo_articulo = $this->getProp($fila, 'articulo');
		$this->articulo = new Articulo(new OpcionesWidget(array('filaArticulo' => $fila)));
		$this->cantidad = $this->getProp($fila, 'cantidad');
		$this->recibida = $this->getProp($fila, 'recibida');
		$this->retirada = $this->getProp($fila, 'retirada');
		$this->apartada = $this->getProp($fila, 'apartada');
		$this->pendiente = $this->getProp($fila, 'pendiente');
		$this->pvp = $this->getProp($fila, 'pvp');
		$this->iva = $this->getProp($fila, 'iva');
		$this->importe = $this->getProp($fila, 'importe');
		$this->importe_pendiente = $this->pvp * $this->pendiente;
		$this->importe_reservado = $this->pvp * $this->recibida;
		$this->importe_retirado = $this->pvp * $this->retirada;
		$this->descuento = $this->getProp($fila, 'descuento');
		$this->pvp_con_dto = $this->getProp($fila, 'pvp_con_dto');
		$this->importe_con_dto = $this->getProp($fila, 'importe_con_dto');
		$this->base = $this->getProp($fila, 'base');
		$this->importe_con_dto_pendiente = $this->pvp_con_dto * $this->pendiente;
		$this->importe_con_dto_reservado = $this->pvp_con_dto * $this->recibida;
		$this->importe_con_dto_retirado = $this->pvp_con_dto * $this->retirada;
		$this->cod_lote = $this->getProp($fila, 'lote');
		$this->lote = new Lote($this->getProp($fila, 'lote')); // ==> Esto hay que arreglarlo para pasarle la fila de la consulta
		$this->dto_lote = $this->getProp($fila, 'dto_lote');
		$this->tipo = $this->getProp($fila, 'tipo');
		$this->pedido_eliminado = $this->getProp($fila, 'pedido_eliminado');
	}
	
    function __destruct() {
        unset($this->articulo);
    }

	function cargarArticulo(){
		$this->articulo = new Articulo($this->codigo_articulo, NULL, $this->cantidad, $this->cod_lote, true, true);
	}
	
	function setObjetoPedido($objeto_pedido){
		$this->objeto_pedido = $objeto_pedido;
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

	public static function associateEmptyLinesCode(){
		//Hasta nuevo aviso el campo pendiente_sinlib de lineas y cabecera se pone a 3. Necesitamos que se ponga a 1 para lo que acaba de entrar
		$sentencia_sql = 'UPDATE `mc_pedcli` `cabecera` SET `pendiente_sinlib` = 1 WHERE `cabecera`.`cod_sinlib` IN 
						(SELECT `mc_pedcli_sinlib` FROM `ml_pedcli` WHERE `mc_pedcli` = 0) ;';
		//Asociamos las líneas con las cabaceras:
		$sentencia_sql .= 'UPDATE `ml_pedcli` `lineas` SET `mc_pedcli` = 
							( SELECT `codigo` FROM `mc_pedcli` `cabecera` WHERE `cabecera`.`cod_sinlib` = `lineas`.`mc_pedcli_sinlib` LIMIT 1 )
						 WHERE `lineas`.`mc_pedcli` = 0;';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
}

?>