<?php

/*
  Lista de banners
  // Creado por Pedro el 20/Marzo/2017
 */

class SuperListaBanner {
    public static $campos_tabla = array();
    public static $alias = '';
    public static $nombreTabla = '';
    public static $camposSelect = '';
    public static $whereSelect = '';
    public static $publicFieldList = array();


    private $lista = Array();

    function __construct($condicion = "", $activo = 1) {
        include('comunes/globals.php');
        $idioma = Sesion::get("idioma");
        $idioma = ($idioma != NULL) ? $idioma : Shop::$configuracion->idioma;
        //Cargamos los datos que necesitamos del banner
            //Pedro 07/Octubre/2019 ==> Vamos a cargar los banners del idioma actual o los que no tengan idioma:
        $select_idioma = '';
        $filtradoIdioma = array();
        if (Module::is_active('multi-idioma')){
            $idioma = Idioma::getCurrentLanguajeCode();
            $filtradoIdioma = array(
                array('condicion' => 'IS', 'campo' => 'idioma', 'operador' => 'OR', 'valor' => ' NULL '),
                array('condicion' => ' = ', 'campo' => 'idioma', 'operador' => 'OR', 'valor' => ''),
                array('condicion' => ' = ', 'campo' => 'idioma', 'operador' => 'OR', 'valor' => $idioma),
                );
        }
        //Pedro 07/Octubre/2019 ==> Usamos el loadList que tiene la clase Banner
        //Vamos a  cargar los banners con la función de loadList
        $filtro = array('condicion' => $condicion, 'limit' => '');
        if (count($filtradoIdioma) > 0){
            $filtro['idioma'] = $filtradoIdioma;
        }
        if ($activo != NULL){
            $filtro['activo'] = $activo;
        }
        $this->lista = Banner::loadList($filtro);

    }

    function __destruct() {
        unset($this->lista);
    }

    function add($element = NULL) {
        if ($element != NULL) {
            $this->lista[] = $element;
        }
        return(true);
    }

    function remove($index){
        if (isset($this->lista[$index])){
            array_splice ($this->lista, $index, 1);
            return(true);
        }else{
            return(false);
        }
        
    }
    
    function get($index){
        if (isset($this->lista[$index])){
            return($this->lista[$index]);
        }else{
            return(NULL);
        }
    }
    
    function set($index, $element){
        $this->lista[$index] = $element;
        return(true);
    }
    
    public function getCount(){
        return(count($this->lista));
    }
     public function getList(){
        return($this->lista);
    }
}

?>