<?php
/*
  Clase SuperEbooks
  @version 1.0
 */

class SuperOfertasRegalo extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();


	public $articulo = 0;
    public $codigo = 0;
    public $descripcion = '';
	public $cantidad = 0;
    public $cantidad_regalo = 0;
	public $desde_fecha = 0;
	public $hasta_fecha = 0;
	
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$articulo = isset($argumentos[0]) ? $argumentos[0] : NULl;
		$codigo = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		include('comunes/globals.php');
		static::$whereSelect = '' ;
		if ($articulo != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`articulo` = "' . $articulo . '" ';
		}
		//No tiene mucho sentido que no nos pasen la ruta si un producto puede tener varias descargas:
		if ($codigo != NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' .  static::getAlias() . '`.`codigo` = "' . $codigo . '" ';
		}
		
		if ($limitar !== NULL){
			if ($limitar){
				static::$whereSelect .= ' LIMIT 1 ';
			}
		}
		return(static::$whereSelect);
	}
	
    //Constructor y destructor
    function __construct($opciones) {
        include('comunes/globals.php');
        $this->articulo = 0;
		$this->codigo = 0;
		$filaOferta = NULL;
		if (is_a($opciones, 'OpcionesWidget')) {
			$this->articulo = ($opciones->configuracion->articulo != NULL) ? $opciones->configuracion->articulo : $this->articulo;
			$this->codigo = ($opciones->configuracion->codigo != NULL) ? $opciones->configuracion->codigo : $this->codigo;
			$filaOferta = ($opciones->configuracion->filaOferta != NULL) ? $opciones->configuracion->filaOferta : $filaOferta;
		}
		$fila = NULL;
		//Leemos el objeto:
		if ($filaOferta == NULL){
			//Vamos a cargar las descargas que ha hecho el usuario de este fichero:
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
							WHERE ' . static::getWhereTabla($this->articulo, $this->codigo);
			//echo("$sentencia_sql<br />\n");
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
			$fila = $bd->getFila();
		}else{
			$fila = $filaOferta;
		}
		if ($fila != NULL){
			$this->codigo = $fila[static::getAlias() . '_' . 'codigo'];
			$this->articulo = $fila[static::getAlias() . '_' . 'articulo'];
			$this->descripcion = $fila[static::getAlias() . '_' . 'descripcion'];
			$this->cantidad = $fila[static::getAlias() . '_' . 'cantidad'];
			$this->cantidad_regalo = $fila[static::getAlias() . '_' . 'cantidad_regalo'];
			$this->desde_fecha = $fila[static::getAlias() . '_' . 'desde_fecha'];
			$this->hasta_fecha = $fila[static::getAlias() . '_' . 'hasta_fecha'];
		}
    }

    function __destruct() {
        
    }

	public static function cargarOfertas($articulo){
		$codigo_articulo = 0;
		$lista_ofertas = array();
		if (is_a($articulo, 'Articulo')){
			$codigo_articulo = $articulo->codigo;
		}else{
			$codigo_articulo = $articulo;
		}
		//Vamos a componer la select:
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
							WHERE ' . static::getWhereTablaArray(array(
									'articulo' => $codigo_articulo,
									'desde_fecha' => array(
													'condicion' => '<=',
													'valor' => date("Y-m-d")
												),
									'hasta_fecha' => array(
													'condicion' => '>=',
													'valor' =>  date("Y-m-d")
												),
									'limit' => ''
								));
		//echo("<pre> $sentencia_sql </pre>\n");
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		while($fila = $bd->getFila()){
			$lista_ofertas[] = new OfertasRegalo(new OpcionesWidget(array('filaOferta' => $fila)));
		}
		
		return($lista_ofertas);
	}
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>