<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Contiene las acciones de la tabla -->
<!-- ============================================================== -->
<?php
  $parametrosPlantilla = Theme::getLastParamList();
  $sitio = Theme::getLastParam('sitio');
  $id_fila = Theme::getLastParam('id_fila');
  $enviado = Theme::getLastParam('enviado');
  $acciones = Theme::getLastParam('acciones');
  $clave_check = RemoteRequest::generateRandomString();
  //vamos a coger la lista de codigos
  $lista_codigos = Getter::get('check_linea', array());

  //Marina(04/Diciembre/2019) Este fichero va a mostrar el check y los botones de acciones.
  //Mediante parámetros del tema le diremos si se va a incluir en la cabecera de la tabla 
  //o en las filas de la tabla, y según donde esté le aplicamos un script u otro.
  //Las diferencias en la funcionalidad serán:
  //Check: Marcar todos / marcar uno
  //Botones: Accion para todos / Acción para uno

  //Creamos un input distinto según si estamos en cabecera o en las filas
?>
  <th class="<?=($sitio == 'cabecera') ? 'marcar_todo' : 'marcar_fila';?>">
    <span>
      <?php
      //Si estamos en la cabecera tenemos un check que controla los demas para marcarlos/desmarcarlos todos
      if($sitio == 'cabecera'){
        ?>
        <input id="<?=$clave_check;?>" type="checkbox" title="<?=traducir('Marcar todo');?>"/>
        <script>
          document.addEventListener('WSLE', function(){
            $("#<?=$clave_check;?>").on("change", function() {
                $("[data-name=\"check_linea\"]").prop("checked", this.checked);
            });

            $('[data-name=\"check_linea\"]').on("change", function() {
              if ($('[data-name=\"check_linea\"]').length == $("[data-name=\"check_linea\"]:checked").length) {
                  $("#<?=$clave_check;?>").prop("checked", true);
              } else {
                  $("#<?=$clave_check;?>").prop("checked", false);
              }
            });
          });
        </script>
        <?php
      //si estamos en las lineas de la tabla tenemos un check individual por cada fila 
      }else if($sitio == 'lineas_tabla'){
        ?>
        <input type="checkbox" name="check_linea_<?=$id_fila;?>" title="<?=traducir('Marcar línea');?>" class="<?=($enviado == 0) ? 'check_no_enviado' : 'check_enviado';?>" <?=(in_array($id_fila, $lista_codigos)) ? 'checked' : '';?> data-name="check_linea"/>
        <?php
      }

      ?>
    </span>

    <?php
    //Marina(04/Diciembre/2019) Incluimos los botones de acciones que se configuran desde el fichero de cada seccion (ejemplo en: emails.php)
    ?>
    <div class="botones_acciones">
        
      <?php
      $parametrosActuales = Getter::getList('' , array('opcion_realizar', 'accion_lista', 'pregunta_accion', 'check_linea'));
      ob_start();
      foreach ($parametrosActuales as $parametro => $valor) {
        ?>
        <input type="hidden" name="<?=$parametro;?>" value="<?=$valor;?>"/>
        <?php 
      }
      $input = ob_get_clean();
        $cont = 0;
        foreach($acciones as $accion){
          $nombre = $accion['nombre'];
          $title = $accion['title'];
          $icono = $accion['icono'];
          $accion_realizar = $accion['accion'];
          $pregunta = $accion['pregunta'];
          /*<form class="accion_<?=$cont;?> accion_lista" method="post">*/
          $scriptOnSubmit = ($sitio == 'cabecera') ? '' : 'onSubmit="return confirm(\'' . $pregunta . '\');"';

          ?>
          <form class="accion_<?=$cont;?> <?=($sitio == 'cabecera') ? 'accion_cabecera' : 'accion_linea';?>" method="post" <?= $scriptOnSubmit;?>>
            <button class="btn btn-light" name="<?=$nombre;?>" title="<?=traducir($title);?> <?=($sitio == 'cabecera') ? 'marcados' : '';?>" type="submit" >
                <i class="mdi <?=$icono;?>"></i>
            </button>
            <input name="accion_lista" type="hidden" value="<?=$accion_realizar;?>"/>
            <input name="pregunta_accion" type="hidden" value="<?=$pregunta;?>"/>
            <?php
            if ($sitio != 'cabecera'){
              ?>
              <input name="check_linea[]" type="hidden" value="<?=$id_fila;?>"/>
              <?php
            }
            ?>
            <?=$input;?>
          </form>
          <?php
          $cont++;
        }
        //si estamos en cabecera ejecutamos el script que hace la misma accion para todos los check marcados
        if($sitio == 'cabecera'){
        ?>
          <script>
            document.addEventListener('WSLE', function(){
              $('form.accion_cabecera').on('submit', function(e){
                  e.preventDefault();
                  var elementos = $('input[name^=\'check_linea_\']:checked').toArray();
                  var formulario = $(this);
                  //borro los input que creo mas abajo para evitar que se creen más de la cuenta
                  $(this).find('input[name=\'check_linea[]\']').remove();
                  if (elementos.length > 0){
                    elementos.forEach(function(elemento){

                      var name_completo = $(elemento).attr('name');
                      var trozos_name = name_completo.split('_');
                      var input = $('<input/>');
                      input.attr({
                          'type': 'hidden',
                          'name': 'check_linea[]',
                          'value': trozos_name[2]
                      });
                      formulario.append(input);
                    });
                  }

                  var pregunta = $(this).find('input[name=\'pregunta_accion\']').val();

                  if ( confirm(pregunta) ){
                      $(this).unbind('submit');
                      $(this).submit();
                  }else{
                      return false;
                  }
              });

            });
          </script>
        <?php
        }
        ?>
    </div>
  </th>
