<!-- ============================================================== -->
<!-- Marina (09/09/2019) Sección dedicada al mantenimiento y limpieza de la web -->
<!-- ============================================================== -->
<?php
    $nombre_seccion = Sections::getParam('section_name', Sections::$current_section);

    $acciones_disponibles = [
        'borrar_cache_completa' => 'ALL',
        'borrar_escaparates' => 'ESCAPARATES',
        'cache_bd' => 'DB',
        'cache_html' => 'HTML',
        'cache_overrides' => 'OVERRIDES'
    ];
    //TODO crear un switch en el que iremos decidiendo lo que hace cada acción



?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <!-- ============================================================== -->
                    <!-- Selector de carpeta DYNAMIC -->
                    <!-- ============================================================== -->
                    <h4 class="card-title"><?=traducir('Caché');?></h4>
                    <div class="form-group row">
                        <div class="card-body">
                            <?php
                            $objDir = new FileSystem(_WS_GLOBAL_DYNAMIC_DIR_);
                            $lista_directorios = $objDir->getDirList(_WS_GLOBAL_DYNAMIC_DIR_);
                            $id_select_dir = RemoteRequest::generateRandomString(6);
                            ?>
                            <select name="instancia" id="<?=$id_select_dir;?>">
                                <?php
                                foreach ($lista_directorios as $clave => $valor){
                                    //Vamos a obtener el nombre del tema para mostrarlo:
                                    $valor = trim($valor);
                                    $nombre = $valor;
                                    $ruta_theme_name = _WS_GLOBAL_DYNAMIC_DIR_ . $valor . '/theme_name';
                                    if (file_exists($ruta_theme_name)){
                                        $nombre .= ' - ' . file_get_contents($ruta_theme_name);
                                    }else if ($valor == crc32(_WS_THEMES_DIR_ . _WS_THEME_DIR_)){
                                        $nombre .= ' - Administrador ';
                                    }
                                ?>
                                <option value="<?=$valor;?>"><?=$nombre;?></option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="FileSystem" data-function="cleanDynamicDir" data-name="<?=$acciones_disponibles['borrar_cache_completa'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar toda la caché">
                                    <?=traducir('Borrar toda');?>
                                </button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="FileSystem" data-function="cleanDynamicDir"  data-name="<?=$acciones_disponibles['borrar_escaparates'];?>" data-toggle="tooltip" data-placement="top" data-original-title="<?=traducir('Borrar menús categorías');?>"> <?=traducir('Borrar menús categorías');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="FileSystem" data-function="cleanDynamicDir"  data-name="<?=$acciones_disponibles['cache_bd'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de la base de datos"><?=traducir('Solo base de datos');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="FileSystem" data-function="cleanDynamicDir"  data-name="<?=$acciones_disponibles['cache_html'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de Html"><?=traducir('Solo html');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="FileSystem" data-function="cleanDynamicDir"  data-name="<?=$acciones_disponibles['cache_overrides'];?>" data-toggle="tooltip" data-placement="top" data-original-title="Borrar solo la caché de overrides"><?=traducir('Solo overrides');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Sesiones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="cleanOldSessions" data-toggle="tooltip" data-placement="top" data-original-title="Borrar sesiones con más de 7 días"><?=traducir('Borrar sesiones');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Traducciones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="cleanEmptyTrad" data-toggle="tooltip" data-placement="top" data-original-title="Borrar las traducciones vacías"><?=traducir('Optimizar traducciones');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Pedidos');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="reassignPedcliCodes" data-toggle="tooltip" data-placement="top" data-original-title="Asignar códigos programa a pedidos"><?=traducir('Asignar códigos programa a pedidos');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="cleanOrphanedCarts" data-toggle="tooltip" data-placement="top" data-original-title="Eliminar la cabecera de pedidos temporales sin hash"><?=traducir('Eliminar cabeceras hash erróneo');?></button>
                            </div>
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="cleanOrphanedLinCarts" data-toggle="tooltip" data-placement="top" data-original-title="Borrar lineas de pedidos sin cabecera"><?=traducir('Limpiar lineas huérfanas');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Direcciones');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="ArmiSync" data-function="emptyAddress" data-toggle="tooltip" data-placement="top" data-original-title="Borrar las direcciones vacías"><?=traducir('Limpiar direcciones sin uso');?></button>
                            </div>
                        </div>
                    </div>
                    <h4 class="card-title"><?=traducir('Artículos');?></h4>
                    <div class="form-group row border-bottom">
                        <div class="card-body">
                            <div class="div_boton">
                                <button type="button" class="boton_cambios btn btn-primary" data-class="Busqueda" data-function="indexProducts" data-toggle="tooltip" data-placement="top" data-original-title="Reconstruir índice de artículos para las búsquedas"><?=traducir('Reindexar artículos');?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    document.addEventListener('WSLE', function(){
        $("button.boton_cambios").on('click', function(){
            var boton = $(this);
            boton.attr("disabled", true);
            var clase = $(this).data('class');
            var funcion = $(this).data('function');
            var data = {};
            if (funcion == 'cleanDynamicDir'){
                var accion = boton.data('name');
                var dir = $('#<?=$id_select_dir;?>').val();
                data = {type: accion, dir: dir};
            }else if (funcion == 'indexProducts'){
                //Vamos a comprobar si tenemos el data "reindex" a false:
                var reindex = boton.data('reindex');
                reindex = (typeof reindex !== 'undefined') ? reindex : 1;
                data = {updateAll: reindex};
            }
            //La función de reindexar productos es un tanto especial:
            if ( (clase != '') && (funcion != '') ){
                //Si estamos Aquí, vamos a ver si poner el spinner o el %:
                var porcen = boton.data('porcen');
                var html = '<?=traducir('Procesando');?>';
                if (typeof porcen !== 'undefined'){
                    var html = porcen + '% <?=traducir('Procesando');?>';
                }else{
                    var html = '<img src="<?=Shop::$configuracion->url . _WS_THEME_HTML_DIR_ . 'assets/images/processing.gif';?>" width="19px"/><?=traducir('Procesando');?>'
                }
                boton.html(html);
                WS_data_update(
                    'Busqueda',
                    funcion,
                    data,
                    '',
                    function(data){
                        var total = 0;
                        if (funcion == 'indexProducts'){
                            var data = JSON.parse(data.response);
                            total = data.total;
                        }
                        if (total > 0){
                            var porcen = boton.data('porcen');
                            if (typeof porcen === 'undefined'){
                                //El total es el total absoluto, vamos a poner el %:
                                boton.data('porcen', '0');
                                boton.data('total', total);
                            }else{
                                //Redefinimos el %:
                                var total_absoluto = boton.data('total');
                                var indexados = total_absoluto - total;
                                var porcen = Math.round( (indexados * 100) / total_absoluto );
                                boton.data('porcen', porcen);
                            }
                            boton.removeAttr("disabled");
                            boton.data('reindex', '0');
                            boton.click();
                        }else{
                            setTimeout(function(){boton.html(boton.data('original-title'));boton.button('toogle').tooltip('hide');boton.removeAttr("disabled");}, 2000);   
                        }
                    }
                );
            }
        });
    });  
</script>