<?php

//---------------------------------------------------------------------------------------------------------
// 12/Enero/2015
// Versión 1.0 Widget que engloba los enlaces de los textos legales
//---------------------------------------------------------------------------------------------------------



function widget_textos_legales($nombre_funcion = 'textos_legales') {
    /*
      //$nombre_funcion = "textos_legales", $enlaces="aviso_legal,privacidad,terminos_y_condiciones,cookies", $separador="-"
      include("comunes/globals.php");
      $retorno = false;
      //Si existe el tipo de escaparate, entonces lo mostramos
      if(function_exists($nombre_funcion)){
      $retorno = $nombre_funcion($enlaces, $separador);
      }
      return($retorno);
     */

    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'textos_legales';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function textos_legales($enlaces = 'aviso_legal,privacidad,terminos_y_condiciones,cookies', $separador = '-') {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    if (($enlaces != NULL) && (is_a($enlaces, "OpcionesWidget"))) {
        $opciones = $enlaces;
        $enlaces = 'aviso_legal,privacidad,terminos_y_condiciones,cookies';
        $separador = '-';
        if (is_a($opciones, 'OpcionesWidget')) {
            $enlaces = ($opciones->configuracion->enlaces != NULL) ? $opciones->configuracion->enlaces : $enlaces;
            $separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $enlaces_base = array(
        'aviso_legal' => '<a href="' . Shop::$configuracion->url . 'aviso_legal" class="aviso_legal" title="' . traducir('Aviso legal') . '">' . traducir('Aviso legal') . '</a>',
        'privacidad' => '<a href="' . Shop::$configuracion->url . 'privacidad" class="privacidad" title="' . traducir('Política de privacidad') . '">' . traducir('Política de privacidad') . '</a>',
        'terminos_y_condiciones' => '<a href="' . Shop::$configuracion->url . 'terminos_y_condiciones" class="' . traducir('terminos_y_condiciones') . '" title="' . traducir('Términos y condiciones') . '">' . traducir('Términos y condiciones') . '</a>',
        'cookies' => '<a href="' . Shop::$configuracion->url . 'cookies" class="cookies" title="' . traducir('Política de cookies') . '">' . traducir('Cookies') . '</a>');
    $array_enlaces = explode(",", $enlaces);
    $cadena_enlaces = "";
    foreach ($array_enlaces as $clave => $valor) {
        if ($enlaces_base[$valor] != NULL) {
            $cadena_enlaces .= ( ($cadena_enlaces != '') ? ' ' . $separador . ' ' : '' ) . $enlaces_base[$valor];
        }
    }
    //No mostramos nada si no hay enlaces a mostarr
    if ($cadena_enlaces != '') {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <?= $cadena_enlaces; ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
    return(true);
}
?>