<?php
/*
	Clase Idioma
	@version 1.0
*/

//30/Septiembre/2019 ==> Añadimos la carga como objeto de WebStore
class SuperPais extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	//campos de la tabla y otros:
	public $codigo = 0;
	public $nombre = '';
	public $prefijo = '';
	public $iniciales = '';

	// public static function getCampos(){
	// 	static::$nombreTabla = strtolower(get_called_class());
	// 	static::getTablaRelacionada();
	// 	//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
	// 	if (static::$nombreTabla != ''){
	// 		static::$campos_tabla = BaseDatos::dameCampos(static::$nombreTabla);
	// 		static::$camposSelect = BaseDatos::dameCamposAlias(static::$nombreTabla) . ' ';
	// 	}
	// 	return(static::$camposSelect);
	// }

	public static function getNombreTabla(){
		$idioma = Idioma::getCurrentLanguaje(true);
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Vamos a simplificar, cogemos el nombre de la tabla usando la función de la clase padre:
		static::$nombreTabla = static::$nombreTabla . ' `' .  static::getAlias() . '`  ';
		return(static::$nombreTabla);
	}  

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		$activo = isset($argumentos[2]) ? $argumentos[2] : NULL;
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = \'' . $id . '\' ';
		}
		if ($activo !== NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`web_pais` = \'' . (($activo) ? 1 : 0) . '\' ';
		}
		
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
	
    function __construct($params){
    	//Marina(15/Enero/2020) 
		//Vamos a decodificar los parámetros:
		$codigo = NULL;
		if (is_numeric($params)){
			$codigo = $params;
		}
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaPais = $params->getDefaultValue('filaPais', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$codigo = $params->getDefaultValue('codigo', $codigo);
		$activo = $params->getDefaultValue('activo', NULL);
		$fila = NULL;
		
		if ($filaPais == NULL){
			if ( ($codigo != NULL) || ($activo != NULL) ){
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($codigo);
				
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaPais;
		}
		if($fila != NULL){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->prefijo = $this->boolData($this->getProp($fila, 'prefijo'));
		$this->iniciales = $this->getProp($fila, 'iniciales');

	}
	
    function __destruct(){
        
    }

    //crear funcion estatica que devuelve array de paises 

    public static function cargarActivos(){
		$retorno = array();

		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla(NULL, false, true);
		//echo $sentencia_sql;

		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while( $fila = $bd->getFila() ){
				$retorno[] = new Pais(array('filaPais' => $fila));
			}
		}

		return($retorno);
	}
}
?>