<?php

class SuperTipoEnvioCliente extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

    public $codigo = 0;
    public $nombre = '';
    public $importe_fijo = 0;
    public $importe_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_rec_reembolso = 0;
    public $privado = 0;
    public $pais = 0;
    public $transferencia = 0;
    public $pasarela = 0;
    public $tipo_pasarela = 0;
    public $cuenta_bancaria = '';
    public $sin_pago = 0;
    public $sin_envio = 0;
    public $rangosEnvios = array();
    public $tarifasPorLocalidad = array();
    public $flag_utf8 = false;
    public $descripcion = "";
    public $requiere_pago = true;
	public $productos_destino = true;

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		$campos = '';
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				BaseDatos::dameCamposAlias('traduc_tipo_envio');
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
		$idioma = Idioma::getCurrentLanguaje(true);
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= '`' . static::$nombreTabla . '` as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin(get_called_class(), array('codigo', '$' . $idioma), 'traduc_tipo_envio', array('tipo_envio', 'idioma'));
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}

		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : 0;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		if ($codigo > 0){
			static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = ' . $codigo . ' ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}

    function __construct($opciones) {
        if (is_numeric($opciones)){
			$opciones = array('codigoEnvio' => $opciones);
		}
		$opciones = new ObOptions($opciones);
		$filaTipoEnvio = $opciones->getDefaultValue('filaTipoEnvio', NULL);
		$codigo = $opciones->getDefaultValue('codigoEnvio', 0);
		$cargarRangosEnvio = $opciones->getDefaultValue('cargarRangosEnvio', true);
		$cargarTarifasLocalidad = $opciones->getDefaultValue('cargarTarifasLocalidad', true);

		$fila = NULL;
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaTipoEnvio == NULL){
			$sentencia_sql = 'SELECT ' . static::getCampos() .
							' FROM ' . static::getNombreTabla() . 
							' WHERE ' . static::getWhereTabla($codigo);

			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaTipoEnvio;
		}
		$this->extractData($fila);

        if ($cargarRangosEnvio) {
            $this->cargarRangosEnvio();
        }
        if ($cargarTarifasLocalidad) {
            $this->cargarTarifasPorLocalidad();
        }
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->importe_fijo);
        unset($this->importe_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_rec_reembolso);
        unset($this->privado);
        unset($this->pais);
        unset($this->transferencia);
        unset($this->pasarela);
        unset($this->tipo_pasarela);
        unset($this->cuenta_bancaria);
        unset($this->sin_pago);
        unset($this->sin_envio);
	    unset($this->productos_destino);
    }

	public function extractData($fila){
		 if ($fila != NULL) {
			$this->codigo = $this->getProp($fila, 'codigo');
			$this->nombre = $this->getProp($fila, 'nombre');
			$this->importe_fijo = $this->getProp($fila, 'importe_fijo');
			$this->importe_unidad = $this->getProp($fila, 'importe_unidad');
			$this->reembolso = $this->getProp($fila, 'reembolso');
			$this->recargo_reembolso = $this->getProp($fila, 'recargo_reembolso');
			$this->porc_rec_reembolso = $this->getProp($fila, 'porc_rec_reembolso');
			$this->privado = $this->getProp($fila, 'privado');
			$this->pais = $this->getProp($fila, 'pais');
			$this->transferencia = $this->getProp($fila, 'transferencia');
			$this->pasarela = $this->getProp($fila, 'pasarela');
			$this->tipo_pasarela = $this->getProp($fila, 'tipo_pasarela');
			$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria');
			$this->sin_pago = $this->getProp($fila, 'sin_pago');
			$this->sin_envio = $this->getProp($fila, 'sin_envio');
			$this->descripcion = $this->getProp($fila, 'descripcion', BaseDatos::dameAlias('traduc_tipo_envio'));
			if ($this->sin_pago || $this->reembolso) {
				$this->requiere_pago = false;
			}
			$this->productos_destino = $this->getProp($fila, 'productos_destino');
        }
	}
    function cargarRangosEnvio() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM rango_envio '
                . 'WHERE tipo_envio_cliente = ' . $this->codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    $this->rangosEnvios[] = new RangoEnvio($fila['codigo']);
                }
            }
        }
    }

    function cargarTarifasPorLocalidad() {
		$this->tarifasPorLocalidad = TarifasPorLocalidad::getAll($this->codigo);
    }

	public static function tipoEnvioTodos(){
		$retorno = array();
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
						FROM ' . static::getNombreTabla() . '; ';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($retorno, new TipoEnvioCliente(new OpcionesWidget(array('filaTipoEnvio' => $fila))));
			}
		}
		return($retorno);
	}

    /**
     * Nos devuelve los gastos de envío
	 * Si a esta función le pasamos una localidad, no la coge de la cesta y te dice los gastos de envio.
     * */
    public function getGastosEnvio($localidad = '', $cart = NULL) {
		//Inicializamos un par de variables que vamos a necestiar en la función
		$finded = false;
        $localImporteTotal = 0;	//	==> El importe total que vamos a devolver
        //Cogemos, desde ya, los valores que tiene el objeto asignados:
        $localImporte_fijo = $this->importe_fijo;
        $localImporte_unidad = $this->importe_unidad;
        $localReembolso = $this->reembolso;
        $localRecargo_reembolso = $this->recargo_reembolso;
        $localPorc_rec_reembolso = $this->porc_rec_reembolso;
		//Para el resto de cálculos vamos a coger más datos de la cesta que necesitamos
		$cart = ($cart == NULL) ? CabeceraCesta::getCart() : $cart;
        $importe_pedido = $cart->importe;
        $cantidad_articulos = $cart->cantidad;
		
		//Vamos a ver la localidad actual
		if ($localidad == ''){
			$direccionEnvio = $cart->getCurrentShippingDestination();
			if ($direccionEnvio != NULL){
				$localidad = $direccionEnvio->cod_postal;
			}
		}
		//echo("La locadad es: {$localidad}<br/>\n");
        if ($localidad != '') {
            $objeto = array_filter($this->tarifasPorLocalidad, function($v, $k) use ($localidad){
                return ( ($v->localidad == $localidad) || ($v->provincia == substr($localidad, 0, 2)) );
            }, ARRAY_FILTER_USE_BOTH);
            if (count($objeto) > 0) {
                $objeto = reset($objeto);
                $finded = true;
                $localImporte_fijo = $objeto->importe_fijo;
                $localImporte_unidad = $objeto->importe_x_unidad;
                $localReembolso = $objeto->reembolso;
                $localRecargo_reembolso = $objeto->recargo_reembolso;
                $localPorc_rec_reembolso = $objeto->porc_recargo_reembolso;
            }
        }

        //Si NO hemos encontrado los gastos por localidad, miramos los gastos por tramos
        if (!$finded) {
            if ($importe_pedido > 0) {
                $objeto = array_filter($this->rangosEnvios, function($v, $k) use ($importe_pedido){	//Para poder usar la variable "importe_pedido" aquí dentro tengo que usar el "use"
                    return ( ($v->rango_inferior <= $importe_pedido) && ($v->rango_superior > $importe_pedido));
                }, ARRAY_FILTER_USE_BOTH);
                if (count($objeto) > 0) {
                    $objeto = reset($objeto);
                    $finded = true;	//	==> Indicamos que ya se ha encontrado el importe para que no se recalcule más abajo
                    $localImporteTotal = $objeto->importe;
                }
            }
        }else{
			//Si pasamos por aquí es porque el envío por localidad se ha encontrado.
				//Resteamos la variable "finded" para que se calcule el importe total
			$finded = false;
		}

        //Aquí recalculamos el total, lo hacemos en dos casos, que aún no haya importe o que no se haya encontrado un importe (esto es algo redundante)
        if ( ($localImporteTotal == 0) && (!$finded) ) {	//Hemos añadido aquí que no se haya encontrado porque se puden ponder a 0 los gastos de envío por localidad, provincia o rango de envío
            //Si no existe rango de envio le aplicamos el importe fijo
            $localImporteTotal = $localImporte_fijo;

            if ($localImporte_unidad > 0) {
                $localImporteTotal += $cantidad_articulos * $localImporte_unidad;
            }
            if ($localReembolso) {
                //Si hay porcentaje de recargo de reembolso lo sumamos
                if ($localPorc_rec_reembolso > 0) {
                    //$retorno = ($retorno * $gastos["porc_recargo_reembolso"]) / 100;
                    $localImporteTotal += ( ($importe_pedido + $localImporteTotal) * $localPorc_rec_reembolso) / 100;
                }
                //Es un reembolso, así que hay que calcular los gastos x reembolso
                $localImporteTotal += $localRecargo_reembolso;
            }
        }
        return($localImporteTotal);
    }

}

?>