<?php

/*
  Clase SuperFileSystem
  @version 1.0
 */

class SuperFileSystem {
	//Pedro 25/Octubre/2019 ==> A esta clase le vamos a pasar una ruta y podremos trabajar sobre ella:
	private $path = '';
	
    //Constructor y destructor
    function __construct($path) {
    	$this->path = $path;    
    }

    function __destruct() {
        
    }
	
	//Pedro 25/Octubre/2019 ==> Vamos a devolver un array con las carpetas de un directorio:
	public function getDirList(){
		$return = scandir($this->path);
		$ruta_absoluta = $this->path;
		$return = array_filter($return, function($dir) use ($ruta_absoluta){return( (is_dir($ruta_absoluta . $dir)) & (strpos($dir, '..') === false) & (strpos($dir, '.') === false) );});
		return($return);
	}
	
	
	public static function cleanDirectory($path, $removeHiddenFiles = false){
		//Pedro 21/Octubre/2019 ==> Añadimos los tipos de error:
		//$error = 1 ==> No hay ficheros que borrar
		//$error = 2 ==> Error al borrar uno de los ficheros
		$error = false;
		if ($removeHiddenFiles){
			$files = glob($path . ((substr($path, -1, 1) != '/' )? '/' : '') . '{,.}*', GLOB_BRACE);
		}else{
			$files = glob($path . ((substr($path, -1, 1) != '/' )? '/' : '') . '*'); // get all file names
		}
		if (count($files) == 0){
			$error = 1;
		}
		foreach($files as $file){ //recorremos cada fichero:
			if(is_file($file)){
				$error = (unlink($file))? $error : 2; // Borramos el fichero y registramos el error si lo hay
			}
		}
		return($error);
	}
	
	public static function dir_is_empty($dir) {
		$retorno = true;
		if ($handle = opendir($dir)){
			while (false !== ($entry = readdir($handle))) {
				if ($entry != '.' && $entry != '..') {
				  closedir($handle);
				  $retorno = false;
				}
			}
			closedir($handle);
		}
		return($retorno);
	}
	/*
	-- Estas funciones remotas están limitadas sólo a la carpeta UPLOAD por seguridad
	-- A día de hoy el único "fileType" soportado es img
	*/
	public static function remoteDirIsEmpty($data){
		//Ojo, estas consultas son siempre partiendo desde la carpeta de subidas
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		$path = $data->path;
		$fileType = 'img';
		if (isset($data->fileType)){
			$fileType = $data->fileType;
		}
		$uploadPath = '';
		switch(strtolower($fileType)){
			case 'img':
				$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
			break;
		}
		if ($path = realpath($uploadPath . DIRECTORY_SEPARATOR . $path)){
			$retorno->resultado = self::dir_is_empty($path);
		}else{
			$retorno->resultado = false;
		}
		return(json_encode($retorno));
	}
	
	public static function remoteCreateDir($data){
		$fileType = 'img';
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		//Pedro 25/Octubre2019 ==> Por seguridad vamos a quitar los .. para evitar que nadie se salga de aquí
		if (strpos($data->path, '..') === false) {
			$subCarpeta = "";
			if (isset($data->fileType)){
				$fileType = $data->fileType;
			}
			$uploadPath = '';
			switch(strtolower($fileType)){
				case 'img':
					$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
				break;
			}
			//Si no hay uploadPath, no hacemos nada
			$uploadPath = str_replace('.', '', $uploadPath);	//Simplemente vamos a quitar los '.' de la ruta
			if ($uploadPath != ''){
				//Por seguridad SIEMPRE los directorios se podrán crear dentro de UPLOAD
				$uploadPath .= DIRECTORY_SEPARATOR . $data->path;
				//Ahora ha llegado el momento de crear el directorio en cuestión:
				if (!is_dir($uploadPath)){
					if (mkdir($uploadPath, 0755, true)){
						$retorno->resultado = true;
					}
				}
			}
		}
		return(json_encode($retorno));
	}
	
	public static function remoteDeleteDir($data){
		$fileType = 'img';
		$retorno = new stdClass();
		$retorno->resultado = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		//Pedro 25/Octubre2019 ==> Por seguridad vamos a quitar los .. para evitar que nadie se salga de aquí
		if (strpos($data->path, '..') === false) {
			$subCarpeta = "";
			if (isset($data->fileType)){
				$fileType = $data->fileType;
			}
			$uploadPath = '';
			switch(strtolower($fileType)){
				case 'img':
					$uploadPath = realpath(_WS_UPLOAD_IMAGES_DIR_);
				break;
			}
			//Si no hay uploadPath, no hacemos nada
			$uploadPath = str_replace('.', '', $uploadPath);	//Simplemente vamos a quitar los '.' de la ruta
			if ($uploadPath != ''){
				//Por seguridad SIEMPRE los directorios se podrán crear dentro de UPLOAD
				$uploadPath .= DIRECTORY_SEPARATOR . $data->path;
				//Ahora ha llegado el momento de crear el directorio en cuestión:
				if (is_dir($uploadPath)){
					if (rmdir($uploadPath)){
						$retorno->resultado = true;
					}
				}
			}
		}
		return(json_encode($retorno));
	}
	/*
	-- FIN DE ==> Estas funciones remotas están limitadas sólo a la carpeta UPLOAD por seguridad
	-- A día de hoy el único "fileType" soportado es img
	*/
	//-------------------------------------------------
	/*
	-- Vamos a añadir funciones remotas para la caché:
	*/
	
	public static function remoteCleanDynamicDir($data){
		//Inicializamos el renorno:
		$retorno = new stdClass();
		$retorno->resultado = false;
		//Carpeta dónde vamos a limpiar:
		$dir = '';
		//Procesamos los datos recibidos
		if (is_string($data)){
			$data = json_decode($data);
		}
		if ( isset($data->type) && isset($data->dir) ){
			$type = strtoupper($data->type);
			$cacheDir = $data->dir;
			$cacheDir = _WS_GLOBAL_DYNAMIC_DIR_ . $cacheDir . ( (substr($cacheDir, -1) != '/') ? '/' : '' );
			switch ($type){
				case 'DB':
					$dir = $cacheDir . 'cache/dictionary.php';
					$retorno->resultado = true;
				break;
				case 'ESCAPARATES':
					$dir = $cacheDir . 'cache/menu_escaparates/';
					$retorno->resultado = true;
				break;
				case 'OVERRIDES':
					$dir = array(
						$cacheDir . 'classes/',
						$cacheDir . 'controllers/'
						);
						$retorno->resultado = true;
				break;
				case 'HTML':
					$dir = array(
						$cacheDir . 'controlFiles/',
						$cacheDir . 'file_index/',
						$cacheDir . 'media/css/',
						$cacheDir . 'media/js/',
						$cacheDir . 'sections/'
						);
						$retorno->resultado = true;
				break;
				case 'ALL':
					$dir = array(
						$cacheDir . 'cache',
						$cacheDir . 'cache/menu_escaparates/',
						$cacheDir . 'classes/',
						$cacheDir . 'controllers/',
						$cacheDir . 'controlFiles/',
						$cacheDir . 'file_index/',
						$cacheDir . 'media/css/',
						$cacheDir . 'media/js/',
						$cacheDir . 'sections/'
						);
						$retorno->resultado = true;
				break;
			}
			//Si $dir es una cadena, lo convertimos en un arraY:
			if (is_string($dir)){
				$dir = array($dir);
			}

			foreach($dir as $key => $dirName){
				if ($dirName != ''){
					//Recorremos los directorios indicados eliminando los ficheros que haya dentro
					self::cleanDirectory($dirName);
				}
			}
		}
		
		return(json_encode($retorno));
	}
	
	//Formas de llamar a esta función:
	/*WS_data_update(
		'FileSystem',
		'CleanDynamicDir',
    	{type:'OVERRIDES', dir:'xxxxx'},
		'',
		function(data){
			console.log("DAtos: " + data);
		}
	);
	*/
	/*
	-- FIN DE ==> Vamos a añadir funciones remotas para la caché:
	*/
	public static function log($string = '', $path = NULL){
		$path = ($path != NULL) ? $path : _WS_INDEX_DIR_ . '/log_'.date('m-d-Y_hi').'.txt';
		if (trim($string) != ''){
			if ($file = fopen($path, 'a+')){
				fwrite($file, $string . PHP_EOL);
				fclose($file);
			}
		}
		return($path);
	}
}
