<?php
	header('Content-Type:application/json');
/*
	Este es el fichero encargado de recibir las peticiones vía ajax 
	y las mandará al controlador RemoteRequest
	@version 1.0
*/
	//Pedro 25/Julio/2019	==> No podemos hacer carga perezosa de imágenes cuando se hace un "remote request"
	//define('_WS_LAZY_IMAGES', false);	//Lo quito por que da problemas
	include_once('local.php');	// ==> Lo hacemos con un include para no tener que editar el index en cada cliente (Pedro 07/Febrero/2019)

	//Nos aseguramos de que SIEMPRE exista un "core_path"
	if (!defined('_WS_CORE_PATH')){
		define('_WS_CORE_PATH', '');	//Esta variable SÓLO se usa para poder hacer el include de webStore sin tener que tocar el index.php.
										//	Existe otra variable que es "_WS_CORE_DIR_" que contiene la ruta absoluta interna al core de webStore
	}
	
	//Arrancamos el core de webStore
	include(_WS_CORE_PATH . 'core/initWebStore.php');


	//Ejecutamos la petición remota, 
	//	para pruebas comento esto:

	$struct = Getter::getJson();
	$struct = base64_decode($struct);
	$data = NULL;
	if ($subStruct = RemoteRequest::json_validate($struct)){
		//Ahora sólo vamos a ver si existe data o es nulo:
		if (isset($subStruct->data)){
			$data = $subStruct->data;
		}
	}
	//var_dump($data);
	if ($struct != NULL){
		//Con lo que tenga struct, llamamos a la función que ejecutará la consulta:
		RemoteRequest::call($struct, false);
	}
