<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Filtrado de palabras clave en la busqueda -->
<!-- ============================================================== -->
<?php  
  $parametrosPlantilla = Theme::getLastParamList();
  $camposTabla = Theme::getLastParam('camposTabla');
  $filasTabla = Theme::getLastParam('filasTabla');
  $seccion = Theme::getLastParam('seccion');
?>


<!-- ============================================================== -->
<!-- FILTRADO DE PALABRAS CLAVE EN LA BUSQUEDA -->
<!-- ============================================================== -->

<div class="card m-b-0 border-top">
  <div class="card-header" id="headingTwo">
    <h5 class="mb-0">
      <a class="collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        <i class="m-r-5 fa mdi mdi-filter" aria-hidden="true"></i>
          <span><?=traducir('Filtrado');?></span>
      </a>
    </h5>
  </div>
  <?php
    //filtrar por: nombre, codigo, ean, precio desde hasta,  un radiobutton (no_web)con visibles, no visibles o todos 
    //Vamos a crear las variables para cada campo del formulario
    $ordenActual = Getter::get('ord', '');
    $elementosXPagina = Getter::get('exp', 10);

    $idioma = Getter::get('idioma', '');
    $texto = Getter::get('texto', '');

    $where = array();
    $reemplazo = array('\'', '"', '%');
    //Section::setParam($paramName, $value);


    if ($idioma != ''){
      $nombre_filtro = str_replace($reemplazo, '', $idioma);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'idioma', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      $where['idioma'] = $subArray;
    }
    if ($texto != ''){
      $nombre_filtro = str_replace($reemplazo, '', $texto);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'texto', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      $where['texto'] = $subArray;
    }


    Sections::setParam('filtro', $where);
  ?>
  <div id="collapseTwo" class="collapse <?=(count($where) > 0) ? 'show' : '';?>" aria-labelledby="headingTwo" data-parent="#accordionExample">
    <div class="card-body">
      <div class="row">
      <!-- FORMULARIO DE FILTRADO DE ARTICULOS-->
        <form class="form-horizontal col-12" method="POST" action="<?=Shop::$configuracion->url . $seccion;?>">
            <div class="card-body">
              <h4 class="card-title"><?=traducir('Filtrar lista');?></h4>
              <input type="hidden" name="ord"  value="<?=$ordenActual;?>">
              <input type="hidden" name="exp"  value="<?=$elementosXPagina?>">

              <div class="row">
                <div class="col-12 row">
                  <div class="form-group col-lg-6">
                    <label for="fidioma" class="col-md-12 font-bold"><?=traducir('Idioma');?></label>
                    <input type="text" name="idioma"  value="<?=$idioma;?>"  class="form-control" id="fidioma" placeholder="<?=traducir('Idioma');?>">
                  </div>
                  <div class="form-group col-lg-6">
                    <label for="ftext" class="col-md-12 font-bold"><?=traducir('Texto');?></label>
                    <input type="text" name="texto"  value="<?=$texto;?>" class="form-control" id="ftexto" placeholder="<?=traducir('Texto');?>">
                  </div>
                </div>
              </div>

            </div>
            <div class="border-top">
                <div class="card-body">
                  <?php
                    if (count($where) > 0){
                      //componemos la lista de parámetros a utilizar
                      $parametrosFinales = ($ordenActual != '') ? 'ord=' . $ordenActual : '';
                      //Elementos X Pagina
                      $parametrosFinales .= ( ($parametrosFinales != '' && $elementosXPagina != '') ? '&' : '') .  (($elementosXPagina != '') ? 'exp=' . $elementosXPagina : '');
                     
                      //Componemos en enlace "base sobre el que añadir la página a la que navegar"
                      $enlace = Shop::$configuracion->url . Sections::$current_section . ( ($parametrosFinales != '') ? '?' : '') . $parametrosFinales;
                  ?>
                      <a href="<?=$enlace;?>"><button type="button" class="btn btn-danger"><?=traducir('Borrar filtro');?></button></a>
                  <?php
                    }
                  ?> 
                    <button type="submit" class="btn btn-primary"><?=traducir('Filtrar');?></button>
                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>


