<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Composición de la tabla -->
<!-- ============================================================== -->
<?php
  $parametrosPlantilla = Theme::getLastParamList();
  $camposTabla = Theme::getLastParam('camposTabla');
  $nombreTabla = Theme::getLastParam('nombreTabla');
  $tituloTabla = Theme::getLastParam('tituloTabla');
  $acciones = Theme::getLastParam('acciones');
  $opciones = Theme::getLastParam('opciones');

  //Ejemplo de como vamos a coger los parámetros:
  $ordenActual = Getter::get('ord', '');    //Así vamos a coger las cosas que se pasen en el filtrado
  $paginaActual = intval(Getter::get('p', 0));
  $elementosXPagina =  intval(Getter::get('exp', 10));

  $parametrosActuales = Getter::getList('' , array('ord', 'p', 'exp'));

  $orden = '';
  //Y ahora procesamos los parámetros:
  if ($ordenActual != ''){
    //Se supone que he recibdo algo así:
    //nombre_legal*ASC  || también es posible que me pasen el nombre del campo con un alias de tabla: alias.nombre_legal*ASC
    //Es por ello que separo en un array los dos valores:
    $array = explode('*', $ordenActual);
    //En el emento 0 tengo el campo:
    $campoOrden = $array[0];
    //En el 1 tengo el tipo (ASC o DESC). Si no me lo pasan entiendo que es ASC:
    $tipoOrden = isset($array[1]) ? $array[1] : ' ASC ' ;
    $orden = ' ORDER BY ' . $campoOrden . ' ' . $tipoOrden . ' ';
  }

  //Vamos a componer un filtro con los elementos que nos hayan pasado:
  $filtro = Sections::getParam('filtro', array());

  //Con el filtro actual, vamos a ver cuantos elementos hay
  $totalElementos = $nombreTabla::getCount($filtro);

  //Al filtro le añadimos el límite según las páginas:
  $filtro['limit'] = ' LIMIT ' . ($paginaActual * $elementosXPagina) . ', ' . $elementosXPagina . ' ';
  $filtro['order'] = $orden;



  //Y cargamos la lista para mostarla
  $filasTabla = $nombreTabla::loadList($filtro);

  if (count($filasTabla) > 0){
    //componemos la lista de parámetros a utilizar
    $parametrosFinales = ($ordenActual != '') ? 'ord=' . $ordenActual : '';
    //TODO, ahora añadimos los "parametrosActuales"
    $parametrosFinales .= ( ($parametrosFinales != '' && count($parametrosActuales) > 0) ? '&' : '') . http_build_query($parametrosActuales);

    //Componemos en enlace "base sobre el que añadir la página a la que navegar"
    $enlace = Shop::$configuracion->url . Sections::$current_section . ( ($parametrosFinales != '') ? '?' : '') . $parametrosFinales;
    $paginasDisponibles = array(10, 20, 50, 100);
    ?>

    <!-- ============================================================== -->
    <!-- TABLA  -->
    <!-- ============================================================== -->
    <div class="card">
      <h5 class="card-header m-b-0">
        <i class="m-r-5 mdi mdi-view-list" aria-hidden="true"></i>
        <span><?=traducir($tituloTabla);?></span>
      </h5>
      <div class="card-body opciones_tabla">

        <div class="elementos_a_mostrar">
          <span>Mostrando 
            <select onchange="window.location.href = '<?=$enlace . (($parametrosFinales != '') ? '&' : '?');?>exp=' + $(this).val();">
            <?php
              foreach($paginasDisponibles as $indice => $valor){
            ?>
                <option value="<?=$valor;?>" <?=($elementosXPagina == $valor)? 'selected' : '';?>><?=$valor;?></option>
            <?php
              }
            ?>
            </select>
            de <?=$totalElementos;?> (del <?=($paginaActual*$elementosXPagina)+1;?> al <?=($paginaActual*$elementosXPagina)+$elementosXPagina;?>)
          </span>
        </div>
        <div class="opciones_generales">
          <?php
          //Vamos a coger los parametros de filtrados y paginacion para que se mantengan en estos formularios
          $parametrosActuales = Getter::getList('' , array('funcion_opcion','accion_lista', 'pregunta_accion', 'check_linea'));
          ob_start();
          foreach ($parametrosActuales as $parametro => $valor) {
            ?>
            <input type="hidden" name="<?=$parametro;?>" value="<?=$valor;?>"/>
            <?php 
          }
          $input = ob_get_clean();
          //var_dump($opciones);
          if( $opciones != NULL ){
              foreach($opciones as $opcion){
                $nombre_opcion = $opcion['nombre_opcion'];
                $title_opcion = $opcion['title_opcion'];
                $clase_opcion = $opcion['clase_opcion'];
                $funcion_opcion = $opcion['funcion_opcion'];
                $pregunta_opcion = $opcion['pregunta_opcion'];
                $scriptOnSubmit = 'onSubmit="return confirm(\'' . $pregunta_opcion . '\');"';
                //TODO el formulario no funciona, debería eliminar los email enviados
                ?>

                <form class="opciones" method="POST" <?= $scriptOnSubmit;?>>
                  <button class="btn <?=$clase_opcion;?>" name="<?=$nombre_opcion;?>" value="<?=$nombre_opcion;?>" title="<?=traducir($title_opcion);?>" type="submit"><?=traducir($title_opcion);?></button>
                  <input name="funcion_opcion" type="hidden" value="<?=$funcion_opcion;?>"/>
                <?=$input;?>
                </form>
                <?php
              }
          }else{
            echo "<p>Esta tabla no tiene opciones.</p>";
          }
          ?>

        </div>
      </div>
      <table class="table tabla_<?=$nombreTabla;?>">
        <thead>
          <!-- ============================================================== -->
          <!-- CABECERA DE LA TABLA -->
          <!-- ============================================================== -->
            <?php
               //Incluimos la parte para filtrar clientes
                $params = $parametrosPlantilla;
                $ficheroLineas = 'plantilla_seccion_lista_cabecera';
                $ficheroLineasPerso = $ficheroLineas . '_' . strtolower($nombreTabla);
                $params['fileName'] = (Theme::findFile($ficheroLineasPerso . '.php') != NULL) ? ($ficheroLineasPerso .'.php') : ($ficheroLineas . '.php');
                $params['filasTabla'] = $filasTabla;
                $params['ordenActual'] = $ordenActual;
                $params['paginaActual'] = $paginaActual;
                $params['elementosXPagina'] = $elementosXPagina;
                $params['parametrosActuales'] = $parametrosActuales;
                $params['totalElementos'] = $totalElementos;

                Theme::include_file($params);
            ?>
        </thead>

          <tbody>
            <!-- ============================================================== -->
            <!-- LINEAS DE LA TABLA -->
            <!-- ============================================================== -->
            <?php
               //Incluimos las lineas de la tabla
                $params = $parametrosPlantilla;
                $ficheroLineas = 'plantilla_seccion_lista_linea';
                $ficheroLineasPerso = $ficheroLineas . '_' . strtolower($nombreTabla);
                $params['fileName'] = (Theme::findFile($ficheroLineasPerso . '.php') != NULL) ? ($ficheroLineasPerso .'.php') : ($ficheroLineas . '.php');
                $params['filasTabla'] = $filasTabla;

                Theme::include_file($params);
            ?>
          </tbody>
        </table>

      <!-- ============================================================== -->
      <!-- PAGINACION -->
      <!-- ============================================================== -->
      <?php
         //Incluimos la paginacion
          $params = $parametrosPlantilla;
          $ficheroLineas = 'plantilla_seccion_lista_paginacion';
          $ficheroLineasPerso = $ficheroLineas . '_' . strtolower($nombreTabla);
          $params['fileName'] = (Theme::findFile($ficheroLineasPerso . '.php') != NULL) ? ($ficheroLineasPerso .'.php') : ($ficheroLineas . '.php');
          $params['ordenActual'] = $ordenActual;
          $params['paginaActual'] = $paginaActual;
          $params['elementosXPagina'] = $elementosXPagina;
          $params['parametrosActuales'] = $parametrosActuales;
          $params['totalElementos'] = $totalElementos;

          Theme::include_file($params);
      ?>
    </div>
<?php
  }else{
?>
    <div class="card">
      <h5 class="card-header m-b-0">
        <i class="m-r-5 mdi mdi-view-list" aria-hidden="true"></i>
        <span><?=traducir($tituloTabla);?></span>
      </h5>
      <div class="col-12">
        <div class="alert alert-danger">
          <p><i class="mdi mdi-alert"></i><strong> ¡Lo sentimos!</strong> No hay resultados.</p>
        </div>
      </div>
    </div>
<?php
  }
?>