<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">

                        <div class="form-group row">
                            <label for="dto_dia_libro" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Descuento día del libro');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="dto_dia_libro" value="<?=Shop::$configuracion->dto_dia_libro;?>" class="form-control" id="dto_dia_libro" placeholder="<?= traducir('Descuento día del libro');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="franquicia_feran" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Franquicia Ferán');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="franquicia_feran" value="<?=Shop::$configuracion->franquicia_feran;?>" class="form-control" id="franquicia_feran" placeholder="<?= traducir('Franquicia Ferán');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="dto_texto" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Descuento texto');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="dto_texto" value="<?=Shop::$configuracion->dto_texto;?>" class="form-control" id="dto_texto" placeholder="<?= traducir('Descuento texto');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="dto_texto_libre" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Descuento texto libre');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="dto_texto_libre" value="<?=Shop::$configuracion->dto_texto_libre;?>" class="form-control" id="meta" placeholder="<?= traducir('Descuento texto libre');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="mes_inicio_texto" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Mes inicio texto');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="mes_inicio_texto" value="<?=Shop::$configuracion->mes_inicio_texto;?>" class="form-control" id="mes_inicio_texto" placeholder="<?= traducir('Mes inicio texto');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="mes_fin_texto" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Mes fin texto');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="mes_fin_texto" value="<?=Shop::$configuracion->mes_fin_texto;?>" class="form-control" id="mes_fin_texto" placeholder="<?= traducir('Mes fin texto');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="trabaja_descuentos" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Trabaja descuentos');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="trabaja_descuentos" value="<?=Shop::$configuracion->trabaja_descuentos;?>" class="form-control" id="trabaja_descuentos">
                            </div>
                        </div>
                        
                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-4 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-6">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>