<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">

                        <div class="form-group row">
                            <label for="url_sin_idioma" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Url sin idioma');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="url_sin_idioma" value="<?=Shop::$configuracion->url;?>" class="form-control" id="url_sin_idioma" placeholder="<?= traducir('Url sin idioma');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="datos_obligatorios" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Datos obligatorios');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="datos_obligatorios" value="<?=Shop::$configuracion->datos_obligatorios;?>" class="form-control" id="datos_obligatorios" placeholder="<?= traducir('Datos obligatorios');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="mes_inicio_texto" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Mes inicio texto');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="mes_inicio_texto" value="<?=Shop::$configuracion->mes_inicio_texto;?>" class="form-control" id="mes_inicio_texto" placeholder="<?= traducir('Mes inicio texto');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="mes_fin_texto" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Mes fin texto');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="mes_fin_texto" value="<?=Shop::$configuracion->mes_fin_texto;?>" class="form-control" id="mes_fin_texto" placeholder="<?= traducir('Mes fin texto');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="multi_idioma" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Multi idioma');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="multi_idioma" value="<?=Shop::$configuracion->multi_idioma;?>" class="form-control" id="multi_idioma" placeholder="<?= traducir('Multi idioma');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="cliente_contado" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Cliente contado');?></label>
                            <div class="col-sm-6">
                                <input type="number" name="cliente_contado" value="<?=Shop::$configuracion->cliente_contado;?>" class="form-control" id="cliente_contado" placeholder="<?= traducir('Cliente contado');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="segundaMano" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Segunda mano');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="segundaMano" value="<?=Shop::$configuracion->segundaMano;?>" class="form-control" id="segundaMano">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="filtroGlobal" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Filtro global');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="filtroGlobal" value="<?=Shop::$configuracion->filtroGlobal;?>" class="form-control" id="filtroGlobal" placeholder="<?= traducir('Filtro global');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="https_on" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Https ON');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="https_on" value="<?=Shop::$configuracion->https_on;?>" class="form-control" id="https_on" placeholder="<?= traducir('Https ON');?>">
                            </div>
                        </div>

                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-4 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-6">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>