<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Sección de listado de articulos -->
<!-- ============================================================== -->


 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
        	<?php
        	Theme::include_file(
        		array(
        			'fileName' => 'plantilla_seccion_lista.php',
					'camposTabla' => array(
					 	'Código' => 'codigo',
                        'Frase' =>'frase',
						'Traducir' =>'traducciones'
					 ),
					'nombreTabla' => 'Traduccion',
					'tituloTabla' => 'Traducciones de la plantilla',
                    'seccion' => basename(__FILE__, '.php')
				)
        	);
			//Vamos a meter aquí el script para editar las traducciones:
        	?>
<script>
document.addEventListener('WSLE', function(){
	//Doble click en las líneas
	$('table.editar_frase_traduccion td').on("dblclick", function(){
		guardarDato();
		//Ocultamos el span:
		$(this).find('span').addClass('hide');
		//Mostramos el input y le añadimos la clase visible para marcarlo
		$(this).find('input').removeClass('hide');
		$(this).find('input').addClass('visible').trigger('focus');
		/*$(this).find('input').focus(function() {
		   $(this).select();
		});*/
		//Por si es un select:
		$(this).find('select').removeClass('hide');
		$(this).find('select').addClass('visible');
		$(this).find('select').focus();
		
	});
	//Pierde foco del campo
	$('table.editar_frase_traduccion td input, td select').on("blur", function(){
		guardarDato();
	});
	//Pierde el foco con un enter:
	$('table.editar_frase_traduccion td input, td select').keyup(function(e){
		if(e.keyCode == 13){
			guardarDato();
		}
	});
	
	function guardarDato(){
		//Esta función coge todos los td input abiertos, mira sus valores y se los envía al servidor:
		$('td input.visible, td select.visible').each(function(){
			//Vamos a ver si este input ha cambiado:
			sendData($(this));
		});
	}
	
	function sendData(elemento){
		if (elemento.data('previo') != elemento.val()){
			//TODO Aquí es dónde hay que hacer el envío, actualizar el span y el data-previo
			var codigo = elemento.data('codigo');
			var idioma = elemento.data('idioma');
			var valor = {
				codigo: codigo,
				idioma: idioma,
				frase:elemento.val()
			};
			WS_data_update(
				'Traduccion',
				'insertOrUpdate',
				valor,
				'',
				function(data){
					data = JSON.parse(data.response);
					var resultado = data.resultado.frase;
					//console.log(data);
					elemento.val(resultado);
					elemento.data('previo', resultado);
					elemento.closest('td').find('span').html(resultado);
				}
			);
		}
		elemento.removeClass('visible');
		elemento.addClass('hide');
		elemento.closest('td').find('span').removeClass('hide');
	}
	
	
	//Control del borrado de los banners:
	$('form.borradoBanner button.btnBorrar').on('click', function(event){
		if (confirm('¿Desea eliminar este banner?')){
			$(this).closest('form.borradoBanner').submit();
		}
		
	});
});
</script>
        </div>
    </div>
</div>