<?php

//---------------------------------------------------------------------------------------------------------
// 05/Enero/2016
// Versión 1.0 Nueva extensión de la cesta de la compra que cotiene los elementos de la misma por separado
//---------------------------------------------------------------------------------------------------------

/*
  Este widget es el encargado de actualizar la variable "pasos_cesta" otrora controlada por un fichero independiente.
  Comprueba en qué paso estamos de la cesta y actúa en consecuencia.
  Muestra los pasos de la cesta, utilizando el fichero que se le pasa en las opciones:
  Parámetros:
  -Opciones
 * fichero_pasos => Nombre del fichero (sin la extensión) que muestra los pasos de la cesta. Por defecto es "pasos_cesta"
 * Opciones extra => Se incluirán las opciones extra con los pasos a mostrar
 * *índice ==> número de paso por el que vamos (los pasos del 1 al 4 son estándares)
 * *texto ==> Texto a mostrar en este paso de la cesta
 * *pago ==> [true|false] Indica que este paso mostrará la forma de pago (no se mostrará cuando estemos en "sin_pago" o en "contra_reembolso"
 * *url ==> indica la URL a la que llevará el enlace de esta opción. Por defecto es la misma que el texto, pero corregida
 * *tipo_envio_necesario ==> No se dará acceso a este paso mientras no exista el tipo de envío [true|false]. Por defecto es false.
 * *forma_pago_necesaria ==> No se dará acceso a este paso mientras no exista forma de pago [true|false]. Por defecto es false.
 * *acciones_paso ==> indica qué acciones se pueden realizar en este paso separadas por |: [cod_descuento|tipo_envio|forma_pago|observaciones|direcciones|finalizar]
  VALORES A UTILIZAR EN EL FICHERO:
  -tipo_envio => Tipo de envío seleccionado
  -forma_pago => Forma de pago seleccionada
  -cod_descuento => Código de descuento seleccionado
  -tipo_envio_sin_pago => Indica si el tipo de envío seleccionado no incluye pago [true|false]
  -contra_reembolso => Indica si el tipo de envío actual es o no contra reembolso [true|false]
  -indice => Número de paso dentro del bucle
  -estado => [pendiente|actual|hecho] => Indica si el paso en cuestión está pendiente, es el actual o está hecho
  -texto => texto ya traducido del paso de la cesta
  -enlace => enlace a este paso de la cesta. Siempre contendrá el enlace definido
  -enlace_condicional => enlace de este elemento de la cesta. Sólo contendrá el enlace de la cesta si procede
 */



function pasos_cestaV2($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }

    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }
    //Por último cogemos las opciones que nos han pasado:
    $fichero_pasos = 'pasos_cesta';
    $lista_pasos_cesta = array();
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_pasos' => $fichero_pasos));
        $opciones->addElement(array('indice' => 1, 'texto' => 'Datos de la compra', 'pago' => false, 'url' => 'datos_compra', 'tipo_envio_necesario' => false, 'forma_pago_necesaria' => false, 'acciones_paso' => 'cod_descuento'));
        $opciones->addElement(array('indice' => 2, 'texto' => 'Tipo de envío', 'pago' => false, 'url' => 'Tipo_envio', 'tipo_envio_necesario' => false, 'forma_pago_necesaria' => false, 'acciones_paso' => 'tipo_envio'));
        $opciones->addElement(array('indice' => 3, 'texto' => 'Forma de pago', 'pago' => true, 'url' => 'Forma_pago', 'tipo_envio_necesario' => true, 'forma_pago_necesaria' => false, 'acciones_paso' => 'forma_pago'));
        $opciones->addElement(array('indice' => 4, 'texto' => 'Finalizar pedido', 'pago' => false, 'url' => 'resumen_compra', 'tipo_envio_necesario' => true, 'forma_pago_necesaria' => true, 'acciones_paso' => 'observaciones|direcciones|finalizar'));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_pasos = ($opciones->configuracion->fichero_pasos != NULL) ? $opciones->configuracion->fichero_pasos : $fichero_pasos;
        $lista_pasos_cesta = ($opciones->elementos != NULL) ? $opciones->elementos : array();

        //Legados aquí tenemos que ver qué en qué opcion estamos y si se mostrará o no
        $iCod_descuento = $iTipo_envio = $iForma_pago = $iObservaciones = $iDirecciones = $Ifinalizar = 0;
        foreach ($lista_pasos_cesta as $clave => $valor) {
            //Convertimos el valor a array porque la clase me convierte el array en un objeto estandar (de la clase stdClass)
            $valor = get_object_vars($valor);
            if (strpos($valor['acciones_paso'], 'cod_descuento') !== false) {
                $iCod_descuento = $valor['indice'];
            }
            if (strpos($valor['acciones_paso'], 'tipo_envio') !== false) {
                $iTipo_envio = $valor['indice'];
            }
            if (strpos($valor['acciones_paso'], 'forma_pago') !== false) {
                $iForma_pago = $valor['indice'];
            }
            if (strpos($valor['acciones_paso'], 'observaciones') !== false) {
                $iObservaciones = $valor['indice'];
            }
            if (strpos($valor['acciones_paso'], 'direcciones') !== false) {
                $iDirecciones = $valor['indice'];
            }
            if (strpos($valor['acciones_paso'], 'finalizar') !== false) {
                $Ifinalizar = $valor['indice'];
            }
        }
        //Ahora ya sabemos en qué índice está cada acción. Con esta información, vamos a ver en qué paso estamos:
        $paso_cesta = dame_valor_variable_global('paso_cesta', -1);
        $cambiado_paso_cesta = false;
        if ($paso_cesta > -1) {
            //Se ha cambiado de paso manualmente
            $cambiado_paso_cesta = true;
        } else {
            //Comprobamos en qué paso de la cesta deberíamos estar de forma automática
            if ($paso_cesta <= 0) {
                $paso_cesta = 1;
            }
            //Si tenemos código de descuento, nos vamos al siguiente paso de esta opción
            if ($cod_descuento != '') {
                $paso_cesta = $iCod_descuento + 1;
            }
            if ($paso_cesta > 1) {
                if (($forma_pago == 0) && (!( ($tipo_envio_sin_pago) || ($contra_reembolso) ))) {
                    //Es necesario asignar una forma de pago:
                    $paso_cesta = $iForma_pago;
                } else {
                    $paso_cesta = $iForma_pago + 1;
                }

                //El tipo de envío SIEMPRE es necesario
                if ($tipo_envio == 0) {
                    $paso_cesta = $iTipo_envio;
                }
            }
            //Si tenemos tipo de envío y no es necesaria la forma de pago o la tenemos, nos vamos al paso de las observaciones
            if (($tipo_envio > 0) && ( ($forma_pago > 0) || ($tipo_envio_sin_pago) || ($contra_reembolso) )) {
                $paso_cesta = $iObservaciones;
            }
        }
        //Por último faltan por hacer algunas comprobaciones básicas
        //Vamos a ver si hay algún mensaje de la cesta indicando que el código de descuento no es correcto para mostrarlo
        /*$mensaje_error_cod_dto = $listaSysMsg->findElement(array('origen' => '/^codigo_descuento$/'));
        if ($mensaje_error_cod_dto != NULL) {
            $paso_cesta = 1;
        }*/

        //Si no hay productos, entonces no dejamos pasar del paso 1
        $array_articulos_cesta = Sesion::get('array_articulos_cesta');

        $cantidad_articulos_cesta = count($array_articulos_cesta);
        if ($cantidad_articulos_cesta == 0) {
            $paso_cesta = 1;
        }

        //Todo lo anterior no vale para nada si el cliente no quiere que se pase del paso 1 de forma automática
        if (Shop::$configuracion->cesta_siempre_paso1) {
            if (!$cambiado_paso_cesta) {
                $paso_cesta = 1;
            }
        }

        //Si nos hemos pasado de "paso_cesta" nos vamos al último paso:
        if ($paso_cesta > count($lista_pasos_cesta)) {
            $paso_cesta = count($lista_pasos_cesta);
        }
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            foreach ($lista_pasos_cesta as $clave => $valor) {
                //Convertimos el valor a array porque la clase me convierte el array en un objeto estandar (de la clase stdClass)
                $valor = get_object_vars($valor);
                $indice = $valor['indice'];
                $estado = 'pendiente';
                $texto = traducir($valor['texto']);
                $enlace = corregir_url(Shop::$configuracion->url . traducir($valor['url']));
                $enlace_condicional = $enlace;
                //Si el paso de la cesta es para pagar y no hay que pagar con el tipo de envío seleccionado, incrementamos paso cesta
                if (($tipo_envio_sin_pago || $contra_reembolso) && ( $paso_cesta == $indice ) && ( $valor['pago'] )) {
                    $paso_cesta++;
                    $enlace_condicional = 'javascript:void(0);';
                }
                //Ahora según el paso de la cesta, miraremos a ver si es actual, pendiente o hecho
                if ($paso_cesta == $indice) {
                    $estado = 'actual';
                } else if ($paso_cesta > $indice) {
                    $estado = 'hecho';
                }
                if (($tipo_envio == 0) && ( $valor['tipo_envio_necesario'])) {
                    $enlace_condicional = 'javascript:void(0);';
                }
                if ((($forma_pago == 0) && ( $valor['forma_pago_necesaria'])) && (!(($tipo_envio_sin_pago || $contra_reembolso ) || ($forma_pago > 0)))) {
                    $enlace_condicional = 'javascript:void(0);';
                }

                //Aquí incluimos el fichero
                $ruta_fichero = Theme::findFile($fichero_pasos . '.php');
                if ($ruta_fichero != NULL) {
                    include($ruta_fichero);
                }
            }
            ?>
        </div>
        <?php
    }
    //Guardamos el paso de la cesta en la sesión (para que se pueda usar en consultas remotas vía Ajax
    Sesion::set('paso_cesta', $paso_cesta);
}

/*
  Mostramos el fichero con el formulario de código de descuento
  Parámetros:
  -Opciones
 * fichero_dto => Fichero a utilizar para mostrar el formulario
 */

function codigo_descuento($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');	//TODO ==> Esto se tiene q cambiar también
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
	$datos_usuario = Usuario::logueado();
    if ($datos_usuario != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }
    //Por último cogemos las opciones que nos han pasado:
    $fichero_dto = 'codigo_descuento';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_dto' => $fichero_dto));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_dto = ($opciones->configuracion->fichero_dto != NULL) ? $opciones->configuracion->fichero_dto : $fichero_dto;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_dto . '.php');
            if ($ruta_fichero != NULL) {
                //No hacemos nada de esto si no existe el fichero
                $url_formulario = Shop::$configuracion->url . 'cesta';
                /*$mensaje_error = $listaSysMsg->findElement(array('origen' => '/^codigo_descuento$/'));
                if ($mensaje_error != NULL) {
                    $mensaje_error = $mensaje_error[0]->getCuerpo();
                }*/
                $nombre_campo_codigo_descuento = 'cod_descuento';
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
}

/*
  Mostramos el fichero que muestra el descuento aplicado (si lo hay)
  Parámetros:
  -Opciones
 * fichero_dto => Fichero a utilizar para mostrar el valor del descuento
 */

function codigo_descuento_aplicado($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }

    //Por último cogemos las opciones que nos han pasado:
    $fichero_dto = 'codigo_descuento_aplicado';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_dto' => $fichero_dto));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_dto = ($opciones->configuracion->fichero_dto != NULL) ? $opciones->configuracion->fichero_dto : $fichero_dto;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_dto . '.php');
            if ($ruta_fichero != NULL) {
                //No hacemos nada de esto si no existe el fichero
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
}

/*
  Mostramos el fichero con el formulario de selector tipo de envío
  Parámetros:
  -Opciones
 * fichero_tipo_envio => Fichero a utilizar para mostrar el formulario
 * texto_opcion_0 => Texto a mostrar cuando no hay envío seleccionado
 */
//Pedro 12/Abril/2019 ==> Cambiamos este widget para que funciones SOLO con ficheros personalizables, uno que contiene el selector y otro para cada opción disponible
function selector_tipo_envio($opciones = NULL) {
	$opciones = new ObOptions($opciones);
	$fichero_tipo_envio = $opciones->getDefaultValue('fichero_tipo_envio', 'selector_tipo_envio');
	$fichero_linea_tipo_envio = $opciones->getDefaultValue('fichero_linea_tipo_envio', 'linea_tipo_envio');
	$dataUpdate = $opciones->getDefaultValue('dataUpdate', 'cart|addresses');

	$configuracionWidget = base64_encode(serialize(array(
		'widget' => 'cesta_compra',
		'function' => __FUNCTION__,
		'opciones' => $opciones
	)));
	?>
	<div class="<?= (__FUNCTION__); ?>" data-configuration="<?=$configuracionWidget;?>" data-update="<?=$dataUpdate;?>">
		<?php
		//Pedro 12/Abril/2019 ==> Si falta algún dato en la dirección de envío no seguimos
		$cart = CabeceraCesta::getCart();
		$usuario = $cart->objeto_cliente;
		$direccion_envio = $cart->getCurrentShippingDestination();
		//Lo primero es asegurarnos de que existe el fichero
		$ruta_fichero = Theme::findFile($fichero_tipo_envio . '.php');
		if ($ruta_fichero != NULL){
			//Si no hay usuario, no hay dirección o de la dirección hay datos que faltan, no la mostramos:
			if ( ($usuario == NULL) || ($direccion_envio == NULL) ){
				//COmo no hay que seguir, quiatmos "ruta_fichero"
				$ruta_fichero = NULL;
			}
			if ($ruta_fichero != NULL){
				$a = $direccion_envio;
				if ( (trim($a->nombre) == '' ) || (trim($a->direccion) == '' ) ||(trim($a->cod_postal) == '' ) ||(trim($a->localidad) == '' ) ||(trim($a->provincia) == '' ) ||(trim($a->telefono) == '' ) ){
					$ruta_fichero = NULL;
				}
			}
			if ($ruta_fichero != NULL){
				if ($cart->getEditando() ||$cart->getCreando() ){
					$ruta_fichero = NULL;
				}
			}
		}
		//Después de todos los cálculos, aunque el fichero exista, es posible que no lo mostremos:
		if ($ruta_fichero != NULL) {
			$listaTiposEnvio = TipoEnvioCliente::tipoEnvioTodos();
			//if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
			if (count($listaTiposEnvio) > 0){
				ob_start();
				//if ($resultado) {
				$tipo_producto_cesta = CabeceraCesta::getProductType();
				foreach($listaTiposEnvio as $clave => $valor){
					$mostrar_linea = true;
					//Pedro 15/Mayo/2019 ==> Si el tipo de envío es el de "recogida en tienda" no lo vamos a mostrar
					$obTipoEnvio = $valor;
					if ($obTipoEnvio->codigo == Shop::$configuracion->envio_recogida_tienda){
						//Le pasamos el objeto actual de tipo de envío y el tipo de envío seleccionado actualmente
						$mostrar_linea = false;
					}
					//Para hacer este if he usado una tabla verdad:
					if ( ( ($obTipoEnvio->productos_destino == 'L') || ($obTipoEnvio->productos_destino == 'P') ) &&
							( ($tipo_producto_cesta == 'T') || ($tipo_producto_cesta != $obTipoEnvio->productos_destino) ) &&
							( $tipo_producto_cesta != 'N' ) ){
						$mostrar_linea = false;
					}
					
					if ($mostrar_linea){
						Theme::include_file($fichero_linea_tipo_envio . '.php', $obTipoEnvio);	
					}
				}
				$selector_tipo_envio = ob_get_clean();
				//Ojo, incluimos el ficheor origianl, no buscamos la ruta completa
				Theme::include_file($fichero_tipo_envio . '.php', $selector_tipo_envio);
			}
		}
		?>
	</div>
	<?php
}

/*
  Mostramos el fichero con el tipo de envío seleccionado
  Parámetros:
  -Opciones
 * fichero_tipo_envio => Fichero a utilizar para mostrar el tipo de envío
 */
//Esto desaparecerá:
/*
function tipo_envio_aplicado($opciones = NULL) {
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    $nombre_tipo_envio = nombre_tipo_envio($tipo_envio);
    $descripcion_tipo_envio = descripcion_tipo_envio($tipo_envio);
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }

    //Por último cogemos las opciones que nos han pasado:
    $fichero_tipo_envio = 'tipo_envio_aplicado';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_tipo_envio' => $fichero_tipo_envio));
    }
    if (is_a($opciones, "OpcionesWidget")) {
        $fichero_tipo_envio = ($opciones->configuracion->fichero_tipo_envio != NULL) ? $opciones->configuracion->fichero_tipo_envio : $fichero_tipo_envio;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_tipo_envio . '.php');
            if ($ruta_fichero != NULL) {
                //No hacemos nada de esto si no existe el fichero
                $url_formulario = Shop::$configuracion->url . 'forma_pago';
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
}
*/
/*
  Mostramos el fichero con el formulario de selector de forma de pago
  Parámetros:
  -Opciones
 * fichero_forma_pago => Fichero a utilizar para mostrar el formulario
 * texto_opcion_0 => Texto a mostrar cuando no hay forma de pago seleccionada
 */

function selector_forma_pago($opciones = NULL) {
	$opciones = new ObOptions($opciones);
	$fichero_forma_pago = $opciones->getDefaultValue('fichero_forma_pago', 'selector_forma_pago');
	$fichero_linea_forma_pago = $opciones->getDefaultValue('fichero_linea_forma_pago', 'linea_forma_pago');
	$dataUpdate = $opciones->getDefaultValue('dataUpdate', 'cart|addresses');

	$configuracionWidget = base64_encode(serialize(array(
		'widget' => 'cesta_compra',
		'function' => __FUNCTION__,
		'opciones' => $opciones
	)));
	?>
	<div class="<?= (__FUNCTION__); ?>" data-configuration="<?=$configuracionWidget;?>" data-update="<?=$dataUpdate;?>">
		<?php
		//Pedro 15/Mayo/2019 ==> SI el tipo de envío es de recogida en tienda, no tiene sentido pagarlo?
		//Pedro 12/Abril/2019 ==> Si falta algún dato en la dirección de envío no seguimos
		$cart = CabeceraCesta::getCart();
		$usuario = $cart->objeto_cliente;
		//Lo primero es asegurarnos de que existe el fichero
		$ruta_fichero = Theme::findFile($fichero_forma_pago . '.php');
		if ($ruta_fichero != NULL){
			//Si no hay usuario, no hay dirección o de la dirección hay datos que faltan, no la mostramos:
			if ( ($usuario == NULL) ){
				//COmo no hay que seguir, quiatmos "ruta_fichero"
				$ruta_fichero = NULL;
			}
			
		}
		//Vamos a ver si hay que enseñar la forma de pago:
		
		//¿Hay tipo de envío?:
		$tipo_envio = CabeceraCesta::getShippingType(true);	//Cargamos el tipo de envío indicando que queremos el objeto y no el código
		if ( ($ruta_fichero != NULL) ){
			if ( ($tipo_envio == NULL) || ($tipo_envio->codigo == 0)){
				$ruta_fichero = NULL;
			}else if (!$tipo_envio->requiere_pago){
				//El tipo de envío requiere pago?
				$ruta_fichero = NULL;
			}
		}

		//Después de todos los cálculos, aunque el fichero exista, es posible que no lo mostremos:
		if ($ruta_fichero != NULL) {
			$listaFormasPago = FormasPago::formaPagoTodas();
			//if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
			if (count($listaFormasPago) > 0){
				ob_start();
				//if ($resultado) {
				foreach($listaFormasPago as $clave => $valor){
					$obFormaPago = $valor;
					Theme::include_file($fichero_linea_forma_pago . '.php', $obFormaPago);	//Le pasamos el objeto actual de tipo de envío y el tipo de envío seleccionado actualmente
				}
				$selector_forma_pago = ob_get_clean();
				//Ojo, incluimos el ficheor origianl, no buscamos la ruta completa
				Theme::include_file($fichero_forma_pago . '.php', $selector_forma_pago);
			}
		}
		?>
	</div>
	<?php
}

/*
  Mostramos el fichero con la forma de pago aplicada
  Parámetros:
  -Opciones
 * fichero_forma_pago => Fichero a utilizar para mostrar la forma de pago aplicada
 */

function forma_pago_aplicada($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    $nombre_forma_pago = nombre_forma_pago($forma_pago);
    $descripcion_forma_pago = descripcion_forma_pago($forma_pago);
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }

    //Por último cogemos las opciones que nos han pasado:
    $fichero_forma_pago = 'forma_pago_aplicada';
    $texto_opcion_0 = 'Haga click aquí';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_forma_pago' => $fichero_forma_pago));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_forma_pago = ($opciones->configuracion->fichero_forma_pago != NULL) ? $opciones->configuracion->fichero_forma_pago : $fichero_forma_pago;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_forma_pago . '.php');
            if ($ruta_fichero != NULL) {
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
}

/*
  Mostramos el fichero con el formulario para modificar las observaciones
  Parámetros:
  -Opciones
 * fichero_observaciones => Fichero a utilizar para mostrar el formulario
 */

function observaciones_pedido($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }

    //Por último cogemos las opciones que nos han pasado:
    $fichero_observaciones = 'observaciones_pedido';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_observaciones' => $fichero_observaciones));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_observaciones = ($opciones->configuracion->fichero_observaciones != NULL) ? $opciones->configuracion->fichero_observaciones : $fichero_observaciones;
        $nombre_campo_observaciones = 'observaciones';
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_observaciones . '.php');
            if ($ruta_fichero != NULL) {
                //Vamos a coger las observaciones que haya guardadas en las cookies
                $textoObservaciones = Sesion::getCookieValue('observacionesPedido');
                //No hacemos nada de esto si no existe el fichero
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
        //Aquí vamos a poner el script que cogerá lo que escribamos y lo meta en una cookie
        $nombre_script = 'script_' . incrementa_contador(true);
        ?>
        <script type="text/javascript" id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
                //Buscamos el formulario en cuestión
                var observaciones = elementObjetive.find("form textarea[name='<?= $nombre_campo_observaciones; ?>']");
                if (observaciones.length > 0) {
                    //Si hay un objeto observaciones, vamos a meterle el valor que haya en la cookie correspondiente:
                    var cadena_cookies = document.cookie;
                    var array_cookies = cadena_cookies.split(";");
                    var encontrado = false
                    var observacionesAMostrar = "";
                    for (var i = 0; (i < array_cookies.length) && (!encontrado); i++) {
                        //Recogemos el array con las cookies existentes
                        array_cookies[i] = array_cookies[i].split("=");
                        if (array_cookies[i][0].search("observacionesPedido") >= 0) {
                            //Tenemos un elemento del array articulos cesta, extraemos el índice
                            observacionesAMostrar = array_cookies[i][1];
                            observacionesAMostrar = observacionesAMostrar.replace(/\[enter\]/g, "\r\n");
                            encontrado = true;
                        }
                    }
                    observaciones.val(observacionesAMostrar);
                    observaciones.bind("input propertychange", function () {
                        //console.log("pasa");
                        var texto = $(this).val();
                        texto = texto.replace(/\r?\n/g, "[enter]");
                        document.cookie = "observacionesPedido=" + texto + "; domain=<?= $dominio; ?>;path=<?= $carpeta; ?>;";
                    });
                }
            })();
		});
        </script>
        <?php
    }
}

/*
  Mostramos el fichero que muestra la capa que permite restaurar la cesta
  Parámetros:
  -Opciones
 * fichero_restaurar => Fichero a utilizar para mostrar la opción de restaurar
 */

function cesta_restaurar($opciones = NULL) {
    include('comunes/globals.php');

    $fichero_restaurar = 'restaurar_cesta';
	$dataUpdate = 'bloque_restaurar';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_restaurar' => $fichero_restaurar));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_restaurar = ($opciones->configuracion->fichero_restaurar != NULL) ? $opciones->configuracion->fichero_restaurar : $fichero_restaurar;
		$dataUpdate = ($opciones->configuracion->dataUpdate != NULL) ? $opciones->configuracion->dataUpdate : $dataUpdate;
		$configuracionWidget = base64_encode(serialize(array(
					'widget' => 'cesta_compra',
					'function' => 'cesta_restaurar',
					'opciones' => $opciones
				)));
        ?>
        <div class="<?= (__FUNCTION__); ?>"  data-configuration="<?=$configuracionWidget;?>" data-update="<?=$dataUpdate;?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_restaurar . '.php');
            if ($ruta_fichero != NULL) {
                //No hacemos nada de esto si no existe el fichero
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
}

/*
  Mostramos el fichero con el widget de las direcciones de envío
  Parámetros:
  -Opciones
 * widget_direcciones => Widget a utilizar para mostrar las direcciones
 * widget_login => widget a utilizar para que el usuario haga login si es necesario
 */

function direcciones_envio_pedido($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos los valores que ya están definidos en el fichero
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    $cod_descuento = Sesion::get('cod_descuento');
    //Cargamos otras  variables disponobles en el fichero de la Base de Datos
    $tipo_envio_sin_pago = false;
    $contra_reembolso = false;
    if ($tipo_envio > 0) {
        $tipo_envio_sin_pago = getEnvioSinPago($tipo_envio);
        $contra_reembolso = getEnvioReembolso($tipo_envio);
    }
    //Vamos a coger una variable temporal con el código del cliente
    $cod_cliente = 0;
    if (Usuario::logueado() != NULL) {
        $cod_cliente = $datos_usuario->codigo;
    }

    //Por último cogemos las opciones que nos han pasado:
    $widget_login = new Widget($_WH->GW('usuario', 'login', 'php', false), '', true);
    $widget_direcciones = new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada', 'php', false));
    $widget_datos_envio = new Widget($_WH->GW('usuario', 'peticion_datos_sin_registro', 'php', false));
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $widget_login = ($opciones->configuracion->widget_login != NULL) ? $opciones->configuracion->widget_login : $widget_login;
            $widget_direcciones = ($opciones->configuracion->widget_direcciones != NULL) ? $opciones->configuracion->widget_direcciones : $widget_direcciones;
            $widget_datos_envio = ($opciones->configuracion->widget_datos_envio != NULL) ? $opciones->configuracion->widget_datos_envio : $widget_datos_envio;
            $envioSinEnvio = envioSinEnvio($tipo_envio);
            if (!Shop::$configuracion->pedidos_sin_login) {
                //Pedidos sin login no permitidos, controlamos que el usuario esté logueado
                if (Usuario::logueado() != NULL) {
                    if ($envioSinEnvio != 1) {
                        //Hay que añadir el widget de direcciones
                        if ($widget_direcciones == NULL) {
                            //Vamos a mostrar la dirección predeterminada
                            new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada'), $opciones);
                            //Añadimos el botón de modificar
                            ?>
                            <a href="<?= Shop::$configuracion->url; ?>mis_direcciones" title="<?= traducir('Modificar'); ?>"><?= traducir('Modificar'); ?></a>
                            <?php
                        } else {
                            if (is_a($widget_direcciones, 'Widget')) {
                                $widget_direcciones->mostrar();
                            }
                        }
                    }
                } else {
                    if (($widget_login == NULL) || !is_a($widget_login, 'Widget')) {
                        //Es necesario el login
                        ?>
                        <p class="login_necesario"><?= traducir('Para poder finalizar el pedido es necesario que se identifique en nuestra página web'); ?></p>
                        <?php
                        new Widget($_WH->GW('usuario'), '', true);
                        //new Widget($_WH->GW("usuario", "btnRegistro"));
                    } else {
                        $widget_login->mostrar();
                    }
                }
            } else {
                if (Usuario::logueado() == NULL) {
                    //Debido a la falta de tiempo cambiamos este orden a uno más comun @Tomas 29/11/16
                    //además, si nos han pasado un widget de login, lo mostramos
                    if (($widget_login != NULL) && (is_a($widget_login, "Widget"))) {
                        //Es necesario el login
                        $widget_login->mostrar();
                    }
                    //Mostramos el widget de las direcciones, si no nos lo han pasado, entonces lo creamos a manubrio
                    if (!is_a($widget_datos_envio, 'Widget')) {
                        new Widget($_WH->GW('usuario', 'peticion_datos_sin_registro'));
                    } else {
                        $widget_datos_envio->mostrar();
                    }
                } else {
                    //El usuario está logueado, vamos a mostrar las direcciones
                    if ($widget_direcciones == NULL) {
                        //Vamos a mostrar la dirección predeterminada
                        new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada'), $opciones);
                        //Añadimos el botón de modificar
                        ?>
                        <a href="<?= Shop::$configuracion->url; ?>mis_direcciones" title="<?= traducir('Modificar'); ?>"><?= traducir('Modificar'); ?></a>
                        <?php
                    } else {
                        if (is_a($widget_direcciones, 'Widget')) {
                            $widget_direcciones->mostrar();
                        }
                    }
                }
            }
            ?>
        </div>
        <?php
    }
}

/**
  Mostramos el fichero que muestra la capa que permite vaciar la cesta
  Parámetros:
  No hay parámetros (por ahora)
 */
function cesta_vaciar($opciones = NULL) {
    include('comunes/globals.php');
    //Vamos a coger una variable temporal con el código del cliente
	$capas_actualizar = '*=\\\'bloque_total_cesta\\\'|*=\\\'bloque_tipo_envio\\\'|*=\\\'bloque_lineas\\\'|*=\\\'bloque_restaurar\\\'';
    ?>
    <div class="<?= (__FUNCTION__); ?>">
		<a href="javascript:void(0);" onclick="var cadena_consulta = '<?= html_entity_decode(traducir('¿Desea vaciar la cesta por completo?\nEsta operación no tiene marcha atrás.')); ?>';if (confirm(cadena_consulta)) {emtpyCart('<?=$capas_actualizar;?>');};" >Vaciar</a>
    </div>
    <?php
}

/*
  Mostramos las líneas de la cesta
  Parámetros:
  $fichero_lineas => Fichero que contiene la línea de la cesta
 */
 
 function linea_cesta($opciones) {
    include('comunes/globals.php');
	
    $cod_cliente = 0;
	$datos_usuario = Usuario::logueado();
	if ($datos_usuario != NULL){
		$cod_cliente = $datos_usuario->codigo;
	}
	$opciones = new ObOptions($opciones);
	$fichero_linea = $opciones->getDefaultValue('fichero_linea', 'linea_cesta');
	$objeto_linea = $opciones->getDefaultValue('objeto_linea', NULL);
	$tipoCapaContenedoraLineas = $opciones->getDefaultValue('tipoCapaContenedoraLineas', 'div');
	$dataUpdateLineas = $opciones->getDefaultValue('dataUpdateLineas', 'bloque_linea');
	$codigoCabecera = $opciones->getDefaultValue('codigoCabecera', 0);
	$codigoLinea = $opciones->getDefaultValue('codigoLinea', '0');
			
	//var_dump($objeto_linea);
			
	//Si no recibimos el objeto de línea vamos a ver si la podemos cargar por código de pedido y código de línea:
	if ($objeto_linea == NULL){
		if ( ($codigoCabecera > 0) && ($codigoLinea > 0) ){
			$nOpciones = array('codigoPedido' => $codigoCabecera, 'codigoLinea' => $codigoLinea);
			$objeto_linea = new LineaCesta($nOpciones);
		}
	}

	if ($objeto_linea != NULL){
			//Para hacer la carga con javascript no podemos pasar el objeto entero, pasamos los códigos:
			$opciones = array(
				'codigoCabecera' => $objeto_linea->cabecera,
				'codigoLinea' => $objeto_linea->codigo,
				'fichero_linea' => $fichero_linea,
				'tipoCapaContenedoraLineas' => $tipoCapaContenedoraLineas,
				'dataUpdateLineas' => $dataUpdateLineas
			);

			$configuracionWidget = base64_encode(serialize(array(
				'widget' => 'cesta_compra',
				'function' => __FUNCTION__,
				'opciones' => $opciones
			)));

			if ($tipoCapaContenedoraLineas != ''){
				//Si tenemos un data update para las líneas, vamos a añadirle el código del artículo:
				if ($dataUpdateLineas != ''){
					$dataUpdateLineas .= '_articulo_' . $objeto_linea->articulo;
				}
				?>
				<<?=$tipoCapaContenedoraLineas;?> data-configuration="<?=$configuracionWidget;?>" class="linea_cesta contenedor_linea_cesta" data-update="<?=$dataUpdateLineas;?>">
				<?php
			}
			if ($objeto_linea->codigo > 0){	//Sólo así sabremos si la línea se ha cargado
				//La variable "objeto_linea" ya está aquí inicializada
				Theme::include_file($fichero_linea . '.php', $objeto_linea);
			}
			if ($tipoCapaContenedoraLineas != ''){
			?>
				</<?=$tipoCapaContenedoraLineas;?>>
			<?php
		}
	}
 }

function lineas_cesta($opciones) {
    include('comunes/globals.php');
    $cod_cliente = 0;
	$datos_usuario = Usuario::logueado();
	if ($datos_usuario != NULL){
		$cod_cliente = $datos_usuario->codigo;
	}
	
	$opciones = new ObOptions($opciones);
	$fichero_linea = $opciones->getDefaultValue('fichero_linea', 'linea_cesta');
	$tipoCapaContenedora = $opciones->getDefaultValue('tipoCapaContenedora', 'div');
	$tipoCapaContenedoraLineas = $opciones->getDefaultValue('tipoCapaContenedoraLineas', 'div');
	$dataUpdate = $opciones->getDefaultValue('dataUpdate', 'cart');
	$dataUpdateLineas = $opciones->getDefaultValue('dataUpdateLineas', 'bloque_linea');
	$widget_login = $opciones->getDefaultValue('widget_login', NULL);
	$fichero_cabecera_lote = $opciones->getDefaultValue('fichero_cabecera_lote', 'cab_lote_linea.php');
	$fichero_pie_lote = $opciones->getDefaultValue('fichero_pie_lote', 'pie_lote_linea.php');
	
	//Ahora toca mostrar las líneas
	//Capturamos la cesta de la sesión:
	$cesta = CabeceraCesta::getCart();
	$lineas = $cesta->lineas;

	
	//Para saber el tipo de líneas a utilizar, vamos a crear una capa donde aglutinar a las líneas de la cesta
	$configuracionWidget = base64_encode(serialize(array(
		'widget' => 'cesta_compra',
		'function' => __FUNCTION__,
		'opciones' => $opciones
	)));
	if ((Shop::$configuracion->cesta_login_inicio) && (Usuario::logueado() == NULL)) {
		//El login es necesario:
		if (($widget_login == NULL) || !is_a($widget_login, 'Widget')) {
			//Es necesario el login
			?>
			<p class="login_necesario"><?= traducir('Para poder finalizar el pedido es necesario que se identifique en nuestra página web'); ?></p>
			<?php
			new Widget($_WH->GW('usuario'), '', true);
			//new Widget($_WH->GW("usuario", "btnRegistro"));
		} else {
			$widget_login->mostrar();
		}
	} else {
		if ($tipoCapaContenedora != ''){
			$configuracionWidget = base64_encode(serialize(array(
				'widget' => 'cesta_compra',
				'function' => 'lineas_cesta',
				'opciones' => $opciones
			)));
?>
		<<?=$tipoCapaContenedora;?> data-configuration="<?=$configuracionWidget;?>" data-update="<?=$dataUpdate;?>" data-configuration="<?=$configuracionWidget;?>">
<?php
		}
		//Antes de continuar, vamos a agrupar las líneas poniendo primero NO lotes y después el resto:
		foreach (array_filter($lineas, 'CabeceraCesta::sin_lotes') as $clave => $linea){
			$opciones->objeto_linea = $linea;
			new Widget($_WH->GW('cesta_compra', 'linea_cesta'), $opciones);
		}
	 
		//Ahora toca sacar sólo los lotes respetando el oden de entrada
		$ultimo_lote = 0;
		$ultimo_objeto_lote = NULL;
		$ultimo_special_id = '';
		foreach (array_filter($lineas, 'CabeceraCesta::con_lotes') as $clave => $linea){
			if ( ($ultimo_lote != $linea->codigo_lote) || ($ultimo_special_id != $linea->special_id) ){
				//Pedro 27/Julio/2019 ==> Vamos a mandar también la línea en la que estamos para poder obtener el detalle que necesitemos
				//Si el último lote es > 0, hay que mostrar el pie:
				if ($ultimo_lote > 0){
					Theme::include_file($fichero_pie_lote, $ultimo_objeto_lote, $linea);
				}
				//Si el lote actual es > 0, mostraoms la cabecera:
				if ($linea->codigo_lote > 0){
					Theme::include_file($fichero_cabecera_lote, $linea->lote, $linea);
				}
				$ultimo_lote = $linea->codigo_lote;
				$ultimo_special_id = $linea->special_id;
			}
			$opciones->objeto_linea = $linea;
			$ultimo_objeto_lote = $linea->lote;
			new Widget($_WH->GW('cesta_compra', 'linea_cesta'), $opciones);
		}
		//Llegados a este punto, vamos a controlar si hay que meter el pie del lote otra vez:
		if ($ultimo_lote > 0){
			Theme::include_file($fichero_pie_lote, $linea->lote);
		}
		
		
		
		/*
		foreach($lineas as $clave => $linea){
			$opciones->objeto_linea = $linea;
			new Widget($_WH->GW('cesta_compra', 'linea_cesta'), $opciones);
		}
		*/
		
		
		if ($tipoCapaContenedora != ''){
?>
	</<?=$tipoCapaContenedora;?>>
<?php
		}
	}
    return(true);
}

/*
  Mostramos las líneas de la cesta
  Parámetros:
  $fichero_pie_cesta => Fichero que contiene el pie a mostrar
 */

function pie_cesta_perso($opciones = NULL) {
    include('comunes/globals.php');
    //Cogemos los valores de la sesión
    $tipo_envio = Sesion::get('tipo_envio');
    $forma_pago = Sesion::get('forma_pago');
    //Cogemos datos relevantes del envio y forma de pago en función del tipo de envío y forma de pagao
    $reembolso = getEnvioReembolso($tipo_envio);
    $sin_pago = getEnvioSinPago($tipo_envio);
    $pasarela = getPasarela($forma_pago);
    $nombre_pasarela = getNombrePasarela($forma_pago);

    //Vamos a obtener el resto de datos del pedido
    $fichero_pie_cesta = 'pie_cesta';
    $lista_pasos_cesta = array();
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget(array('fichero_pie_cesta' => $fichero_pie_cesta));
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_pie_cesta = ($opciones->configuracion->fichero_pie_cesta != NULL) ? $opciones->configuracion->fichero_pie_cesta : $fichero_pie_cesta;
        //var_dump($opciones->getElements());
        $lista_pasos_cesta = ($opciones->elementos != NULL) ? $opciones->getElements() : array();
        //Si no hay pasos creados, vamos a crearlos nosotros:
        if (count($lista_pasos_cesta) == 0) {
            $lista_pasos_cesta[] = array('indice' => 1, 'texto' => 'Continuar', 'url' => 'tipo_envio');
            $lista_pasos_cesta[] = array('indice' => 2, 'texto' => 'Continuar', 'url' => 'forma_pago');
            $lista_pasos_cesta[] = array('indice' => 3, 'texto' => 'Continuar', 'url' => 'resumen_compra');
            $lista_pasos_cesta[] = array('indice' => 4, 'texto' => 'Finalizar pedido', 'url' => '');
        }
        /*echo("<pre>");
        var_dump($lista_pasos_cesta);
        echo("</pre>");
        */
        //Vamos a definir las variables a usar:
        //var_dump($lista_pasos_cesta[$paso_cesta - 1]);
        //Pedro 17/Mayo/2017 ==> Puede que nadie haya definido el paso de cesta por el que voy, en este caso lo inicializamos al primer paso:
        $paso_cesta = ($paso_cesta == 0) ? 1 : $paso_cesta;
        
        $url_continuar = ($lista_pasos_cesta[$paso_cesta - 1]['url'] != '') ? Shop::$configuracion->url . $lista_pasos_cesta[$paso_cesta - 1]['url'] : 'javascript:void(0);';
        $texto_continuar = $lista_pasos_cesta[$paso_cesta - 1]['texto'];
        $script_finalizar = '';

        //Si estamos en el último paso:
        if ($lista_pasos_cesta[count($lista_pasos_cesta) - 1]['indice'] == $paso_cesta) {
            $listo_para_finalizar = true;
            //Si admitimos pedidos sin login, tenemos que controlar el tema de las direcciones
            if (Shop::$configuracion->pedidos_sin_login) {
                $listo_para_finalizar = false;
                //Empezamos comprobando si hemos recibido los datos del formulario
                $accion = dame_valor_variable_global('accion', '');
                $modificar_datos_envio = dame_valor_variable_global('modificar_datos_envio', '');
                if ($accion == 'datos_usuario') {
                    //Ahora asignamos los datos que necesitamos:
                    $texto_continuar = 'Continuar';
                    $url_continuar = 'javascript:void(0);';
                } else if (($datos_usuario_sin_registro != NULL) && (strtoupper($modificar_datos_envio) != 'MODIFICAR')) {
                    //Tenemos ya los datos de un usuario,Los botones de finalizar tienen que ser los normales
                    $listo_para_finalizar = true;
                } else {
                    //Si el usuario ha hecho login, hacemos una cosa
                    if (Usuario::logueado() != NULL) {
                        $listo_para_finalizar = true;
                    } else {
                        //No tenemos nada aún, estamos a la espera de que el usuario rellene sus datos
                        $texto_continuar = 'Continuar';
                        //el script tiene que enviar el formulario de datos de usuario
                        $nombre_funcion = 'enviar_datos_cliente' . incrementa_contador();
                        ?>
                        <script>
                            function <?= $nombre_funcion; ?>() {
                                $("form.registro_simple").submit();
                            }
                        </script>
                        <?php
                        $script_finalizar = ' onclick="' . $nombre_funcion . '();" ';
                        $url_continuar = "javascript:void(0);";
                    }
                }
            } else if (Usuario::logueado() == NULL) {
                $listo_para_finalizar = false;
            }
            //Si tenemos tipo de envío y (tenemos tipo de pago o no hace falta)
            if (($tipo_envio > 0) && ( ($forma_pago > 0) || ( $reembolso || $sin_pago ) )) {
                //Se supone que ya tenemos guardado el pedido de cliente
                if ($listo_para_finalizar) {
                    //Aquí hay que generar todo lo referente a la pasarela de pago
                    if (($reembolso) || ($sin_pago) || (!$pasarela)) {
                        //Todo OK, se puede hacer el pedido
                        $url_continuar = "javascript:void(0);";
                        $texto_continuar = traducir('Finalizar compra');
                        $script_finalizar = ' onclick="modificar_obs_pedido(' . $cod_pedido . ');" ';
                        //Vamos a crear el script para modificar las observaciones del pedido
                        ?>
                        <script type="text/javascript">
                            function modificar_obs_pedido(pedido) {
                                var cadena_cookies = document.cookie;
                                var array_cookies = cadena_cookies.split(";");
                                //Cogemos las observaciones:
                                var encontrado = false;
                                var observaciones = "";
                                for (var i = 0; (i < array_cookies.length) && (!encontrado); i++) {
                                    //Recogemos el array con las cookies existentes
                                    array_cookies[i] = array_cookies[i].split("=");
                                    if (array_cookies[i][0].search("observacionesPedido") >= 0) {
                                        //Tenemos un elemento del array articulos cesta, extraemos el índice
                                        observaciones = array_cookies[i][1];
                                        observaciones = observaciones.replace(/\[enter\]/g, "\r\n");
                                        encontrado = true;
                                    }
                                }
                                var parametros = "pedido=" + pedido + "&observaciones=" + observaciones + "&hash=<?= genera_cod_seguridad(); ?>";
                                var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/pedidos_guardar_observaciones.php";
                                realizar_solicitud(url, parametros, function (respuesta) {
                                    window.location = "<?= Shop::$configuracion->url; ?>finalizar_compra/" + pedido;
                                });
                            }
                        </script>
                        <?php
                    } else {
                        //En la mayoría de los casos, este pedido se paga por pasarela, vamos a cargarla
                        //Hacemos el include del formulario de la pasarela
                        $ruta_fichero = Theme::findFile($nombre_pasarela . ".php");
                        if ($ruta_fichero != NULL) {
                            include($ruta_fichero);
                            //Insertamos aquí un script que va a utilizar el formulario anterior para enviarlo cuando se guarden las observaciones
                            ?>
                            <script type="text/javascript">
							document.addEventListener('WSLE', function(event) {
                                var scripts = document.getElementsByTagName('script');
                                var thisScriptTag_pass = scripts[ scripts.length - 1 ];
                                var formObjetive = $(thisScriptTag_pass).prev();
							});
							function modificar_obs_pedido_<?= $nombre_pasarela; ?>(pedido) {
								var cadena_cookies = document.cookie;
								var array_cookies = cadena_cookies.split(";");
								//Cogemos las observaciones:
								var encontrado = false;
								var observaciones = "";
								for (var i = 0; (i < array_cookies.length) && (!encontrado); i++) {
									//Recogemos el array con las cookies existentes
									array_cookies[i] = array_cookies[i].split("=");
									if (array_cookies[i][0].search("observacionesPedido") >= 0) {
										//Tenemos un elemento del array articulos cesta, extraemos el índice
										observaciones = array_cookies[i][1];
										observaciones = observaciones.replace(/\[enter\]/g, "\r\n");
										encontrado = true;
									}
								}
								var parametros = "pedido=" + pedido + "&observaciones=" + observaciones + "&hash=<?= genera_cod_seguridad(); ?>";
								var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/pedidos_guardar_observaciones.php";
								realizar_solicitud(url, parametros, function (respuesta) {
									formObjetive.submit();
								});
							}
                            </script>
                            <?php
                            $script_finalizar = ' onclick="modificar_obs_pedido_' . $nombre_pasarela . '(' . $cod_pedido . ');" ';

                            $url_continuar = "javascript:void(0);";
                            $texto_continuar = traducir("Finalizar compra");
                        } else {
                            echo(traducir('Ha ocurrido un error al intentar cargar la pasarela de pago'));
                        }
                        $contenido_form_pasarela = ''; //En esta variable vamos a meter el formulario de la pasarela
                    }
                }
            }
        }
        //Vamos a meter aquí el trozo de código html
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
            $ruta_fichero = Theme::findFile($fichero_pie_cesta . '.php');
            if ($ruta_fichero != NULL) {
                //No hacemos nada de esto si no existe el fichero
                //hacemos el include del fichero en cuestión
                include($ruta_fichero);
            }
            ?>
        </div>
        <?php
    }
    return(true);
}

/*
  Mostramos las líneas de la cesta
  Parámetros:
  $fichero_pie_cesta => Fichero que contiene el pie a mostrar
 */

function cesta_desplegableV2($opciones = NULL) {
    include('comunes/globals.php');
    /* la cesta desplegable contiene los siguientes elementos
      ->Desplegador => elemento que al ponerse encima desplegará la cesta
      ->contenido-mini-cesta:
      L>cesta_vaciar
      L>cesta_restaurar
      L>cabecera_cesta
      L>lineas_cesta
      L>totales_cesta
      Todo eso son ficheros html a cargar, excepto el fichero de vaciar, que es un widget a secas, aquí también será fichero, pero como no lleva recálculos, usaremos el pie cesta que no lleva recálculos
    */
    //$cantidad_cesta = ($cantidad_cesta > 0) ? $cantidad_cesta : 0;
	$opciones = new ObOptions($opciones);
	$fichero_desplegador = $opciones->getDefaultValue('fichero_desplegador', 'desplegador_cesta');
	$fichero_cabecera = $opciones->getDefaultValue('fichero_cabecera', 'cabecera_mini_cesta');
	$dataUpdateCabecera = $opciones->getDefaultValue('dataUpdateCabecera', 'bloque_total_cesta');
	$fichero_vaciar = $opciones->getDefaultValue('fichero_vaciar', 'vaciar_mini_cesta');
	$dataUpdateVaciar = $opciones->getDefaultValue('dataUpdateVaciar', 'bloque_vaciar');
	$fichero_restaurar = $opciones->getDefaultValue('fichero_restaurar', 'restaurar_mini_cesta');
	$dataUpdateRestaurar = $opciones->getDefaultValue('dataUpdateRestaurar', 'bloque_restaurar');
	$fichero_linea = $opciones->getDefaultValue('fichero_linea', 'linea_mini_cesta');
	$dataUpdateLineas = $opciones->getDefaultValue('dataUpdateLineas', 'bloque_lineas');
	$dataUpdateLinea = $opciones->getDefaultValue('dataUpdateLinea', 'bloque_linea');
	$fichero_totales = $opciones->getDefaultValue('fichero_totales', 'totales_mini_cesta');
	$dataUpdateTotales = $opciones->getDefaultValue('dataUpdateTotales', 'bloque_total_cesta');
	$opcionesDesplegable = $opciones->getDefaultValue('opcionesDesplegable', NULL);

	//Vamos a crear el 'desplegador' de la cesta
	$nOpciones = new OpcionesWidget(array('ruta_fichero' => $fichero_desplegador, 'dataUpdate' => 'bloque_total_cesta'));
	$widget_lanzador = new Widget($_WH->GW('cesta_compra', 'totales_cesta', 'php', false), $nOpciones);
	//Ahora creamos la cesta que se va a desplegar
	$tipo = 'dropDown';
	if ($opcionesDesplegable != NULL){
		$tipo = ($opcionesDesplegable->type != NULL) ? $opcionesDesplegable->type : $tipo;
	}
	
	
	$widget_lanzado = new Widget(array('tipo' => $tipo, 'ejecutar' => false, 'opciones' => $opcionesDesplegable));
	//echo("antes\n");
	
	$widget_lanzado->record();
	?>
	<div class="contenedor_cesta_desplegable">
	<?php
		//Cabecera
		$nOpciones = new OpcionesWidget(array('ruta_fichero' => $fichero_cabecera, 'dataUpdate' => $dataUpdateCabecera));
		new Widget($_WH->GW('cesta_compra', 'totales_cesta'), $nOpciones);
		//Vaciar
		$nOpciones = new OpcionesWidget(array('ruta_fichero' => $fichero_vaciar, 'dataUpdate' => $dataUpdateVaciar));
		new Widget($_WH->GW('cesta_compra', 'totales_cesta'), $nOpciones);
		//Restaurar
		$nOpciones = new OpcionesWidget(array('fichero_restaurar' => $fichero_restaurar, 'dataUpdate' => $dataUpdateRestaurar));
		new Widget($_WH->GW('cesta_compra', 'cesta_restaurar'), $nOpciones);
		//Líneas cesta
		$nOpciones = new OpcionesWidget(array('fichero_linea' => $fichero_linea, 'dataUpdate' => $dataUpdateLineas, 'dataUpdateLineas' => $dataUpdateLinea));
		new Widget($_WH->GW('cesta_compra', 'lineas_cesta'), $nOpciones);
		//Totales
		$nOpciones = new OpcionesWidget(array('ruta_fichero' => $fichero_totales, 'dataUpdate' => $dataUpdateTotales));
		new Widget($_WH->GW('cesta_compra', 'totales_cesta'), $nOpciones);
	?>
	</div>
	<?php
	$widget_lanzado->record();
	
	//echo("despues\n");
	$widget_lanzado->cambia_tipo('dropDown');
	
	?>
	<div class="<?= (__FUNCTION__); ?>">
		<?php
		//Si hay que iniciar sesión y no está iniciada, entonces no mostramos el desplegable
		if ((Shop::$configuracion->cesta_login_inicio) && (Usuario::logueado() == NULL)) {
			$widget_lanzador->mostrar();
		} else {
			$lanzador_widget_cesta = new Widget(LW_params(), $widget_lanzado, $widget_lanzador, 'div', 'onmouseenter');
		}
		?>
	</div>
	<?php
	
}

//------------------------------------------------------------------------------------------------------------------------------
//Funciones extra que utiliza este widget
//------------------------------------------------------------------------------------------------------------------------------
function getEnvioSinPago($tipo_envio) {
    include('comunes/globals.php');
    $tipo_envio_sin_pago = false;
    $sentencia_sql = "SELECT sin_pago FROM tipo_envio_cli WHERE codigo = $tipo_envio";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                if ($fila["sin_pago"] == 1) {
                    $tipo_envio_sin_pago = true;
                }
            }
        }
    }
    return($tipo_envio_sin_pago);
}

function getEnvioReembolso($tipo_envio) {
    include('comunes/globals.php');
    $contra_reembolso = false;
    $sentencia_sql = 'SELECT reembolso FROM tipo_envio_cli WHERE codigo = ' . $tipo_envio;
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                if ($fila['reembolso'] == 1) {
                    $contra_reembolso = true;
                }
            }
        }
    }
    return($contra_reembolso);
}

function getPasarela($forma_pago) {
    include('comunes/globals.php');
    $pasarela = false;
    $sentencia_sql = "SELECT pasarela FROM formas_de_pago WHERE codigo = $forma_pago";
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $pasarela = $fila['pasarela'];
            }
        }
    }
    return($pasarela);
}

function getNombrePasarela($forma_pago) {
    include('comunes/globals.php');
    $nombre_pasarela = false;
    $sentencia_sql = 'SELECT nombre FROM formas_de_pago WHERE codigo = ' . $forma_pago;
    if ($conexionBD) {
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            if ($fila = mysqli_fetch_array($resultado)) {
                $nombre_pasarela = $fila['nombre'];
            }
        }
    }
    return($nombre_pasarela);
}

function cestaInsertaScriptOnChangeSelect($url_formulario, $nombre_select) {
    $nombre_script = 'script_' . incrementa_contador(true);
    ?>
    <script type="text/javascript" id="<?= $nombre_script; ?>">
	document.addEventListener('WSLE', function(event) {
        ;(function () {
            var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
            //Buscamos el formulario en cuestión
            var formulario = elementObjetive.find('form[action^="<?= $url_formulario; ?>"]');
            if (formulario.length > 0) {
                //Hay que determinar si es con radiobutton o con select
                if (formulario.find("select").length > 0) {
                    formulario.find("select[name='<?= $nombre_select; ?>']").on("change", function () {
                        var tipo = $(this).val();
                        if (tipo > 0) {
                            formulario.submit();
                        }
                    });
                } else if (formulario.find("input[type='radio']").length > 0) {
                    formulario.find("input[type='radio'][name='<?= $nombre_select; ?>']").on("click", function () {
                        $(this).prop('checked', true);
                        $(this).attr('checked', 'checked');
                        //console.log($(this));
                        formulario.submit();
                    });
                }
            }
        })();
	});
    </script>
    <?php
}
?>
