<?php

//---------------------------------------------------------------------------------------------------------
// 21/Mayo/2015
// Versión 1.0 Widget que se usa para mostrar información referente a los lotes
//---------------------------------------------------------------------------------------------------------



function widget_lotes() {
	include('comunes/globals.php');
	//Aquí definimos una serie de parámetros que necesitamos
	$funcion_por_defecto = 'muestra_lote';
	$parametros_por_defecto = array();
	$parametros_recibidos = func_get_args();
	if (count($parametros_recibidos) == 0) {
		$parametros_recibidos[0] = $funcion_por_defecto;
	} else {
		if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
			$parametros_recibidos[0] = $funcion_por_defecto;
		}
	}
	$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
	$retorno = false;
	//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
	if (count($parametros_recibidos) > 0) {
		//Recogemos el nombre de la función de entre el resto de parámetros
		$nombre_funcion = $parametros_recibidos[0];
		//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
		$parametros_recibidos = array_slice($parametros_recibidos, 1);
		//Si la función existe la ejecutamos
		if (function_exists($nombre_funcion)) {
			$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
		}
	}
	return($retorno);
}

function muestra_lote($codigo_lote = 0) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($codigo_lote != NULL) && (is_a($codigo_lote, "OpcionesWidget"))) {
		$opciones = $codigo_lote;
		$codigo_lote = 0;
		if (is_a($opciones, 'OpcionesWidget')) {
			$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : $codigo_lote;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	$obj_lote = new Lote($codigo_lote);
	$retorno = false;
	if ($obj_lote->codigo > 0) {
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<?php
			/*
			  echo '<pre>';
			  print_r($obj_lote);
			  echo '</pre>'; */
			?>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
	return($retorno);
}

function venta_lote($codigo_lote = 0, $fichero = 'linea_venta_lote') {
	//include('comunes/globals.php');
	$ocultarCabecera = false;
	$lote_a_mostrar = NULL;
	$fichero = 'linea_venta_lote';
	$accion = 'absoluto';
	if (is_a($codigo_lote, "OpcionesWidget")){
		$opciones = $codigo_lote;
		$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : 0;
		$lote_a_mostrar = ($opciones->configuracion->objeto_lote != NULL) ? $opciones->configuracion->objeto_lote : NULL;
		$fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		$accion = ($opciones->configuracion->accion != NULL) ? $opciones->configuracion->accion : $accion;
	}
	if ($lote_a_mostrar == NULL){
		$lote_a_mostrar = new Lote($codigo_lote);
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<form class="form_venta_lote" action="<?= Shop::$configuracion->url; ?>venta_lote/<?=$lote_a_mostrar->nombre;?>" method="post">
			<input type="submit" name="Comprar" value="Comprar" />
			<input type="hidden" value="<?= $lote_a_mostrar->codigo; ?>" name="cod_lote" />
			<?php
			//Aquí hay que meter el descuento activo del lote
			/*
			//Vamos a mirar si ya hay descuento de lote
			if (!is_numeric($codigo_lote)) {
				$indice_dto_lote = lote::codigo_de_nombre($codigo_lote);
			} else {
				$indice_dto_lote = $codigo_lote;
			}
			$indice_dto_lote = lote::buscar_dto_lote($indice_dto_lote);
			$cod_dto_lote_actual = "";
			$porcen_dto_actual = 0;
			if ($indice_dto_lote > -1) {
				$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
				$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
				$porcen_dto_actual = $cod_dto_lote_actual[1];
				$cod_dto_lote_actual = $cod_dto_lote_actual[2];
			}
			*/
			/*
			?>
			<input type="hidden" name="porcen_dto_lote" value="<?= $porcen_dto_actual; ?>" />
			<input type="hidden" name="cod_dto_lote" value="<?= $cod_dto_lote_actual; ?>" />
			<?php
			*/
			//$contador_lineas = 0;
			/* echo("<!--");
			  print_r($lote_a_mostrar);
			  echo("-->");
			 */
			$lista_no_optativas = '';
			$lista_optativas = '';
			foreach ($lote_a_mostrar->lineas_lote as $clave => $valor) {
				ob_start();
				//$articulo_a_mostrar = $valor->obj;
				$linea_lote_a_mostrar = $valor;
				$identificador_linea = $linea_lote_a_mostrar->mc_lote . '_' . $linea_lote_a_mostrar->codigo;
				?>
				<fieldset class="linea_venta_lote linea_<?=$linea_lote_a_mostrar->mc_lote;?> elemento[<?=$identificador_linea;?>]" onclick="$(this).find('input[type=\'radio\']').prop('checked', true);$(this).closest('form').find('input[type=\'submit\']').show();">
				<?php
					//Pedro 07/Junio/2019 ==> Según si trabaja cantidades y PVP hacemos una cosa y otra
					if ($linea_lote_a_mostrar->trabaja_cantidades_pvp){
						//El input de la cantidad va oculto:
					?>
						<input type="hidden" name="cantidad_lote[<?=$identificador_linea;?>]" value="<?= $linea_lote_a_mostrar->cantidad_en_cesta(); ?>" />
					<?php
						//Además según sea optativa a o no mostramos un input o un check bloqueado:
						if ($linea_lote_a_mostrar->optativa){
							//Los radiobutton tienen que ser comunes al lote, usamos el código del mismo
							/*
							//TaTiana 19-06-17=> cambio el checked y lo quito a peticion de sergio. 
 							?>
							<input type="radio" name="selector[<?=$linea_lote_a_mostrar->mc_lote;?>]" value="<?=$linea_lote_a_mostrar->articulo;?>" <?=($selected) ? ' checked="checked"' : '';?>>
							<?php*/
							?>
							<input type="radio" name="selector[<?=$linea_lote_a_mostrar->mc_lote;?>]" value="<?=$linea_lote_a_mostrar->articulo;?>" required>
							<?php
							//Esta variable es para que siempre esté seleccionada la primera
						}else{
							//Los check son independientes, usamos el identificador para la línea
							?>
							<input type="checkbox" name="selector[<?=$identificador_linea;?>]" checked="checked" disabled="disabled">
							<?php
						}
					}else{
					?>
						<div class="cantidad">
							<div class="lote_menos">
								<a class="boton_menos" href="javascript:void(0);" onclick="$('input[name=\'cantidad_lote[<?=$identificador_linea;?>]\']').val(Math.max($('input[name=\'cantidad_lote[<?=$identificador_linea;?>]\']').val()-1, 0));">-</a>
							</div>
							<input type="number" class="linea_lote_cantidad" min="0" name="cantidad_lote[<?=$identificador_linea;?>]" value="<?= $linea_lote_a_mostrar->cantidad_en_cesta(); ?>" />
							<div class="lote_mas">
								<a class="boton_mas" href="javascript:void(0);" onclick="$('input[name=\'cantidad_lote[<?=$identificador_linea;?>]\']').val(parseInt($('input[name=\'cantidad_lote[<?=$identificador_linea;?>]\']').val())+1);">+</a>
							</div>
						</div>
					<?php
					}
					?>
					<input type="hidden" name="codigo[<?=$identificador_linea;?>]" value="<?=$linea_lote_a_mostrar->objeto_articulo->codigo;?>" />
					<input type="hidden" name="lote[<?=$identificador_linea;?>]" value="<?=$linea_lote_a_mostrar->mc_lote;?>" />
					<input type="hidden" name="cantidad_linea[<?=$identificador_linea;?>]" value="<?=$linea_lote_a_mostrar->cantidad;?>" />
					<input type="hidden" name="special_id[<?=$identificador_linea;?>]" value="<?=$linea_lote_a_mostrar->cantidad;?>" />
					<?php
					// lote_contenedor_cantidad($articulo_a_mostrar, $lote_a_mostrar->codigo);
					Theme::include_file($fichero . '.php', $linea_lote_a_mostrar);
					?>
					<?php  /*<input type="hidden" name="articulo_lote[<?= $contador_lineas; ?>]" value="<?= $articulo_a_mostrar->codigo; ?>" /> */ ?>
				</fieldset>
				<?php
				$texto = ob_get_clean();
				if ($linea_lote_a_mostrar->optativa){
					$lista_optativas .= $texto;
				}else{
					$lista_no_optativas .= $texto;
				}
				$texto = '';
			}
			//si hay "no optativas" mostramos el texto
			//Tatiana: 19-06-17=> cambio el orden de las optativas a peticion de sergio.
			
			if ($lista_optativas != ''){
				?>
				
				<div class="lista_optativas">
					<p class='texto_aclaratorio'>
						<?=traducir('Elija optativa');?>
					</p>
				<?=$lista_optativas;?>
				
				</div>
				<?php
			}
			if ($lista_no_optativas != ''){
				?>
				<div class="lista_no_optativas">
					<p class='texto_aclaratorio'>
						<?=traducir('Obligatorias');?>
					</p>
					<?=$lista_no_optativas;?>
				</div>
				<?php
			}
			//Ponemos dos veces el botón de comprar, arriba y abajo
			?>
			<input type="submit" name="Comprar" value="Comprar" />
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
		<script id="<?=$nombre_script;?>">
		document.addEventListener('WSLE', function(event) {
			var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
			elementObjetive.on("submit", function (event) {
				event.preventDefault();
				//var suma = 0;
				var linea = Array();
				var special_id = '';
				$(this).find("fieldset.linea_<?=$lote_a_mostrar->codigo;?>").each(function () {
					var cantidad = 0;
					//tenemos que ver, si el lote trabaja cantidades y pvp si hay que coger los input/radio
					<?php
					if ($lote_a_mostrar->trabaja_cantidades_pvp){
						//var add = false;
						//Añadimos primero los checkbox y después los radiobuttons
					?>
						if ($(this).find('input[name^=\'selector\']').is(':checked')){
							cantidad = ($(this).find('input[name^=\'cantidad_linea\']').val() * $(this).find('input[name^=\'cantidad_lote\']').val());
						}else{
							cantidad = 0;	//En este caso, este producto se borra de la cesta
						}
						//Pedro 22/Julio/2019 ==> Cogemos las optativas para el special_id
						if ($(this).find('input[type=\'radio\'][name^=\'selector\']').is(':checked')){
							special_id += ((special_id != '') ? '_' : '') + $(this).find('input[name^=\'codigo\']').val();
							console.log($(this).find('input[name^=\'codigo\']').val());
						}
					<?php
					}else{
						?>
						cantidad = ($(this).find('input[name^=\'cantidad_linea\']').val() * $(this).find('input[name^=\'cantidad_lote\']').val());
						<?php
					}
					?>
					linea.push({
						ean : $(this).find('input[name^=\'codigo\']').val(),
						cantidad:cantidad,
						accion:'<?=$accion;?>',
						lote:$(this).find('input[name^=\'lote\']').val(),
						special_id: (special_id != '') ? $(this).find('input[name^=\'lote\']').val() + '-' + special_id : '',
					});
					//console.log( $(this).find('input[name^=\'lote\']').val());
				});
				var data = {lineas_lote : linea};
				console.log(data);
				WS_data_update(
					'CabeceraCesta',
					'addProductList',
					data,
					'*=\'bloque_lineas\'|*=\'bloque_total_cesta\'|*=\'bloque_tipo_envio\'',
					function(data){
						//Redimensionamos la cesta:
						resizeModalBasket($("[class^='linea_cesta']"), true);
						//Redirigimos al lote:	//Lo comentamos para las trazas, hay que descomentar después
						//window.location.href = '<?=Shop::$configuracion->url . 'cursos/' . corregir_url($lote_a_mostrar->colegio);?>';
					}
				);
				//console.log(linea);
			});
		});
		</script>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	unset($lote_a_mostrar);
	return(true);
}

function lote_mostrar_colegios($opciones = NULL) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	//Esta select es para coger el nombre del colegio
	//$sentencia_sql = "SELECT SUBSTRING_INDEX( nombre,  '/' , -1 ) FROM mc_lotes LIMIT 0 , 30";
	$sentencia_sql = "SELECT DISTINCT nombre_lote FROM
							(SELECT SUBSTRING_INDEX( nombre,  '/' , 1 ) nombre_lote, visible_web FROM mc_lotes) consulta
							WHERE visible_web = 1 ORDER BY nombre_lote ASC";
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		if ($conexionBD) {
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					?>
					<a href="<?= Shop::$configuracion->url; ?>cursos/<?= corregir_url($fila['nombre_lote']); ?>" title="<?= traducir('Seleccionar colegio') . ' ' . $fila['nombre_lote']; ?>"><?= $fila["nombre_lote"]; ?></a>
					<?php
				}
			}
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function lote_mostrar_cursos($colegio = "") {
	$ocultarCabecera = false;

	if (($colegio != NULL) && (is_a($colegio, "OpcionesWidget"))) {
		$opciones = $colegio;
		$colegio = "";
		if (is_a($opciones, 'OpcionesWidget')) {
			$colegio = ($opciones->configuracion->colegio != NULL) ? $opciones->configuracion->colegio : $colegio;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	if ($colegio != "") {
		//Si el colegio tiene "_" hay que cambiarlos por espacios
		include('comunes/globals.php');
		//Esta select es para coger el nombre del curso
		$sentencia_sql = "SELECT DISTINCT nombre_lote, nombre FROM
								(SELECT SUBSTRING_INDEX( nombre,  '/' , -1 ) nombre_lote, nombre, visible_web FROM mc_lotes WHERE nombre LIKE '%$colegio%' AND visible_web = 1) consulta
								WHERE visible_web = 1 ORDER BY nombre_lote ASC";
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<?php
			if ($conexionBD) {
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					while ($fila = mysqli_fetch_array($resultado)) {
						$nombre_lote = explode('/', $fila['nombre']);
						foreach($nombre_lote as $key => $value){
							$nombre_lote[$key] = SEO::URL($value);
						}
						$nombre_lote = implode('/', $nombre_lote);
						?>
						<a href="<?= Shop::$configuracion->url; ?>venta_lote/<?=$nombre_lote?>" title="<?= traducir('Seleccionar curso') . ' ' . $fila['nombre_lote']; ?>"><?= $fila['nombre_lote']; ?></a>
						<?php
					}
				}
			}
			?>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
}

function lote_pedir_cod_descuento($codigo_lote = NULL) {
	/*
	$ocultarCabecera = false;

	if (($codigo_lote != NULL) && (is_a($codigo_lote, "OpcionesWidget"))) {
		$opciones = $codigo_lote;
		$codigo_lote = NULL;
		if (is_a($opciones, 'OpcionesWidget')) {
			$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : $codigo_lote;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}

	if ($codigo_lote != NULL) {
		if (!is_numeric($codigo_lote)) {
			$codigo_lote = lote::codigo_de_nombre($codigo_lote);
		}
		//Si el colegio tiene "_" hay que cambiarlos por espacios
		include('comunes/globals.php');
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<form action="<?= Shop::$configuracion->url ?>comunes/consultas/descuento_lote_verificar.php" method="post" class="formulario_descuento_lote">
				<?php
				//Vamos a ver si tenemos el lote ya con un dto
				$indice_dto_lote = lote::buscar_dto_lote($codigo_lote);
				$cod_dto_lote_actual = "";
				$porcen_dto_actual = 0;
				if ($indice_dto_lote > -1) {
					$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
					$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
					$porcen_dto_actual = $cod_dto_lote_actual[1];
					$cod_dto_lote_actual = $cod_dto_lote_actual[2];
				}
				?>
				<fieldset >
					<label><?= traducir('Si dispone de un código de descuento, introdúzcalo y pulse el botón ') . '<strong>' . traducir("'verificar código de descuento'") . '</strong>'; ?></label>
					<input type="text" name="cod_descuento_lote" value="<?= $cod_dto_lote_actual; ?>" <?= ($cod_dto_lote_actual != "") ? 'disabled="disabled"' : ""; ?>/>
					<input type="hidden" name="lote" value="<?= $codigo_lote; ?>" />
					<input type="submit" name="enviar" value="<?= traducir('Verificar código de descuento'); ?>" style="<?= ($cod_dto_lote_actual != '') ? 'display:none;' : ''; ?>"/>
				</fieldset>
			</form>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
			<script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
				;(function () {
					var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
					elementObjetive.on("submit", function (event) {
						//Lo primero es cancelar el evento
						event.preventDefault();
						//Vamos a coger los objtos que necesitamos
						var submitBTN = $(this).find("input[type='submit']");
						var capa_verificando = $(this).parent("div").find(".verificando_cod_dto");
						var capa_resultado = $(this).parent("div").find(".resultado_cod_dto");
						var capa_anular = $(this).parent("div").find(".anular_cod_dto_lote");
						var campo_dto_lote = $(this).find("input[name='porcen_dto_lote']");
						var campo_codigo = $(this).find("input[name='cod_descuento_lote']");
						//Ocultamos el input y mostramos el texto de "cargando"
						submitBTN.hide('fast');
						capa_verificando.show('show');
						capa_resultado.hide('fast');
						capa_resultado.html("");

						//Obtenemos los datos del formulario
						var url = $(this).attr("action");
						var cod_descuento_lote = campo_codigo.val();
						var lote = $(this).find("input[name='lote']").val();
						//Vamos a realizar la consulta
						var parametros = "lote=" + lote + "&cod_descuento_lote=" + cod_descuento_lote; ?>";
						realizar_solicitud(url, parametros, function (respuesta) {
							//console.log(respuesta);
							capa_verificando.hide('show');
							var texto_resultado = "";
							if (respuesta > 0) {
								texto_resultado = '<div class="codigo_correcto"><p><?= traducir("El código de descuento proporcionado es correcto"); ?>.</p> <p><?= traducir("Descuento a aplicar "); ?> <strong>' + respuesta + "</strong><span>%</span>.</p></div>";
								capa_resultado.find("a").show('fast');
								campo_dto_lote.val(respuesta);
								capa_anular.show('fast');
								$("input[name='porcen_dto_lote']").val(respuesta);
								$("input[name='cod_dto_lote']").val(cod_descuento_lote);
								campo_codigo.prop("disabled", "disabled");
							} else {
								submitBTN.show('fast');
								texto_resultado = '<div class="codigo_incorrecto"><?= traducir("Código de descuento incorrecto."); ?></div>';
							}
							capa_resultado.html(texto_resultado);
							capa_resultado.show('fast');
						});
					});
				}());
			});
			</script>
			<div class="verificando_cod_dto" style="display:none;"><?= traducir("Verificando código de descuento"); ?></div>
			<div class="resultado_cod_dto" style="<?= ($cod_dto_lote_actual != "") ? "" : 'display:none;'; ?>">
				<?php
				if ($cod_dto_lote_actual != "") {
					?>
					<p><?= traducir('El código de descuento proporcionado es correcto'); ?>.</p><p> <?= traducir('Descuento a aplicar '); ?> <strong><?= $porcen_dto_actual; ?></strong><span>%</span>.</p>
					<?php
				}
				?>
			</div>
			<div class="anular_cod_dto_lote" style="<?= ($cod_dto_lote_actual != '') ? '' : 'display:none;'; ?>">
				<a href="javascript:void(0);" title="<?= traducir("Anular descuento"); ?>" class="boton"><?= traducir('Anular descuento'); ?></a>
				<script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
					;(function () {
						var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
						elementObjetive.on("click", function () {
							$(this).parent("div").parent("div").find("input[type='submit']").show("fast");
							$(this).parent("div").parent("div").find("div.resultado_cod_dto").hide("fast");
							$(this).parent("div").parent("div").find("div.anular_cod_dto_lote").hide("fast");
							$("input[name='porcen_dto_lote']").val(0);
							$("input[name='cod_dto_lote']").val("");
							$(this).parent("div").parent("div").find("input[name='cod_descuento_lote']").removeProp("disabled");
						});
					}());
				});
				</script>
			</div>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
	*/
	//Esto está por hacer
}

//Busqueda de por lote
function busqueda_lote($opciones = NULL) {
	include 'comunes/globals.php';
	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	?>
	<?php
	if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<form name="busqueda_lotes" id="busqueda_lote" class="busqueda_lote" method="post" action="<?= Shop::$configuracion->url ?>">
			<fieldset>
				<input type="text" name="lote_buscar" value="<?= $lote_buscar; ?>" placeholder="Introduce tu colegio"/>
				<input type="submit" id="btn_buscar_lote" value="<?= traducir("Buscar mis libros"); ?>" class="boton" />
			</fieldset>
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
		<script id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
			;(function () {
				var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
				elementObjetive.on("submit", function (evt) {
					evt.preventDefault();
					var valor = $("input[name='lote_buscar']").val();
					if (valor) {
						$(location).attr('href', "<?= Shop::$configuracion->url ?>busqueda_lote/" + valor);
					}
				});
			}());
		});
		</script>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function resultado_busqueda_lote($opciones = NULL) {
	include 'comunes/globals.php';

	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}

	$nombre = ($opciones->configuracion->nombre_lote != NULL) ? $opciones->configuracion->nombre_lote : "1";
	$fichero = $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : "mostrar_lote";
	?>
	<?php
	if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		if ($conexionBD) {
			$sentencia = 'SELECT * FROM  `mc_lotes` WHERE visible_web = 1 AND `nombre` LIKE "%' . $nombre . '%"';
			//echo $sentencia;
			$ruta_fichero = Theme::findFile($fichero . ".php");
			$resultado = mysqli_query($conexionBD, $sentencia);
			while ($fila = mysqli_fetch_array($resultado)) {
				$url = Shop::$configuracion->url . 'venta_lote/';
				$codigo = $fila['codigo'];
				$nombre = $fila['nombre']; //estoy reciclando la variable
				$trabaja_cantidades = $fila['trabaja_cantidades'];
				$observaciones = $fila['observaciones'];
				$total = $fila['total'];
				$cantidad = $fila['cantidad'];
				$codigo_anterior = $fila['codigo_anterior'];
				$ano_lote = $fila['ano_lote'];
				$precio_lote = $fila['precio_lote'];
				$visible_web = $fila['visible_web'];
				// Hacemos un strstr para buscar la primera aparicion de la / si no esta devuelve false, por lo que el lote no sale.
				if (strstr($nombre, '/')) {
					$partes = explode('/', $nombre);
					$url .= $partes[0] . '/' . $partes[1];
					include($ruta_fichero);
				}
			}
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

//---------------------------------------------------------------------------------------------------------------
// FUNCIONES QUE UTILIZAMOS EN ESTE WIDGET
//---------------------------------------------------------------------------------------------------------------
function articulo_cantidad_en_lote($linea_lote = NULL) {
	$retorno = 0;
	//No hacemos nada si el lote es nulo o el ean 0
	if ($linea_lote != NULL) {
		$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
		$indice = busca_articulo_cesta($linea_lote->articulo->codigo, $linea_lote->mc_lote);
		/* if ($indice === -1){
		  echo 0;
		  }
		 */
		for ($i = 0; $i < sizeof($array_cantidades_cesta); $i++) {
			if ($i === $indice) {
				//Las líneas de lote llevan una cantidad, hay que dividirla
				$retorno = $array_cantidades_cesta[$i] / $linea_lote->cantidad;
			}
		}
	}
	//Por si el retorno es decimal:
	$retorno = round($retorno);
	return($retorno);
}
?>