<?php
// Creado el 25/04/2016
/**
  Widget para mostrar la multifoto.
  19/12/2016 añadida la opciond e pasarle el evento que quieres asignarle a las fotos extra Click por defecto, pero se ha probado con mouseenter
  @version 1.1
 */



/**
  Llamada inicial al Widget
 */
function widget_multifoto($nombre_funcion = "mostrarPortada") {
	include('comunes/globals.php');
	//Aquí definimos una serie de parámetros que necesitamos
	$funcion_por_defecto = "mostrarPortada";
	$parametros_por_defecto = array();
	$parametros_recibidos = func_get_args();
	if (count($parametros_recibidos) == 0) {
		$parametros_recibidos[0] = $funcion_por_defecto;
	} else {
		if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
			$parametros_recibidos[0] = $funcion_por_defecto;
		}
	}
	$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
	$retorno = false;
	//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
	if (count($parametros_recibidos) > 0) {
		//Recogemos el nombre de la función de entre el resto de parámetros
		$nombre_funcion = $parametros_recibidos[0];
		//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
		$parametros_recibidos = array_slice($parametros_recibidos, 1);
		//Si la función existe la ejecutamos
		if (function_exists($nombre_funcion)) {
			$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
		}
	}
	return($retorno);
}

/**
  Muestra la imagen principal del articulo también llamada portada. Devuelve solo un IMG el reto de capas hay que currrarselas en el diseño
  Esta funcion se recicla más abajo
 */
function mostrarPortada($opciones = NULL) {
	include('comunes/globals.php');
	//var_dump($opciones);
	if (!isset($opciones)) {
		$opciones = new OpcionesWidget();
	}
	$ruta_fichero = "";
	$ean = ($opciones->configuracion->ean == NULL ) ? '' : $opciones->configuracion->ean;
	$cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : '1';
	$tam_portada = ($opciones->configuracion->tam_portada != NULL) ? $opciones->configuracion->tam_portada : 'ficha_ampliada';
	$ruta_base = ($opciones->configuracion->ruta_base != NULL) ? $opciones->configuracion->ruta_base : 'https://www.sinlib.es/';
	$programa = ($opciones->configuracion->programa != NULL) ? $opciones->configuracion->programa : 'sinlib';
	$formato = ($opciones->configuracion->formato != NULL) ? $opciones->configuracion->formato : 'jpg';
	$alt_img = ($opciones->configuracion->alt != NULL) ? $opciones->configuracion->alt : '';
	$tam_portada = Shop::$configuracion->tam_portada("$tam_portada");
	$carpetaPortadas = 'portadasSinlib';
	if ($programa == 'herbolib') {
		$carpetaPortadas = 'portadasHerbolib';
	}
	
	//vamos a controlar el tiempo de este widget:
	//$tiempo_inicio = microtime();
	/*
	//No vamos a hacer la consulta curl, vamos a coger la foto directamente
	// Creo el curl
	$ch = curl_init();
	// asigno url
	$rutaConsulta = $ruta_base . $carpetaPortadas . '/fotosProductoCliente.php?ean=' . $ean . '&cliente=' . $cliente . '&principal=1';
	//echo($rutaConsulta);
	curl_setopt($ch, CURLOPT_URL, $rutaConsulta);
	//echo "$ruta_base"."$carpetaPortadas/fotosProductoCliente.php?ean=$ean&cliente=$cliente&principal=1";
	//return the transfer as a string 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// $output contiene la  salida en cadena
	$output = curl_exec($ch);
	// close curl resource to free up system resources 
	curl_close($ch);
	$resultado = json_decode($output);
	// var_dump($resultado);
	$resultado = (is_array($resultado)) ? $resultado : array();
	if (count($resultado) > 0) {
		$ruta_fichero = $resultado[0]->nombre_fichero;
	}
	$url_foto = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_portada[0] . '&alto=' . $tam_portada[1] . '&calidad=' . $tam_portada[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
	*/
	$ruta_fichero = $url_foto = Shop::$configuracion->servidor_portadas . 'muestraPortadaN.php?ean=' . $ean . '&cliente=' . $cliente . '&ruta=' . $ruta_fichero . '&ancho=' . $tam_portada[0] . '&alto=' . $tam_portada[1] . '&calidad=' . $tam_portada[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto . '&hash=' . rand(1,9999);
	?>
	<img src="<?=$url_foto;?>" alt="<?= $ean; ?>" width="<?= $tam_portada[0]; ?>" height="<?= $tam_portada[1]; ?>" alt="<?=$alt_img;?>" class="imagen_<?= $ean; ?>" data-posicion="-1"/>
	<?php
	//$tiempo_fin = microtime();
	//Vamos a calcular la diferencia
	//$diff = $tiempo_fin - $tiempo_inicio;
	//echo($diff . " segundos<br />\n");
	return $ruta_fichero;
}

/**
  Muestra las imagenes secundarias del articulo si las hubiera....
  Si no solo muestra la principal.
 */
function mostrarExtraFotos($opciones = NULL) {
	include('comunes/globals.php');
	//var_dump($opciones);
	if (!isset($opciones)) {
		$opciones = new OpcionesWidget();
	}
	$ean = ($opciones->configuracion->ean == NULL ) ? '' : $opciones->configuracion->ean;
	$cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : '1';
	$tam_portada = ($opciones->configuracion->tam_portada != NULL) ? $opciones->configuracion->tam_portada : 'imagen_pedidos';
	$ruta_base = ($opciones->configuracion->ruta_base != NULL) ? $opciones->configuracion->ruta_base : 'http://www.sinlib.es/';
	$tam_portada = Shop::$configuracion->tam_portada($tam_portada);
	//No se por que lo uso pero se puede necesitar cambiar :O
	$tam_b = Shop::$configuracion->tam_portada('ficha_ampliada');
	//things
	$programa = ($opciones->configuracion->programa != NULL) ? $opciones->configuracion->programa : 'sinlib';
	$carpetaPortadas = 'portadasSinlib';
	if ($programa == 'herbolib') {
		$carpetaPortadas = 'portadasHerbolib';
	}
	$evento = ($opciones->configuracion->evento != NULL) ? $opciones->configuracion->evento : 'click';
	// Creo el curl
	$ch = curl_init();
	// asigno url
	$url = "$ruta_base" . "$carpetaPortadas/fotosProductoCliente.php?ean=$ean&cliente=$cliente&principal=0";
	//echo $url;
	curl_setopt($ch, CURLOPT_URL, $url);
	//return the transfer as a string 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// $output contiene la  salida en cadena
	$output = curl_exec($ch);
	// close curl resource to free up system resources 
	curl_close($ch);
	$resultado = json_decode($output);
	if ($resultado == NULL){
		$resultado = array();
	}
	//var_dump($resultado);
	//Si obtenemos mas de una foto, no mostramos la caja ni tampoco añadimos todo el JS, lo cual dará ligereza a la carga.
	if (count($resultado) >= 2) {
		?>
		<div class="<?= (__FUNCTION__) ?>">
			<?php
			for ($i = 0; $i < count($resultado); $i++) {
				$ruta_fichero = $resultado[$i]->nombre_fichero;
				$url_foto = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_portada[0] . '&alto=' . $tam_portada[1] . '&calidad=' . $tam_portada[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
				$url_foto_b = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_b[0] . '&alto=' . $tam_b[1] . '&calidad=' . $tam_b[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
				?>
				<img id="pos_<?= $i ?>" src="<?=$url_foto?>" alt="<?= $ean; ?>" width="<?= $tam_portada[0]; ?>" height="<?= $tam_portada[1]; ?>" class="miniaturaExtra"/ data-url="<?=$url_foto_b;?>" data-posicion="<?= $i ?>">		
				<?php
			}
			//Solucion al estilo compadre para poder reemplazar los tamaños de las portadas y que el tinglao funcione
			//$tam_portadaB = Shop::$configuracion->tam_portada("ampliacion");
			$tam_portada = Shop::$configuracion->tam_portada('ficha_ampliada');
			?>
			<script type="text/javascript" >
			document.addEventListener('WSLE', function(event) {
				;(function () {
					/**
					 *	Desde este metodo preparamos la URL de la nueva lupita y se la asignamos a la imagen esn cuestión
					 */
					function llamarlupita(url) {
						//$(".imagen_<?= $ean ?>").unbind();
						var newurl = url.replace("<?= $tam_portada[0] ?>", "1000");
						newurl = newurl.replace("<?= $tam_portada[1] ?>", "1000");
						// console.log("llamarlupita"+newurl);
						var objeto = $(".imagen_<?= $ean ?>");
						armiLupa(objeto, newurl);
					}
					//le colocamos a todas las miniaturas el evento del cambio
					$(".miniaturaExtra").on("<?= $evento ?>", function () {
						var img = $(".imagen_<?= $ean ?>");// capturamos el nodo para poder trabajar con el durante toda la funcion
						img.attr("src", $(this).data('url'));
						img.removeData("posicion");
						img.data('posicion', $(this).data('posicion'));
						//Señalamos de alguna forma la imagen que se ha seleccionado
						$(".mostrarExtraFotos").find("img").removeClass("seleccionado");
						$(this).addClass("seleccionado");
						//console.log($(this).data('posicion'));
						//cada vez que cambiamos repasamos el evento de la lupa para que la imagens sea correcta.
						llamarlupita($(this).data('url'));
					});
					//boton de retroceder en las fotos
					$("#back_foto").on("click", function () {
						var pos = $(".imagen_<?= $ean ?>").data("posicion");
						var elemento = $(".mostrarExtraFotos");
						var elementos = $(".miniaturaExtra").size();
						var url = "";
						if (pos == -1) {
							posPortada = 0;
						} else {
							var posPortada = $(".imagen_<?= $ean ?>").data("posicion");
							//console.log(posPortada);
							var n = posPortada - 1;//restamos uno a la posición actual
							if (n < 0) {
								var nodoImg = elemento.find("#pos_" + (elementos - 1));
								//console.log(nodoImg);
								url = nodoImg.data("url");
								//console.log(url);
								var posicion = nodoImg.data("posicion");
								$(".imagen_<?= $ean ?>").attr("src", url);
								$(".imagen_<?= $ean ?>").data("posicion", posicion);
								//Marcamos de alguna manera la foto que esta seleccionada
								$(".mostrarExtraFotos").find("img").removeClass("seleccionado");
								elemento.find("#pos_" + (elementos - 1)).addClass("seleccionado");
								llamarlupita(url);
							} else {
								var nodoImg = elemento.find("#pos_" + n);
								url = nodoImg.data("url");
								//console.log(url);
								var posicion = nodoImg.data("posicion");
								$(".imagen_<?= $ean ?>").attr("src", url);
								$(".imagen_<?= $ean ?>").data("posicion", posicion);
								//Marcamos de alguna manera la foto que esta seleccionada
								$(".mostrarExtraFotos").find("img").removeClass("seleccionado");
								elemento.find("#pos_" + n).addClass("seleccionado");
								llamarlupita(url);
							}

						}
					});
					//boton de avanzar en las fotos
					$("#next_foto").on("click", function () {
						var elemento = $(".mostrarExtraFotos");
						var posPortada = $(".imagen_<?= $ean ?>").data("posicion");
						var elementos = $(".miniaturaExtra").size();
						if (posPortada == -1) {
							posPortada = 0;
						}
						var n = posPortada + 1;
						// console.log("El numero de miniaturas es"+$(".miniaturaExtra").size());
						//console.log("pos es"+posPortada);
						if (n > (elementos - 1)) {
							var nodoImg = elemento.find("#pos_0");
							url = nodoImg.data("url");
							//console.log(url);
							var posicion = nodoImg.data("posicion");
							$(".imagen_<?= $ean ?>").attr("src", url);
							$(".imagen_<?= $ean ?>").data("posicion", posicion);
							$(".mostrarExtraFotos").find("img").removeClass("seleccionado");
							elemento.find("#pos_0").addClass("seleccionado");
							llamarlupita(url);
						} else {
							url = elemento.find("#pos_" + n).data("url");
							posicionElemento = elemento.find("#pos_" + n).data("posicion");
							$(".imagen_<?= $ean ?>").attr("src", url);
							$(".imagen_<?= $ean ?>").data('posicion', posicionElemento);
							//Marcamos de alguna manera la foto que esta seleccionada
							$(".mostrarExtraFotos").find("img").removeClass("seleccionado");
							elemento.find("#pos_" + n).addClass("seleccionado");
							llamarlupita(url);
						}
					});
				})();
			});
			</script>
		</div>
		<?php
	} else {
		?>
		<script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
			$("#next_foto").hide();
			$("#back_foto").hide();
		});
		</script>
		<?php
	}
}

/**
  Muestra la portada y nos permite usar la lupita, la famosa lupita...
 */
function mostrarPortadaMultiFotoLupita($opciones = null) {
	include('comunes/globals.php');
	//var_dump($opciones);
	if (!isset($opciones)) {
		$opciones = new OpcionesWidget();
	}
	$ean = ($opciones->configuracion->ean == NULL ) ? '' : $opciones->configuracion->ean;
	$cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : '1';
	$tam_portada = ($opciones->configuracion->tam_portada != NULL) ? $opciones->configuracion->tam_portada : 'ampliacion';
	$formato = 'jpg';
	$tam_portada = Shop::$configuracion->tam_portada($tam_portada);
	?>
	<div class="<?= (__FUNCTION__); ?> lupa_articulo portada">
		<span id="back_foto" class="flechitaBack"></span>
		<figure>
			<?php
			/* Esta funcion imprimirá in img y nos devolvera la ruta del fichero para poder aprovecharla */
			$ruta_fichero = mostrarPortada($opciones);
			$ruta_fichero = '';
			$nombre_script = 'script_' . incrementa_contador(true);
			?>
			<script type="text/javascript" id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
				;(function () {
					var objeto = getLastHtmlObject('<?= $nombre_script; ?>');
					//console.log(objeto);
					objeto = objeto.closest("figure").find("img");
					<?php
					//$url_foto = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_portada[0] . '&alto=' . $tam_portada[1] . '&calidad=' . $tam_portada[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
					//La foto por defecto será siempre la de portada:
					$url_foto = Shop::$configuracion->servidor_portadas . 'muestraPortadaN.php?ean=' . $ean . '&cliente=' . $cliente . '&ruta=' . $ruta_fichero . '&ancho=1024&alto=0&calidad=100&fichero_no_foto=' . Shop::$configuracion->no_foto . '&hash=' . rand(1,9999);
					?>
					var rutaImagen = "<?=$url_foto?>";
					//console.log(rutaImagen);
					armiLupa(objeto, rutaImagen);
				})();
			});
			</script>
			<figcaption></figcaption>
		</figure>
		<span id="next_foto" class="flechitaNext"></span>
	</div>
	<?php
}

/**
  Funcion que nos permite llamar la portada principal y el sistema multifoto para la web movil
 */
function getMultifotoMovil($opciones = null) {
	include('comunes/globals.php');
	//var_dump($opciones);
	if (!isset($opciones)) {
		$opciones = new OpcionesWidget();
	}
	$ean = ($opciones->configuracion->ean == NULL ) ? '' : $opciones->configuracion->ean;
	$cliente = ($opciones->configuracion->cliente != NULL) ? $opciones->configuracion->cliente : '1';
	$tam_portada = ($opciones->configuracion->tam_portada != NULL) ? $opciones->configuracion->cliente : 'imagen_pedidos';
	$ruta_base = ($opciones->configuracion->ruta_base != NULL) ? $opciones->configuracion->ruta_base : 'http://www.sinlib.es/';
	$tam_portada = Shop::$configuracion->tam_portada($tam_portada);
	$tam_b = Shop::$configuracion->tam_portada('ficha_ampliada');
	// Creo el curl
	$ch = curl_init();
	// asigno url
	curl_setopt($ch, CURLOPT_URL, "$ruta_base" . "portadasSinlib/fotosProductoCliente.php?ean=$ean&cliente=$cliente&principal=0");
	//return the transfer as a string 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// $output contiene la  salida en cadena
	$output = curl_exec($ch);
	// close curl resource to free up system resources 
	curl_close($ch);
	$resultado = json_decode($output);
	//Si obtenemos mas de una foto, no mostramos la caja ni tampoco añadimos todo el JS, lo cual dará ligereza a la carga.
	if (count($resultado) >= 2) {
		?>
		<div class="<?= (__FUNCTION__) ?>">
			<?php
			for ($i = 0; $i < count($resultado); $i++) {
				$ruta_fichero = $resultado[$i]->nombre_fichero;
				$url_foto = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_portada[0] . '&alto=' . $tam_portada[1] . '&calidad=' . $tam_portada[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
				$url_foto_b = Shop::$configuracion->servidor_portadas . 'muestraMultiFoto.php?ruta=' . $ruta_fichero . '&ancho=' . $tam_b[0] . '&alto=' . $tam_b[1] . '&calidad=' . $tam_b[2] . '&fichero_no_foto=' . Shop::$configuracion->no_foto;
				?>
				<img id="pos_<?= $i ?>" src="<?=$url_foto;?>" alt="<?= $ean; ?>" width="<?= $tam_portada[0]; ?>" height="<?= $tam_portada[1]; ?>" class="miniaturaExtra"/ data-url="<?=$url_foto_b;?>" data-posicion="<?= $i ?>">		
					 <?php
				 }
				 ?>
		</div>
		<script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
			$(".miniaturaExtra").on("click", function () {
				var img = $(".imagen_<?= $ean ?>");// capturamos el nodo para poder trabajar con el durante toda la funcion
				img.attr("src", $(this).data('url'));
				img.removeData("posicion");
				img.data('posicion', $(this).data('posicion'));
				//console.log($(this).data('posicion'));
				//cada vez que cambiamos repasamos el evento de la lupa para que la imagens ea correcta.
				llamarlupita($(this).data('url'));
			});
		});
		</script>
		<?php
	}
}
?>