<?php
/*
	Clase SuperBanner
	// Editado por Tomás añadido el campo target.
	//Editado por Pedro para añadir la clase BaseDatos
*/

class SuperCodigosPromocionales extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	public $codigo_promocional = '';
	public $fecha_alta = 0;
	public $fecha_baja = 0;
	public $descuento = 0;
	public $activo = false;
	public $g_envio_gratis = false;
	public $escaparates = '';
	public $lote = 0;
	public $numUsos = 0;

	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			//En un principio esta tabla no tiene más tablas asociadas
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_promocional = isset($argumentos[0]) ? $argumentos[0] : '';
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;

		static::$whereSelect = '';
		if ($codigo_promocional != '') {
			static::$whereSelect = ' `' . static::getAlias() . '`.`codigo_promocional` = "' . $codigo_promocional . '" ';
		}

		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}

	function __construct($opciones = 0){
		//08/Mayo/2019 ==> Hay que inicualizar los campos en la lista de campos de la tabla sólo si no está inicializada:
		if (empty(static::$publicFieldList)){
			$this->initPublicFields();
		}
		$opciones = new ObOptions($opciones);
		$filaCodigosPromocionales = $opciones->getDefaultValue('filaCodigosPromocionales', NULL);
		$codigo_promocional = $opciones->getDefaultValue('codigo_promocional', '');
		
		$fila = NULL;
		if ($filaCodigosPromocionales == NULL){
			//Cargamos los datos que necesitamos del banner
			//$sentencia_sql = 'SELECT codigo, posicion, orden, url, titulo, imagen, activo, condicion, target FROM banner WHERE codigo = ' . $codigo;
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla($codigo_promocional);
			//echo($sentencia_sql . "\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaCodigosPromocionales;
		}
		if ($fila != NULL){
			$this->extractData($fila);
		}
	}
	
	private function extractData($fila){
		$this->codigo_promocional = $this->getProp($fila, 'codigo_promocional');
		$this->fecha_alta = $this->getProp($fila, 'fecha_alta');
		$this->fecha_baja = $this->getProp($fila, 'fecha_baja');
		$this->descuento = $this->getProp($fila, 'descuento');
		$this->activo = ($this->getProp($fila, 'activo') == 1) ? true : false;
		$this->g_envio_gratis = $this->getProp($fila, 'g_envio_gratis');
		$this->escaparates = $this->getProp($fila, 'escaparates');
		$this->lote = $this->getProp($fila, 'lote');
		$this->numUsos = $this->getProp($fila, 'numUsos');
	}
	
	function __destruct() {
		unset($this->codigo_promocional);
		unset($this->fecha_alta);
		unset($this->fecha_baja);
		unset($this->descuento);
		unset($this->activo);
		unset($this->g_envio_gratis);
		unset($this->escaparates);
		unset($this->lote);
		unset($this->numUsos);
    }
/*
	public static function loadList($filter = NULL){
		$retorno = array();
		$whereTabla = ' 1 ';
		if (is_array($filter)){
			if (count($filter) > 0){
				$whereTabla = static::getWhereTablaArray( $filter );
			}
		}
		
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . ( ($whereTabla != '') ? ' WHERE ' . $whereTabla : '');
		//echo("$sentencia_sql\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while($fila = $bd->getFila()){
				$retorno[]= new Banner(new OpcionesWidget(array('filaCodigosPromocionales' => $fila)));
			}
		}

		return($retorno);
	}
*/
	public static function activateCode($code, $active = 1){
		
		static::updateField($code, 'activo', ( ($active == 1) ? '1' : '0' ));
		
		//Ahora vamos a comprobar el estado del banner y devolvemos el estado del mismo:
		$codigo_promocional = new CodigosPromocionales(array('codigo_promocional' => $code));
		return($codigo_promocional->activo);
	}
	
	public static function remoteAactivateCode($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$code = (isset($data->code)) ? $data->code : 0;
		$active = (isset($data->active)) ? $data->active : NULL;
		$retorno->resultado = static::activateCode($code, $active);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}

	//Esta función nos dice si un código de descuento es válido, estática y dináimca
	public function checkDiscountCode(){
		$return = false;	// SIempre devolvemos 0, a no ser que todo haya funcionado
		//La primera carga hay que hacerla hacia el código promocional. tenemos que ver si está activo
		$ahora = strtotime(date("Y-m-d") . ' ' . date("H:i:s"));

		if ( ($ahora <= strtotime($this->fecha_baja)) && ($ahora >= strtotime($this->fecha_alta)) && ($this->activo) ){
			$return = true;
			//Como estamos dentro del rango de fechas, el código se puede usar, ahora vamos a comrpobar si hay otros elementos que lo impidan:
			$usuario = Usuario::logueado();
			if ($usuario != NULL){
				if ($usuario->codigo != ''){
					//Estamos dentro del plazo de fechas, vamos a ver si el número de usos de este cliente es menor que el establecido:
					$limite = ($this->numUsos > 0) ? $this->numUsos : 1;
					$consulta = 'SELECT `numero` from codigos_promocionales_usados 
								WHERE `codigo_promocional` = \'' . $this->codigo_promocional . '\' AND `cliente` = \'' . $usuario->codigo . '\' AND numUsos >= ' . $limite . ' ; ';
					$bd = new BaseDatos();
					if ($bd->isConectado()){
						$bd->setConsultaSQL($consulta);
						if ($fila = $bd->getFila()){
							//En caso de que la consulta devuelva algo es porque ya hay códigos usados de más
							$return = false;
						}
					}

				}
			}
		}
		return($return);
	}
}
?>