<?php
/*
	Clase Newsletter
	@version 1.0
*/

//11/Octubre/2019 ==> Añadimos la carga como objeto de WebStore
class SuperNewsletter extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	//campos de la tabla y otros:
	public $email = '';

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			/*if ($soloPrincipal === false || $soloPrincipal === NULL){
				//Aquí añadimos los campos de las tablas asociadas
			}*/
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		
		/*if ($soloPrincipal === false || $soloPrincipal === NULL){
			//Aquí añadimos las tablas relacionadas
		}*/
		$consulta .= ' ';
		
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$email = isset($argumentos[0]) ? $argumentos[0] : '';
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;

		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($email !== '') {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`email` = \'' . $email . '\' ';
		}
		
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    function __construct($params){
		//Vamos a decodificar los parámetros:
		//Por defecto nos van a mandar la cadena de texto:
		$email = '';
		if (is_string($params)){
			$email = $params;
		}
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaNewsletter = $params->getDefaultValue('filaNewsletter', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$email = $params->getDefaultValue('email', $email);
		//Aquí dejo comentada una función que me va a dar el idioma por defecto de la web
		$fila = NULL;
		
		if ( ($filaNewsletter == NULL) && ($email != '') ){
			//Preparamos el FROM con las uniones correspondientes
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla($email);
			//echo("$sentencia_sql<br/>\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaNewsletter;
		}
		if($fila != null){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->email = $this->getProp($fila, 'email');
	}
	
	//-----------------------------------------------
	//	FUNCIONES REMOTAS	
	//-----------------------------------------------

	public static function remoteInsertOrUpdate($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$email = (isset($data->email)) ? $data->email : 0;
		static::insertOrUpdate('email', $email);
		$newsletter = new Newsletter(array('email' => $email));
		$retorno->resultado = $newsletter;

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}

	public static function removeNewsletter($email){
		//En $email tenemos el correo electrónico a borrar
		$retorno = false;
		if ($email != ''){
			$sentencia_sql = 'DELETE `' . static::getAlias() . '` FROM ' . static::getNombreTabla() . '
										WHERE ' . static::getWhereTabla($email, false);
			//echo("{$sentencia_sql}<br/>\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				//Si se ha borrado alguna fila, devolvemos true
				if ($bd-> getNumeroFilas() > 0){
					$retorno = true;
				}
			}
		}
		return($retorno);
	}
	
	public static function remoteRemoveNewsletter($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$retorno->resultado = static::removeNewsletter($data->email);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
}
/*
WS_data_update(
	'Newsletter',
	'insertOrUpdate',
	{email = 'pedro@arminet.es'},
	'',
	function(data){
		console.log(data);
	}
);

*/
?>