<?php
/*
	Clase Idioma
	@version 1.0
*/

//30/Septiembre/2019 ==> Añadimos la carga como objeto de WebStore
class SuperPais extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	//campos de la tabla y otros:
	public $codigo = 0;
	public $nombre = '';
	public $prefijo = '';
	public $iniciales = '';

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);;
	}

	public static function getNombreTabla($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}  

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		$activo = isset($argumentos[2]) ? $argumentos[2] : NULL;
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = \'' . $id . '\' ';
		}
		if ($activo !== NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`web_pais` = \'' . (($activo) ? 1 : 0) . '\' ';
		}
		
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
	
    function __construct($params){
    	//var_dump($params);
    	//Marina(15/Enero/2020) 
		//Vamos a decodificar los parámetros:
		$codigo = NULL;
		if (is_numeric($params)){
			$codigo = $params;
		}
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaPais = $params->getDefaultValue('filaPais', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$codigo = $params->getDefaultValue('codigo', $codigo);
		$activo = $params->getDefaultValue('activo', NULL);
		$fila = NULL;
		
		if ($filaPais == NULL){
			//echo("hola<br />\n");
				//var_dump($codigo);
				//var_dump($activo);
				//var_dump($params);
			if ( ($codigo != NULL) || ($activo != NULL) ){
							//echo("adios<br />\n");
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($codigo);
				
				echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaPais;
		}
		if($fila != NULL){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->prefijo = $this->boolData($this->getProp($fila, 'prefijo'));
		$this->iniciales = $this->getProp($fila, 'iniciales');

	}
	
    function __destruct(){
        
    }

    //crear funcion estatica que devuelve array de paises 

    public static function cargarActivos(){
		$retorno = array();

		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla(NULL, false, true);
		//echo $sentencia_sql;

		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while( $fila = $bd->getFila() ){
				$retorno[] = new Pais(array('filaPais' => $fila));
			}
		}

		return($retorno);
	}
}
?>