<?php
ini_set('memory_limit', '256M');
set_time_limit(600);
if(!function_exists('callback')){
	function callback($buffer) {
			if (!$estamosEnInclude){
				$buffer = utf8_encode($buffer);
			}
			return($buffer);
	}
}
ini_set('include_path', "../.." . PATH_SEPARATOR . get_include_path());
//Incluimos las funciones de BD y las comunes
include_once("comunes/globals.php");
include_once("comunes/funciones/funciones_generales.php");
include_once("comunes/funciones/funciones_bases_de_datos.php");
include_once("comunes/funciones/funciones_sesion.php");
include_once("comunes/funciones/funciones_idioma.php");
include_once("comunes/funciones/funciones_precios.php");
include_once("comunes/estructuras_de_datos.php");
include_once("comunes/widgets/cesta_compra.php");
include_once("comunes/widgets/direcciones_envio.php");
include_once("comunes/login.php");

	//Si "valor" está definido, estamos haciendo un include:
	$estamosEnInclude = false;
	if (isset($valor)){
		$estamosEnInclude = true;
		$nombre = $valor->nombre;
		$nombre_original = $valor->nombre_original;
		$condicion = $valor->condicion;
		$descripcion = $valor->descripcion;
		$ruta = $valor->ruta;
		$activo = $valor->activo;
		$codigo = $valor->codigo;
	}else{
		$configuracion = new Configuracion();
		$codigo = dame_valor_variable_global("codigo");
		//Hay que hacer la select:
		$objCatalogo = new Catalogo($codigo);
		$nombre = $objCatalogo->nombre;
		$nombre_original = $objCatalogo->nombre_original;
		$condicion = $objCatalogo->condicion;
		$descripcion = $objCatalogo->descripcion;
		$ruta = $objCatalogo->ruta;
		$activo = $objCatalogo->activo;
		ob_start("callback");
	}
?>

<div class="elemento_catalogo" id="elemento_catalogo_<?=$codigo;?>">
	<form class="formulario_catalogo" action="<?=Shop::$configuracion->url;?>admin/consultas/adjuntosActualizar.php" id="formulario_<?=$codigo;?>">
	
<?php
$url_foto = Shop::$configuracion->url;
$extension = strtoupper(pathinfo($nombre_original, PATHINFO_EXTENSION));

switch($extension){
	case 'PDF':
		$url_foto .= "admin/images/iconoPdf.png";
	break;
	case 'XLSX':		
	case 'XLS':
		$url_foto .= "admin/images/iconoExcel.png";
	break;
	case 'DOC':		
	case 'DOCX':
		$url_foto .= "admin/images/iconoWord.png";
	break;
	case 'JPG':		
	case 'BMP':		
	case 'PNG':		
	case 'GIF':
		$url_foto .= "adjuntos/ficheros/" . $ruta;
	break;
	default:
		$url_foto .= "admin/images/iconoDesconocido.png";
	break;
}
?>
	<div class="elemento_foto">	
		<img src="<?=$url_foto;?>" title="imagen adjunto" alt="Imagen Adjunto" />
			<fieldset>
				<label><?=traducir("Activo");?></label>
				<input type="checkbox" name="activo" <?=($activo) ? 'checked="checked"' : "";?>/>
			</fieldset>
	</div>
	<div class="datos_catalogo">
			<fieldset>
				<label><?=traducir("Nombre");?></label>
				<input type="text" name="nombre" value="<?=$nombre;?>"/>
			</fieldset>
			<fieldset>
				<label><?=traducir("Nombre original");?></label>
				<input type="text" name="nombre_original" value="<?=$nombre_original;?>"/>
			</fieldset>
			<fieldset>
				<label><?=traducir("Condición");?></label>
				<input type="text" name="condicion" value="<?=$condicion;?>"/>
			</fieldset>
			<fieldset>
				<label><?=traducir("Descripción");?></label>
				<textarea name="descripcion" ><?=$descripcion;?></textarea>
			</fieldset>
	</div>
		<input type="hidden" name="codigo" value="<?=$codigo;?>" />
		<fieldset class="botones" id="botones_<?=$codigo;?>">
			<input type="submit" value="Modificar" />
			<input type="button" value="Borrar" onclick="borrar_adjunto(<?=$codigo;?>)"/>
		</fieldset>
		<fieldset class="espera_acciones" id="espera_acciones_<?=$codigo;?>">
			<img src="<?=Shop::$configuracion->url;?>admin/images/sending.gif"/>
		</fieldset>
</form>

<script>
var formularios = lista_formularios.length;
asignar_formulario_<?=$codigo;?>(formularios, <?=$codigo;?>);


function asignar_formulario_<?=$codigo;?>(form_pos, codigo){
	lista_formularios[form_pos] = new CustomAjax("#formulario_"+codigo, function(respuesta){
		//Ocultamos el "cargando" y mostramos los botones:
		$("#espera_acciones_"+codigo).hide();
		$("#botones_"+codigo).show();
		asignar_formulario_<?=$codigo;?>(form_pos, codigo);
	},
	function(){
		//Ocultamos los botones y mostramos el "cargando":
		$("#espera_acciones_"+codigo).show();
		$("#botones_"+codigo).hide();
		
	});
}

</script>
</div>

<?php
//Cuando todo haya pasado, nos desconectamos de la base de datos
if (!$estamosEnInclude){
	cerrar_conexion_bd();
}

//convertimos el buffer;
if(!isset($valor)){
	ob_end_flush();
}
?>
