/**
 *  Arminet File Manager con algunos extras para la gestion de banners
 *  @author Pedrothdc
 */
/**
 * Creamos la estructura de imagenes y directorios
 */
function crearEstructura(data){
	//console.log(data);
    var archivos = data.archivos;
    var fich = $("#ficheros");
	var rutaAc = $("#directorioListado").text();
    for (indice in archivos) {
        var obj = archivos[indice];       
        var span;
        if (obj.tipo == "directorio") {
			//console.log(obj);
			if(obj.nombre == ".."){
				if(rutaAc != "almacen_img"){
					//Preparamos la nueva ruta
					var nveces = rutaAc.split("/").length -1;
					var split = rutaAc.split("/");
					var nruta ="";
					for(var a = 0 ; a < nveces; a++){
						nruta += split[a];
					}
					//preparamos el elemento
					span = $('<div class="directorio" ondragover="allowDrop(event)"></div>');
					span.data("ruta", nruta);
					span.text("Subir a ..");
					span.attr("title","Directorio padre");
						span.on("drop", function(event){
						drop(event);
					});
					//Solo coocamos el dobleclick
					span.dblclick(navegarDirectorio);
				}
			}else{
				span = $('<div class="directorio" ondragover="allowDrop(event)"></div>');
				span.data("ruta", obj.ruta);
				span.text(obj.nombre);
				span.attr("title","Directorio"+obj.nombre);
				span.on("drop", function(event){
					drop(event);
				});
				//Le colocamos el escuchador del click para poder navegar a otro directorio
				span.click(seleccionado);
				span.dblclick(navegarDirectorio);
			   // console.log(span);
			}
        } else if (obj.tipo == "imagen") {
            span = $('<div id="'+obj.nombre+'" class="imagen_f" draggable="true"></div>');
			span.data("nombre",obj.nombre)
            var imagen = $('<img draggable="false">').attr("src", obj.ruta);
            span.on("dragstart", function(event) {
                drag(event);
               //event.stopPropagation();                     
            });
            span.append('<a href="javascript:void(0);" class="seleccionar" onclick="seleccionarFoto($(this))">seleccionar</a>');
            span.append(imagen);
            span.append('<a href="javascript:void(0);" class="borrar" onclick="delfoto($(this))">Borrar</a>')        
        }
        fich.append(span);
    }
    fich.append(fich.find(".imagen_f"));
}
/**
 * Eventos Drop
 */
function allowDrop(ev) {
    ev.preventDefault();
}

function drag(ev) {
//console.log(ev.target.data);
	$('.aviso').show();
//console.log($(ev.target).data("nombre"));
	ev.originalEvent.dataTransfer.setData("text", $(ev.target).data("nombre"));
}

function drop(ev) {
    $('.aviso').hide();
    ev.preventDefault();
	//console.log("drop");
    var file = ev.originalEvent.dataTransfer.getData("text");
    //console.log(file);
    var origen = $("#directorioListado").text() + '/' + file;
    var destino = $(ev.target).data("ruta") + '/' + file;
    //console.log("consultas/moverImage.php?origen=" + origen + "&destino=" + destino);
    $.ajax({
        method: "GET",
        url: "consultas/moverImage.php?origen=" + origen + "&destino=" + destino,
        success: function (result) {
           // console.log(result);
            if(result.correcto){
                //alert("Ya ha llegao");
                var tmp = "#"+file;
                tmp = tmp.replace(".","\\.");
               // console.log(tmp);
                $(tmp).remove();
            }
        },
        error: function () {
            swal("La petición Ajax falló");
        },
        cache:false
    });

}
/**
 * Deja limpio el DOM de ficheros para mostrar otro directorio o lo que se queira
 */
function limpiarEstructura(){
    var a = $("#ficheros").html("");
}
/**
 * Nos permite seleccionar otro dir y listarlo
 */
function navegarDirectorio(){
    var ruta = $(this).data('ruta');
    limpiarEstructura();
    leerDirectorio(ruta);
    fileReaderObject[0].path ="../../"+ruta;
    $("#directorio").val(ruta+'/');
}
/**
 * Manda una petición asíncrona para obtener el resultado de un directorio.
 */
function leerDirectorio(ruta) {
    $("#directorioListado").text(ruta);
    $.ajax({
        method: "GET",
        url: "consultas/leerDirectorio.php?ruta=" + ruta,
        success: function (result) {
			//console.log(result);
			//console.log(JSON.parse(result));
            crearEstructura(result);
        },
        error: function () {
            swal("La petición Ajax falló");
        },
        cache:false
    });
}
/**
 * Esta funcion nos marca como seleecionadouna foto del directorio
 */
function seleccionarFoto(dis) {
    //console.log(this);
    var obj;
    if(dis == null ){
        obj = this;
    }else{
        obj = dis;
    }
    //Limpiamos el campo oculto con el nombre de la imagen
		$('input[name="nombre_banner"]').prop("value", "");
        //Vamos a coger la ruta de la imagen
        var ruta_imagen = $(obj).parent().find("img")[0].src;
        //console.log(ruta_imagen);
        $("#img_prev").attr("src", ruta_imagen);
        ruta_imagen = ruta_imagen.split("/");
        ruta_imagen = ruta_imagen[ruta_imagen.length - 1];
        $('input[name="nombre_banner"]').prop("value", ruta_imagen);
}
/**
 * Nos permite marcar una carpeta como seleccionada
 */
function seleccionado(){
    $(this).removeClass("seleccionado");
    $(".seleccionado").removeClass("seleccionado");
    $(this).addClass("seleccionado");
}
/**
 * Subimos directorio
 */
function subirDir(){
    var ruta = $("#directorioListado").text();
    var nveces = ruta.split("/").length -1;
    var split = ruta.split("/");
    var nruta ="";
    for(var a = 0 ; a < nveces; a++){
        nruta += split[a];
    }
    //console.log(nruta);
    if(nruta !='/' && nruta != ""){
        //Siempre limpiamos antes de leer de neuvo un directorio
        limpiarEstructura();
        leerDirectorio(nruta);
    }else{
       // console.log(nruta+"no es valida XD");
    }
}
/**
 * crear un dir
 */
function crearDir() {
    //console.log("dragoncito");
    //var nombre = prompt("Nombre del directorio");
    swal({
        title: "Crear directorio",
        text: "Escriba el nombre del directorio:",
        type: "input",
        showCancelButton: true,
        closeOnConfirm: true,
        animation: "slide-from-top",
        inputPlaceholder: "ej: slider, libros, anuncios"
    },
        function (inputValue) {
            if (inputValue === false) return false;
            var nombre = inputValue;
            if (nombre != null || nombre != "") {
                var ruta = $("#directorioListado").text() + '/' + nombre;
                var obj = {
                    "ruta": ruta
                };
                // console.log(obj);
                $.ajax({
                    method: "POST",
                    url: "consultas/crearDirectorio.php",
                    data: JSON.stringify(obj),
                    success: function (result) {
                        //console.log(result);
                        if (result.correcto) {
                            limpiarEstructura();
                            leerDirectorio($("#directorioListado").text());
                        }
                    },
                    error: function () {
                        swal("La petición Ajax falló");
                    },
                    cache: false
                });
            }else{
                swal.showInputError("Tienes que ponerle un nombre obligatoriamente.");
                return false
            }
        });
}
/**
 * Borra un directorio
 */
function borrarDir() {
    if ($(".seleccionado").length > 0) {
        swal({
            title: "Vas a eliminar el directorio " + $(".seleccionado").text(),
            text: "No puede borrar directorios que tengan fotos, una vez borrado no puede recuperarse",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sí, deseo eliminarlo",
            closeOnConfirm: false
        },
            function () {
                var ruta = $(".seleccionado").data('ruta');
                //console.log("la ruta "+ ruta);
                $.ajax({
                    method: "GET",
                    url: "consultas/borrarDirectorio.php?ruta=" + ruta,
                    success: function (result) {
                        //console.log(result);
                        if (result == 1) {
                            swal("Borrado", "Se ha borrado el directorio", "success");
                            limpiarEstructura();
                            leerDirectorio($("#directorioListado").text());
                        } else {
                            swal("Error", "No se ha podido borrar", "warning")
                        }
                    },
                    error: function () {
                        swal("La petición Ajax falló, ¿no puede borrarse por que tiene archivos?");
                    }
                });
            });

    } else {
        swal("No has seleccionado un directorio")
    }
}
/**
 * Borrar foto
 */
function delfoto(dis) {
    // almacenamos el objeto en cuestión para luego poder eliminarlo del DOM
    var objeto;
    if (dis == undefined) {
        objeto = this;
    } else {
        objeto = dis;
    }
    swal({
        title: "Vas a eliminar " +$(objeto).parent().data("nombre"),
        text: "Una vez eliminada no la prodrás recuperar y si la eliminas se perderá el banner creado",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Sí, dese continuar",
        closeOnConfirm: false
    },
        function () {
            var nombre = $(objeto).parent().data("nombre");
            var ruta = $("#directorioListado").text() + '/' + nombre;
            // console.log(ruta);
            //Vamos a lanzar un php que borre la imagen
            $.ajax({
                method: "GET",
                url: "consultas/deleteImg.php?ruta=" + ruta,
                success: function (result) {
                   // console.log(result);
                    if (result === 1) {
                        //Por último vamos a quitar la imagen
                        swal("Borrado", "Se ha borrado", "success");
                        $(objeto).parent().remove();
                    } else {
                        alert("No se ha podido borrar");
                    }
                },
                error: function () {
                    swal("La petición Ajax falló");
                }
            });
        });
}

$(document).ready(function(){
	leerDirectorio('almacen_img');
    $("#subirdir").click(subirDir);
    $("#añadirdir").click(crearDir);
    $("#borrardir").click(borrarDir);
    $("#reset").click(function(ev){
        ev.preventDefault();
         location.reload();
    });
});