var bufferSize = 61440;
var acumulado = 0;
function readURL(objeto) {
	if (objeto.files && objeto.files[0]) {
		var lectorImagen = new FileReader();

		lectorImagen.onload = function (e) {
			$('#imagen_intermedia').attr('src', e.target.result);
			//var tipo = e.target.result.split(";");
			//$('#imagen_intermedia').attr("class", tipo[0]);
		}
		lectorImagen.readAsDataURL(objeto.files[0]);
		mostrarCarga();
		$("#estado_carga").html("Convirtiendo imagen");
	}
}

function cancelarModif(sesion){
	$('input[name=accion]').val('crear');
	$('input[name=btn]').val('Crear');
	$("#cancelarModif").hide();
	////Inicializamos los valores del formulario
	$('input[name=referencia]').val("");
	$('input[name=amueblado]').prop("checked", "");
	$('select[name=tipo] option').each(function(){
		if ($(this).val() == 0){
			$(this).attr("selected", "selected");
		}else{
			$(this).removeAttr("selected");
		}
	});
	$('textarea[name=descripcion]').html("");
	$('select[name=localidad] option').each(function(){
		if ($(this).val() == 0){
			$(this).attr("selected", "selected");
		}else{
			$(this).removeAttr("selected");
		}
	});
	$('input[name=precio]').val("");
	$('input[name=codigo]').val(0);
	if (!menu_oculto){
		muestraMenu();
	}
	//Limpiamos las imágenes
	limpiar_imagenes(sesion);
	$("#btn_crear_inmueble").html("Crear");
}

function consultaPHP(url, params, funcion){
	var http = new XMLHttpRequest();
	http.open("POST", url, true);
	
	//Send the proper header information along with the request
	http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	//http.setRequestHeader("Content-length", params.length);
	//http.setRequestHeader("Connection", "close");
	
	http.onreadystatechange = function() {//Call a function when the state changes.
		if(http.readyState == 4 && http.status == 200) {
			var resultado = http.responseText;
			if (resultado != "ERROR"){
				funcion(resultado);
			}else{
				//Ha habido un error al insertar la imagen	
			}
		}
	}
	http.send(params);
}

function limpiar_imagenes(id_sesion){
	$("#lista_fotos").children(".capa_imagen").remove();
	//Vamos a borrar todas las imágenes temporales de esta sesión
	var url = "comunes/limpiar_imagenes_temporales.php";
	var params = "id_sesion=" + id_sesion;
	consultaPHP(url, params, function(){});
}

function mostrarCarga(){
	$("#btn_carga_imagen").hide();
	$("#img_cargando").show();
	$("#btn_crear_inmueble").hide();
}
function ocultarCarga(){
	$("#btn_carga_imagen").show();
	$("#img_cargando").hide();
	$("#btn_crear_inmueble").show();
	$("#intCarga1").css("width", "0%");
	$("#intCarga2").css("width", "0%");
}

function controlCamposCorrectos(){
	var correcto = true;
	var texto = "";
	if ($("input[name=referencia]").val() == ""){
		$("input[name=referencia]").css("border-color", "red");
		correcto = false;
		//texto += " Debe introducir una referencia v&aacute;lida."; 
	}
	if ($("select[name=tipo]").val() == 0){
		$("select[name=tipo]").css("border-color", "red");
		correcto = false;
		//texto += " Debe introducir un tipo v&aacute;lido."; 
	}
	if ($("select[name=localidad]").val() == 0){
		$("select[name=localidad]").css("border-color", "red");
		correcto = false;
		//texto += " Debe introducir una localidad v&aacute;lida."; 
	}
	if ($("input[name=precio]").val() == ""){
		$("input[name=precio]").css("border-color", "red");
		correcto = false;
		//texto += " Debe introducir un precio v&aacute;lido."; 
	}
	if (correcto){
		$("#crear_inmueble").submit();
	}else{
		return(false);
	}
}

function control_click_amueblado(){
		//Si está seleccionado, lo des-seleccionamos y si no, lo seleccionamos
		if ($('input[name=amueblado]').is(":checked")){
			$('input[name=amueblado]').prop("checked", "");
			return(false);
		}else{
			$('input[name=amueblado]').prop("checked", "checked");
			return(false);
		}
}

function muestraMenu(){
	if (menu_oculto){
		//$("#inserccion_datos").slideDown();
		$("#inserccion_datos").animate({top: "0px"}, function(){
			$("#btn_nuevo_cerrar").html("Cerrar");	
		});
		menu_oculto = false;
	}else{
		$("#inserccion_datos").animate({top: "-242px"}, function(){
			$("#btn_nuevo_cerrar").html("Nuevo");
		});
		menu_oculto = true;
	}
}

function insImageData(id_sesion, data, id_imagen, orden, imagen_original){
	//Primero calculamos el tamaño del data recibido
	if (data.length < bufferSize){
		data = data.replace(/\+/g, "%2B");
		//Tenemos que enviar buffer size, pero la función que ejecutaremos después sólo agrupará los trozos
		var url = "comunes/insertar_imagen.php";
		var params = "id_sesion=" + id_sesion + "&imagen=" + data + "&orden=" + orden + "&id_imagen=" + id_imagen + "&fin=1&estado_carga=" + estado_carga;
		consultaPHP(url, params, function(resultado){
			//hemos subido unos bytes, vamos a mover "estado_carga"
			var indice_carga = (estado_carga <= 10) ? 1 : 2;
			$("#intCarga" + indice_carga).css("width", "100%");

			//Si el estado es menor o igual a 10, entonces hemos cargado la miniatura, ahora hay que cargar la imagen en grande
			if (estado_carga <= 10){
				$("#estado_carga").html("Subiendo imagen grande");
				$('#imagen_intermedia').load();
			}else{
				//Hemos cargado la grande, no hay que hacer nada más
				estado_carga = 0;	
			}
			//insImageData(id_sesion, data, cod_imagen, orden + 1);
			//ocultamos el botón de loading sólo si ha terminado de subirse la imagen grande
			if (estado_carga == 0){
				ocultarCarga();
				insertarImagen(resultado, imagen_original);
			}
		});
	}else{
		//eliminamos bufferSize de data y lo enviamos
		subData = data.substr(0, bufferSize);
		subData = subData.replace(/\+/g, "%2B");
		//Vamos a sustituir los + por unos caracteres especiales
		data = data.substr(bufferSize, data.length - bufferSize);
		//console.log(subData);
		//var subData = data	.splice(0, bufferSize);
		var url = "comunes/insertar_imagen.php";
		var params = "id_sesion=" + id_sesion + "&imagen=" + subData + "&orden=" + orden + "&id_imagen=" + id_imagen + "&fin=0";
		//console.log(url + "/" + params);
		consultaPHP(url, params, function(){
			//hemos subido unos bytes, vamos a mover "estado_carga"
			var indice_carga = (estado_carga <= 10) ? 1 : 2;
			var porcen = ((imagen_original.length - data.length) * 100) / imagen_original.length;
			$("#intCarga" + indice_carga).css("width", porcen + "%");
			insImageData(id_sesion, data, id_imagen, orden + 1, imagen_original);
		});
		
	}
	
}
function borrarImagen(id_imagen, id_sesion){
	//Según si es una imagen temporal o una imagen definitiva, tenemos que hacer una cosa u otra
	var accion = id_imagen.split("_")[0];
	var cod_imagen = id_imagen.split("_")[1];
	var cod_inmueble = (id_imagen.split("_")[0] == "TMPcapaImagen")? 0 : id_imagen.split("_")[2];
	//Ahora vamos a componer la url y los parámetros
	var url = "comunes/borrar_imagen.php";
	var params = "id_sesion=" + id_sesion + "&cod_imagen=" + cod_imagen + "&cod_inmueble=" + ((cod_inmueble > 0)?cod_inmueble:0);
	//console.log(url + "?" + params );
	consultaPHP(url, params, function(resultado){
		//Si todo ha salido correcto, eliminamos la imagen de la pantalla
		if (resultado == 1){
			$("#" + id_imagen).parent().remove();
		}
	});
}

function marcarPrincipal(codigo){
	var url = "comunes/marcarPrincipal.php";
	var params = "cod_inmueble=" + codigo;
	consultaPHP(url, params, function(resultado){
		//Si todo ha salido correcto, eliminamos la imagen de la pantalla
		if (resultado == 1){
		}
	});
	if ($("#marcarPrincipal_" + codigo).html() == "Marcar como principal"){
		//Le tenemos que cambiar el color
		$("#inmueble_" + codigo).attr("class", "inmueble  principal");
		$("#marcarPrincipal_" + codigo).html("Desmarcar como principal");
	}else{
		//Le cambiamos el color
		$("#inmueble_" + codigo).attr("class", "inmueble");
		$("#marcarPrincipal_" + codigo).html("Marcar como principal");
	}
}

function ocultar_formularios(){
	$("#capa_blanca").hide();
	$("#crear_localidad").hide();
	$("#crear_tipo").hide();
	$("body").css("overflow", "");	
	//Limpiamos los formularios
	$("#crear_localidad input[name=nombre_localidad]").prop("value", "");
	$("#form_tipo input[name=nombre_tipo]").prop("value", "");
}