var numFileReaders = 0;
var fileReaderObject = [];
//Primero ejecutamos una serie de eventos en el onload
window.onload = function (){
	//Controlamos las variables de configuración
	imageWidth = (typeof imageWidth === 'undefined') ? null : imageWidth;
	imageWidth = (imageWidth == null) ? null : imageWidth;
	imageHeight = (typeof imageHeight === 'undefined') ? null : imageHeight;
	imageHeight = (imageHeight == null) ? null : imageHeight;
	imageUrl = (typeof imageUrl === 'undefined') ? null : imageUrl;
	imageUrl = (imageUrl == null) ? "" : imageUrl;
	imageParams = (typeof imageParams === 'undefined') ? null : imageParams;
	imageParams = (imageParams == null) ? "" : imageParams;
	imageFinalFunction = (typeof imageFinalFunction === 'undefined') ? null : imageFinalFunction;
	imageFinalFunction = (imageFinalFunction == null) ? function(){} : imageFinalFunction;
	imageFormat = (typeof imageFormat === 'undefined') ? null : imageFormat;
	imageFormat = (imageFormat == null) ? "jpg" : imageFormat;
	imagePath = (typeof imagePath === 'undefined') ? null : imagePath;
	imagePath = (imagePath == null) ? "" : imagePath;
	imageUploadingText = (typeof imageUploadingText === 'undefined') ? null : imageUploadingText;
	imageUploadingText = (imageUploadingText == null) ? "Subiendo imagen" : imageUploadingText;
	//Tenemos que cargar todos aquellos elementos con la clase "fileReader"
	//Hay varios valores que tenemos que tener cargados, si no, no seguimos
	if ( (imageUrl != "") && (imagePath != "") ){
		$(".fileReader").each(function(){
			fileReaderObject[numFileReaders] = new fileReaderClass(imageWidth, imageHeight, $(this), imageUrl, imageParams, imageFinalFunction, imageFormat, imagePath, imageUploadingText);
			numFileReaders++;
		});
	}
}

function fileReaderClass(width, height, selector, url, params, finalFunction, format, path, uploadingText){
	this.uploadingText = (uploadingText == null) ? "Subiendo" : uploadingText;
	this.format = (format == null) ? "jpg" : format;
	this.fileName = "";
	this.buffer = 102400;
	this.finalFunction = (finalFunction == null) ? function(){} : finalFunction;
	this.path = (path == null) ? "../../banner/" : path;
	this.url = (url == null) ? "" : url;
	this.params = (params == null) ? "" : params;
	this.data = "";
	this.dataTam = 0;
	/*this.width = (width == null) ? 500: width;
	this.height = (height == null) ? 500: height;*/
	this.auxForm = $('<form runat="server"></form>');
	this.auxFileReader = $('<input id="fileReader_' + numFileReaders + '" class="fileReader" name="fichero" type="file" value="Seleccionar imagen" style="display:none;">');
	/*El cargador obtendra sus estilos desde la hoja de estilos en la que este situado. 
	// no olvidar poner el background y el height
	*/
	this.cargador = $('<span class="contenedor_barra" style="width: 100%; display: none; float: left; "><span class="barra" style="display: block;float: left;width: 0%;"></span></span>');
	this.auxHref = $('<a href="#">Cargar</a>');
	var tauxfReader = this.auxFileReader;
	this.auxHref.on('click', function(){
		//console.log('#fileReader_'+ numFileReaders);
		tauxfReader.click();		
	});
	this.auxImg = $('<img src="" style="display:none;"/>');
	this.auxCanvas = $('<canvas style="display:none;" width="' + width + '" height="' + height + '"></>');
	this.auxUploading = $('<p style="text-align:center; display:none">' + this.uploadingText + '</p>');
	//Ahora vamos a asociar la imagen y el filereader al documento
	this.auxForm.append(this.auxFileReader);
	this.auxForm.append(this.auxHref);
	this.auxForm.append(this.cargador);
	this.auxForm.append(this.auxUploading);
	$(document.body).append(this.auxImg);
	$(document.body).append(this.auxCanvas);
	this.insertaEn(selector);
	this.elementNumber = 0; //Cuando se sube una imagen, se sube este valor como el "orden" para luego poder recomponer la imagen
	//Ahora vamos a asociar el onload a la imagen
	var auxImg = this.auxImg;
	var auxCanvas = this.auxCanvas;
	var auxFileReader = this.auxFileReader;
	var auxForm = this.auxForm;
	var auxHref = this.auxHref;
	var auxObject = this;
	//console.log(this.auxImg);
	this.auxImg.on('load', function(){
		var auxWidth = width;
		var auxHeight = height;
		//console.log("imagen cargada, a convertir");
		//Vamos a copiar la imagen a un canvas, limpiamos y redimensionamos el canvas
		var canvas = auxCanvas[0];
		var ctx = canvas.getContext('2d');
		//Vamos a calcular la posición y la ubicación de la imagen dentro del canvas
		var anchoImagen = $(this).width();
		var altoImagen = $(this).height();
		//Si hemos recibido como null el ancho, o el alto, entonces tenemos que mantener esa proporción
		if ( (auxWidth != null) && (auxHeight == null) ){
			//Ancho fijo, alto proporcional
			auxHeight = (altoImagen * auxWidth) / anchoImagen;
		}else if ( (auxWidth == null) && (auxHeight != null) ){
			//Ancho fijo, alto proporcional
			auxWidth = (anchoImagen * auxHeight) / altoImagen;
		}else if ( (auxWidth == null) && (auxHeight == null) ){
			auxWidth = anchoImagen;
			auxHeight = altoImagen;
		}
		canvas.width = ctx.width = auxWidth;
		canvas.height = ctx.height = auxHeight;
		var margenX = margenY = 0;
		//Si las dimensiones a las que queremos transformar la imagen son diferentes, hay que redimensionar
		if ( ( auxWidth != anchoImagen ) ||( auxHeight != altoImagen ) ){
			if (altoImagen > anchoImagen){
				//Tipo A
				var anchoAux = anchoImagen * (height / altoImagen);
				margenX = (width - anchoAux) / 2;
				margenY = 0;
				auxWidth = anchoAux;
			}else{
				//Tipo B
				altoAux = altoImagen * (width / anchoImagen);
				margenY = (height - altoAux) / 2;
				margenX = 0;
				auxHeight = altoAux;
			}
		}
		//Vamos a dibujar la imagen en el canavas, pero redimensionándola
		ctx.drawImage($(this)[0], margenX, margenY, auxWidth, auxHeight);
		//Llega el momento de sacar los datos del canvas
		auxObject.data = canvas.toDataURL();
		auxObject.dataTam = auxObject.data.length;
		//Vamos a crear una imagen temporal
		//Controlamos el estado de la carga de imágenes
		//insImageData('<?=$id_sesion;?>', data, id_imagen, 1, imagen_original);
		var temp = new Date();
		var fileName = temp.getFullYear().toString() + 
                  temp.getMonth().toString() + 
                  temp.getDate().toString() +
                  temp.getHours().toString() + 
                  temp.getMinutes().toString() + 
                  temp.getSeconds().toString();
		auxObject.subirImagen(fileName);
		auxObject.auxHref.hide();
		auxObject.auxUploading.show();
		auxObject.cargador.show();
		//auxObject.cargador.css("display", "block");
	});
	
	//Ahora un proceso en el onchange del filereader
	this.auxFileReader.change( function(){
		var auxElement = $(this)[0];
		if (auxElement.files && auxElement.files[0]) {
			var lectorImagen = new FileReader();
			lectorImagen.onload = function (e) {
				auxImg.attr('src', e.target.result);
			}
			var fichero = auxElement.files[0];
			console.log(fichero.type);
			if(fichero.type == "image/gif"){
				//Esto solo lo lanzamos si es un gif, lo lanzamos a otro archivo mas retocado
				var formData = new FormData($(".fileReader form")[0]);
				console.log(formData);
				var message = ""; 
				//hacemos la petición ajax  
				$.ajax({
					url: 'consultas/uploadgif.php',  
					type: 'POST',
					// Form data
					//datos del formulario
					data: formData,
					//necesario para subir archivos via ajax
					cache: false,
					contentType: false,
					processData: false,
					//mientras enviamos el archivo
					beforeSend: function(){
						swal({
							  title: "Estamos subiendo la imagen",
							  text: "Ten paciencia",
							  timer: 3000,
							  showConfirmButton: false
							});
						//console.log("Enviando imagen");						
					},
					//una vez finalizado correctamente
					success: function(data){
						//console.log(data);
						if(data.estado){
							swal('Ok', 'Se ha subido correctamente', 'success');
							setTimeout(function(){
								location.reload();
							},2000);
							
						}else{
							swal("Error", data.err,"warning");
						}
					},
					//si ha ocurrido un error
					error: function(){
						swal('La petición Ajax Falló.');
					}
				});
				
			}else{
				lectorImagen.readAsDataURL(fichero);
			}
		}
	});
}

fileReaderClass.prototype.insertaEn = function (selector){
	if (selector != null){
		this.selector = selector;
		$(selector).append(this.auxForm);
	}
};

fileReaderClass.prototype.subirImagen = function (fileName){
	var fin = false;
	this.fileName = (fileName != null) ? fileName : this.fileName;
	//Es el momento de asignarle un nombre a la imagen, si no lo tiene
	if (this.fileName == ""){
		var temp = new Date();
		this.fileName = temp.getFullYear().toString() + 
                  temp.getMonth().toString() + 
                  temp.getDate().toString() +
                  temp.getHours().toString() + 
                  temp.getMinutes().toString() + 
                  temp.getSeconds().toString();
	}
	//Vamos a preparar la cadena de envío
	var subData = this.data.substr(0, this.buffer);
	//Vamos a sustituir los + por unos caracteres especiales
	subData = subData.replace(/\+/g, "%2B");
	//Recortamos data
	this.data = this.data.substr(this.buffer, this.data.length - this.buffer);
	var cadena_envio = "data=" + subData + "&id_imagen=" + this.fileName + ( (this.params != "" ) ? "&" : "") + this.params + "&destino_foto=" + this.path + "&orden=" + this.elementNumber;
	this.elementNumber++;
	//Si los datos son menores que el buffer, entonces hay que enviar el fin, si no, no es necesario
	if (subData.length <= this.buffer){
		cadena_envio += "&fin=1" + "&formato=" + this.format;
		fin = true;
	}
	var auxObject = this;
	consultaPHP(this.url, cadena_envio, function(resultado){
		//console.log(resultado);
		//Si no hemos llegado al final, y todo es correcto, volvemos a enviar
		if (!fin && resultado != "ERROR"){
			auxObject.subirImagen();
			var porcen = ((auxObject.dataTam - auxObject.data.length) * 100) / auxObject.dataTam;
			auxObject.cargador.children(".barra").css("width", porcen + "%");
		}else{
			if (fin){
				//Ya se está ha enviado el último paquete, es el momento de ejecutar la opción
				auxObject.finalFunction(auxObject);
				auxObject.cargador.hide();
				auxObject.auxHref.show();
				auxObject.auxUploading.hide();
				auxObject.cargador.children(".barra").css("width", "0%");
				//Necesitamos quitar el ancho y alto a las imágenes
				auxObject.auxCanvas.removeAttr("width height");
				auxObject.auxImg.prop("src", "");
			}
		}
	});
}


function consultaPHP(url, params, funcion){
	var http = new XMLHttpRequest();
	http.open("POST", url, true);
	
	//Send the proper header information along with the request
	http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	//http.setRequestHeader("Content-length", params.length);
	//http.setRequestHeader("Connection", "close");
	
	http.onreadystatechange = function() {//Call a function when the state changes.
		if(http.readyState == 4 && http.status == 200) {
			var resultado = http.responseText;
			if (resultado != "ERROR"){
				//console.log(resultado);
				funcion(resultado);
			}else{
				//Ha habido un error al insertar la imagen	
			}
		}
	}
	http.send(params);
}
